/*
 * Decompiled with CFR 0.152.
 */
package FairCom.Helper.Classes;

import FairCom.Helper.Classes.FcTreeNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.EventListener;
import java.util.EventObject;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class FcDynamicTree
extends JTree
implements TreeSelectionListener {
    protected FcTreeNode rootNode;
    protected DefaultTreeModel myTreeModel;
    private Toolkit toolkit = Toolkit.getDefaultToolkit();
    protected Color foregroundColor = null;
    protected boolean comboMode = false;
    protected EventListenerList checkedListenerList = new EventListenerList();

    public void addCheckedEventListener(CheckedEventListener checkedEventListener) {
        this.listenerList.add(CheckedEventListener.class, checkedEventListener);
    }

    public void removeCheckedEventListener(CheckedEventListener checkedEventListener) {
        this.listenerList.remove(CheckedEventListener.class, checkedEventListener);
    }

    public FcDynamicTree() {
        this.rootNode = new FcTreeNode("Root Node");
        this.myTreeModel = new DefaultTreeModel(this.rootNode);
        this.setModel(this.myTreeModel);
        this.setEditable(false);
        this.setRowHeight(18);
        BasicTreeUI basicTreeUI = (BasicTreeUI)this.getUI();
        basicTreeUI.setRightChildIndent(8);
        basicTreeUI.setLeftChildIndent(8);
        this.setCellRenderer(new TreeNodeRenderer());
        this.addMouseListener(new NodeSelectionListener(this));
        this.getSelectionModel().setSelectionMode(1);
        this.setShowsRootHandles(true);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.addTreeSelectionListener(this);
        MyMouseAdapter myMouseAdapter = new MyMouseAdapter();
        this.addMouseMotionListener(myMouseAdapter);
        MyMouseEventAdapter myMouseEventAdapter = new MyMouseEventAdapter();
        this.addMouseListener(myMouseEventAdapter);
    }

    void fireMyEvent(CheckedEvent checkedEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != CheckedEventListener.class) continue;
            ((CheckedEventListener)objectArray[i + 1]).eventOccurred(checkedEvent);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
    }

    public void clear() {
        this.rootNode.removeAllChildren();
        this.myTreeModel.reload();
    }

    public void clearNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        defaultMutableTreeNode.removeAllChildren();
        this.myTreeModel.reload(defaultMutableTreeNode);
    }

    public void setComboMode(boolean bl) {
        this.comboMode = bl;
        this.setVisible(false);
        this.setVisible(true);
    }

    public void removeCurrentNode() {
        DefaultMutableTreeNode defaultMutableTreeNode;
        MutableTreeNode mutableTreeNode;
        TreePath treePath = this.getSelectionPath();
        if (treePath != null && (mutableTreeNode = (MutableTreeNode)(defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent()).getParent()) != null) {
            this.myTreeModel.removeNodeFromParent(defaultMutableTreeNode);
            return;
        }
        this.toolkit.beep();
    }

    public FcTreeNode addObject(FcTreeNode fcTreeNode) {
        FcTreeNode fcTreeNode2 = null;
        TreePath treePath = this.getSelectionPath();
        fcTreeNode2 = treePath == null ? this.rootNode : (FcTreeNode)treePath.getLastPathComponent();
        return this.addObject(fcTreeNode2, fcTreeNode, true);
    }

    public FcTreeNode addObject(FcTreeNode fcTreeNode, FcTreeNode fcTreeNode2) {
        return this.addObject(fcTreeNode, fcTreeNode2, false);
    }

    public FcTreeNode addObject(FcTreeNode fcTreeNode, FcTreeNode fcTreeNode2, boolean bl) {
        if (fcTreeNode == null) {
            fcTreeNode = this.rootNode;
        }
        this.myTreeModel.insertNodeInto(fcTreeNode2, fcTreeNode, fcTreeNode.getChildCount());
        if (bl) {
            this.scrollPathToVisible(new TreePath(fcTreeNode2.getPath()));
        }
        return fcTreeNode2;
    }

    public void expandNode() {
        this.expandPath(new TreePath(this.rootNode.getPath()));
    }

    public void expandNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.expandPath(new TreePath(defaultMutableTreeNode.getPath()));
    }

    public void setChecked(FcTreeNode fcTreeNode, boolean bl) {
        if (fcTreeNode.showCheckBox && fcTreeNode.isChecked != bl) {
            fcTreeNode.isChecked = bl;
            this.fireMyEvent(new CheckedEvent(fcTreeNode));
            int n = fcTreeNode.getChildCount();
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    FcTreeNode fcTreeNode2 = (FcTreeNode)fcTreeNode.getChildAt(i);
                    this.setChecked(fcTreeNode2, bl);
                }
            }
        }
    }

    class TreeNodeRenderer
    extends JPanel
    implements TreeCellRenderer {
        protected JCheckBox check;
        protected TreeLabel label;
        FcTreeNode node = null;
        String os = "";

        public TreeNodeRenderer() {
            this.setLayout(null);
            this.check = new JCheckBox();
            this.add(this.check);
            this.label = new TreeLabel();
            this.add(this.label);
            this.os = System.getProperty("os.name").toLowerCase();
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            String string = jTree.convertValueToText(object, bl, bl2, bl3, n, bl4);
            this.setEnabled(jTree.isEnabled());
            this.setOpaque(false);
            this.node = (FcTreeNode)object;
            if (FcDynamicTree.this.comboMode && this.node.showCheckBox) {
                this.check.setVisible(true);
                this.check.setSelected(this.node.isChecked());
            } else {
                this.check.setVisible(false);
            }
            this.label.setFont(jTree.getFont());
            this.label.setSelected(bl);
            this.label.setFocus(bl4);
            this.label.setText(string);
            if (bl) {
                if (this.os.startsWith("win")) {
                    this.label.setForeground(Color.WHITE);
                }
            } else if (FcDynamicTree.this.foregroundColor != null) {
                this.label.setForeground(FcDynamicTree.this.foregroundColor);
            } else {
                this.label.setForeground(UIManager.getColor("Tree.textForeground"));
            }
            if (bl2) {
                this.label.setIcon(((FcTreeNode)object).getExpandedIcon());
            } else {
                this.label.setIcon(((FcTreeNode)object).getCollapsedIcon());
            }
            return this;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = this.check.getPreferredSize();
            Dimension dimension2 = this.label.getPreferredSize();
            return new Dimension(dimension.width + dimension2.width, dimension.height < dimension2.height ? dimension2.height : dimension.height);
        }

        @Override
        public void doLayout() {
            Dimension dimension = this.check.getPreferredSize();
            Dimension dimension2 = this.label.getPreferredSize();
            int n = 0;
            int n2 = 0;
            if (dimension.height < dimension2.height) {
                n = (dimension2.height - dimension.height) / 2;
            } else {
                n2 = (dimension.height - dimension2.height) / 2;
            }
            this.check.setBounds(-3, n - 2, dimension.width, dimension.height);
            if (FcDynamicTree.this.comboMode && this.node != null && this.node.showCheckBox) {
                this.label.setBounds(dimension.width, n2, dimension2.width, dimension2.height);
            } else {
                this.label.setBounds(1, n2, dimension2.width, dimension2.height);
            }
        }

        @Override
        public void setBackground(Color color) {
            if (color instanceof ColorUIResource) {
                color = null;
            }
            super.setBackground(color);
        }

        public class TreeLabel
        extends JLabel {
            boolean isSelected;
            boolean hasFocus;

            @Override
            public void setBackground(Color color) {
                if (color instanceof ColorUIResource) {
                    color = null;
                }
                super.setBackground(color);
            }

            @Override
            public void paint(Graphics graphics) {
                String string = this.getText();
                if (string != null && 0 < string.length()) {
                    if (this.isSelected) {
                        graphics.setColor(UIManager.getColor("Tree.selectionBackground"));
                    } else {
                        graphics.setColor(UIManager.getColor("Tree.textBackground"));
                    }
                    Dimension dimension = this.getPreferredSize();
                    int n = 0;
                    Icon icon = this.getIcon();
                    if (icon != null) {
                        n = icon.getIconWidth() + Math.max(0, this.getIconTextGap() - 1);
                    }
                    graphics.fillRect(n, 0, dimension.width - 1 - n, dimension.height);
                    if (this.hasFocus) {
                        graphics.setColor(UIManager.getColor("Tree.selectionBorderColor"));
                    }
                }
                super.paint(graphics);
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                if (dimension != null) {
                    dimension = new Dimension(dimension.width + 3, dimension.height + 5);
                }
                return dimension;
            }

            public void setSelected(boolean bl) {
                this.isSelected = bl;
            }

            public void setFocus(boolean bl) {
                this.hasFocus = bl;
            }
        }
    }

    class NodeSelectionListener
    extends MouseAdapter {
        JTree tree;

        NodeSelectionListener(JTree jTree) {
            this.tree = jTree;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            int n2 = mouseEvent.getX();
            int n3 = this.tree.getRowForLocation(n2, n = mouseEvent.getY());
            TreePath treePath = this.tree.getPathForRow(n3);
            if (treePath != null) {
                FcTreeNode fcTreeNode = (FcTreeNode)treePath.getLastPathComponent();
                Rectangle rectangle = this.tree.getPathBounds(treePath);
                if (mouseEvent.getX() >= rectangle.x && mouseEvent.getX() < rectangle.x + 15) {
                    boolean bl;
                    boolean bl2 = bl = !fcTreeNode.isChecked();
                    if (FcDynamicTree.this.isEnabled()) {
                        FcDynamicTree.this.setChecked(fcTreeNode, bl);
                    }
                }
                ((DefaultTreeModel)this.tree.getModel()).nodeChanged(fcTreeNode);
                this.tree.revalidate();
                this.tree.repaint();
            }
        }
    }

    public class MyMouseAdapter
    extends MouseMotionAdapter {
        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            TreePath treePath = FcDynamicTree.this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath != null) {
                FcTreeNode fcTreeNode = (FcTreeNode)treePath.getLastPathComponent();
                FcDynamicTree.this.setToolTipText(fcTreeNode.getToolTipText());
            }
        }
    }

    public class MyMouseEventAdapter
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            TreePath treePath;
            if (mouseEvent.getButton() == 3 && (treePath = FcDynamicTree.this.getPathForLocation(mouseEvent.getPoint().x, mouseEvent.getPoint().y)) != null) {
                FcTreeNode fcTreeNode = (FcTreeNode)treePath.getLastPathComponent();
                fcTreeNode.showContextMenu(mouseEvent);
            }
        }
    }

    public class CheckedEvent
    extends EventObject {
        public CheckedEvent(Object object) {
            super(object);
        }
    }

    public static interface CheckedEventListener
    extends EventListener {
        public void eventOccurred(CheckedEvent var1);
    }
}

