/*
 * Decompiled with CFR 0.152.
 */
package FairCom.Helper.Classes;

import FairCom.Helper.Classes.DataWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import org.xml.sax.SAXException;

public class FcWriter {
    private FileWriter sw = null;
    private FileWriter xwf = null;
    private DataWriter xw = null;
    private FORMAT format;

    public FcWriter(String string, FORMAT fORMAT, boolean bl) throws IOException {
        this.format = fORMAT;
        if (fORMAT == FORMAT.CSV) {
            this.sw = new FileWriter(string, bl);
        } else if (fORMAT == FORMAT.XML) {
            this.xwf = new FileWriter(string, bl);
            this.xw = new DataWriter(this.xwf);
            this.xw.setIndentStep(4);
        }
    }

    public void close() throws IOException {
        if (this.format == FORMAT.CSV) {
            this.sw.close();
        } else if (this.format == FORMAT.XML) {
            this.xwf.close();
        }
    }

    public void endDocument() throws IOException {
        if (this.format == FORMAT.XML) {
            try {
                this.xw.endDocument();
            }
            catch (SAXException sAXException) {
                throw new IOException(sAXException.getMessage());
            }
        }
    }

    public void startDocument() throws IOException {
        if (this.format == FORMAT.XML) {
            try {
                this.xw.startDocument();
            }
            catch (SAXException sAXException) {
                throw new IOException(sAXException.getMessage());
            }
        }
    }

    public void write(String string) throws IOException {
        if (this.format == FORMAT.CSV) {
            this.sw.write(string);
        }
    }

    public void writeLine(String string) throws IOException {
        if (this.format == FORMAT.CSV) {
            this.sw.write(string + "\r\n");
        }
    }

    public void writeComment(String string) throws IOException {
        if (this.format == FORMAT.CSV) {
            this.sw.write(string + "\r\n\r\n");
        } else if (this.format == FORMAT.XML) {
            char[] cArray = string.toCharArray();
            try {
                this.xwf.write("<!--");
                this.xw.characters(cArray, 0, string.length());
                this.xwf.write("-->\r\n");
            }
            catch (SAXException sAXException) {
                throw new IOException(sAXException.getMessage());
            }
        }
    }

    public void writeValue(String string, String string2) throws IOException {
        try {
            this.xw.dataElement(string, string2);
        }
        catch (SAXException sAXException) {
            throw new IOException(sAXException.getMessage());
        }
    }

    public void writeStart(String string) throws IOException {
        this.writeStart(string, null);
    }

    public void writeStart(String string, String string2) throws IOException {
        try {
            this.xw.startElement(string);
            if (string2 != null && !string2.isEmpty()) {
                this.xw.characters(string2);
            }
        }
        catch (SAXException sAXException) {
            throw new IOException(sAXException.getMessage());
        }
    }

    public void writeStartWithAttributes(String string, HashMap<String, String> hashMap) throws IOException {
        this.writeStartWithAttributes(string, hashMap, null);
    }

    public void writeStartWithAttributes(String string, HashMap<String, String> hashMap, String string2) throws IOException {
        try {
            this.xw.startElement(string, (HashMap)hashMap);
            if (string2 != null && !string2.isEmpty()) {
                this.xw.characters(string2);
            }
        }
        catch (SAXException sAXException) {
            throw new IOException(sAXException.getMessage());
        }
    }

    public void writeEnd(String string) throws IOException {
        try {
            this.xw.endElement(string);
        }
        catch (SAXException sAXException) {
            throw new IOException(sAXException.getMessage());
        }
    }

    public static enum FORMAT {
        CSV,
        XML;

    }
}

