/*
 * Decompiled with CFR 0.152.
 */
package FairCom.Helper.Dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;

public class FcFontChooser
extends JComponent {
    public static final int OK_OPTION = 0;
    public static final int CANCEL_OPTION = 1;
    public static final int ERROR_OPTION = -1;
    private static final Font DEFAULT_SELECTED_FONT = new Font("Serif", 0, 12);
    private static final Font DEFAULT_FONT = new Font("Dialog", 0, 10);
    private static final int[] FONT_STYLE_CODES = new int[]{0, 1, 2, 3};
    private static final String[] DEFAULT_FONT_SIZE_STRINGS = new String[]{"8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "36", "48", "72"};
    protected int dialogResultValue = -1;
    private String[] fontStyleNames = null;
    private String[] fontFamilyNames = null;
    private String[] fontSizeStrings = null;
    private JTextField fontFamilyTextField = null;
    private JTextField fontStyleTextField = null;
    private JTextField fontSizeTextField = null;
    private JList fontNameList = null;
    private JList fontStyleList = null;
    private JList fontSizeList = null;
    private JPanel fontNamePanel = null;
    private JPanel fontStylePanel = null;
    private JPanel fontSizePanel = null;
    private JPanel samplePanel = null;
    private JTextField sampleText = null;

    protected String GetCatalogString(String string) {
        return string;
    }

    public FcFontChooser() {
        this(DEFAULT_FONT_SIZE_STRINGS);
    }

    public FcFontChooser(String[] stringArray) {
        if (stringArray == null) {
            stringArray = DEFAULT_FONT_SIZE_STRINGS;
        }
        this.fontSizeStrings = stringArray;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(this.getFontFamilyPanel());
        jPanel.add(this.getFontStylePanel());
        jPanel.add(this.getFontSizePanel());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(2, 1));
        jPanel2.add((Component)jPanel, "North");
        jPanel2.add((Component)this.getSamplePanel(), "Center");
        this.setLayout(new BoxLayout(this, 0));
        this.add(jPanel2);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setSelectedFont(DEFAULT_SELECTED_FONT);
    }

    public void setTitle(String string) {
    }

    public JTextField getFontFamilyTextField() {
        if (this.fontFamilyTextField == null) {
            this.fontFamilyTextField = new JTextField();
            this.fontFamilyTextField.addFocusListener(new TextFieldFocusHandlerForTextSelection(this.fontFamilyTextField));
            this.fontFamilyTextField.addKeyListener(new TextFieldKeyHandlerForListSelectionUpDown(this.getFontFamilyList()));
            this.fontFamilyTextField.getDocument().addDocumentListener(new ListSearchTextFieldDocumentHandler(this.getFontFamilyList()));
            this.fontFamilyTextField.setFont(DEFAULT_FONT);
        }
        return this.fontFamilyTextField;
    }

    public JTextField getFontStyleTextField() {
        if (this.fontStyleTextField == null) {
            this.fontStyleTextField = new JTextField();
            this.fontStyleTextField.addFocusListener(new TextFieldFocusHandlerForTextSelection(this.fontStyleTextField));
            this.fontStyleTextField.addKeyListener(new TextFieldKeyHandlerForListSelectionUpDown(this.getFontStyleList()));
            this.fontStyleTextField.getDocument().addDocumentListener(new ListSearchTextFieldDocumentHandler(this.getFontStyleList()));
            this.fontStyleTextField.setFont(DEFAULT_FONT);
        }
        return this.fontStyleTextField;
    }

    public JTextField getFontSizeTextField() {
        if (this.fontSizeTextField == null) {
            this.fontSizeTextField = new JTextField();
            this.fontSizeTextField.addFocusListener(new TextFieldFocusHandlerForTextSelection(this.fontSizeTextField));
            this.fontSizeTextField.addKeyListener(new TextFieldKeyHandlerForListSelectionUpDown(this.getFontSizeList()));
            this.fontSizeTextField.getDocument().addDocumentListener(new ListSearchTextFieldDocumentHandler(this.getFontSizeList()));
            this.fontSizeTextField.setFont(DEFAULT_FONT);
        }
        return this.fontSizeTextField;
    }

    public JList getFontFamilyList() {
        if (this.fontNameList == null) {
            this.fontNameList = new JList<String>(this.getFontFamilies());
            this.fontNameList.setSelectionMode(0);
            this.fontNameList.addListSelectionListener(new ListSelectionHandler(this.getFontFamilyTextField()));
            this.fontNameList.setSelectedIndex(0);
            this.fontNameList.setFont(DEFAULT_FONT);
            this.fontNameList.setFocusable(false);
        }
        return this.fontNameList;
    }

    public JList getFontStyleList() {
        if (this.fontStyleList == null) {
            this.fontStyleList = new JList<String>(this.getFontStyleNames());
            this.fontStyleList.setSelectionMode(0);
            this.fontStyleList.addListSelectionListener(new ListSelectionHandler(this.getFontStyleTextField()));
            this.fontStyleList.setSelectedIndex(0);
            this.fontStyleList.setFont(DEFAULT_FONT);
            this.fontStyleList.setFocusable(false);
        }
        return this.fontStyleList;
    }

    public JList getFontSizeList() {
        if (this.fontSizeList == null) {
            this.fontSizeList = new JList<String>(this.fontSizeStrings);
            this.fontSizeList.setSelectionMode(0);
            this.fontSizeList.addListSelectionListener(new ListSelectionHandler(this.getFontSizeTextField()));
            this.fontSizeList.setSelectedIndex(0);
            this.fontSizeList.setFont(DEFAULT_FONT);
            this.fontSizeList.setFocusable(false);
        }
        return this.fontSizeList;
    }

    public String getSelectedFontFamily() {
        String string = (String)this.getFontFamilyList().getSelectedValue();
        return string;
    }

    public int getSelectedFontStyle() {
        int n = this.getFontStyleList().getSelectedIndex();
        return FONT_STYLE_CODES[n];
    }

    public int getSelectedFontSize() {
        int n = 1;
        String string = this.getFontSizeTextField().getText();
        while (true) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                string = (String)this.getFontSizeList().getSelectedValue();
                this.getFontSizeTextField().setText(string);
                continue;
            }
            break;
        }
        return n;
    }

    public Font getSelectedFont() {
        Font font = new Font(this.getSelectedFontFamily(), this.getSelectedFontStyle(), this.getSelectedFontSize());
        return font;
    }

    public void setSelectedFontFamily(String string) {
        String[] stringArray = this.getFontFamilies();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].toLowerCase().equals(string.toLowerCase())) continue;
            this.getFontFamilyList().setSelectedIndex(i);
            break;
        }
        this.updateSampleFont();
    }

    public void setSelectedFontStyle(int n) {
        for (int i = 0; i < FONT_STYLE_CODES.length; ++i) {
            if (FONT_STYLE_CODES[i] != n) continue;
            this.getFontStyleList().setSelectedIndex(i);
            break;
        }
        this.updateSampleFont();
    }

    public void setSelectedFontSize(int n) {
        String string = String.valueOf(n);
        for (int i = 0; i < this.fontSizeStrings.length; ++i) {
            if (!this.fontSizeStrings[i].equals(string)) continue;
            this.getFontSizeList().setSelectedIndex(i);
            break;
        }
        this.getFontSizeTextField().setText(string);
        this.updateSampleFont();
    }

    public void setSelectedFont(Font font) {
        this.setSelectedFontFamily(font.getFamily());
        this.setSelectedFontStyle(font.getStyle());
        this.setSelectedFontSize(font.getSize());
    }

    public String getVersionString() {
        return this.GetCatalogString("Version");
    }

    public int showDialog(Component component) {
        return this.showDialog(component, "Font");
    }

    public int showDialog(Component component, String string) {
        this.dialogResultValue = -1;
        JDialog jDialog = this.createDialog(component, string);
        jDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                FcFontChooser.this.dialogResultValue = 1;
            }
        });
        jDialog.setVisible(true);
        jDialog.dispose();
        jDialog = null;
        return this.dialogResultValue;
    }

    protected JDialog createDialog(Component component, String string) {
        Frame frame = component instanceof Frame ? (Frame)component : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, component);
        JDialog jDialog = new JDialog(frame, string, true);
        DialogOKAction dialogOKAction = new DialogOKAction(jDialog);
        DialogCancelAction dialogCancelAction = new DialogCancelAction(jDialog);
        JButton jButton = new JButton(dialogOKAction);
        jButton.setFont(DEFAULT_FONT);
        JButton jButton2 = new JButton(dialogCancelAction);
        jButton2.setFont(DEFAULT_FONT);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(2, 1));
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.setBorder(BorderFactory.createEmptyBorder(25, 0, 10, 10));
        ActionMap actionMap = jPanel.getActionMap();
        actionMap.put(dialogCancelAction.getValue("Default"), dialogCancelAction);
        actionMap.put(dialogOKAction.getValue("Default"), dialogOKAction);
        InputMap inputMap = jPanel.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke("ESCAPE"), dialogCancelAction.getValue("Default"));
        inputMap.put(KeyStroke.getKeyStroke("ENTER"), dialogOKAction.getValue("Default"));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jPanel, "North");
        jDialog.getContentPane().add((Component)this, "Center");
        jDialog.getContentPane().add((Component)jPanel2, "East");
        jDialog.pack();
        jDialog.setLocationRelativeTo(frame);
        return jDialog;
    }

    protected void updateSampleFont() {
        Font font = this.getSelectedFont();
        this.getSampleTextField().setFont(font);
    }

    protected JPanel getFontFamilyPanel() {
        if (this.fontNamePanel == null) {
            this.fontNamePanel = new JPanel();
            this.fontNamePanel.setLayout(new BorderLayout());
            this.fontNamePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.fontNamePanel.setPreferredSize(new Dimension(180, 130));
            JScrollPane jScrollPane = new JScrollPane(this.getFontFamilyList());
            jScrollPane.getVerticalScrollBar().setFocusable(false);
            jScrollPane.setVerticalScrollBarPolicy(22);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            jPanel.add((Component)this.getFontFamilyTextField(), "North");
            jPanel.add((Component)jScrollPane, "Center");
            JLabel jLabel = new JLabel(this.GetCatalogString("FontName"));
            jLabel.setHorizontalAlignment(2);
            jLabel.setHorizontalTextPosition(2);
            jLabel.setLabelFor(this.getFontFamilyTextField());
            jLabel.setDisplayedMnemonic('F');
            this.fontNamePanel.add((Component)jLabel, "North");
            this.fontNamePanel.add((Component)jPanel, "Center");
        }
        return this.fontNamePanel;
    }

    protected JPanel getFontStylePanel() {
        if (this.fontStylePanel == null) {
            this.fontStylePanel = new JPanel();
            this.fontStylePanel.setLayout(new BorderLayout());
            this.fontStylePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.fontStylePanel.setPreferredSize(new Dimension(140, 130));
            JScrollPane jScrollPane = new JScrollPane(this.getFontStyleList());
            jScrollPane.getVerticalScrollBar().setFocusable(false);
            jScrollPane.setVerticalScrollBarPolicy(22);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            jPanel.add((Component)this.getFontStyleTextField(), "North");
            jPanel.add((Component)jScrollPane, "Center");
            JLabel jLabel = new JLabel(this.GetCatalogString("FontStyle"));
            jLabel.setHorizontalAlignment(2);
            jLabel.setHorizontalTextPosition(2);
            jLabel.setLabelFor(this.getFontStyleTextField());
            jLabel.setDisplayedMnemonic('Y');
            this.fontStylePanel.add((Component)jLabel, "North");
            this.fontStylePanel.add((Component)jPanel, "Center");
        }
        return this.fontStylePanel;
    }

    protected JPanel getFontSizePanel() {
        if (this.fontSizePanel == null) {
            this.fontSizePanel = new JPanel();
            this.fontSizePanel.setLayout(new BorderLayout());
            this.fontSizePanel.setPreferredSize(new Dimension(70, 130));
            this.fontSizePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            JScrollPane jScrollPane = new JScrollPane(this.getFontSizeList());
            jScrollPane.getVerticalScrollBar().setFocusable(false);
            jScrollPane.setVerticalScrollBarPolicy(22);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            jPanel.add((Component)this.getFontSizeTextField(), "North");
            jPanel.add((Component)jScrollPane, "Center");
            JLabel jLabel = new JLabel(this.GetCatalogString("FontSize"));
            jLabel.setHorizontalAlignment(2);
            jLabel.setHorizontalTextPosition(2);
            jLabel.setLabelFor(this.getFontSizeTextField());
            jLabel.setDisplayedMnemonic('S');
            this.fontSizePanel.add((Component)jLabel, "North");
            this.fontSizePanel.add((Component)jPanel, "Center");
        }
        return this.fontSizePanel;
    }

    protected JPanel getSamplePanel() {
        if (this.samplePanel == null) {
            TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), this.GetCatalogString("Text"));
            Border border = BorderFactory.createEmptyBorder(5, 10, 10, 10);
            CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(titledBorder, border);
            this.samplePanel = new JPanel();
            this.samplePanel.setLayout(new BorderLayout());
            this.samplePanel.setBorder(compoundBorder);
            this.samplePanel.add((Component)this.getSampleTextField(), "Center");
        }
        return this.samplePanel;
    }

    public JTextField getSampleTextField() {
        if (this.sampleText == null) {
            Border border = BorderFactory.createLoweredBevelBorder();
            this.sampleText = new JTextField(this.GetCatalogString("SampleString"));
            this.sampleText.setBorder(border);
            this.sampleText.setPreferredSize(new Dimension(300, 100));
        }
        return this.sampleText;
    }

    public void setSampleTextField(String string) {
        this.sampleText.setText(string);
    }

    protected String[] getFontFamilies() {
        if (this.fontFamilyNames == null) {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            this.fontFamilyNames = graphicsEnvironment.getAvailableFontFamilyNames();
        }
        return this.fontFamilyNames;
    }

    protected String[] getFontStyleNames() {
        if (this.fontStyleNames == null) {
            int n = 0;
            this.fontStyleNames = new String[4];
            this.fontStyleNames[n++] = this.GetCatalogString("Plain");
            this.fontStyleNames[n++] = this.GetCatalogString("Bold");
            this.fontStyleNames[n++] = this.GetCatalogString("Italic");
            this.fontStyleNames[n++] = this.GetCatalogString("BoldItalic");
        }
        return this.fontStyleNames;
    }

    protected class DialogCancelAction
    extends AbstractAction {
        protected static final String ACTION_NAME = "Cancel";
        private JDialog dialog;

        protected DialogCancelAction(JDialog jDialog) {
            this.dialog = jDialog;
            this.putValue("Default", ACTION_NAME);
            this.putValue("ActionCommandKey", ACTION_NAME);
            this.putValue("Name", FcFontChooser.this.GetCatalogString(ACTION_NAME));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FcFontChooser.this.dialogResultValue = 1;
            this.dialog.setVisible(false);
        }
    }

    protected class DialogOKAction
    extends AbstractAction {
        protected static final String ACTION_NAME = "OK";
        private JDialog dialog;

        protected DialogOKAction(JDialog jDialog) {
            this.dialog = jDialog;
            this.putValue("Default", ACTION_NAME);
            this.putValue("ActionCommandKey", ACTION_NAME);
            this.putValue("Name", FcFontChooser.this.GetCatalogString(ACTION_NAME));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FcFontChooser.this.dialogResultValue = 0;
            this.dialog.setVisible(false);
        }
    }

    protected class ListSearchTextFieldDocumentHandler
    implements DocumentListener {
        JList targetList;

        public ListSearchTextFieldDocumentHandler(JList jList) {
            this.targetList = jList;
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.update(documentEvent);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.update(documentEvent);
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.update(documentEvent);
        }

        private void update(DocumentEvent documentEvent) {
            String string = "";
            try {
                Document document = documentEvent.getDocument();
                string = document.getText(0, document.getLength());
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
            if (string.length() > 0) {
                int n = this.targetList.getNextMatch(string, 0, Position.Bias.Forward);
                if (n < 0) {
                    n = 0;
                }
                this.targetList.ensureIndexIsVisible(n);
                String string2 = this.targetList.getModel().getElementAt(n).toString();
                if (string.equalsIgnoreCase(string2) && n != this.targetList.getSelectedIndex()) {
                    SwingUtilities.invokeLater(new ListSelector(n));
                }
            }
        }

        public class ListSelector
        implements Runnable {
            private int index;

            public ListSelector(int n) {
                this.index = n;
            }

            @Override
            public void run() {
                ListSearchTextFieldDocumentHandler.this.targetList.setSelectedIndex(this.index);
            }
        }
    }

    protected class TextFieldKeyHandlerForListSelectionUpDown
    extends KeyAdapter {
        private JList targetList;

        public TextFieldKeyHandlerForListSelectionUpDown(JList jList) {
            this.targetList = jList;
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            int n = this.targetList.getSelectedIndex();
            switch (keyEvent.getKeyCode()) {
                case 38: {
                    n = this.targetList.getSelectedIndex() - 1;
                    if (n < 0) {
                        n = 0;
                    }
                    this.targetList.setSelectedIndex(n);
                    break;
                }
                case 40: {
                    int n2 = this.targetList.getModel().getSize();
                    n = this.targetList.getSelectedIndex() + 1;
                    if (n >= n2) {
                        n = n2 - 1;
                    }
                    this.targetList.setSelectedIndex(n);
                    break;
                }
            }
        }
    }

    protected class TextFieldFocusHandlerForTextSelection
    extends FocusAdapter {
        private JTextComponent textComponent;

        public TextFieldFocusHandlerForTextSelection(JTextComponent jTextComponent) {
            this.textComponent = jTextComponent;
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.textComponent.selectAll();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this.textComponent.select(0, 0);
            FcFontChooser.this.updateSampleFont();
        }
    }

    protected class ListSelectionHandler
    implements ListSelectionListener {
        private JTextComponent textComponent;

        ListSelectionHandler(JTextComponent jTextComponent) {
            this.textComponent = jTextComponent;
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                JList jList = (JList)listSelectionEvent.getSource();
                String string = (String)jList.getSelectedValue();
                String string2 = this.textComponent.getText();
                this.textComponent.setText(string);
                if (!string2.equalsIgnoreCase(string)) {
                    this.textComponent.selectAll();
                    this.textComponent.requestFocus();
                }
                FcFontChooser.this.updateSampleFont();
            }
        }
    }
}

