/*
 * Decompiled with CFR 0.152.
 */
package FairCom.Helper.Dialogs;

import FairCom.Helper.Classes.AceServers;
import FairCom.Helper.Classes.CtreeServer;
import FairCom.Helper.Dialogs.ServersTable;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Set;
import java.util.SortedMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class ServersManager
extends JDialog {
    public boolean okClicked;
    private ServersTable serversTbl = new ServersTable(true);
    private ArrayList<CtreeServer> aceServers;
    private String xmlFilename = "";
    private CtreeServer currentSrv;
    private JButton addNewBT;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JComboBox charsetCombo;
    private JButton copyBT;
    private JTextField databaseTF;
    private JButton downBT;
    private JTextField friendlyNameTF;
    private JTextField isamAddressTF;
    private JPanel isamPanel;
    private JTextField isamPortTF;
    public JComboBox jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JSplitPane jSplitPane1;
    private JTable jTable1;
    private JButton okButton;
    private JPasswordField passwordTF;
    private JCheckBox preferredCB;
    private JButton removeBT;
    private JTextField sqlAddressTF;
    private JPanel sqlPanel;
    private JTextField sqlPortTF;
    private JTextField sslCertTF;
    private JComboBox sslModeCB;
    private JTextField timeoutTF;
    private JButton upBT;
    private JTextField userNameTF;
    private JPanel userPanel;

    public ServersManager(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.charsetCombo.addItem(" ");
        SortedMap<String, Charset> sortedMap = Charset.availableCharsets();
        Set<String> set = sortedMap.keySet();
        for (String object2 : set) {
            this.charsetCombo.addItem(object2);
        }
        this.serversTbl.setSelectionMode(0);
        this.serversTbl.setCellSelectionEnabled(false);
        this.serversTbl.setRowSelectionAllowed(true);
        this.serversTbl.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    ServersManager.this.saveCurrentServer();
                    ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                    int n = listSelectionModel.getMinSelectionIndex();
                    if (n > -1) {
                        ServersManager.this.setCurrentServer(n);
                    }
                }
            }
        });
        Font font = this.serversTbl.getFont();
        Font font2 = font.deriveFont(12.0f);
        this.serversTbl.setFont(font2);
        this.jScrollPane1.setViewportView(this.serversTbl);
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jPanel3 = new JPanel();
        this.removeBT = new JButton();
        this.downBT = new JButton();
        this.upBT = new JButton();
        this.addNewBT = new JButton();
        this.copyBT = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.friendlyNameTF = new JTextField();
        this.preferredCB = new JCheckBox();
        this.sqlPanel = new JPanel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.sqlAddressTF = new JTextField();
        this.databaseTF = new JTextField();
        this.sqlPortTF = new JTextField();
        this.timeoutTF = new JTextField();
        this.jLabel11 = new JLabel();
        this.charsetCombo = new JComboBox();
        this.sslModeCB = new JComboBox();
        this.jLabel12 = new JLabel();
        this.sslCertTF = new JTextField();
        this.jLabel13 = new JLabel();
        this.isamPanel = new JPanel();
        this.jComboBox1 = new JComboBox();
        this.isamPortTF = new JTextField();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.isamAddressTF = new JTextField();
        this.jLabel9 = new JLabel();
        this.userPanel = new JPanel();
        this.jLabel6 = new JLabel();
        this.jLabel10 = new JLabel();
        this.passwordTF = new JPasswordField();
        this.userNameTF = new JTextField();
        this.buttonPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Servers Manager");
        this.jSplitPane1.setDividerLocation(260);
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView(this.jTable1);
        this.removeBT.setText("Remove");
        this.removeBT.setPreferredSize(new Dimension(70, 23));
        this.removeBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ServersManager.this.removeBTActionPerformed(actionEvent);
            }
        });
        this.downBT.setText("Move Down");
        this.downBT.setPreferredSize(new Dimension(70, 23));
        this.downBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ServersManager.this.downBTActionPerformed(actionEvent);
            }
        });
        this.upBT.setText("Move Up");
        this.upBT.setPreferredSize(new Dimension(70, 23));
        this.upBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ServersManager.this.upBTActionPerformed(actionEvent);
            }
        });
        this.addNewBT.setText("Add New");
        this.addNewBT.setPreferredSize(new Dimension(70, 23));
        this.addNewBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ServersManager.this.addNewBTActionPerformed(actionEvent);
            }
        });
        this.copyBT.setText("Copy");
        this.copyBT.setPreferredSize(new Dimension(70, 23));
        this.copyBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ServersManager.this.copyBTActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this.upBT, -2, 88, -2).addGap(26, 26, 26).addComponent(this.downBT, -2, 89, -2).addGap(11, 11, 11)).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this.addNewBT, -2, 75, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.copyBT, -2, 70, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeBT, -2, 71, -2))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.removeBT, -2, -1, -2).addComponent(this.copyBT, -2, -1, -2).addComponent(this.addNewBT, -2, -1, -2)).addGap(18, 18, 18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.downBT, -2, -1, -2).addComponent(this.upBT, -2, -1, -2)).addContainerGap()));
        GroupLayout groupLayout2 = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 268, Short.MAX_VALUE).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.jPanel3, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addComponent(this.jScrollPane1).addGap(18, 18, 18).addComponent(this.jPanel3, -2, -1, Short.MAX_VALUE).addGap(22, 22, 22)));
        this.jSplitPane1.setLeftComponent(this.jPanel1);
        this.jLabel1.setText("Friendly Name :");
        this.friendlyNameTF.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                ServersManager.this.friendlyNameTFKeyReleased(keyEvent);
            }
        });
        this.preferredCB.setText("Preferred Server");
        this.preferredCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ServersManager.this.preferredCBActionPerformed(actionEvent);
            }
        });
        this.sqlPanel.setBorder(BorderFactory.createTitledBorder("SQL Connection"));
        this.jLabel2.setText("Host Name / IP Address :");
        this.jLabel3.setText("SQL Database Name :");
        this.jLabel4.setText("Port Number :");
        this.jLabel5.setText("Query Timeout :");
        this.sqlAddressTF.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                ServersManager.this.sqlAddressTFKeyReleased(keyEvent);
            }
        });
        this.jLabel11.setHorizontalAlignment(11);
        this.jLabel11.setText("Charset (optional ) :");
        this.charsetCombo.setEditable(true);
        this.sslModeCB.setModel(new DefaultComboBoxModel<String>(new String[]{"None", "Basic", "Peer Authentication"}));
        this.sslModeCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ServersManager.this.sslModeCBActionPerformed(actionEvent);
            }
        });
        this.jLabel12.setText("SSL Mode :");
        this.sslCertTF.setEnabled(false);
        this.jLabel13.setText("Certificate :");
        GroupLayout groupLayout3 = new GroupLayout(this.sqlPanel);
        this.sqlPanel.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, groupLayout3.createSequentialGroup().addContainerGap().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addGroup(groupLayout3.createSequentialGroup().addGap(16, 16, 16).addComponent(this.jLabel3))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sqlAddressTF, -2, 128, -2).addComponent(this.databaseTF, -2, 128, -2)).addGap(18, 18, 18).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel4).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.timeoutTF).addComponent(this.sqlPortTF, -1, 48, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.LEADING, groupLayout3.createSequentialGroup().addGap(18, 18, 18).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel11, -2, 110, -2).addComponent(this.jLabel12).addComponent(this.jLabel13)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.charsetCombo, 0, -1, Short.MAX_VALUE).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.sslCertTF, GroupLayout.Alignment.LEADING).addComponent(this.sslModeCB, GroupLayout.Alignment.LEADING, 0, 148, Short.MAX_VALUE))))).addGap(41, 41, 41)));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout3.createSequentialGroup().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.sqlAddressTF, -2, -1, -2)).addGap(26, 26, 26).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.databaseTF, -2, -1, -2))).addGroup(groupLayout3.createSequentialGroup().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.sqlPortTF, -2, -1, -2)).addGap(26, 26, 26).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.timeoutTF, -2, -1, -2)))).addGap(24, 24, 24).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.charsetCombo, -2, -1, -2).addComponent(this.jLabel11)).addGap(18, 18, 18).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sslModeCB, -2, -1, -2).addComponent(this.jLabel12)).addGap(18, 18, 18).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sslCertTF, -2, -1, -2).addComponent(this.jLabel13)).addContainerGap()));
        this.isamPanel.setBorder(BorderFactory.createTitledBorder("Isam Connection"));
        this.isamPanel.setPreferredSize(new Dimension(513, 115));
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"Server Name", "Port Number"}));
        this.jComboBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ServersManager.this.jComboBox1ActionPerformed(actionEvent);
            }
        });
        this.jLabel7.setText("@");
        this.jLabel8.setText("Host Name / IP Address");
        this.isamAddressTF.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                ServersManager.this.isamAddressTFKeyReleased(keyEvent);
            }
        });
        this.jLabel9.setText("@");
        GroupLayout groupLayout4 = new GroupLayout(this.isamPanel);
        this.isamPanel.setLayout(groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addGap(44, 44, 44).addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jComboBox1, 0, -1, Short.MAX_VALUE).addComponent(this.isamPortTF, -2, 154, -2)).addGap(18, 18, 18).addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel9).addComponent(this.jLabel7)).addGap(18, 18, 18).addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.isamAddressTF, -2, 148, -2).addComponent(this.jLabel8)).addContainerGap(66, Short.MAX_VALUE)));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addContainerGap().addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBox1, -2, -1, -2).addComponent(this.jLabel9).addComponent(this.jLabel8)).addGap(18, 18, 18).addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.isamPortTF, -2, -1, -2).addComponent(this.jLabel7).addComponent(this.isamAddressTF, -2, -1, -2)).addContainerGap(23, Short.MAX_VALUE)));
        this.userPanel.setBorder(BorderFactory.createTitledBorder("User Options"));
        this.jLabel6.setText("User Name :");
        this.jLabel10.setText("User Password :");
        this.passwordTF.setText("jPasswordField1");
        GroupLayout groupLayout5 = new GroupLayout(this.userPanel);
        this.userPanel.setLayout(groupLayout5);
        groupLayout5.setHorizontalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout5.createSequentialGroup().addGap(18, 18, 18).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.userNameTF, -2, 128, -2).addGap(32, 32, 32).addComponent(this.jLabel10).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.passwordTF, -2, 97, -2).addContainerGap(27, Short.MAX_VALUE)));
        groupLayout5.setVerticalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout5.createSequentialGroup().addContainerGap().addGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.userNameTF, -2, -1, -2).addComponent(this.jLabel10).addComponent(this.passwordTF, -2, -1, -2)).addContainerGap(13, Short.MAX_VALUE)));
        this.okButton.setMnemonic('O');
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ServersManager.this.okButtonActionPerformed(actionEvent);
            }
        });
        this.cancelButton.setMnemonic('C');
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ServersManager.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout6 = new GroupLayout(this.buttonPanel);
        this.buttonPanel.setLayout(groupLayout6);
        groupLayout6.setHorizontalGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout6.createSequentialGroup().addGap(106, 106, 106).addComponent(this.okButton, -2, 93, -2).addGap(94, 94, 94).addComponent(this.cancelButton, -2, 87, -2).addContainerGap(91, Short.MAX_VALUE)));
        groupLayout6.setVerticalGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout6.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.cancelButton).addComponent(this.okButton))));
        GroupLayout groupLayout7 = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(groupLayout7);
        groupLayout7.setHorizontalGroup(groupLayout7.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout7.createSequentialGroup().addGroup(groupLayout7.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout7.createSequentialGroup().addContainerGap().addComponent(this.buttonPanel, -2, -1, -2)).addGroup(groupLayout7.createSequentialGroup().addGap(19, 19, 19).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.friendlyNameTF, -2, 172, -2).addGap(37, 37, 37).addComponent(this.preferredCB)).addGroup(groupLayout7.createSequentialGroup().addContainerGap().addComponent(this.isamPanel, -2, 470, -2))).addContainerGap(-1, Short.MAX_VALUE)).addGroup(groupLayout7.createSequentialGroup().addContainerGap().addComponent(this.userPanel, -1, -1, Short.MAX_VALUE).addGap(9, 9, 9)).addGroup(groupLayout7.createSequentialGroup().addContainerGap().addComponent(this.sqlPanel, -2, 470, -2).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout7.setVerticalGroup(groupLayout7.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout7.createSequentialGroup().addGap(20, 20, 20).addGroup(groupLayout7.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.friendlyNameTF, -2, -1, -2).addComponent(this.preferredCB)).addGap(18, 18, 18).addComponent(this.isamPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sqlPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.userPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.buttonPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.jSplitPane1.setRightComponent(this.jPanel2);
        GroupLayout groupLayout8 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout8);
        groupLayout8.setHorizontalGroup(groupLayout8.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout8.createSequentialGroup().addComponent(this.jSplitPane1, -2, 745, -2).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout8.setVerticalGroup(groupLayout8.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, -1, 544, Short.MAX_VALUE));
        this.pack();
    }

    private void jComboBox1ActionPerformed(ActionEvent actionEvent) {
        if (this.jComboBox1.getSelectedIndex() == 0) {
            this.isamPortTF.setText(this.currentSrv.getServerName());
        } else {
            Integer n = this.currentSrv.getServerPort();
            this.isamPortTF.setText(Integer.toString(n));
        }
    }

    private void okButtonActionPerformed(ActionEvent actionEvent) {
        this.saveCurrentServer();
        AceServers.saveServers(this.xmlFilename, this.aceServers);
        this.okClicked = true;
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    private void isamAddressTFKeyReleased(KeyEvent keyEvent) {
        this.sqlAddressTF.setText(this.isamAddressTF.getText());
    }

    private void sqlAddressTFKeyReleased(KeyEvent keyEvent) {
        this.isamAddressTF.setText(this.sqlAddressTF.getText());
    }

    private void friendlyNameTFKeyReleased(KeyEvent keyEvent) {
        this.currentSrv.setFriendlyName(this.friendlyNameTF.getText());
        this.serversTbl.updateName(this.currentSrv.getFriendlyName());
    }

    private void preferredCBActionPerformed(ActionEvent actionEvent) {
        for (CtreeServer ctreeServer : this.aceServers) {
            ctreeServer.setPreferred(false);
        }
        this.currentSrv.setPreferred(this.preferredCB.isSelected());
        Object object = this.serversTbl.getSelectedRows();
        if (((Object)object).length > 0) {
            Object object2 = object[0];
            this.serversTbl.update(this.aceServers);
            this.serversTbl.setRowSelectionInterval((int)object2, (int)object2);
        }
    }

    private void addNewBTActionPerformed(ActionEvent actionEvent) {
        CtreeServer ctreeServer = new CtreeServer();
        ctreeServer.setFriendlyName("New Server");
        while (this.serverNameExist(ctreeServer)) {
            ctreeServer.setFriendlyName(ctreeServer.getFriendlyName() + "_");
        }
        this.aceServers.add(ctreeServer);
        this.serversTbl.update(this.aceServers);
        this.serversTbl.selectLastRow();
    }

    private void copyBTActionPerformed(ActionEvent actionEvent) {
        int[] nArray = this.serversTbl.getSelectedRows();
        if (nArray.length > 0) {
            int n = nArray[0];
            CtreeServer ctreeServer = this.aceServers.get(n);
            CtreeServer ctreeServer2 = new CtreeServer(ctreeServer);
            while (this.serverNameExist(ctreeServer2)) {
                ctreeServer2.setFriendlyName(ctreeServer2.getFriendlyName() + "_");
            }
            this.aceServers.add(ctreeServer2);
            this.serversTbl.update(this.aceServers);
            this.serversTbl.selectLastRow();
        }
    }

    private void removeBTActionPerformed(ActionEvent actionEvent) {
        int[] nArray = this.serversTbl.getSelectedRows();
        if (nArray.length > 0) {
            int n = nArray[0];
            CtreeServer ctreeServer = this.aceServers.get(n);
            this.aceServers.remove(ctreeServer);
            this.serversTbl.update(this.aceServers);
            if (n < this.serversTbl.getRowCount()) {
                this.serversTbl.setRowSelectionInterval(n, n);
            } else if (n > 0) {
                this.serversTbl.setRowSelectionInterval(n - 1, n - 1);
            }
        }
    }

    private void upBTActionPerformed(ActionEvent actionEvent) {
        int n;
        int[] nArray = this.serversTbl.getSelectedRows();
        if (nArray.length > 0 && (n = nArray[0]) > 0) {
            CtreeServer ctreeServer = this.aceServers.remove(n);
            this.aceServers.add(n - 1, ctreeServer);
            this.serversTbl.update(this.aceServers);
            this.serversTbl.setRowSelectionInterval(n - 1, n - 1);
        }
    }

    private void downBTActionPerformed(ActionEvent actionEvent) {
        int n;
        int[] nArray = this.serversTbl.getSelectedRows();
        if (nArray.length > 0 && (n = nArray[0]) < this.serversTbl.getRowCount() - 1) {
            CtreeServer ctreeServer = this.aceServers.remove(n);
            this.aceServers.add(n + 1, ctreeServer);
            this.serversTbl.update(this.aceServers);
            this.serversTbl.setRowSelectionInterval(n + 1, n + 1);
        }
    }

    private void sslModeCBActionPerformed(ActionEvent actionEvent) {
        int n = this.sslModeCB.getSelectedIndex();
        if (n == 2) {
            this.sslCertTF.setEnabled(true);
            this.sslCertTF.setText(this.sqlAddressTF.getText());
        } else {
            this.sslCertTF.setEnabled(false);
            this.sslCertTF.setText("");
        }
    }

    private boolean serverNameExist(CtreeServer ctreeServer) {
        for (CtreeServer ctreeServer2 : this.aceServers) {
            if (!ctreeServer2.getFriendlyName().equals(ctreeServer.getFriendlyName())) continue;
            return true;
        }
        return false;
    }

    public boolean showDialog(String string) {
        this.xmlFilename = string;
        this.aceServers = AceServers.loadServers(string);
        this.serversTbl.update(this.aceServers);
        if (!this.aceServers.isEmpty()) {
            this.serversTbl.setRowSelectionInterval(0, 0);
        }
        this.setVisible(true);
        return this.okClicked;
    }

    private void saveCurrentServer() {
        if (this.currentSrv != null) {
            this.currentSrv.setFriendlyName(this.friendlyNameTF.getText());
            this.currentSrv.setPreferred(this.preferredCB.isSelected());
            if (this.jComboBox1.getSelectedIndex() == 0) {
                this.currentSrv.setUseServerPort(false);
                this.currentSrv.setServerName(this.isamPortTF.getText());
            } else {
                this.currentSrv.setUseServerPort(true);
                try {
                    this.currentSrv.setServerPort(Integer.parseInt(this.isamPortTF.getText()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.currentSrv.setHostNameOrAddress(this.isamAddressTF.getText());
            try {
                this.currentSrv.setSqlServerPort(Integer.parseInt(this.sqlPortTF.getText()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.currentSrv.setDatabaseName(this.databaseTF.getText());
            this.currentSrv.setCharset((String)this.charsetCombo.getSelectedItem());
            try {
                this.currentSrv.setQueryTimeout(Integer.parseInt(this.timeoutTF.getText()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.currentSrv.setLoggedUser(this.userNameTF.getText());
            char[] cArray = this.passwordTF.getPassword();
            this.currentSrv.setPassword(new String(cArray));
            this.currentSrv.setSslMode(this.sslModeCB.getSelectedIndex());
            this.currentSrv.setSslCert(this.sslCertTF.getText());
        }
    }

    private void setCurrentServer(int n) {
        Integer n2;
        this.currentSrv = this.aceServers.get(n);
        this.friendlyNameTF.setText(this.currentSrv.getFriendlyName());
        this.preferredCB.setSelected(this.currentSrv.isPreferred());
        if (this.currentSrv.isUseServerPort()) {
            this.jComboBox1.setSelectedIndex(1);
            n2 = this.currentSrv.getServerPort();
            this.isamPortTF.setText(n2.toString());
        } else {
            this.jComboBox1.setSelectedIndex(0);
            this.isamPortTF.setText(this.currentSrv.getServerName());
        }
        this.isamAddressTF.setText(this.currentSrv.getHostNameOrAddress());
        this.sqlAddressTF.setText(this.currentSrv.getHostNameOrAddress());
        this.databaseTF.setText(this.currentSrv.getDatabaseName());
        this.charsetCombo.setSelectedItem(this.currentSrv.getCharset());
        n2 = this.currentSrv.getQueryTimeout();
        this.timeoutTF.setText(n2.toString());
        this.userNameTF.setText(this.currentSrv.getLoggedUser());
        this.passwordTF.setText(this.currentSrv.getPassword());
        Integer n3 = this.currentSrv.getSqlServerPort();
        this.sqlPortTF.setText(n3.toString());
        this.sslModeCB.setSelectedIndex(this.currentSrv.getSslMode());
        this.sslCertTF.setText(this.currentSrv.getSslCert());
    }
}

