/*
 * Decompiled with CFR 0.152.
 */
package FairCom.Helper.Editors;

import FairCom.Helper.Classes.FcBaseTableModel;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

public class FcBooleanCellEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener {
    JCheckBox c;
    int inValue = 0;
    JTable table;
    int column;
    boolean displayText;
    boolean valueIsText;

    public FcBooleanCellEditor(boolean bl) {
        this.displayText = bl;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.displayText) {
            if (this.c.isSelected()) {
                this.c.setText("(True)");
            } else {
                this.c.setText("(False)");
            }
        }
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        if (eventObject instanceof MouseEvent) {
            JTable jTable = (JTable)eventObject.getSource();
            Point point = ((MouseEvent)eventObject).getPoint();
            int n = jTable.rowAtPoint(point);
            int n2 = jTable.columnAtPoint(point);
            Rectangle rectangle = jTable.getCellRect(n, n2, true);
            int n3 = point.x - rectangle.x;
            if (n3 < 5 || n3 > 16) {
                return false;
            }
        }
        return true;
    }

    @Override
    public Object getCellEditorValue() {
        int n;
        int n2 = n = this.c.isSelected() ? 1 : 2;
        if (n != this.inValue) {
            FcBaseTableModel fcBaseTableModel = (FcBaseTableModel)this.table.getModel();
            fcBaseTableModel.hasDirtyColumns = true;
            fcBaseTableModel.dirtyColumns.set(fcBaseTableModel.getDataColumnNumber(this.column), true);
        }
        if (this.valueIsText) {
            if (this.c.isSelected()) {
                return "y";
            }
            return "n";
        }
        return this.c.isSelected();
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.table = jTable;
        this.column = n2;
        this.c = new JCheckBox();
        this.c.addActionListener(this);
        this.valueIsText = false;
        if (object instanceof String) {
            this.valueIsText = true;
            String string = object.toString().toLowerCase();
            object = string.equals("yes") || string.equals("y") || string.equals("true") ? Boolean.TRUE : Boolean.FALSE;
        }
        if (object != null) {
            this.c.setSelected((Boolean)object);
        }
        if (object == null) {
            if (this.displayText) {
                this.c.setText("(null)");
            }
            this.inValue = 0;
        } else if (((Boolean)object).booleanValue()) {
            if (this.displayText) {
                this.c.setText("(True)");
            }
            this.inValue = 1;
        } else {
            if (this.displayText) {
                this.c.setText("(False)");
            }
            this.inValue = 2;
        }
        return this.c;
    }
}

