/*
 * Decompiled with CFR 0.152.
 */
package FairCom.Helper.Editors;

import FairCom.Helper.Classes.FcBaseTableModel;
import java.awt.Component;
import java.awt.FontMetrics;
import javax.swing.AbstractCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;

public class FcComboBoxCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    JComboBox combo;
    String inValue = "";
    JTable table;
    int column;
    int cellWidth = 0;
    int maxWidth = 0;

    public FcComboBoxCellEditor(String[] stringArray) {
        this.combo = new JComboBox<String>(stringArray);
        this.combo.setEditable(false);
    }

    public FcComboBoxCellEditor() {
        this.combo = new JComboBox();
        this.combo.setEditable(false);
    }

    public void setEditable(boolean bl) {
        this.combo.setEditable(bl);
    }

    public void setItems(String[] stringArray) {
        this.combo.removeAllItems();
        for (String string : stringArray) {
            this.combo.addItem(string);
        }
    }

    public void setItems(TableColumn tableColumn, String[] stringArray) {
        FontMetrics fontMetrics = this.combo.getFontMetrics(this.combo.getFont());
        this.combo.removeAllItems();
        for (String string : stringArray) {
            this.combo.addItem(string);
            this.cellWidth = fontMetrics.stringWidth(string) + 35;
            if (this.cellWidth <= this.maxWidth) continue;
            this.maxWidth = this.cellWidth;
        }
        tableColumn.setPreferredWidth(this.maxWidth);
    }

    public void removeAllItems() {
        this.combo.removeAllItems();
    }

    @Override
    public Object getCellEditorValue() {
        Object object = this.combo.getSelectedItem();
        if (object != null) {
            String string = object.toString();
            if (!string.equals(this.inValue)) {
                FcBaseTableModel fcBaseTableModel = (FcBaseTableModel)this.table.getModel();
                fcBaseTableModel.hasDirtyColumns = true;
                fcBaseTableModel.dirtyColumns.set(fcBaseTableModel.getDataColumnNumber(this.column), true);
            }
            return string;
        }
        return null;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.table = jTable;
        this.column = n2;
        this.combo.setSelectedItem(object);
        return this.combo;
    }
}

