/*
 * Decompiled with CFR 0.152.
 */
package FairCom.Helper.Editors;

import FairCom.Helper.Classes.FcBaseTableModel;
import FairCom.Helper.Editors.FcNumberCellEditor;
import com.standbysoft.component.date.swing.JDatePicker;
import com.standbysoft.component.date.swing.plaf.basic.SpinnerTimePickerUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Toolkit;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

public class FcDateTimeCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    JDatePicker datePicker;
    DateFormat dateFormatter = DateFormat.getDateInstance(3);
    DateFormat dateTimeFormatter = DateFormat.getDateTimeInstance(3, 2);
    DateFormat currentFormatter;
    String inValue = "";
    JTable table;
    int column;

    public FcDateTimeCellEditor() {
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)this.dateFormatter;
        String string = simpleDateFormat.toPattern();
        int n = string.length();
        int n2 = string.lastIndexOf(121) + 1;
        string = string.substring(0, n2) + "yy" + (n2 < n ? string.substring(n2, n) : "");
        simpleDateFormat.applyPattern(string);
        simpleDateFormat = (SimpleDateFormat)this.dateTimeFormatter;
        string = simpleDateFormat.toPattern();
        n = string.length();
        n2 = string.lastIndexOf(121) + 1;
        string = string.substring(0, n2) + "yy" + (n2 < n ? string.substring(n2, n) : "");
        simpleDateFormat.applyPattern(string);
        this.datePicker = new JDatePicker();
        this.datePicker.setEditable(true);
        this.datePicker.setFont(new Font("Tahoma", 0, 11));
        this.datePicker.setFreeText(true);
    }

    @Override
    public Object getCellEditorValue() {
        Object object = null;
        try {
            object = this.validate();
        }
        catch (Exception exception) {
            Logger.getLogger(FcNumberCellEditor.class.getName()).log(Level.SEVERE, null, exception);
        }
        String string = this.datePicker.getText();
        if (!string.equals(this.inValue)) {
            FcBaseTableModel fcBaseTableModel = (FcBaseTableModel)this.table.getModel();
            fcBaseTableModel.hasDirtyColumns = true;
            fcBaseTableModel.dirtyColumns.set(fcBaseTableModel.getDataColumnNumber(this.column), true);
        }
        return object;
    }

    private Object validate() throws ParseException {
        String string = this.datePicker.getText();
        Date date = null;
        if (string.length() > 1) {
            date = this.currentFormatter.parse(string);
            return new Date(date.getTime());
        }
        return null;
    }

    @Override
    public boolean stopCellEditing() {
        try {
            this.datePicker.setToolTipText(null);
            this.datePicker.setBackground(this.table.getBackground());
            this.validate();
            return super.stopCellEditing();
        }
        catch (Exception exception) {
            Toolkit.getDefaultToolkit().beep();
            this.datePicker.setBackground(new Color(255, 102, 102));
            this.datePicker.setToolTipText("Invalid Value");
            return false;
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.table = jTable;
        this.column = n2;
        this.datePicker = new JDatePicker();
        this.datePicker.setEditable(true);
        this.datePicker.setFont(new Font("Tahoma", 0, 11));
        this.datePicker.setFreeText(true);
        boolean bl2 = false;
        Class<?> clazz = jTable.getColumnClass(n2);
        if (object == null) {
            bl2 = true;
            object = new Date();
        }
        if (clazz == Date.class) {
            this.currentFormatter = this.dateFormatter;
        } else if (clazz == Timestamp.class) {
            this.currentFormatter = this.dateTimeFormatter;
            this.datePicker.putClientProperty((Object)"JDatePicker.TimePickerUI", (Object)SpinnerTimePickerUI.class.getName());
            this.datePicker.putClientProperty((Object)"JDatePicker.showTimePicker", (Object)Boolean.TRUE);
        }
        Date date = new Date();
        try {
            date = (Date)object;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.datePicker.setDateFormat(this.currentFormatter);
        this.datePicker.setSelectedDate(date);
        this.inValue = bl2 ? "" : this.datePicker.getText();
        return this.datePicker;
    }
}

