/*
 * Decompiled with CFR 0.152.
 */
package FairCom.Helper.Editors;

import FairCom.Helper.Classes.FcBaseTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;

public class FcNumberCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    JTextField field = new JTextField();
    static NumberFormat floatFormatter = NumberFormat.getNumberInstance();
    static NumberFormat intFormatter = NumberFormat.getIntegerInstance();
    String inValue = "";
    JTable table;
    int column;

    public FcNumberCellEditor() {
        this.field.setHorizontalAlignment(4);
    }

    @Override
    public Object getCellEditorValue() {
        Object object = null;
        try {
            object = this.validate();
        }
        catch (Exception exception) {
            Logger.getLogger(FcNumberCellEditor.class.getName()).log(Level.SEVERE, null, exception);
        }
        String string = this.field.getText();
        if (!string.equals(this.inValue)) {
            FcBaseTableModel fcBaseTableModel = (FcBaseTableModel)this.table.getModel();
            fcBaseTableModel.hasDirtyColumns = true;
            fcBaseTableModel.dirtyColumns.set(fcBaseTableModel.getDataColumnNumber(this.column), true);
        }
        return object;
    }

    private Object validate() throws ParseException {
        String string = this.field.getText();
        if (string.equals("(null)") || string.length() == 0) {
            return null;
        }
        Class<?> clazz = this.table.getColumnClass(this.column);
        if (clazz == Short.class) {
            return intFormatter.parse(string).shortValue();
        }
        if (clazz == Integer.class) {
            return intFormatter.parse(string).intValue();
        }
        if (clazz == Long.class) {
            return intFormatter.parse(string).longValue();
        }
        if (clazz == BigDecimal.class) {
            return new BigDecimal(floatFormatter.parse(string).doubleValue());
        }
        if (clazz == Float.class) {
            Number number = floatFormatter.parse(string);
            return Float.valueOf(floatFormatter.parse(string).floatValue());
        }
        if (clazz == Double.class) {
            return floatFormatter.parse(string).doubleValue();
        }
        return floatFormatter.parse(string);
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.table = jTable;
        this.column = n2;
        this.inValue = "";
        FcBaseTableModel fcBaseTableModel = (FcBaseTableModel)jTable.getModel();
        boolean bl2 = fcBaseTableModel.isColumnTypeUnsigned(n2);
        if (object != null) {
            Class<?> clazz = jTable.getColumnClass(n2);
            try {
                if (clazz == Short.class) {
                    short s = (Short)object;
                    if (bl2) {
                        int n3 = s & 0xFF;
                        this.inValue = intFormatter.format(n3);
                    } else {
                        this.inValue = intFormatter.format(object);
                    }
                } else if (clazz == Integer.class) {
                    int n4 = (Integer)object;
                    if (bl2) {
                        int n5 = n4 & 0xFFFF;
                        this.inValue = intFormatter.format(n5);
                    } else {
                        this.inValue = intFormatter.format(object);
                    }
                } else if (clazz == Long.class) {
                    long l = (Long)object;
                    if (bl2) {
                        long l2 = l & 0xFFFFFFFFL;
                        this.inValue = intFormatter.format(l2);
                    } else {
                        this.inValue = intFormatter.format(object);
                    }
                } else if (clazz == BigDecimal.class || clazz == BigInteger.class) {
                    int n6 = fcBaseTableModel.columnsScale.get(fcBaseTableModel.getDataColumnNumber(n2));
                    if (n6 > -1) {
                        floatFormatter.setMinimumFractionDigits(n6);
                        floatFormatter.setMaximumFractionDigits(n6);
                    } else {
                        floatFormatter.setMinimumFractionDigits(0);
                        floatFormatter.setMaximumFractionDigits(9);
                    }
                    this.inValue = floatFormatter.format(object);
                } else if (clazz == Float.class || clazz == Double.class) {
                    int n7 = fcBaseTableModel.columnsScale.get(fcBaseTableModel.getDataColumnNumber(n2));
                    if (n7 > -1) {
                        floatFormatter.setMinimumFractionDigits(n7);
                        floatFormatter.setMaximumFractionDigits(n7);
                    } else {
                        floatFormatter.setMinimumFractionDigits(0);
                        floatFormatter.setMaximumFractionDigits(9);
                    }
                    Double d = Double.parseDouble(object.toString());
                    this.inValue = floatFormatter.format(d);
                } else {
                    int n8 = fcBaseTableModel.columnsScale.get(fcBaseTableModel.getDataColumnNumber(n2));
                    if (n8 > -1) {
                        floatFormatter.setMinimumFractionDigits(n8);
                        floatFormatter.setMaximumFractionDigits(n8);
                    } else {
                        floatFormatter.setMinimumFractionDigits(0);
                        floatFormatter.setMaximumFractionDigits(9);
                    }
                    this.inValue = floatFormatter.format(object);
                }
            }
            catch (Exception exception) {
                this.inValue = "";
            }
        }
        this.field.setText(this.inValue);
        return this.field;
    }

    @Override
    public boolean stopCellEditing() {
        try {
            this.field.setToolTipText(null);
            this.field.setBackground(this.table.getBackground());
            this.validate();
            return super.stopCellEditing();
        }
        catch (Exception exception) {
            Toolkit.getDefaultToolkit().beep();
            this.field.setBackground(new Color(255, 102, 102));
            this.field.setToolTipText("Invalid Value");
            return false;
        }
    }
}

