/*
 * Decompiled with CFR 0.152.
 */
package FairCom.Helper.Editors;

import FairCom.Helper.Classes.FcBaseTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Toolkit;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

public class FcStringCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    JTextField field = new JTextField();
    String inValue = "";
    JTable table;
    int column;

    @Override
    public Object getCellEditorValue() {
        String string = this.field.getText();
        if (!string.equals(this.inValue)) {
            FcBaseTableModel fcBaseTableModel = (FcBaseTableModel)this.table.getModel();
            fcBaseTableModel.hasDirtyColumns = true;
            fcBaseTableModel.dirtyColumns.set(fcBaseTableModel.getDataColumnNumber(this.column), true);
        }
        if (string.equals("(null)") || string.length() == 0) {
            return null;
        }
        return string;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.table = jTable;
        this.column = n2;
        TableModel tableModel = jTable.getModel();
        FcBaseTableModel fcBaseTableModel = (FcBaseTableModel)tableModel;
        int n3 = fcBaseTableModel.columnsMode.get(fcBaseTableModel.getDataColumnNumber(n2));
        if (n3 == fcBaseTableModel.BYTE) {
            Font font = new Font("Monospaced", 0, 11);
            this.field.setFont(font);
        } else {
            this.field.setFont(jTable.getFont());
        }
        if (object == null) {
            this.field.setText("");
            this.inValue = "";
        } else {
            this.field.setText(object.toString());
            this.inValue = object.toString();
        }
        return this.field;
    }

    private void validate() throws Exception {
        String string;
        FcBaseTableModel fcBaseTableModel;
        int n;
        TableModel tableModel = this.table.getModel();
        if (tableModel instanceof FcBaseTableModel && (n = fcBaseTableModel.columnsMode.get((fcBaseTableModel = (FcBaseTableModel)tableModel).getGridColumnNumber(this.column)).intValue()) == fcBaseTableModel.BYTE && (string = this.field.getText()).length() > 0 && (string.length() + 1) % 3 != 0) {
            throw new Exception();
        }
    }

    @Override
    public boolean stopCellEditing() {
        try {
            this.field.setToolTipText(null);
            this.field.setBackground(this.table.getBackground());
            this.validate();
            return super.stopCellEditing();
        }
        catch (Exception exception) {
            Toolkit.getDefaultToolkit().beep();
            this.field.setBackground(new Color(255, 102, 102));
            this.field.setToolTipText("Invalid Value");
            return false;
        }
    }
}

