/*
 * Decompiled with CFR 0.152.
 */
package FairCom.Helper.Editors;

import FairCom.Helper.Classes.FcBaseTableModel;
import FairCom.Helper.Editors.FcNumberCellEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractCellEditor;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerDateModel;
import javax.swing.table.TableCellEditor;

public class FcTimeCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    JSpinner spinner;
    SimpleDateFormat timeFormatter = (SimpleDateFormat)SimpleDateFormat.getTimeInstance(2);
    String pattern = this.timeFormatter.toPattern();
    Date date = new Date();
    String inValue = "";
    JTable table;
    int column;

    public FcTimeCellEditor() {
        SpinnerDateModel spinnerDateModel = new SpinnerDateModel(this.date, null, null, 11);
        this.spinner = new JSpinner(spinnerDateModel);
        JSpinner.DateEditor dateEditor = new JSpinner.DateEditor(this.spinner, this.pattern);
        JFormattedTextField jFormattedTextField = dateEditor.getTextField();
        jFormattedTextField.setHorizontalAlignment(2);
        dateEditor.setAlignmentX(0.0f);
        this.spinner.setEditor(dateEditor);
    }

    @Override
    public Object getCellEditorValue() {
        Object object = null;
        try {
            object = this.validate();
        }
        catch (Exception exception) {
            Logger.getLogger(FcNumberCellEditor.class.getName()).log(Level.SEVERE, null, exception);
        }
        JSpinner.DateEditor dateEditor = (JSpinner.DateEditor)this.spinner.getEditor();
        JFormattedTextField jFormattedTextField = dateEditor.getTextField();
        String string = jFormattedTextField.getText();
        if (!string.equals(this.inValue)) {
            FcBaseTableModel fcBaseTableModel = (FcBaseTableModel)this.table.getModel();
            fcBaseTableModel.hasDirtyColumns = true;
            fcBaseTableModel.dirtyColumns.set(fcBaseTableModel.getDataColumnNumber(this.column), true);
        }
        return object;
    }

    private Object validate() throws ParseException {
        JSpinner.DateEditor dateEditor = (JSpinner.DateEditor)this.spinner.getEditor();
        JFormattedTextField jFormattedTextField = dateEditor.getTextField();
        String string = jFormattedTextField.getText();
        Date date = null;
        if (string.length() > 1) {
            date = this.timeFormatter.parse(string);
            return date;
        }
        return null;
    }

    @Override
    public boolean stopCellEditing() {
        JSpinner.DateEditor dateEditor = (JSpinner.DateEditor)this.spinner.getEditor();
        JFormattedTextField jFormattedTextField = dateEditor.getTextField();
        try {
            jFormattedTextField.setToolTipText(null);
            jFormattedTextField.setBackground(this.table.getBackground());
            this.validate();
            return super.stopCellEditing();
        }
        catch (Exception exception) {
            Toolkit.getDefaultToolkit().beep();
            jFormattedTextField.setBackground(new Color(255, 102, 102));
            jFormattedTextField.setToolTipText("Invalid Value");
            return false;
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.table = jTable;
        this.column = n2;
        boolean bl2 = false;
        if (object == null) {
            object = new Date();
            bl2 = true;
        }
        this.spinner.setValue(object);
        JSpinner.DateEditor dateEditor = (JSpinner.DateEditor)this.spinner.getEditor();
        JFormattedTextField jFormattedTextField = dateEditor.getTextField();
        this.inValue = bl2 ? "" : jFormattedTextField.getText();
        return this.spinner;
    }
}

