/*
 * Decompiled with CFR 0.152.
 */
package FairCom.Helper.ErrorViewer;

import FairCom.Helper.ErrorViewer.Error;
import FairCom.Helper.ErrorViewer.ErrorsTable;
import FairCom.Helper.ErrorViewer.FairComErrors;
import FairCom.Helper.ErrorViewer.Product;
import FairCom.Helper.ErrorViewer.Products;
import FairCom.Helper.ErrorViewer.UpdateErrors;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class ErrorViewerDialog
extends JDialog {
    Frame parent;
    String xmlFilename = "FairComErrors.xml";
    String xmlUserFilename = "FairComUserErrors.xml";
    String oldDesc = "";
    FairComErrors errors;
    FairComErrors modifiedErrors = new FairComErrors();
    ErrorsTable errorsTable;
    private JTextField err_codeTB;
    private JTextArea err_descriptionTA;
    private JTextField err_productTB;
    private JTextField err_symbolicTB;
    private JScrollPane errorListScrollPane;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JScrollPane jScrollPane1;
    private JTabbedPane jTabbedPane1;
    private JTable jTable1;
    private JButton lookupBT;
    private JButton saveBT;
    private JLabel statusLabel;
    private JButton updateBT;

    public ErrorViewerDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.parent = frame;
        this.errorsTable = new ErrorsTable(true);
        this.errorsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    JTable jTable = (JTable)mouseEvent.getSource();
                    int n = jTable.getSelectedRow();
                    ErrorViewerDialog.this.err_codeTB.setText(ErrorViewerDialog.this.errorsTable.getValueAt(n, 0).toString());
                    ErrorViewerDialog.this.err_symbolicTB.setText(ErrorViewerDialog.this.errorsTable.getValueAt(n, 1).toString());
                    ErrorViewerDialog.this.err_productTB.setText(ErrorViewerDialog.this.errorsTable.getValueAt(n, 2).toString());
                    ErrorViewerDialog.this.err_descriptionTA.setText(ErrorViewerDialog.this.errorsTable.getValueAt(n, 3).toString());
                    ErrorViewerDialog.this.jTabbedPane1.setSelectedIndex(0);
                }
            }
        });
        this.errorListScrollPane.setViewportView(this.errorsTable);
        this.getRootPane().setDefaultButton(this.lookupBT);
        if (this.errors == null) {
            this.loadErrorsFile();
            this.loadUserErrorsFile();
            if (this.errors != null) {
                this.fillGrid();
            }
        }
    }

    public void checkErrors(Frame frame) {
        if (this.errors == null) {
            JOptionPane.showMessageDialog(frame, "No errors available.\n\nClick \"Update\" button to build a new errors file", "Error", 0);
        }
    }

    @Override
    public void setVisible(boolean bl) {
        this.getRootPane().setDefaultButton(this.lookupBT);
        if (bl && this.errors == null) {
            JOptionPane.showMessageDialog(this.parent, "No errors available.\n\nClick \"Update\" button to build a new errors file", "Error", 0);
        }
        super.setVisible(bl);
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.err_codeTB = new JTextField();
        this.err_symbolicTB = new JTextField();
        this.lookupBT = new JButton();
        this.saveBT = new JButton();
        this.updateBT = new JButton();
        this.jPanel4 = new JPanel();
        this.jLabel3 = new JLabel();
        this.err_productTB = new JTextField();
        this.jLabel4 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.err_descriptionTA = new JTextArea();
        this.jPanel2 = new JPanel();
        this.errorListScrollPane = new JScrollPane();
        this.jTable1 = new JTable();
        this.jPanel5 = new JPanel();
        this.statusLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Error Viewer");
        this.jTabbedPane1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ErrorViewerDialog.this.jTabbedPane1StateChanged(changeEvent);
            }
        });
        this.jLabel1.setText("Error Code :");
        this.jLabel2.setText("Symbolic Constant :");
        this.err_codeTB.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                ErrorViewerDialog.this.err_codeTBKeyPressed(keyEvent);
            }
        });
        this.err_symbolicTB.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                ErrorViewerDialog.this.err_symbolicTBKeyPressed(keyEvent);
            }
        });
        this.lookupBT.setText("Look Up");
        this.lookupBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ErrorViewerDialog.this.lookupBTActionPerformed(actionEvent);
            }
        });
        this.saveBT.setText("Save");
        this.saveBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ErrorViewerDialog.this.saveBTActionPerformed(actionEvent);
            }
        });
        this.updateBT.setText("Update");
        this.updateBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ErrorViewerDialog.this.updateBTActionPerformed(actionEvent);
            }
        });
        this.jPanel4.setBorder(BorderFactory.createTitledBorder("Error Info"));
        this.jLabel3.setText("Product :");
        this.jLabel4.setText("Description :");
        this.err_descriptionTA.setColumns(20);
        this.err_descriptionTA.setFont(new Font("Tahoma", 0, 11));
        this.err_descriptionTA.setRows(5);
        this.jScrollPane1.setViewportView(this.err_descriptionTA);
        GroupLayout groupLayout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(18, 18, 18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabel3).addGap(18, 18, 18).addComponent(this.err_productTB, -2, 103, -2))).addGap(0, 396, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 569, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.err_productTB, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 156, Short.MAX_VALUE).addContainerGap()));
        GroupLayout groupLayout2 = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addGap(26, 26, 26).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.err_codeTB, -1, 162, Short.MAX_VALUE).addComponent(this.err_symbolicTB)).addGap(18, 18, 18).addComponent(this.lookupBT, -2, 80, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.saveBT, -2, 80, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.updateBT, -2, 80, -2).addContainerGap(30, Short.MAX_VALUE)).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addGap(17, 17, 17).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.err_codeTB, -2, -1, -2).addComponent(this.jLabel1)).addGap(19, 19, 19).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.err_symbolicTB, -2, -1, -2).addComponent(this.jLabel2))).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lookupBT, -2, 50, -2).addComponent(this.saveBT, -2, 50, -2).addComponent(this.updateBT, -2, 50, -2)))).addGap(18, 18, 18).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE)));
        GroupLayout groupLayout3 = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addGap(10, 10, 10)));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE));
        this.jTabbedPane1.addTab("Look Up", this.jPanel1);
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.errorListScrollPane.setViewportView(this.jTable1);
        GroupLayout groupLayout4 = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.errorListScrollPane, -1, 611, Short.MAX_VALUE));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout4.createSequentialGroup().addGap(32, 32, 32).addComponent(this.errorListScrollPane, -1, 325, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Error List", this.jPanel2);
        this.statusLabel.setText("Ready");
        GroupLayout groupLayout5 = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(groupLayout5);
        groupLayout5.setHorizontalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout5.createSequentialGroup().addContainerGap().addComponent(this.statusLabel).addContainerGap(575, Short.MAX_VALUE)));
        groupLayout5.setVerticalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.statusLabel, -1, 25, Short.MAX_VALUE));
        GroupLayout groupLayout6 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout6);
        groupLayout6.setHorizontalGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1, -1, 616, Short.MAX_VALUE).addComponent(this.jPanel5, -1, -1, Short.MAX_VALUE));
        groupLayout6.setVerticalGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout6.createSequentialGroup().addComponent(this.jTabbedPane1, -1, 385, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel5, -2, -1, -2)));
        this.pack();
    }

    public void lookup() {
        this.lookupBTActionPerformed(null);
    }

    private void lookupBTActionPerformed(ActionEvent actionEvent) {
        ArrayList<Error> arrayList = null;
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.err_codeTB.getText();
        String string2 = this.err_symbolicTB.getText();
        boolean bl = false;
        if (!string.isEmpty()) {
            arrayList = this.searchError(string, stringBuilder);
        } else if (!string2.isEmpty()) {
            bl = true;
            arrayList = this.searchSymbol(string2, stringBuilder);
        }
        this.err_descriptionTA.setText("");
        this.err_productTB.setText("");
        this.err_symbolicTB.setText("");
        if (arrayList == null || arrayList.isEmpty()) {
            this.err_descriptionTA.setText("Error not found");
            this.err_productTB.setText("Error not found");
            this.err_symbolicTB.setText("Error not found");
        } else {
            int n = 0;
            for (Error error : arrayList) {
                Integer n2 = error.getCode();
                if (arrayList.size() == 1 && !n2.toString().equals(string)) {
                    this.err_descriptionTA.append("Found error code : " + n2.toString() + "\n\n");
                }
                if (bl) {
                    this.err_codeTB.setText(Integer.valueOf(error.getCode()).toString());
                }
                if (n > 0) {
                    this.err_descriptionTA.append("\nAdditional Error Code : " + error.getCode() + "  -  Error Description = ");
                }
                this.err_descriptionTA.append(error.getDescription() + "\n");
                this.err_productTB.setText(stringBuilder.toString());
                this.err_symbolicTB.setText(error.getSymbolicName());
                this.oldDesc = error.getDescription();
                ++n;
            }
        }
    }

    public JTextField getErrorCodeField() {
        return this.err_codeTB;
    }

    public JTextField getErrorSymbolField() {
        return this.err_symbolicTB;
    }

    private void err_codeTBKeyPressed(KeyEvent keyEvent) {
        this.err_descriptionTA.setText("");
        this.err_productTB.setText("");
        this.err_symbolicTB.setText("");
    }

    private void err_symbolicTBKeyPressed(KeyEvent keyEvent) {
        this.err_descriptionTA.setText("");
        this.err_productTB.setText("");
        this.err_codeTB.setText("");
    }

    private void jTabbedPane1StateChanged(ChangeEvent changeEvent) {
        int n = this.jTabbedPane1.getSelectedIndex();
        if (n == 0) {
            this.statusLabel.setText("Ready");
        } else {
            this.statusLabel.setText("Double Click a Row to Edit Error Description");
            String string = this.err_codeTB.getText();
            if (!string.isEmpty()) {
                this.errorsTable.selectRow(string);
            }
        }
    }

    private void saveBTActionPerformed(ActionEvent actionEvent) {
        String string = this.err_descriptionTA.getText();
        if (!string.isEmpty() && !string.equals(this.oldDesc)) {
            StringBuilder stringBuilder = new StringBuilder();
            Product product = null;
            ArrayList<Error> arrayList = this.searchError(this.err_codeTB.getText(), stringBuilder);
            if (arrayList != null && !arrayList.isEmpty()) {
                Error error = arrayList.get(0);
                if (this.modifiedErrors.getProducts().contains(stringBuilder.toString())) {
                    product = this.modifiedErrors.getProducts().getProduct(stringBuilder.toString());
                } else {
                    product = new Product(stringBuilder.toString());
                    this.modifiedErrors.getProducts().getProduct().add(product);
                }
                Error error2 = null;
                for (Error error3 : product.getErrors()) {
                    if (error3.getCode() != error.getCode()) continue;
                    error2 = error3;
                    break;
                }
                if (error2 == null) {
                    error2 = new Error();
                    error2.setCode(error.getCode());
                    error2.setSymbolicName(error.getSymbolicName());
                    product.getErrors().add(error2);
                }
                error2.setDescription(string);
                this.saveUserXML();
                this.fillGrid();
            }
        }
    }

    private void updateBTActionPerformed(ActionEvent actionEvent) {
        boolean bl;
        UpdateErrors updateErrors = new UpdateErrors(this.parent, true);
        updateErrors.setLocationRelativeTo(this.parent);
        if (this.errors == null) {
            this.errors = new FairComErrors();
        }
        if (bl = updateErrors.update(this.xmlFilename, this.errors)) {
            this.saveXML();
            this.fillGrid();
        }
    }

    private ArrayList<Error> searchError(String string, StringBuilder stringBuilder) {
        ArrayList<Error> arrayList = new ArrayList<Error>();
        try {
            int n = Integer.parseInt(string);
            for (Product product : this.errors.getProducts().getProduct()) {
                for (Error error : product.getErrors()) {
                    if (error.getCode() != n) continue;
                    stringBuilder.append(product.getName());
                    arrayList.add(error);
                }
            }
            n = -n;
            for (Product product : this.errors.getProducts().getProduct()) {
                for (Error error : product.getErrors()) {
                    if (error.getCode() != n) continue;
                    stringBuilder.append(product.getName());
                    arrayList.add(error);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrayList;
    }

    private ArrayList<Error> searchSymbol(String string, StringBuilder stringBuilder) {
        ArrayList<Error> arrayList = new ArrayList<Error>();
        for (Product product : this.errors.getProducts().getProduct()) {
            for (Error error : product.getErrors()) {
                if (error == null || !error.getSymbolicName().equalsIgnoreCase(string)) continue;
                stringBuilder.append(product.getName());
                arrayList.add(error);
            }
        }
        return arrayList;
    }

    private void loadErrorsFile() {
        File file = new File(this.xmlFilename);
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{FairComErrors.class});
                Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
                this.errors = (FairComErrors)unmarshaller.unmarshal((InputStream)fileInputStream);
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(this.parent, "Error Description : " + iOException.getMessage(), "Error", 0);
                }
            }
            catch (JAXBException jAXBException) {
                JOptionPane.showMessageDialog(this.parent, "Invalid file", "Error", 0);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    private void loadUserErrorsFile() {
        File file = new File(this.xmlUserFilename);
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{FairComErrors.class});
                Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
                this.modifiedErrors = (FairComErrors)unmarshaller.unmarshal((InputStream)fileInputStream);
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(this.parent, "Error Description : " + iOException.getMessage(), "Error", 0);
                }
            }
            catch (JAXBException jAXBException) {
                JOptionPane.showMessageDialog(this.parent, "Invalid file", "Error", 0);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    private void saveXML() {
        File file = new File(this.xmlFilename);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            try {
                JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{FairComErrors.class});
                Marshaller marshaller = jAXBContext.createMarshaller();
                marshaller.setProperty("jaxb.formatted.output", (Object)true);
                marshaller.setProperty("jaxb.encoding", (Object)"us-ascii");
                marshaller.marshal((Object)this.errors, (OutputStream)fileOutputStream);
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                }
            }
            catch (JAXBException jAXBException) {}
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    private void saveUserXML() {
        File file = new File(this.xmlUserFilename);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            try {
                JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{FairComErrors.class});
                Marshaller marshaller = jAXBContext.createMarshaller();
                marshaller.setProperty("jaxb.formatted.output", (Object)true);
                marshaller.setProperty("jaxb.encoding", (Object)"us-ascii");
                marshaller.marshal((Object)this.modifiedErrors, (OutputStream)fileOutputStream);
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                }
            }
            catch (JAXBException jAXBException) {}
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    private void fillGrid() {
        this.errorsTable.clearTable();
        for (Product product : this.errors.getProducts().getProduct()) {
            for (Error error : product.getErrors()) {
                boolean bl = false;
                if (this.modifiedErrors.getProducts().contains(product.getName())) {
                    Products products = this.modifiedErrors.getProducts();
                    Product product2 = products.getProduct(product.getName());
                    for (Error error2 : product2.getErrors()) {
                        if (error2.getCode() != error.getCode()) continue;
                        bl = true;
                        error.setDescription(error2.getDescription());
                        this.errorsTable.addRow(product, error);
                    }
                }
                if (bl) continue;
                this.errorsTable.addRow(product, error);
            }
        }
        this.errorsTable.getModel().fireTableDataChanged();
    }
}

