/*
 * Decompiled with CFR 0.152.
 */
package FairCom.Helper.ErrorViewer;

import FairCom.Helper.Classes.FcBaseDynamicTable;
import FairCom.Helper.Classes.FcBaseTableModel;
import FairCom.Helper.ErrorViewer.Error;
import FairCom.Helper.ErrorViewer.FairComErrors;
import FairCom.Helper.ErrorViewer.Product;
import FairCom.Helper.ErrorViewer.Products;
import FairCom.Helper.Renderers.FcTextAreaCellRenderer;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

public class ErrorsTable
extends FcBaseDynamicTable {
    private ErrorsTableModel tableModel = new ErrorsTableModel(this);
    protected boolean inError;

    public ErrorsTable(boolean bl) {
        this.setModel(this.tableModel);
        this.tableModel.setupColumns();
        FcBaseTableModel.RowSorter rowSorter = this.tableModel.setRowSorter();
        rowSorter.setComparator(0, this.intComparator);
    }

    @Override
    public ErrorsTableModel getModel() {
        return this.tableModel;
    }

    void addRows(FairComErrors fairComErrors, FairComErrors fairComErrors2) {
        for (Product product : fairComErrors.getProducts().getProduct()) {
            for (Error error : product.getErrors()) {
                boolean bl = false;
                if (fairComErrors2.getProducts().contains(product.getName())) {
                    Products products = fairComErrors2.getProducts();
                    Product product2 = products.getProduct(product.getName());
                    for (Error error2 : product2.getErrors()) {
                        if (error2.getCode() != error.getCode()) continue;
                        bl = true;
                        this.tableModel.addRow(product, error2);
                    }
                }
                if (bl) continue;
                this.tableModel.addRow(product, error);
            }
        }
    }

    void addRow(Product product, Error error) {
        this.tableModel.addRow(product, error);
    }

    void selectRow(String string) {
        this.tableModel.selecRow(string);
    }

    public class ErrorsTableModel
    extends FcBaseTableModel {
        ErrorsTableModel(ErrorsTable errorsTable2) {
            super(errorsTable2, true);
            this.table = errorsTable2;
        }

        private void setupColumns() {
            String[] stringArray = new String[]{"Code", "Symbolic Constant", "Product", "Description"};
            this.clearTable();
            this.addColumns(stringArray);
            TableColumn tableColumn = this.table.getColumnModel().getColumn(0);
            tableColumn.setPreferredWidth(65);
            tableColumn = this.table.getColumnModel().getColumn(1);
            tableColumn.setPreferredWidth(150);
            tableColumn = this.table.getColumnModel().getColumn(2);
            tableColumn.setPreferredWidth(70);
            tableColumn = this.table.getColumnModel().getColumn(3);
            tableColumn.setPreferredWidth(280);
            tableColumn.setCellRenderer(new FcTextAreaCellRenderer());
            this.autoSizeColumns.set(3, true);
            this.rowAutoSizeColumn = 3;
        }

        @Override
        public void addRow(ArrayList<Object> arrayList) {
            FcBaseTableModel.RowData rowData = (FcBaseTableModel)this.new FcBaseTableModel.RowData(arrayList);
            this.addRow(rowData);
        }

        private void addRow(Product product, Error error) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(error.getCode());
            arrayList.add(error.getSymbolicName());
            arrayList.add(product.getName());
            arrayList.add(error.getDescription());
            FcBaseTableModel.RowData rowData = (FcBaseTableModel)this.new FcBaseTableModel.RowData(arrayList);
            this.addRow(rowData);
        }

        private void selecRow(String string) {
            int n = this.getRowCount();
            for (int i = 0; i < n; ++i) {
                Integer n2 = (Integer)this.getValueAt(i, 0);
                if (!n2.toString().equals(string)) continue;
                i = this.table.convertRowIndexToView(i);
                this.table.setRowSelectionInterval(i, i);
                Rectangle rectangle = this.table.getCellRect(i, i, true);
                this.table.scrollRectToVisible(rectangle);
            }
        }
    }

    class PopupActions
    implements ActionListener {
        int mode;

        public PopupActions(int n) {
            this.mode = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = ErrorsTable.this.getSelectedRows();
        }
    }

    public class TTMouseAdapter
    extends MouseMotionAdapter {
        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            JTable jTable = (JTable)mouseEvent.getSource();
            int n = jTable.rowAtPoint(mouseEvent.getPoint());
            int n2 = jTable.columnAtPoint(mouseEvent.getPoint());
            ErrorsTable.this.showTooltip = false;
        }
    }
}

