/*
 * Decompiled with CFR 0.152.
 */
package FairCom.Helper.ErrorViewer;

import FairCom.Helper.ErrorViewer.AppProperties;
import FairCom.Helper.ErrorViewer.Error;
import FairCom.Helper.ErrorViewer.FairComErrors;
import FairCom.Helper.ErrorViewer.Product;
import FairCom.Helper.ErrorViewer.UserFileFilter;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class UpdateErrors
extends JDialog {
    String xmlFilename = "";
    FairComErrors errors;
    boolean saveXML = false;
    AppProperties prop = new AppProperties();
    private JButton ctreeBT;
    private JCheckBox ctreeCB;
    private JTextField ctreeFileTB;
    private JButton dbLayerBT;
    private JCheckBox dbLayerCB;
    private JTextField dbLayerFileTB;
    private JButton exitBT;
    private JFileChooser jFileChooser1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JScrollPane jScrollPane1;
    private JButton othersBT;
    private JCheckBox othersCB;
    private JTextField othersFileTB;
    private JTextArea progressTA;
    private JButton sqlBT;
    private JCheckBox sqlCB;
    private JTextField sqlFileTB;
    private JButton updateBT;

    public UpdateErrors(Frame frame, boolean bl) {
        super(frame, bl);
        if (frame != null) {
            this.setIconImage(frame.getIconImage());
        }
        this.initComponents();
    }

    private void initComponents() {
        this.jFileChooser1 = new JFileChooser();
        this.ctreeCB = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.ctreeFileTB = new JTextField();
        this.ctreeBT = new JButton();
        this.dbLayerBT = new JButton();
        this.dbLayerCB = new JCheckBox();
        this.dbLayerFileTB = new JTextField();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.sqlFileTB = new JTextField();
        this.sqlBT = new JButton();
        this.sqlCB = new JCheckBox();
        this.jLabel4 = new JLabel();
        this.updateBT = new JButton();
        this.exitBT = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.progressTA = new JTextArea();
        this.othersCB = new JCheckBox();
        this.jLabel5 = new JLabel();
        this.othersFileTB = new JTextField();
        this.othersBT = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Update Errors");
        this.ctreeCB.setSelected(true);
        this.ctreeCB.setText("c-tree Errors");
        this.jLabel1.setText("Error File :");
        this.ctreeBT.setText("...");
        this.ctreeBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UpdateErrors.this.ctreeBTActionPerformed(actionEvent);
            }
        });
        this.dbLayerBT.setText("...");
        this.dbLayerBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UpdateErrors.this.dbLayerBTActionPerformed(actionEvent);
            }
        });
        this.dbLayerCB.setSelected(true);
        this.dbLayerCB.setText("dbLayer Errors");
        this.jLabel2.setText("Error File :");
        this.jLabel3.setText("Error File :");
        this.sqlBT.setText("...");
        this.sqlBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UpdateErrors.this.sqlBTActionPerformed(actionEvent);
            }
        });
        this.sqlCB.setSelected(true);
        this.sqlCB.setText("SQL Errors");
        this.jLabel4.setText("Update Progress :");
        this.updateBT.setText("Update");
        this.updateBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UpdateErrors.this.updateBTActionPerformed(actionEvent);
            }
        });
        this.exitBT.setText("Exit");
        this.exitBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UpdateErrors.this.exitBTActionPerformed(actionEvent);
            }
        });
        this.progressTA.setColumns(20);
        this.progressTA.setFont(new Font("Tahoma", 0, 11));
        this.progressTA.setRows(5);
        this.jScrollPane1.setViewportView(this.progressTA);
        this.othersCB.setSelected(true);
        this.othersCB.setText("Other Errors");
        this.jLabel5.setText("Error File :");
        this.othersBT.setText("...");
        this.othersBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UpdateErrors.this.othersBTActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 560, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addGap(175, 175, 175).addComponent(this.updateBT, -2, 80, -2).addGap(97, 97, 97).addComponent(this.exitBT, -2, 80, -2)).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addGap(26, 26, 26).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout.createSequentialGroup().addComponent(this.othersCB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 46, Short.MAX_VALUE).addComponent(this.jLabel5)).addGroup(groupLayout.createSequentialGroup().addComponent(this.sqlCB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 54, Short.MAX_VALUE).addComponent(this.jLabel3)).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addComponent(this.ctreeCB).addGap(40, 40, 40).addComponent(this.jLabel1)).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addComponent(this.dbLayerCB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 34, Short.MAX_VALUE).addComponent(this.jLabel2)).addComponent(this.jLabel4, GroupLayout.Alignment.LEADING, -2, 110, -2)).addGap(18, 18, 18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.ctreeFileTB, -1, 309, Short.MAX_VALUE).addGap(10, 10, 10).addComponent(this.ctreeBT, -2, 26, -2)).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.othersFileTB, -1, 309, Short.MAX_VALUE).addComponent(this.sqlFileTB, GroupLayout.Alignment.LEADING, -1, 309, Short.MAX_VALUE).addComponent(this.dbLayerFileTB, -1, 309, Short.MAX_VALUE)).addGap(10, 10, 10).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sqlBT, -2, 26, -2).addComponent(this.dbLayerBT, -2, 26, -2).addComponent(this.othersBT, -2, 26, -2)))))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(26, 26, 26).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.ctreeCB).addComponent(this.jLabel1).addComponent(this.ctreeFileTB, -2, -1, -2).addComponent(this.ctreeBT))).addGroup(groupLayout.createSequentialGroup().addGap(57, 57, 57).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dbLayerBT).addComponent(this.dbLayerFileTB, -2, -1, -2).addComponent(this.dbLayerCB).addComponent(this.jLabel2)))).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(8, 8, 8).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sqlFileTB, -2, -1, -2).addComponent(this.jLabel3).addGroup(groupLayout.createSequentialGroup().addComponent(this.sqlBT).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.othersBT).addComponent(this.othersFileTB, -2, -1, -2).addComponent(this.jLabel5).addComponent(this.othersCB))))).addGroup(groupLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.sqlCB))).addGap(18, 18, 18).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane1, -1, 121, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.updateBT).addComponent(this.exitBT)).addContainerGap()));
        this.pack();
    }

    private void exitBTActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    private void updateBTActionPerformed(ActionEvent actionEvent) {
        this.progressTA.setText("");
        if (this.ctreeCB.isSelected() && !this.ctreeFileTB.getText().isEmpty() && this.updateCtree()) {
            this.saveXML = true;
        }
        if (this.dbLayerCB.isSelected() && !this.dbLayerFileTB.getText().isEmpty() && this.updateDbLayer()) {
            this.saveXML = true;
        }
        if (this.sqlCB.isSelected() && !this.sqlFileTB.getText().isEmpty() && this.updateSql()) {
            this.saveXML = true;
        }
        if (this.othersCB.isSelected() && !this.othersFileTB.getText().isEmpty() && this.updateOthers()) {
            this.saveXML = true;
        }
    }

    private void ctreeBTActionPerformed(ActionEvent actionEvent) {
        String string = this.getFile("ctree header files (cterrc.h)", "cterrc.h", this.prop.ctreeFile);
        this.ctreeFileTB.setText(string);
        this.prop.ctreeFile = string;
        this.prop.saveProperties();
    }

    private void dbLayerBTActionPerformed(ActionEvent actionEvent) {
        String string = this.getFile("dbLayer header files (ctdbsdk.h)", "ctdbsdk.h", this.prop.dbLayerFile);
        this.dbLayerFileTB.setText(string);
        this.prop.dbLayerFile = string;
        this.prop.saveProperties();
    }

    private void sqlBTActionPerformed(ActionEvent actionEvent) {
        String string = this.getFile("SQL header files (dherrors.h)", "dherrors.h", this.prop.sqlFile);
        this.sqlFileTB.setText(string);
        this.prop.sqlFile = string;
        this.prop.saveProperties();
    }

    private void othersBTActionPerformed(ActionEvent actionEvent) {
        String string = this.getFile("Other files", this.prop.othersFile, this.prop.othersFile);
        this.othersFileTB.setText(string);
        this.prop.othersFile = string;
        this.prop.saveProperties();
    }

    boolean update(String string, FairComErrors fairComErrors) {
        this.prop.loadProperties();
        this.ctreeFileTB.setText(this.prop.ctreeFile);
        this.dbLayerFileTB.setText(this.prop.dbLayerFile);
        this.sqlFileTB.setText(this.prop.sqlFile);
        this.othersFileTB.setText(this.prop.othersFile);
        this.xmlFilename = string;
        this.errors = fairComErrors;
        this.setVisible(true);
        return this.saveXML;
    }

    private boolean updateCtree() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        String string = "";
        String string2 = "c-tree";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        Product product = this.errors.getProducts().getProduct(string2);
        if (product == null) {
            product = new Product(string2);
            this.errors.getProducts().add(product);
        }
        this.progressTA.append("Updating ctree...");
        try {
            String string7;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.ctreeFileTB.getText()));
            while ((string7 = bufferedReader.readLine()) != null) {
                String[] stringArray;
                Object object;
                ++n;
                String[] stringArray2 = string7.split(" +|\\t|,");
                if (stringArray2.length > 3 && stringArray2[0].equals("#define")) {
                    int n5;
                    int n6 = 2;
                    while (stringArray2[n6].length() == 0) {
                        ++n6;
                    }
                    try {
                        n5 = Integer.parseInt(stringArray2[n6]);
                    }
                    catch (Exception exception) {
                        this.progressTA.append("\r\n\t" + exception.getMessage() + " - Line number = " + n);
                        continue;
                    }
                    if (stringArray2.length == 4) {
                        if (stringArray2[1].equals(string3) || stringArray2[1].equals(string4) || stringArray2[1].equals(string5)) {
                            string = string6;
                        }
                    } else {
                        string = "";
                        int n7 = 4;
                        while (n7 < stringArray2.length && !stringArray2[n7].equals("*/")) {
                            string = string + stringArray2[n7++].trim() + " ";
                        }
                        bufferedReader.mark(100);
                        string7 = bufferedReader.readLine();
                        while (!string7.startsWith("#define")) {
                            string = string + "\n" + string7.trim();
                            string7 = bufferedReader.readLine();
                        }
                        bufferedReader.reset();
                    }
                    string = string.trim();
                    string = string.replace("/*", "");
                    if ((string = string.replace("*/", "")).startsWith("/*")) {
                        string = string.substring(2, string.length() - 2);
                    }
                    if (string.endsWith("*/")) {
                        string = string.substring(0, string.length() - 2);
                    }
                    if (!product.contains(n5)) {
                        object = new Error();
                        ((Error)object).setCode(n5);
                        ((Error)object).setDescription(string);
                        ((Error)object).setSymbolicName(stringArray2[1]);
                        product.getErrors().add((Error)object);
                        ++n3;
                    } else {
                        for (Error error : product.getErrors()) {
                            if (error.getCode() != n5 || !error.getSymbolicName().equals(stringArray2[1]) || error.getDescription().equals(string)) continue;
                            error.setDescription(string);
                            ++n4;
                            break;
                        }
                    }
                    ++n2;
                    continue;
                }
                if (string7.contains("** Symbolic Constant:")) {
                    ++n;
                    stringArray = string7.split("\\*\\* Symbolic Constant:");
                    if (stringArray.length > 1) {
                        string3 = stringArray[1].trim();
                    }
                    string6 = string7 + "\n";
                    while (!string7.equals("*/")) {
                        string7 = bufferedReader.readLine();
                        string6 = string6 + string7 + "\n";
                    }
                    continue;
                }
                if (!string7.contains("** Symbolic Constants:")) continue;
                ++n;
                stringArray = string7.split("\\*\\* Symbolic Constants:");
                if (stringArray.length > 1) {
                    object = stringArray[1].split("/");
                    string3 = object[0].trim();
                    string4 = object[1].trim();
                    string5 = object[2].trim();
                }
                string6 = string7 + "\n";
                while (!string7.equals("*/")) {
                    string7 = bufferedReader.readLine();
                    string6 = string6 + string7 + "\n";
                }
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(this, "Error Description : " + fileNotFoundException.getMessage(), "Error", 0);
        }
        catch (IOException iOException) {
            Logger.getLogger(UpdateErrors.class.getName()).log(Level.SEVERE, null, iOException);
        }
        this.progressTA.append("\r\n\tc-tree Update result :\r\n\t\tFiles Entries = " + n2 + "\r\n\t\tNew Entries Added = " + n3);
        this.progressTA.append("\r\n\t\tUpdated Entries = " + n4);
        this.progressTA.append("\r\nc-tree Update Terminated\n\n");
        return n3 > 0 || n4 > 0;
    }

    private boolean updateDbLayer() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        String string = "dbLayer";
        Product product = this.errors.getProducts().getProduct(string);
        if (product == null) {
            product = new Product(string);
            this.errors.getProducts().add(product);
        }
        this.progressTA.append("Updating dbLayer...");
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.dbLayerFileTB.getText()));
            while ((string2 = bufferedReader.readLine()) != null) {
                if (!string2.contains("CTDB C API return codes")) continue;
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (!string2.contains("CTDBRET_OK")) continue;
                    do {
                        String string32;
                        String[] stringArray = string2.split("\\s|\\t|,");
                        ArrayList<String> arrayList = new ArrayList<String>();
                        for (String string32 : stringArray) {
                            if (string32.isEmpty()) continue;
                            arrayList.add(string32);
                        }
                        String[] stringArray2 = new String[]{""};
                        if (!(stringArray2 = arrayList.toArray(stringArray2))[0].startsWith("CTDBRET_")) continue;
                        int n5 = -999;
                        try {
                            n5 = Integer.parseInt(stringArray2[2]);
                        }
                        catch (Exception exception) {
                            this.progressTA.append("\r\n\t" + exception.getMessage() + " - Line number = " + n);
                            continue;
                        }
                        String string4 = stringArray2[0];
                        string32 = "";
                        int n6 = 4;
                        while (n6 < stringArray2.length && !stringArray2[n6].equals("*/")) {
                            string32 = string32 + " " + stringArray2[n6++];
                        }
                        Error error = null;
                        if (!product.contains(n5)) {
                            error = new Error();
                            product.getErrors().add(error);
                            ++n3;
                        } else {
                            for (Error error2 : product.getErrors()) {
                                if (error2.getCode() != n5 || !error2.getSymbolicName().equals(string4) || error2.getDescription().equals(string32)) continue;
                                error = error2;
                                ++n4;
                                break;
                            }
                        }
                        if (error != null) {
                            error.setDescription(string32);
                            error.setSymbolicName(string4);
                            error.setCode(n5);
                        }
                        ++n2;
                    } while ((string2 = bufferedReader.readLine()) != null && !string2.startsWith("} CTDBRET"));
                }
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(this, "Error Description : " + fileNotFoundException.getMessage(), "Error", 0);
        }
        catch (IOException iOException) {
            Logger.getLogger(UpdateErrors.class.getName()).log(Level.SEVERE, null, iOException);
        }
        this.progressTA.append("\r\n\tdbLayer Update result :\r\n\t\tFiles Entries = " + n2 + "\r\n\t\tNew Entries Added = " + n3);
        this.progressTA.append("\r\n\t\tUpdated Entries = " + n4);
        this.progressTA.append("\r\ndbLayer Update Terminated\n\n");
        return n3 > 0 || n4 > 0;
    }

    private boolean updateSql() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        String string = "SQL";
        Product product = this.errors.getProducts().getProduct(string);
        if (product == null) {
            product = new Product(string);
            this.errors.getProducts().add(product);
        }
        this.progressTA.append("Updating SQL...");
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.sqlFileTB.getText()));
            while ((string2 = bufferedReader.readLine()) != null) {
                if (!string2.contains("-100")) continue;
                do {
                    int n5;
                    String string32;
                    String[] stringArray = string2.split("\\{|\\}|\\(|\\)|,");
                    ArrayList<String> arrayList = new ArrayList<String>();
                    for (String string32 : stringArray) {
                        if (string32.isEmpty()) continue;
                        arrayList.add(string32);
                    }
                    String[] stringArray2 = new String[]{""};
                    if ((stringArray2 = arrayList.toArray(stringArray2)) == null || stringArray2.length <= 1 || !stringArray2[1].startsWith("-")) continue;
                    int n6 = -999;
                    try {
                        n6 = Integer.parseInt(stringArray2[1]);
                    }
                    catch (Exception exception) {
                        this.progressTA.append("\r\n\t" + exception.getMessage() + " - Line number = " + n);
                        continue;
                    }
                    String string4 = stringArray2[0];
                    string32 = "";
                    for (n5 = stringArray2.length - 1; n5 >= 0 && !stringArray2[n5].equals("DH_STRING_LITERAL"); --n5) {
                    }
                    ++n5;
                    while (n5 < stringArray2.length) {
                        string32 = string32 + " " + stringArray2[n5++] + " ";
                    }
                    string32 = string32.replace("\"", "");
                    Error error = null;
                    if (!product.contains(n6)) {
                        error = new Error();
                        product.getErrors().add(error);
                        ++n3;
                    } else {
                        for (Error error2 : product.getErrors()) {
                            if (error2.getCode() != n6 || !error2.getSymbolicName().equals(string4) || error2.getDescription().equals(string32)) continue;
                            error = error2;
                            ++n4;
                            break;
                        }
                    }
                    if (error != null) {
                        error.setDescription(string32);
                        error.setSymbolicName(string4);
                        error.setCode(n6);
                    }
                    ++n2;
                } while ((string2 = bufferedReader.readLine()) != null && !string2.startsWith("} CTDBRET"));
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(this, "Error Description : " + fileNotFoundException.getMessage(), "Error", 0);
        }
        catch (IOException iOException) {
            Logger.getLogger(UpdateErrors.class.getName()).log(Level.SEVERE, null, iOException);
        }
        this.progressTA.append("\r\n\tSQL Update result :\r\n\t\tFiles Entries = " + n2 + "\r\n\t\tNew Entries Added = " + n3);
        this.progressTA.append("\r\n\t\tUpdated Entries = " + n4);
        this.progressTA.append("\r\nSQL Update Terminated\n\n");
        return n3 > 0 || n4 > 0;
    }

    private boolean updateOthers() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        String string = "";
        String string2 = "Others";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        Product product = this.errors.getProducts().getProduct(string2);
        if (product == null) {
            product = new Product(string2);
            this.errors.getProducts().add(product);
        }
        this.progressTA.append("Updating Others...");
        try {
            String string7;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.othersFileTB.getText()));
            while ((string7 = bufferedReader.readLine()) != null) {
                String[] stringArray;
                Object object;
                ++n;
                String[] stringArray2 = string7.split(" +|\\t|,");
                if (stringArray2.length > 3 && stringArray2[0].equals("#define")) {
                    int n5;
                    int n6 = 2;
                    while (stringArray2[n6].length() == 0) {
                        ++n6;
                    }
                    try {
                        n5 = Integer.parseInt(stringArray2[n6]);
                    }
                    catch (Exception exception) {
                        this.progressTA.append("\r\n\t" + exception.getMessage() + " - Line number = " + n);
                        continue;
                    }
                    if (stringArray2.length == 4) {
                        if (stringArray2[1].equals(string3) || stringArray2[1].equals(string4) || stringArray2[1].equals(string5)) {
                            string = string6;
                        }
                    } else {
                        string = "";
                        int n7 = 4;
                        while (n7 < stringArray2.length && !stringArray2[n7].equals("*/")) {
                            string = string + stringArray2[n7++].trim() + " ";
                        }
                        bufferedReader.mark(100);
                        string7 = bufferedReader.readLine();
                        while (!string7.startsWith("#")) {
                            string = string + "\n" + string7.trim();
                            string7 = bufferedReader.readLine();
                            if (string7 != null) continue;
                        }
                        try {
                            bufferedReader.reset();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    string = string.trim();
                    string = string.replace("/*", "");
                    if ((string = string.replace("*/", "")).startsWith("/*")) {
                        string = string.substring(2, string.length() - 2);
                    }
                    if (string.endsWith("*/")) {
                        string = string.substring(0, string.length() - 2);
                    }
                    if (!product.contains(n5)) {
                        object = new Error();
                        ((Error)object).setCode(n5);
                        ((Error)object).setDescription(string);
                        ((Error)object).setSymbolicName(stringArray2[1]);
                        product.getErrors().add((Error)object);
                        ++n3;
                    } else {
                        for (Error error : product.getErrors()) {
                            if (error.getCode() != n5 || !error.getSymbolicName().equals(stringArray2[1]) || error.getDescription().equals(string)) continue;
                            error.setDescription(string);
                            ++n4;
                            break;
                        }
                    }
                    ++n2;
                    continue;
                }
                if (string7.contains("** Symbolic Constant:")) {
                    ++n;
                    stringArray = string7.split("\\*\\* Symbolic Constant:");
                    if (stringArray.length > 1) {
                        string3 = stringArray[1].trim();
                    }
                    string6 = string7 + "\n";
                    while (!string7.equals("*/")) {
                        string7 = bufferedReader.readLine();
                        string6 = string6 + string7 + "\n";
                    }
                    continue;
                }
                if (!string7.contains("** Symbolic Constants:")) continue;
                ++n;
                stringArray = string7.split("\\*\\* Symbolic Constants:");
                if (stringArray.length > 1) {
                    object = stringArray[1].split("/");
                    string3 = object[0].trim();
                    string4 = object[1].trim();
                    string5 = object[2].trim();
                }
                string6 = string7 + "\n";
                while (!string7.equals("*/")) {
                    string7 = bufferedReader.readLine();
                    string6 = string6 + string7 + "\n";
                }
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(this, "Error Description : " + fileNotFoundException.getMessage(), "Error", 0);
        }
        catch (IOException iOException) {
            Logger.getLogger(UpdateErrors.class.getName()).log(Level.SEVERE, null, iOException);
        }
        this.progressTA.append("\r\n\tOthers Update result :\r\n\t\tFiles Entries = " + n2 + "\r\n\t\tNew Entries Added = " + n3);
        this.progressTA.append("\r\n\t\tUpdated Entries = " + n4);
        this.progressTA.append("\r\nOthers Update Terminated\n\n");
        return n3 > 0 || n4 > 0;
    }

    private String getFile(String string, String string2, String string3) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.addChoosableFileFilter(new UserFileFilter(string, string2));
        jFileChooser.setFileSelectionMode(0);
        File file = new File(string3);
        jFileChooser.setCurrentDirectory(file);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            File file2 = jFileChooser.getSelectedFile();
            return file2.getAbsolutePath();
        }
        return string3;
    }
}

