/*
 * Decompiled with CFR 0.152.
 */
package FairCom.Helper.Renderers;

import FairCom.Helper.Classes.FcBaseTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class FcBooleanCellRenderer
extends JCheckBox
implements TableCellRenderer {
    int headerWidth = 0;
    int cellWidth = 0;
    int previousColWidth = 0;
    int newColWidth = 0;
    boolean displayText;
    FontMetrics metrics = this.getFontMetrics(this.getFont());
    private static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

    public FcBooleanCellRenderer(boolean bl) {
        this.displayText = bl;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Object object2;
        FcBaseTableModel fcBaseTableModel = (FcBaseTableModel)jTable.getModel();
        if (bl) {
            this.setForeground(jTable.getSelectionForeground());
            this.setBackground(jTable.getSelectionBackground());
        } else {
            this.setForeground(jTable.getForeground());
            this.setBackground(jTable.getBackground());
        }
        if (object instanceof String) {
            object2 = object.toString().toLowerCase();
            object = ((String)object2).equals("yes") || ((String)object2).equals("y") || ((String)object2).equals("true") ? Boolean.TRUE : Boolean.FALSE;
        }
        this.setSelected(object != null && (Boolean)object != false);
        if (this.displayText) {
            if (object == null) {
                if (fcBaseTableModel.showNullAsEmpty) {
                    this.setText("");
                } else {
                    this.setText("(null)");
                    if (!bl) {
                        this.setForeground(Color.gray);
                    }
                }
            } else if (((Boolean)object).booleanValue()) {
                this.setText("(True)");
            } else {
                this.setText("(False)");
            }
        }
        if (bl2) {
            this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
        } else {
            this.setBorder(noFocusBorder);
        }
        this.setBorder(new CompoundBorder(new EmptyBorder(new Insets(1, 3, 1, 3)), this.getBorder()));
        if (!fcBaseTableModel.suspendAutoSize) {
            object2 = jTable.getColumnModel().getColumn(n2);
            String string = (String)((TableColumn)object2).getHeaderValue();
            this.headerWidth = this.metrics.stringWidth(string) + 15;
            this.newColWidth = this.displayText ? Math.max(this.headerWidth, 75) : Math.max(this.headerWidth, 22);
            this.previousColWidth = ((TableColumn)object2).getPreferredWidth();
            ((TableColumn)object2).setPreferredWidth(Math.max(this.previousColWidth, this.newColWidth));
        }
        return this;
    }
}

