/*
 * Decompiled with CFR 0.152.
 */
package FairCom.Helper.Renderers;

import FairCom.Helper.Classes.FcBaseTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Insets;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class FcComboBoxCellRenderer
extends JComboBox
implements TableCellRenderer {
    int headerWidth = 0;
    int cellWidth = 0;
    int maxWidth = 0;
    int previousColWidth;
    int newColWidth;
    FontMetrics metrics = this.getFontMetrics(this.getFont());
    private static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

    public FcComboBoxCellRenderer(String[] stringArray) {
        super(stringArray);
        for (String string : stringArray) {
            this.cellWidth = this.metrics.stringWidth(string) + 35;
            if (this.cellWidth <= this.maxWidth) continue;
            this.maxWidth = this.cellWidth;
        }
        this.setEditable(false);
    }

    public FcComboBoxCellRenderer() {
        this.setEditable(false);
    }

    public void setItems(String[] stringArray) {
        for (String string : stringArray) {
            super.addItem(string);
            this.cellWidth = this.metrics.stringWidth(string) + 35;
            if (this.cellWidth <= this.maxWidth) continue;
            this.maxWidth = this.cellWidth;
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (bl) {
            this.setForeground(Color.BLACK);
            this.setBackground(jTable.getSelectionBackground());
        } else {
            this.setForeground(jTable.getForeground());
            this.setBackground(jTable.getBackground());
        }
        this.setSelectedItem(object);
        if (bl2) {
            this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
        } else {
            this.setBorder(noFocusBorder);
        }
        this.setBorder(new CompoundBorder(new EmptyBorder(new Insets(1, 3, 1, 3)), this.getBorder()));
        FcBaseTableModel fcBaseTableModel = (FcBaseTableModel)jTable.getModel();
        if (!fcBaseTableModel.suspendAutoSize) {
            TableColumn tableColumn = jTable.getColumnModel().getColumn(n2);
            String string = (String)tableColumn.getHeaderValue();
            this.headerWidth = this.metrics.stringWidth(string) + 15;
            this.newColWidth = Math.max(this.headerWidth, this.maxWidth);
            this.previousColWidth = tableColumn.getPreferredWidth();
            tableColumn.setPreferredWidth(Math.max(this.previousColWidth, this.newColWidth));
        }
        return this;
    }
}

