/*
 * Decompiled with CFR 0.152.
 */
package FairCom.Helper.Renderers;

import FairCom.Helper.Classes.FcBaseTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class FcDateCellRenderer
extends DefaultTableCellRenderer {
    int headerWidth = 0;
    int cellWidth = 0;
    int previousColWidth = 0;
    int newCellWidth = 0;
    FontMetrics metrics = this.getFontMetrics(this.getFont());
    DateFormat dateFormatter = DateFormat.getDateInstance(3);
    DateFormat timeFormatter = DateFormat.getTimeInstance(2);
    DateFormat dateTimeFormatter = DateFormat.getDateTimeInstance(3, 2);

    public FcDateCellRenderer() {
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)this.dateFormatter;
        String string = simpleDateFormat.toPattern();
        int n = string.length();
        int n2 = string.lastIndexOf(121) + 1;
        string = string.substring(0, n2) + "yy" + (n2 < n ? string.substring(n2, n) : "");
        simpleDateFormat.applyPattern(string);
        simpleDateFormat = (SimpleDateFormat)this.dateTimeFormatter;
        string = simpleDateFormat.toPattern();
        n = string.length();
        n2 = string.lastIndexOf(121) + 1;
        string = string.substring(0, n2) + "yy" + (n2 < n ? string.substring(n2, n) : "");
        simpleDateFormat.applyPattern(string);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        FcBaseTableModel fcBaseTableModel = (FcBaseTableModel)jTable.getModel();
        FcDateCellRenderer fcDateCellRenderer = this;
        if (bl) {
            super.setForeground(jTable.getSelectionForeground());
            super.setBackground(jTable.getSelectionBackground());
        } else {
            super.setForeground(jTable.getForeground());
            super.setBackground(jTable.getBackground());
        }
        if (object == null) {
            if (fcBaseTableModel.showNullAsEmpty) {
                this.setValue("");
            } else {
                this.setValue("(null)");
                if (!bl) {
                    ((JComponent)fcDateCellRenderer).setForeground(Color.gray);
                }
            }
        } else {
            int n3 = 0;
            Class<?> clazz = jTable.getColumnClass(n2);
            try {
                if (clazz == Date.class) {
                    this.setText(object == null ? "" : this.dateFormatter.format(object));
                    n3 = 25;
                } else if (clazz == Time.class) {
                    this.setText(object == null ? "" : this.timeFormatter.format(object));
                    n3 = 15;
                } else if (clazz == Timestamp.class) {
                    n3 = 15;
                    this.setText(object == null ? "" : this.dateTimeFormatter.format(object));
                }
            }
            catch (Exception exception) {
                this.setText("(Invalid Value)");
            }
            if (!fcBaseTableModel.suspendAutoSize) {
                TableColumn tableColumn = jTable.getColumnModel().getColumn(n2);
                String string = (String)tableColumn.getHeaderValue();
                this.headerWidth = this.metrics.stringWidth(string) + 15;
                this.cellWidth = this.metrics.stringWidth(this.getText()) + 10 + n3;
                this.newCellWidth = Math.max(this.headerWidth, this.cellWidth);
                this.previousColWidth = tableColumn.getPreferredWidth();
                tableColumn.setPreferredWidth(Math.max(this.previousColWidth, this.newCellWidth));
            }
        }
        return this;
    }
}

