/*
 * Decompiled with CFR 0.152.
 */
package FairCom.Helper.Renderers;

import FairCom.Helper.Classes.FcBaseTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class FcNumberCellRenderer
extends DefaultTableCellRenderer {
    int headerWidth = 0;
    int cellWidth = 0;
    int previousColWidth = 0;
    int newCellWidth = 0;
    FontMetrics metrics = this.getFontMetrics(this.getFont());
    private final NumberFormat intFormatter = NumberFormat.getIntegerInstance();
    private final NumberFormat floatFormatter = NumberFormat.getNumberInstance();
    Object obj = null;

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Serializable serializable;
        FcBaseTableModel fcBaseTableModel = (FcBaseTableModel)jTable.getModel();
        FcNumberCellRenderer fcNumberCellRenderer = this;
        if (bl) {
            super.setForeground(jTable.getSelectionForeground());
            super.setBackground(jTable.getSelectionBackground());
        } else {
            super.setForeground(jTable.getForeground());
            super.setBackground(jTable.getBackground());
        }
        if (object == null) {
            if (fcBaseTableModel.showNullAsEmpty) {
                this.setValue("");
            } else {
                this.setValue("(null)");
                if (!bl) {
                    ((JComponent)fcNumberCellRenderer).setForeground(Color.gray);
                }
            }
        } else if (object == "-") {
            this.setValue("-");
            if (!bl) {
                ((JComponent)fcNumberCellRenderer).setForeground(Color.gray);
            }
        } else {
            serializable = jTable.getColumnClass(n2);
            boolean bl3 = fcBaseTableModel.isColumnTypeUnsigned(n2);
            try {
                if (serializable == Short.class) {
                    short s = Short.parseShort(object.toString());
                    if (bl3) {
                        int n3 = s & 0xFF;
                        this.setValue(this.intFormatter.format(n3));
                    } else {
                        this.setValue(this.intFormatter.format(s));
                    }
                } else if (serializable == Integer.class) {
                    int n4 = Integer.parseInt(object.toString());
                    if (bl3) {
                        long l = (long)n4 & 0xFFFFL;
                        this.setValue(this.intFormatter.format(l));
                    } else {
                        this.setValue(this.intFormatter.format(n4));
                    }
                } else if (serializable == Long.class) {
                    long l = Long.parseLong(object.toString());
                    if (bl3) {
                        long l2 = l & 0xFFFFFFFFL;
                        this.setValue(this.intFormatter.format(l2));
                    } else {
                        this.setValue(this.intFormatter.format(l));
                    }
                } else if (serializable == BigDecimal.class || serializable == BigInteger.class) {
                    int n5 = fcBaseTableModel.columnsScale.get(fcBaseTableModel.getDataColumnNumber(n2));
                    if (n5 > -1) {
                        this.floatFormatter.setMinimumFractionDigits(n5);
                        this.floatFormatter.setMaximumFractionDigits(n5);
                    } else {
                        this.floatFormatter.setMinimumFractionDigits(0);
                        this.floatFormatter.setMaximumFractionDigits(9);
                    }
                    this.setValue(this.floatFormatter.format(object));
                } else if (serializable == Float.class || serializable == Double.class) {
                    int n6 = fcBaseTableModel.columnsScale.get(fcBaseTableModel.getDataColumnNumber(n2));
                    if (n6 > -1) {
                        this.floatFormatter.setMinimumFractionDigits(n6);
                        this.floatFormatter.setMaximumFractionDigits(n6);
                    } else {
                        this.floatFormatter.setMinimumFractionDigits(0);
                        this.floatFormatter.setMaximumFractionDigits(9);
                    }
                    Double d = Double.parseDouble(object.toString());
                    this.setValue(this.floatFormatter.format(d));
                } else {
                    int n7 = fcBaseTableModel.columnsScale.get(fcBaseTableModel.getDataColumnNumber(n2));
                    if (n7 > -1) {
                        this.floatFormatter.setMinimumFractionDigits(n7);
                        this.floatFormatter.setMaximumFractionDigits(n7);
                    } else {
                        this.floatFormatter.setMinimumFractionDigits(0);
                        this.floatFormatter.setMaximumFractionDigits(9);
                    }
                    this.setValue(this.floatFormatter.format(object));
                }
            }
            catch (Exception exception) {
                this.setValue("(Invalid Value)");
            }
        }
        fcNumberCellRenderer.setHorizontalAlignment(4);
        if (!fcBaseTableModel.suspendAutoSize) {
            serializable = jTable.getColumnModel().getColumn(n2);
            String string = (String)((TableColumn)serializable).getHeaderValue();
            this.headerWidth = this.metrics.stringWidth(string) + 15;
            this.cellWidth = this.metrics.stringWidth(this.getText()) + 10;
            this.newCellWidth = Math.max(this.headerWidth, this.cellWidth);
            this.previousColWidth = ((TableColumn)serializable).getPreferredWidth();
            ((TableColumn)serializable).setPreferredWidth(Math.max(this.previousColWidth, this.newCellWidth));
        }
        return this;
    }
}

