/*
 * Decompiled with CFR 0.152.
 */
package rtgmigrate;

import FairCom.Helper.Classes.FcDynamicTree;
import FairCom.Helper.Classes.FcTreeNode;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import rtgmigrate.Globals;
import rtgmigrate.MyTreeNode;

public class FilesTree
extends FcDynamicTree {
    private boolean showHiddenDirs = false;
    private boolean openWithResources = false;
    private String[] filters = null;
    private final ArrayList<String> expandedNodes = new ArrayList();
    private MyTreeNode currentTreeNode;
    private String tempPath;
    private int pathLevel;
    private boolean inverted = false;
    private static final Comparator<File> sortByName = new Comparator<File>(){

        @Override
        public int compare(File file, File file2) {
            String string = file.getName().toLowerCase();
            String string2 = file2.getName().toLowerCase();
            return string.compareTo(string2);
        }
    };

    public FilesTree() {
        this.addTreeExpansionListener(new myTreeExpansionListener());
    }

    void refreshTree() {
        MyTreeNode myTreeNode = (MyTreeNode)this.getLastSelectedPathComponent();
        String string = null;
        if (myTreeNode != null) {
            string = myTreeNode.getFilename();
        }
        this.getExpandedNodes();
        this.fillTree();
        this.expandSavedNodes();
        if (string != null) {
            this.selectFile(string);
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        MyTreeNode myTreeNode = (MyTreeNode)this.getLastSelectedPathComponent();
        if (myTreeNode != null) {
            int n = myTreeNode.getLevel();
            if (n < 1 || myTreeNode == null) {
                return;
            }
            if (this.getCurrentTreeNode() == myTreeNode) {
                return;
            }
            this.setCurrentTreeNode(myTreeNode);
        }
    }

    void refreshNode(MyTreeNode myTreeNode) {
    }

    public void fillTree() {
        this.clear();
        if (this.tempPath.length() > 0) {
            MyTreeNode myTreeNode = new MyTreeNode(this.tempPath);
            myTreeNode.setFileName(this.tempPath);
            myTreeNode.setFileType(FILE_TYPE.CLSDIR);
            MyTreeNode myTreeNode2 = (MyTreeNode)this.addObject(myTreeNode);
            File file = new File(this.tempPath);
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                MyTreeNode myTreeNode3 = new MyTreeNode("");
                this.addObject(myTreeNode2, myTreeNode3);
            }
        } else {
            for (File file : File.listRoots()) {
                String string = file.getPath();
                MyTreeNode myTreeNode = new MyTreeNode(string);
                myTreeNode.setFileName(string);
                myTreeNode.setFileType(FILE_TYPE.HARDDISK);
                MyTreeNode myTreeNode4 = (MyTreeNode)this.addObject(myTreeNode);
                File[] fileArray = file.listFiles();
                if (fileArray == null) continue;
                MyTreeNode myTreeNode5 = new MyTreeNode("");
                this.addObject(myTreeNode4, myTreeNode5);
            }
        }
    }

    public void setFileFilter(String string, boolean bl) {
        this.filters = string.split(";");
        this.inverted = !bl;
    }

    public void expandDirectory(MyTreeNode myTreeNode, File file) {
        myTreeNode.removeAllChildren();
        boolean bl = true;
        do {
            bl = !bl;
            File[] fileArray = file.listFiles(new MyFileFilter(bl));
            Arrays.sort(fileArray, sortByName);
            if (fileArray == null) continue;
            for (File file2 : fileArray) {
                if (file2.isHidden() && !this.showHiddenDirs || !this.isFileInFilter(file2)) continue;
                MyTreeNode myTreeNode2 = new MyTreeNode(file2.getName());
                myTreeNode2.setFileType(FILE_TYPE.CLSDIR);
                myTreeNode2.setFileName(file2.getAbsolutePath());
                if (file2.isDirectory()) {
                    if (!file2.canRead()) {
                        myTreeNode2.setFileType(FILE_TYPE.CLSDIRRED);
                    } else {
                        myTreeNode2.setFileType(FILE_TYPE.CLSDIR);
                    }
                } else if (file2.isFile()) {
                    myTreeNode2.setFileType(FILE_TYPE.FILE);
                    this.setNodeColor(myTreeNode2);
                }
                File[] fileArray2 = file2.listFiles();
                if (fileArray2 != null && fileArray2.length > 0) {
                    MyTreeNode myTreeNode3 = new MyTreeNode("");
                    this.addObject(myTreeNode2, myTreeNode3);
                }
                this.addObject(myTreeNode, myTreeNode2);
            }
        } while (!bl);
        this.myTreeModel.reload((TreeNode)((Object)myTreeNode));
    }

    private void getExpandedNodes() {
        this.expandedNodes.clear();
        FcTreeNode fcTreeNode = (FcTreeNode)this.getModel().getRoot();
        if (fcTreeNode.getChildCount() >= 0) {
            Enumeration enumeration = fcTreeNode.children();
            while (enumeration.hasMoreElements()) {
                MyTreeNode myTreeNode = (MyTreeNode)enumeration.nextElement();
                if (myTreeNode.isExpanded()) {
                    this.expandedNodes.add(myTreeNode.getFilename());
                }
                this._getExpandedNodes(myTreeNode);
            }
        }
    }

    private void _getExpandedNodes(MyTreeNode myTreeNode) {
        if (myTreeNode.getChildCount() >= 0) {
            Enumeration enumeration = myTreeNode.children();
            while (enumeration.hasMoreElements()) {
                MyTreeNode myTreeNode2 = (MyTreeNode)enumeration.nextElement();
                if (myTreeNode2.isExpanded()) {
                    this.expandedNodes.add(myTreeNode2.getFilename());
                }
                this._getExpandedNodes(myTreeNode2);
            }
        }
    }

    private void expandSavedNodes() {
        FcTreeNode fcTreeNode = (FcTreeNode)this.getModel().getRoot();
        if (fcTreeNode.getChildCount() >= 0) {
            Enumeration enumeration = fcTreeNode.children();
            while (enumeration.hasMoreElements()) {
                MyTreeNode myTreeNode = (MyTreeNode)enumeration.nextElement();
                if (this.expandedNodes.contains(myTreeNode.getFilename())) {
                    this.expandNode((DefaultMutableTreeNode)((Object)myTreeNode));
                }
                this._expandSavedNodes(myTreeNode);
            }
        }
    }

    private void _expandSavedNodes(MyTreeNode myTreeNode) {
        if (myTreeNode.getChildCount() >= 0) {
            Enumeration enumeration = myTreeNode.children();
            while (enumeration.hasMoreElements()) {
                MyTreeNode myTreeNode2 = (MyTreeNode)enumeration.nextElement();
                if (!this.expandedNodes.contains(myTreeNode2.getFilename())) continue;
                this.expandNode((DefaultMutableTreeNode)((Object)myTreeNode2));
                this._expandSavedNodes(myTreeNode2);
            }
        }
    }

    public void setShowHiddenDirs(boolean bl) {
        this.showHiddenDirs = bl;
    }

    void setPath(String string) {
        this.tempPath = string;
    }

    public void selectFile(String string) {
        if (string != null) {
            Globals.ShowWaitCursor();
            this.pathLevel = 0;
            FcTreeNode fcTreeNode = (FcTreeNode)this.getModel().getRoot();
            MyTreeNode myTreeNode = this.selectFile(fcTreeNode, string.toLowerCase());
            if (myTreeNode != null) {
                TreePath treePath = new TreePath(myTreeNode.getPath());
                this.setSelectionPath(treePath);
                this.scrollPathToVisible(treePath);
            }
            Globals.ShowNormalCursor();
        }
    }

    private MyTreeNode selectFile(FcTreeNode fcTreeNode, String string) {
        String string2 = File.separator;
        String[] stringArray = string.split(string2 + string2);
        String string3 = "";
        int n = 0;
        do {
            if (n > 0) {
                string3 = string3 + File.separator;
            }
            if (n >= stringArray.length) continue;
            string3 = string3 + stringArray[n].toLowerCase();
        } while (++n <= this.pathLevel);
        if (fcTreeNode.getChildCount() >= 0) {
            Enumeration enumeration = fcTreeNode.children();
            while (enumeration.hasMoreElements()) {
                MyTreeNode myTreeNode = (MyTreeNode)enumeration.nextElement();
                String string4 = myTreeNode.getFilename().toLowerCase();
                if (string4.endsWith(File.separator)) {
                    string4 = string4.substring(0, string4.length() - 1);
                }
                if (string4 == null) continue;
                if (string4.equals(string)) {
                    return myTreeNode;
                }
                if (!string4.equals(string3)) continue;
                ++this.pathLevel;
                this.expandNode((DefaultMutableTreeNode)((Object)myTreeNode));
                if (myTreeNode.getChildCount() <= 0 || (myTreeNode = this.selectFile(myTreeNode, string)) == null) continue;
                return myTreeNode;
            }
        }
        return null;
    }

    public boolean isOpenWithResources() {
        return this.openWithResources;
    }

    public void setOpenWithResources(boolean bl) {
        this.openWithResources = bl;
    }

    public MyTreeNode getCurrentTreeNode() {
        return this.currentTreeNode;
    }

    public void setCurrentTreeNode(MyTreeNode myTreeNode) {
        this.currentTreeNode = myTreeNode;
    }

    void setNodesColor(boolean bl) {
        this.setOpenWithResources(bl);
        FcTreeNode fcTreeNode = (FcTreeNode)this.getModel().getRoot();
        this._setNodesColor(fcTreeNode);
        this.repaint();
    }

    private void _setNodesColor(FcTreeNode fcTreeNode) {
        if (fcTreeNode.getChildCount() >= 0) {
            Enumeration enumeration = fcTreeNode.children();
            while (enumeration.hasMoreElements()) {
                MyTreeNode myTreeNode = (MyTreeNode)enumeration.nextElement();
                if (myTreeNode.getFileType() != null && myTreeNode.getFileType().ordinal() > FILE_TYPE.CLSDIRRED.ordinal()) {
                    this.setNodeColor(myTreeNode);
                }
                this._setNodesColor(myTreeNode);
            }
        }
    }

    private void setNodeColor(MyTreeNode myTreeNode) {
        FILE_TYPE fILE_TYPE = myTreeNode.getFileType();
        if (this.isOpenWithResources()) {
            if (fILE_TYPE.ordinal() >= FILE_TYPE.SPRFILE.ordinal() && fILE_TYPE.ordinal() <= FILE_TYPE.SPRFILEYELLOW.ordinal()) {
                myTreeNode.setFileType(FILE_TYPE.SPRFILERED);
            } else if (fILE_TYPE.ordinal() >= FILE_TYPE.SINDEX.ordinal() && fILE_TYPE.ordinal() <= FILE_TYPE.SINDEXYELLOW.ordinal()) {
                myTreeNode.setFileType(FILE_TYPE.SINDEXRED);
            } else if (myTreeNode.getFilename().toLowerCase().endsWith(".dat")) {
                myTreeNode.setFileType(FILE_TYPE.FILEGREEN);
            } else if (myTreeNode.getFilename().toLowerCase().endsWith(".idx") || myTreeNode.getFilename().toLowerCase().startsWith("Member #")) {
                myTreeNode.setFileType(FILE_TYPE.INDEXRED);
            } else {
                myTreeNode.setFileType(FILE_TYPE.FILEYELLOW);
            }
        } else if (fILE_TYPE.ordinal() >= FILE_TYPE.SPRFILE.ordinal() && fILE_TYPE.ordinal() <= FILE_TYPE.SPRFILEYELLOW.ordinal()) {
            myTreeNode.setFileType(FILE_TYPE.SPRFILEGREEN);
        } else if (fILE_TYPE.ordinal() >= FILE_TYPE.SINDEX.ordinal() && fILE_TYPE.ordinal() <= FILE_TYPE.SINDEXYELLOW.ordinal()) {
            myTreeNode.setFileType(FILE_TYPE.SINDEXGREEN);
        } else if (myTreeNode.getFilename().toLowerCase().endsWith(".dat")) {
            myTreeNode.setFileType(FILE_TYPE.FILEGREEN);
        } else if (myTreeNode.getFilename().toLowerCase().endsWith(".idx") || myTreeNode.getFilename().toLowerCase().startsWith("Member #")) {
            myTreeNode.setFileType(FILE_TYPE.INDEXGREEN);
        } else {
            myTreeNode.setFileType(FILE_TYPE.FILEYELLOW);
        }
        myTreeNode.setFileType(FILE_TYPE.FILEGREEN);
    }

    private boolean isFileInFilter(File file) {
        boolean bl = this.inverted;
        if (file.isDirectory()) {
            return true;
        }
        if (this.filters == null) {
            return true;
        }
        String string = file.getName();
        for (String string2 : this.filters) {
            if (string2.equals("*")) {
                return bl;
            }
            if (string2.equals("*.") && string.indexOf(46) != -1) {
                return !bl;
            }
            String string3 = string2.replace("?", ".?").replace("*", ".*?");
            try {
                if (!(Globals.os.startsWith("win") ? string.matches("(?i:" + string3 + ")") : string.matches(string3))) continue;
                return bl;
            }
            catch (Exception exception) {
                return true;
            }
        }
        return false;
    }

    class myTreeExpansionListener
    implements TreeExpansionListener {
        myTreeExpansionListener() {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            TreePath treePath = treeExpansionEvent.getPath();
            int n = treePath.getPathCount();
            if (n > 1) {
                Object[] objectArray = treePath.getPath();
                MyTreeNode myTreeNode = (MyTreeNode)objectArray[n - 1];
                FilesTree.this.setSelectionPath(new TreePath(myTreeNode));
                if (myTreeNode.getFileType().ordinal() <= FILE_TYPE.CLSDIR.ordinal()) {
                    myTreeNode.setExpanded(true);
                    if (myTreeNode.getChildCount() == 1 && myTreeNode.getFirstChild().isLeaf()) {
                        File file = new File(myTreeNode.getFilename());
                        FilesTree.this.expandDirectory(myTreeNode, file);
                    }
                }
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            TreePath treePath = treeExpansionEvent.getPath();
            int n = treePath.getPathCount();
            if (n > 1) {
                Object[] objectArray = treePath.getPath();
                MyTreeNode myTreeNode = (MyTreeNode)objectArray[n - 1];
                myTreeNode.setExpanded(false);
            }
        }
    }

    public static enum FILE_TYPE {
        HARDDISK,
        CLSDIR,
        OPNDIR,
        CLSDIRRED,
        SPRFILE,
        SPRFILERED,
        SPRFILEGREEN,
        SPRFILEYELLOW,
        FILE,
        FILERED,
        FILEGREEN,
        FILEYELLOW,
        SINDEX,
        SINDEXRED,
        SINDEXGREEN,
        SINDEXYELLOW,
        INDEX,
        INDEXRED,
        INDEXGREEN,
        INDEXYELLOW;

    }

    public class MyFileFilter
    implements FileFilter {
        boolean listFiles = true;

        public MyFileFilter(boolean bl) {
            this.listFiles = bl;
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory() && !this.listFiles) {
                return true;
            }
            return !file.isDirectory() && this.listFiles;
        }
    }
}

