/*
 * Decompiled with CFR 0.152.
 */
package rtgmigrate;

import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import rtgmigrate.AppProperties;
import rtgmigrate.RTGMigrate;

public class Globals {
    public static String execDir = "";
    public static String os = "";
    public static boolean is64Bit = false;
    public static AppProperties appProps = new AppProperties();
    public static boolean connected;
    public static RTGMigrate appFrame;
    public static String cobolSystem;
    public static String cobolLibrary;
    public static String cobolFunction;
    public static String[] args;
    public static boolean advancedMode;
    public static boolean allowUpdates;
    public static UIManager.LookAndFeelInfo[] lfInfo;

    public static void showException(Throwable throwable, String string, boolean bl) {
        Toolkit.getDefaultToolkit().beep();
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        String string2 = "A %s application error occurred. Please contact FairCom with the following information:\n\n";
        string2 = String.format(string2, appFrame.getTitle());
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2);
        stringBuffer.append(throwable.toString()).append("\n");
        int n = 15;
        if (bl) {
            n = stackTraceElementArray.length;
        }
        int n2 = stackTraceElementArray.length;
        for (int i = 0; i < n2 && i < n; ++i) {
            stringBuffer.append(stackTraceElementArray[i].getFileName()).append(":").append(stackTraceElementArray[i].getLineNumber());
            stringBuffer.append(">> ").append(stackTraceElementArray[i].getMethodName()).append("()\n");
        }
        Object[] objectArray = null;
        objectArray = bl ? new Object[]{"Close", "Copy to Clipboard"} : new Object[]{"Close", "Copy to Clipboard", "Full StackTrace"};
        n2 = JOptionPane.showOptionDialog(appFrame, stringBuffer, "Program Exception", 0, 0, null, objectArray, objectArray[0]);
        if (n2 == 2) {
            Globals.showException(throwable, string, true);
        } else if (n2 == 1) {
            StringSelection stringSelection = new StringSelection(stringBuffer.toString());
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, stringSelection);
            Globals.showException(throwable, string, bl);
        }
        System.exit(1);
    }

    public static void setFrame(RTGMigrate rTGMigrate) {
        appFrame = rTGMigrate;
    }

    public static void showException(Exception exception, String string) {
        Toolkit.getDefaultToolkit().beep();
        JOptionPane.showMessageDialog(appFrame, "\n\nError Description : " + exception.getMessage(), string, 0);
    }

    public static void showException(Error error, String string) {
        Toolkit.getDefaultToolkit().beep();
        JOptionPane.showMessageDialog(appFrame, "\n\nError Description : " + error.getMessage(), string, 0);
    }

    public static EXIT_CODE showAbortRetryException(Exception exception, String string) {
        Toolkit.getDefaultToolkit().beep();
        Object[] objectArray = new Object[]{"Retry", "Abort", "Reload"};
        int n = JOptionPane.showOptionDialog(appFrame, "\nError Description : " + exception.getLocalizedMessage(), string, 0, 0, null, objectArray, objectArray[0]);
        switch (n) {
            case 0: {
                return EXIT_CODE.RETRY;
            }
            case 1: {
                return EXIT_CODE.ABORT;
            }
        }
        return EXIT_CODE.RELOAD;
    }

    public static void showMessage(int n, String string) {
        String string2;
        Toolkit.getDefaultToolkit().beep();
        switch (n) {
            case 133: {
                string2 = "Error : " + n + "\n\nCould not identify server or server is not active";
                break;
            }
            case 450: 
            case 451: {
                string2 = "Error : 450 / 451\n\nInvalid User Name or Password";
                break;
            }
            case 1001: {
                string2 = "Error : " + n + "\n\nSA_LOGON: Could not logon to server";
                break;
            }
            default: {
                string2 = "Error : " + n;
            }
        }
        JOptionPane.showMessageDialog(appFrame, string2, string, 0);
    }

    public static void showMessage(String string, String string2) {
        Toolkit.getDefaultToolkit().beep();
        JOptionPane.showMessageDialog(appFrame, string, string2, 0);
    }

    public static void showInfoMessage(String string, String string2) {
        Toolkit.getDefaultToolkit().beep();
        JOptionPane.showMessageDialog(appFrame, string, string2, 1);
    }

    public static String doubleQuote(String string) {
        return "\"" + string + "\"";
    }

    public static String singleQuote(String string) {
        return "'" + string + "'";
    }

    public static ImageIcon getIcon(String string) {
        URL uRL = RTGMigrate.class.getResource("images/" + string);
        if (uRL != null) {
            return new ImageIcon(uRL);
        }
        System.err.println("Couldn't find file: " + string);
        return null;
    }

    public static void ShowWaitCursor() {
        if (appFrame != null) {
            appFrame.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    public static void ShowNormalCursor() {
        if (appFrame != null) {
            appFrame.setCursor(Cursor.getDefaultCursor());
        }
    }

    public static void setLookAndFeel(JFrame jFrame) {
        String string = null;
        if (jFrame == null) {
            lfInfo = UIManager.getInstalledLookAndFeels();
        }
        if (Globals.appProps.lookAndFeel.equals("System")) {
            string = UIManager.getSystemLookAndFeelClassName();
        } else {
            for (UIManager.LookAndFeelInfo lookAndFeelInfo : lfInfo) {
                String string2 = lookAndFeelInfo.getName();
                if (!string2.equals(Globals.appProps.lookAndFeel)) continue;
                string = lookAndFeelInfo.getClassName();
                break;
            }
        }
        if (string == null) {
            Globals.showMessage("Invalid Look & Feel", "Error");
            return;
        }
        try {
            UIManager.setLookAndFeel(string);
            if (jFrame != null) {
                SwingUtilities.updateComponentTreeUI(jFrame);
                jFrame.pack();
            }
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            Globals.showMessage("Invalid Look & Feel", "Invalid Look & Feel");
        }
        catch (ClassNotFoundException classNotFoundException) {
            Globals.showMessage("Class not found : " + classNotFoundException.getLocalizedMessage(), "Invalid Look & Feel");
        }
        catch (InstantiationException instantiationException) {
            Globals.showException(instantiationException, "Invalid Look & Feel");
        }
        catch (IllegalAccessException illegalAccessException) {
            Globals.showException(illegalAccessException, "Invalid Look & Feel");
        }
    }

    static {
        advancedMode = false;
        allowUpdates = false;
    }

    public static enum EXIT_CODE {
        RETRY,
        ABORT,
        RELOAD,
        OK;

    }
}

