/*
 * Decompiled with CFR 0.152.
 */
package rtgmigrate;

import FairCom.Helper.Classes.FcTreeNode;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import rtgmigrate.FilesTree;
import rtgmigrate.Globals;
import rtgmigrate.NodeTag;

public class MyTreeNode
extends FcTreeNode
implements ActionListener {
    private final NodeTag myTag = new NodeTag();
    private final ArrayList<ImageIcon> icons = new ArrayList();

    public MyTreeNode(String string) {
        super(string);
        this.showCheckBox = true;
        if (this.icons.isEmpty()) {
            this.loadIcons();
        }
    }

    private void loadIcons() {
        this.icons.add(Globals.getIcon("HardDisk.png"));
        this.icons.add(Globals.getIcon("ClsdFold.png"));
        this.icons.add(Globals.getIcon("OpenFold.png"));
        this.icons.add(Globals.getIcon("ClsdFoldRed.png"));
        this.icons.add(Globals.getIcon("sFile.png"));
        this.icons.add(Globals.getIcon("sFileRed.png"));
        this.icons.add(Globals.getIcon("sFileGreen.png"));
        this.icons.add(Globals.getIcon("sFileYellow.png"));
        this.icons.add(Globals.getIcon("file.png"));
        this.icons.add(Globals.getIcon("fileRed.png"));
        this.icons.add(Globals.getIcon("fileGreen.png"));
        this.icons.add(Globals.getIcon("fileYellow.png"));
        this.icons.add(Globals.getIcon("sIndex.png"));
        this.icons.add(Globals.getIcon("sIndexRed.png"));
        this.icons.add(Globals.getIcon("sIndexGreen.png"));
        this.icons.add(Globals.getIcon("sIndexYellow.png"));
        this.icons.add(Globals.getIcon("index.png"));
        this.icons.add(Globals.getIcon("indexRed.png"));
        this.icons.add(Globals.getIcon("indexGreen.png"));
        this.icons.add(Globals.getIcon("indexYellow.png"));
    }

    public void setFileType(FilesTree.FILE_TYPE fILE_TYPE) {
        this.setCollapsedIcon(this.icons.get(fILE_TYPE.ordinal()));
        this.showCheckBox = false;
        if (fILE_TYPE == FilesTree.FILE_TYPE.CLSDIR) {
            this.setExpandedIcon(this.icons.get(fILE_TYPE.ordinal() + 1));
        } else {
            this.setExpandedIcon(this.icons.get(fILE_TYPE.ordinal()));
        }
        if (fILE_TYPE == FilesTree.FILE_TYPE.FILEGREEN) {
            this.showCheckBox = true;
        }
        this.myTag.setFileType(fILE_TYPE);
    }

    public FilesTree.FILE_TYPE getFileType() {
        return this.myTag.getFileType();
    }

    public String getFilename() {
        return this.myTag.getFileName();
    }

    public void showContextMenu(MouseEvent mouseEvent) {
        if (!this.isLeaf()) {
            JMenuItem jMenuItem;
            JPopupMenu jPopupMenu = new JPopupMenu();
            if (this.isExpanded()) {
                jMenuItem = new JMenuItem("Select All");
                jMenuItem.setIcon(Globals.getIcon("check.png"));
                jMenuItem.setActionCommand("select");
                jMenuItem.addActionListener(this);
                jPopupMenu.add(jMenuItem);
                JMenuItem jMenuItem2 = new JMenuItem("Deselect All");
                jMenuItem2.setIcon(Globals.getIcon("RemoveRec.png"));
                jMenuItem2.setActionCommand("unselect");
                jMenuItem2.addActionListener(this);
                jPopupMenu.add(jMenuItem2);
            }
            jMenuItem = new JMenuItem("Refresh");
            jMenuItem.setIcon(Globals.getIcon("Refresh.png"));
            jMenuItem.setActionCommand("refresh");
            jMenuItem.addActionListener(this);
            jPopupMenu.add(jMenuItem);
            jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public boolean isExpanded() {
        return this.myTag.isExpanded();
    }

    public void setExpanded(boolean bl) {
        this.myTag.setExpanded(bl);
    }

    public void setFileName(String string) {
        this.myTag.setFileName(string);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        switch (string = actionEvent.getActionCommand()) {
            case "select": {
                Globals.appFrame.selectAll(this);
                break;
            }
            case "unselect": {
                Globals.appFrame.clearTreeSelections(this);
                break;
            }
            case "refresh": {
                Globals.appFrame.refreshTreeNode(this);
                break;
            }
            case "expand": {
                Globals.appFrame.expandAll(this);
                break;
            }
            case "collapse": {
                Globals.appFrame.collapseAll(this);
                break;
            }
        }
    }
}

