/*
 * Decompiled with CFR 0.152.
 */
package com.softwarefx.chartfx.gauge.desktop.internal;

import com.softwarefx.chartfx.gauge.desktop.internal.AppliedAnglesCalculator;
import com.softwarefx.chartfx.gauge.desktop.internal.Assemblies.ChartFX_WinForms_Gauge;
import com.softwarefx.chartfx.gauge.desktop.internal.AssemblySettings;
import com.softwarefx.chartfx.gauge.desktop.internal.GaugeUtils;
import com.softwarefx.chartfx.gauge.desktop.internal.IAppliedAnglesInput;
import com.softwarefx.chartfx.gauge.desktop.internal.Internal.GfxPointF;
import com.softwarefx.chartfx.gauge.desktop.internal.Labeling.IAutoStepConfiguration;
import com.softwarefx.chartfx.gauge.desktop.internal.RadialCap;
import com.softwarefx.chartfx.gauge.desktop.internal.RadialStripCollection;
import com.softwarefx.chartfx.gauge.desktop.internal.Scale;
import com.softwarefx.chartfx.gauge.desktop.internal.ShareUtils;
import com.softwarefx.chartfx.gauge.desktop.internal.StripCollection;
import com.softwarefx.chartfx.gauge.desktop.internal.Tree.GraphicalTreeItemCollection;
import com.softwarefx.chartfx.gauge.desktop.internal.Tree.LeafBoundingBox;
import com.softwarefx.chartfx.gauge.desktop.internal.Tree.LeafBoundingBoxSet;
import com.softwarefx.chartfx.gauge.desktop.internal.Tree.UpdateEventArgs;
import com.softwarefx.chartfx.gauge.desktop.internal.VectorialEngine.EngineUtils;
import com.softwarefx.chartfx.gauge.desktop.internal.VectorialEngine.Serialization.PointFState;
import com.softwarefx.desktop.internal.ac;
import com.softwarefx.sfxnet.System.EventArgs;
import com.softwarefx.sfxnet.System.Reflection.Assembly;
import com.softwarefx.sfxnet.internal.as;
import com.softwarefx.sfxnet.internal.bd;
import com.softwarefx.sfxnet.internal.qq;
import com.softwarefx.sfxnet.internal.qy;

public final class RadialScale
extends Scale {
    private static final float tW = 225.0f;
    private static final float tX = -270.0f;
    private static final float tA = 0.9f;
    private float hM = 0.0f;
    private float hN = 0.0f;
    private qy tY = new qy();
    private float sn = 0.0f;
    private RadialStripCollection tZ = null;
    private RadialCap ua = null;
    private AppliedAnglesCalculator ub = new AppliedAnglesCalculator(new ScaleAppliedAnglesInput(this));

    public RadialScale() {
        this(0.0, 100.0);
    }

    public RadialScale(double d2, double d3) {
        this(d2, d3, 225.0f, -270.0f);
    }

    public RadialScale(double d2, double d3, float f2, float f3) {
        super(d2, d3);
        this.setStartAngle(f2);
        this.setSweepAngle(f3);
        this.sn = 0.9f;
        this.tY.e(qy.wi);
        this.tZ = new RadialStripCollection(this);
        this.tZ.getRootNode().MarkForBeingUpdatedOnlyOnce();
        this.getRootNode().getItems().Insert(0, this.tZ.getCollectionNode());
        this.ua = new RadialCap(this);
        this.getRootNode().getItems().Add(this.ua.getRootNode());
        this.getGraphicalBaseLayer().Add(this.tZ.getCollectionNode());
    }

    public qy getPivot() {
        return this.tY;
    }

    public void setPivot(qy qy2) {
        this.tY.e(qy2);
        this._auto_InvalidateGauge();
    }

    public GfxPointF getSerializablePivot() {
        return new GfxPointF(this.getPivot().lM());
    }

    public void setSerializablePivot(GfxPointF gfxPointF) {
        this.setPivot(GfxPointF.op_Implicit(gfxPointF));
    }

    public float getRadius() {
        return this.sn;
    }

    public void setRadius(float f2) {
        if (f2 <= 0.0f) {
            throw new qq("The radius should be greater than zero.");
        }
        this.sn = f2;
        this._auto_InvalidateGauge();
    }

    public RadialStripCollection getStripes() {
        return this.tZ;
    }

    public void setStripes(RadialStripCollection radialStripCollection) {
        if (radialStripCollection == null) {
            throw new qq();
        }
        if (this.tZ == radialStripCollection) {
            return;
        }
        if (this.tZ != null) {
            GraphicalTreeItemCollection graphicalTreeItemCollection = this.getRootNode().getItems();
            int n = graphicalTreeItemCollection.IndexOf(this.tZ.getCollectionNode());
            if (n != -1) {
                graphicalTreeItemCollection.c(n);
            }
            if ((n = this.getGraphicalBaseLayer().getItems().k(this.tZ.getCollectionNode())) != -1) {
                this.getGraphicalBaseLayer().getItems().c(n);
            }
            this.tZ.Clear();
        }
        this.tZ = radialStripCollection;
        this.tZ.setRelatedScale(this);
        this.getRootNode().getItems().Insert(0, this.tZ.getCollectionNode());
        this.getGraphicalBaseLayer().Add(this.tZ.getCollectionNode());
    }

    public float getStartAngle() {
        return this.hM;
    }

    public void setStartAngle(float f2) {
        this.hM = ShareUtils.ReduceAngle(f2);
        this._auto_InvalidateGauge();
        this.ub.ResetComputation();
    }

    public float getAppliedStartAngle() {
        return this.ub.getAppliedStartAngle();
    }

    public float getSweepAngle() {
        return this.hN;
    }

    public void setSweepAngle(float f2) {
        this.hN = ShareUtils.ReduceSweepAngle(f2);
        this.ub.ResetComputation();
        this._auto_InvalidateGauge();
    }

    public float getAppliedSweepAngle() {
        return this.ub.getAppliedSweepAngle();
    }

    public RadialCap getCap() {
        return this.ua;
    }

    public boolean ShouldSerializePivot() {
        return qy.b(this.getPivot().lM(), qy.wi.lM());
    }

    public void ResetPivot() {
        this.setPivot(qy.wi);
    }

    public boolean ShouldSerializeSerializablePivot() {
        return this.ShouldSerializePivot();
    }

    public float GetTickmarkHashKey(float f2) {
        return (float)as.a((double)ShareUtils.ReduceAngle(f2), 2);
    }

    public void PostUpdate(Scale.ScalePostUpdateEventArgs scalePostUpdateEventArgs) {
        super.PostUpdate(scalePostUpdateEventArgs);
        if (scalePostUpdateEventArgs.getCanBeFinalPass()) {
            this.j(scalePostUpdateEventArgs);
            this.getRootNode().setOffset(this.get_auto_RelatedGauge().getRenderingSystem().ToSystemPoint(this.getPivot().lM()));
        }
    }

    private boolean cS() {
        return qy.a(this.getPivot().lM(), qy.wi.lM()) && this.hh() && (AssemblySettings.getCurrent().getPerformanceSettings() & 4) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void j(Scale.ScalePostUpdateEventArgs scalePostUpdateEventArgs) {
        if (!this.hh()) {
            return;
        }
        float f2 = 0.0f;
        if (!this.cS()) {
            f2 = this.getRadius();
        } else {
            float f3 = -1.0f;
            LeafBoundingBoxSet leafBoundingBoxSet = scalePostUpdateEventArgs.getTickmarkAndLabelBoundingBoxes();
            bd bd2 = leafBoundingBoxSet.C();
            while (bd2.aR()) {
                LeafBoundingBox leafBoundingBox = (LeafBoundingBox)bd2.aQ();
                if (!leafBoundingBox.getIsLeafVisible()) continue;
                float f4 = EngineUtils.FindFarCorner(qy.wi.lM(), leafBoundingBox.getBounds().fz());
                f3 = as.a(f4, f3);
            }
            f2 = f3 * this.getRadius() <= 1.0f ? this.getRadius() : 1.0f / f3;
        }
        this.getRootNode().setSize(f2);
    }

    protected void SerializeImpl(boolean bl, ac ac2) {
        super.SerializeImpl(bl, ac2);
        ac2.a("Cap", this.ua, this.ua.ch().getName(), 256);
        PointFState.Serialize_Boolean_IPersistBase_PointF_r_String serialize_Boolean_IPersistBase_PointF_r_String = new PointFState.Serialize_Boolean_IPersistBase_PointF_r_String(bl, ac2, this.tY, "Pivot");
        PointFState.Serialize(serialize_Boolean_IPersistBase_PointF_r_String);
        this.tY.e(serialize_Boolean_IPersistBase_PointF_r_String.pt);
        ac.e e2 = new ac.e("Radius", this.sn, 0.9f);
        boolean bl2 = ac2.a(e2);
        this.sn = e2.cq;
        if (!bl) {
            this.setRadius(this.sn);
        }
        ac.e e3 = new ac.e("StartAngle", this.hM, 225.0f);
        boolean bl3 = ac2.a(e3);
        this.hM = e3.cq;
        ac.e e4 = new ac.e("SweepAngle", this.hN, -270.0f);
        boolean bl4 = ac2.a(e4);
        this.hN = e4.cq;
        ac2.a("Stripes", this.tZ, null, 260);
    }

    public boolean ShouldSerializeStripes() {
        return this.getStripes().getCount() != 0;
    }

    public void OnFrameChanged(com.softwarefx.sfxnet.System.Object object, EventArgs eventArgs) {
        this.ub.ResetComputation();
    }

    public StripCollection GetStripes() {
        return this.getStripes();
    }

    public float GetCoordinate(double d2) {
        float f2 = this.ub.getAppliedStartAngle();
        float f3 = this.ub.getAppliedSweepAngle();
        if (this.getMin() == this.getMax() || f3 == 0.0f) {
            return f2;
        }
        d2 = this.GetValueInRange(d2);
        double d3 = (double)f2 + (d2 - this.getMin()) * (double)f3 / (this.getMax() - this.getMin());
        return ShareUtils.ReduceAngle((float)d3);
    }

    public int GetOrientation(double d2, double d3) {
        float f2 = this.GetCoordinate(d2);
        float f3 = this.GetCoordinate(d3);
        double d4 = as.e(d2, d3) + as.b(d3 - d2) / 2.0;
        float f4 = this.GetCoordinate(d4);
        if (ShareUtils.ReduceAngle(f4 - f2) < ShareUtils.ReduceAngle(f3 - f2)) {
            return 0;
        }
        return 1;
    }

    public double GetValue(float f2) {
        float f3 = this.ub.getAppliedStartAngle();
        float f4 = this.ub.getAppliedSweepAngle();
        if ((f2 = ShareUtils.ReduceAngle(f2)) > f3 && f4 < 0.0f) {
            f2 -= 360.0f;
        } else if (f2 < f3 && f4 > 0.0f) {
            f2 += 360.0f;
        }
        double d2 = this.getMin() + (double)(f2 - f3) * (this.getMax() - this.getMin()) / (double)f4;
        EngineUtils.AssertAreEqual(ShareUtils.ReduceAngle(f2), this.GetCoordinate(d2), 3.0f);
        if (d2 != this.GetValueInRange(d2)) {
            float f5 = this.GetCoordinate(this.getMax());
            return GaugeUtils.GetClosestAngle(f3, f5, f2) == f3 ? this.getMin() : this.getMax();
        }
        return d2;
    }

    public double GetValue(qy qy2, int n) {
        float f2 = ShareUtils.GetAngle(qy2.lM());
        if (n == 1) {
            f2 += 180.0f;
        }
        double d2 = this.GetValue(f2);
        return d2;
    }

    public void rootNode_Update(com.softwarefx.sfxnet.System.Object object, UpdateEventArgs updateEventArgs) {
        super.rootNode_Update(object, updateEventArgs);
        if (!this.hh()) {
            this.getCap().getRootNode().getItems().Clear();
        }
    }

    public IAutoStepConfiguration CreateAutoStepConfiguration() {
        return new RadialAutoStepConfiguration(this);
    }

    public com.softwarefx.sfxnet.System.Object a(com.softwarefx.sfxnet.System.Object object) {
        super.a((RadialScale)object);
        this.hM = ((RadialScale)object).hM;
        this.hN = ((RadialScale)object).hN;
        this.tY.e(((RadialScale)object).tY);
        this.sn = ((RadialScale)object).sn;
        this.tZ = ((RadialScale)object).tZ;
        return this;
    }

    public void fA() {
        super.fA();
        this.p();
    }

    public void p() {
        this.tY = new qy();
    }

    public static Assembly GetAssembly() {
        return new ChartFX_WinForms_Gauge();
    }

    private static final class RadialAutoStepConfiguration
    extends com.softwarefx.sfxnet.System.Object
    implements IAutoStepConfiguration {
        private RadialScale kL = null;

        public RadialAutoStepConfiguration(RadialScale radialScale) {
            this.kL = radialScale;
        }

        public float getAvailablePhysicalRange() {
            return as.g(this.kL.getAppliedSweepAngle());
        }

        public float getMaximumPhysicalRangeWhenMediumTickmarksDisappear() {
            return 20.0f;
        }

        public float getMaxiumPhysicalRange() {
            return 360.0f;
        }

        public int getMaximumMajorTickmarkCount() {
            return 15;
        }
    }

    private static class ScaleAppliedAnglesInput
    extends com.softwarefx.sfxnet.System.Object
    implements IAppliedAnglesInput {
        private RadialScale kL = null;

        public ScaleAppliedAnglesInput(RadialScale radialScale) {
            this.kL = radialScale;
        }

        public float getStartAngle() {
            return this.kL.getStartAngle();
        }

        public float getSweepAngle() {
            return this.kL.getSweepAngle();
        }

        public RadialScale getRelatedScale() {
            return this.kL;
        }
    }
}

