/*
 * Decompiled with CFR 0.152.
 */
package FairCom.JCheckedListBox;

import FairCom.JCheckedListBox.CheckListCellRenderer;
import FairCom.JCheckedListBox.CheckListener;
import FairCom.JCheckedListBox.ListItem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.EventListenerList;

public class JCheckedListBox
extends JPanel {
    JList jList1;
    private JScrollPane jScrollPane1;
    private ArrayList<ListItem> internalItems;
    private ArrayList<String> items;
    protected EventListenerList listenerList = new EventListenerList();

    public JCheckedListBox() {
        this.initComponents();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.internalItems = new ArrayList();
        this.items = new ArrayList();
        this.jList1 = new JList();
        this.jList1.setListData(this.internalItems.toArray());
        CheckListCellRenderer checkListCellRenderer = new CheckListCellRenderer();
        this.jList1.setCellRenderer(checkListCellRenderer);
        this.jList1.setSelectionMode(0);
        CheckListener checkListener = new CheckListener(this);
        this.jList1.addMouseListener(checkListener);
        this.jList1.addKeyListener(checkListener);
        this.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView(this.jList1);
        this.add((Component)this.jScrollPane1, "Center");
    }

    public ArrayList<String> getItems() {
        this.items.clear();
        for (ListItem listItem : this.internalItems) {
            this.items.add(listItem.name);
        }
        return this.items;
    }

    public int getItemsCount() {
        return this.internalItems.size();
    }

    public ListItem get(int n) {
        return this.internalItems.get(n);
    }

    public void removeItem(ListItem listItem) {
        this.internalItems.remove(listItem);
        this.jList1.setListData(this.internalItems.toArray());
        this.jList1.updateUI();
    }

    public void removeAllItems() {
        this.items.clear();
        this.internalItems.clear();
        this.jList1.setListData(this.internalItems.toArray());
        this.jList1.updateUI();
    }

    public ArrayList<Boolean> getCheckedStatus() {
        ArrayList<Boolean> arrayList = new ArrayList<Boolean>();
        for (ListItem listItem : this.internalItems) {
            arrayList.add(listItem.selected);
        }
        return arrayList;
    }

    public ArrayList<String> getCheckedItems() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ListItem listItem : this.internalItems) {
            if (!listItem.selected) continue;
            arrayList.add(listItem.name);
        }
        return arrayList;
    }

    public int getSelectedItem() {
        return this.jList1.getSelectedIndex();
    }

    public void setSelectedItem(int n) {
        this.jList1.setSelectedIndex(n);
    }

    public void add(String string, Boolean bl) {
        this.internalItems.add(new ListItem(string, bl));
        this.jList1.setListData(this.internalItems.toArray());
        this.jList1.updateUI();
    }

    public void add(int n, ListItem listItem) {
        this.internalItems.add(n, listItem);
        this.jList1.setListData(this.internalItems.toArray());
        this.jList1.updateUI();
    }

    public void setLayoutOrientation(int n) {
        this.jList1.setLayoutOrientation(n);
    }

    public void setVisibleRowCount(int n) {
        this.jList1.setVisibleRowCount(n);
    }

    public void setItems(ArrayList<String> arrayList) {
        this.items = arrayList;
        this.internalItems.clear();
        for (String string : arrayList) {
            this.internalItems.add(new ListItem(string));
        }
        this.jList1.setListData(this.internalItems.toArray());
        this.jList1.updateUI();
    }

    public String getSelectedItemText(int n) {
        if (n == -1 || n >= this.internalItems.size()) {
            return null;
        }
        ListItem listItem = this.internalItems.get(n);
        String string = listItem.getName();
        return string;
    }

    public ArrayList<String> getSelectedItems() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ListItem listItem : this.internalItems) {
            if (!listItem.isSelected()) continue;
            arrayList.add(listItem.name);
        }
        return arrayList;
    }

    public void setItemChecked(int n, boolean bl) {
        ListItem listItem = this.internalItems.get(n);
        listItem.selected = bl;
        this.jList1.updateUI();
    }

    public void setAllItemsChecked(boolean bl) {
        for (ListItem listItem : this.internalItems) {
            listItem.selected = bl;
        }
        this.jList1.updateUI();
    }

    @Override
    public void setEnabled(boolean bl) {
        this.jList1.setEnabled(bl);
    }

    @Override
    public boolean isEnabled() {
        return this.jList1.isEnabled();
    }

    public void checkedEvent(boolean bl, int n) {
        String string = this.getSelectedItemText(n);
        this.fireMyEvent(new CheckedEvent(this, bl, n, string));
    }

    public void selectionEvent(int n) {
        String string = this.getSelectedItemText(n);
        this.fireMyEvent(new SelectionEvent(this, n, string));
    }

    public void addMyEventListener(MyEventListener myEventListener) {
        this.listenerList.add(MyEventListener.class, myEventListener);
    }

    public void removeMyEventListener(MyEventListener myEventListener) {
        this.listenerList.remove(MyEventListener.class, myEventListener);
    }

    public void fireMyEvent(CheckedEvent checkedEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != MyEventListener.class) continue;
            ((MyEventListener)objectArray[i + 1]).itemChecked(checkedEvent);
        }
    }

    public void fireMyEvent(SelectionEvent selectionEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != MyEventListener.class) continue;
            ((MyEventListener)objectArray[i + 1]).itemSelected(selectionEvent);
        }
    }

    public static interface MyEventListener
    extends EventListener {
        public void itemChecked(CheckedEvent var1);

        public void itemSelected(SelectionEvent var1);
    }

    public class SelectionEvent
    extends EventObject {
        int selectedItem;
        String selectedItemText;

        public SelectionEvent(Object object, int n, String string) {
            super(object);
            this.selectedItem = n;
            this.selectedItemText = string;
        }

        public int GetSelectedItem() {
            return this.selectedItem;
        }

        public String GetSelectedItemText() {
            return this.selectedItemText;
        }
    }

    public class CheckedEvent
    extends EventObject {
        boolean isChecked;
        int selectedItem;
        String selectedItemText;

        public CheckedEvent(Object object, boolean bl, int n, String string) {
            super(object);
            this.isChecked = bl;
            this.selectedItem = n;
            this.selectedItemText = string;
        }

        public Boolean IsChecked() {
            return this.isChecked;
        }

        public int GetSelectedItem() {
            return this.selectedItem;
        }

        public String GetSelectedItemText() {
            return this.selectedItemText;
        }
    }
}

