/*
 * Decompiled with CFR 0.152.
 */
package FairCom.CtreeDb;

import FairCom.CtreeDb.CTBase;
import FairCom.CtreeDb.CTException;
import FairCom.CtreeDb.CTHANDLE;
import FairCom.CtreeDb.CTSession;
import FairCom.CtreeDb.CTTable;
import FairCom.CtreeDb.Types.CTDBRET;
import FairCom.CtreeDb.ctdb;

public class CTDatabase
extends CTBase {
    private CTSession parent = null;

    public CTDatabase(CTSession cTSession) throws CTException {
        this.m_handle = ctdb.AllocDatabase(cTSession.m_handle);
        if (this.m_handle == null) {
            throw new CTException(CTDBRET.NOMEMORY.getErrno(), "Can't allocate database handle");
        }
        this.parent = cTSession;
    }

    public void finalize() {
        if (this.m_handle != null) {
            ctdb.FreeDatabase(this.m_handle);
            this.m_handle = null;
        }
    }

    public void Connect(String string) throws CTException {
        int n = ctdb.Connect(this.m_handle, string);
        if (n != 0) {
            throw new CTException(n, "Can't connect to database");
        }
    }

    public void Disconnect() throws CTException {
        int n = ctdb.Disconnect(this.m_handle);
        if (n != 0) {
            throw new CTException(n, "Can't disconnect database");
        }
    }

    public void Create(String string, String string2) throws CTException {
        int n = ctdb.CreateDatabase(this.m_handle, string, string2);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "Can't create database");
        }
    }

    public boolean FirstTable(StringBuffer stringBuffer, StringBuffer stringBuffer2) throws CTException {
        int n = ctdb.FirstTable(this.m_handle, stringBuffer, stringBuffer2);
        boolean bl = false;
        if (n == CTDBRET.OK.getErrno()) {
            bl = true;
        } else if (n != 101) {
            throw new CTException(n, "Can't retrieve table info");
        }
        return bl;
    }

    public boolean NextTable(StringBuffer stringBuffer, StringBuffer stringBuffer2) throws CTException {
        int n = ctdb.NextTable(this.m_handle, stringBuffer, stringBuffer2);
        boolean bl = false;
        if (n == CTDBRET.OK.getErrno()) {
            bl = true;
        } else if (n != 101) {
            throw new CTException(n, "Can't retrieve next table");
        }
        return bl;
    }

    public boolean FindTable(String string, StringBuffer stringBuffer) throws CTException {
        int n = ctdb.FindTable(this.m_handle, string, stringBuffer);
        boolean bl = false;
        if (n == CTDBRET.OK.getErrno()) {
            bl = true;
        } else if (n != 101) {
            throw new CTException(n, "Can't retrieve table info");
        }
        return bl;
    }

    public boolean FindTable(int n, StringBuffer stringBuffer, StringBuffer stringBuffer2) throws CTException {
        int n2 = ctdb.FindTableByUID(this.m_handle, n, stringBuffer, stringBuffer2);
        boolean bl = false;
        if (n2 == CTDBRET.OK.getErrno()) {
            bl = true;
        } else if (n2 != 101) {
            throw new CTException(n2, "Can't retrieve table info");
        }
        return bl;
    }

    public void AddTable(String string, String string2) throws CTException {
        int n = ctdb.AddTable(this.m_handle, string, string2);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "Can't add table");
        }
    }

    public void AddTableXtd(String string, String string2, String string3) throws CTException {
        int n = ctdb.AddTableXtd(this.m_handle, string, string2, string3);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "Can't add table");
        }
    }

    public void DeleteTable(String string, String string2) throws CTException {
        int n = ctdb.DeleteTable(this.m_handle, string, string2);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "Can't delete table");
        }
    }

    public void DropTable(String string) throws CTException {
        int n = ctdb.DropTable(this.m_handle, string);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "Can't delete table");
        }
    }

    public int GetTableUID(String string) throws CTException {
        int n = ctdb.GetTableUID(this.m_handle, string);
        int n2 = ctdb.GetError(this.m_handle);
        if (n2 != CTDBRET.OK.getErrno()) {
            throw new CTException(n2, "Can't retrieve table UID");
        }
        return n;
    }

    public boolean IsActive() {
        return ctdb.IsActiveDatabase(this.m_handle);
    }

    public String GetPath() {
        return ctdb.GetDatabasePath(this.m_handle);
    }

    public String GetName() {
        return ctdb.GetDatabaseName(this.m_handle);
    }

    public void CloseAll() throws CTException {
        int n = ctdb.CloseAll(this.m_handle);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "Close all tables failed");
        }
    }

    public int GetTableCount() {
        return ctdb.GetTableCount(this.m_handle);
    }

    public String GetDefaultSqlTableOwner() {
        return ctdb.GetDefaultSqlTableOwner(this.m_handle);
    }

    public void SetDefaultSqlTableOwner(String string) throws CTException {
        int n = ctdb.SetDefaultSqlTableOwner(this.m_handle, string);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "Set default Sql table owner failed");
        }
    }

    public boolean IsSQL() {
        return ctdb.IsSQLDatabase(this.m_handle);
    }

    public void SetExclusive(boolean bl) throws CTException {
        int n = ctdb.SetDatabaseExclusive(this.m_handle, bl);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "Can't set the exclusive flag");
        }
    }

    public boolean IsExclusive() {
        return ctdb.IsDatabaseExclusive(this.m_handle);
    }

    public void RenameTable(String string, String string2) throws CTException {
        int n = ctdb.RenameTable(this.m_handle, string, string2);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "Can't create database");
        }
    }

    public CTTable FindActiveTable(String string) throws CTException {
        CTHANDLE cTHANDLE = ctdb.FindActiveTable(this.m_handle, string);
        if (cTHANDLE != null) {
            return new CTTable(cTHANDLE);
        }
        return null;
    }
}

