/*
 * Decompiled with CFR 0.152.
 */
package FairCom.CtreeDb;

import FairCom.CtreeDb.CTBase;
import FairCom.CtreeDb.CTException;
import FairCom.CtreeDb.CTField;
import FairCom.CtreeDb.CTResultSet;
import FairCom.CtreeDb.Types.CTDBRET;
import FairCom.CtreeDb.ctdb;

public class CTResultSetCriteria
extends CTBase {
    private CTResultSet parent = null;
    private CTField _field = null;
    private String _lowValue = "";
    private String _highValue = "";
    private int _operator = -1;

    public CTResultSetCriteria(CTField cTField, String string, String string2, int n) throws CTException {
        this._field = cTField;
        this._lowValue = string;
        this._highValue = string2;
        this._operator = n;
    }

    public CTResultSetCriteria() throws CTException {
    }

    void AddCriteria(CTResultSet cTResultSet) throws CTException {
        if (this.parent != null) {
            throw new CTException(CTDBRET.INVARG.getErrno(), "Criteria already added to a result set");
        }
        this.parent = cTResultSet;
        this.m_handle = ctdb.AddCriteria(cTResultSet.m_handle, this._field.m_handle, this._lowValue, this._highValue, this._operator);
        if (this.m_handle == null) {
            int n = ctdb.GetError(cTResultSet.m_handle);
            throw new CTException(n, "Can't add the result set criteria");
        }
    }

    void RemoveCriteria(CTResultSet cTResultSet) throws CTException {
        if (this.parent == null) {
            throw new CTException(CTDBRET.INVARG.getErrno(), "Criteria is not added to any Result Set");
        }
        int n = ctdb.RemoveCriteria(cTResultSet.m_handle, this.m_handle);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "Can't remove the result set criteria");
        }
        this.parent = null;
    }

    public CTField getField() {
        return this._field;
    }

    public String getHighValue() {
        return this._highValue;
    }

    public String getLowValue() {
        return this._lowValue;
    }

    public int getOperator() {
        return this._operator;
    }

    public void setField(CTField cTField) throws CTException {
        if (this.parent != null) {
            throw new CTException(CTDBRET.INVARG.getErrno(), "Criteria already added to a result set");
        }
        this._field = cTField;
    }

    public void setHighValue(String string) throws CTException {
        int n;
        this._highValue = string;
        if (this.parent != null && (n = ctdb.UpdateCriteria(this.m_handle, this._lowValue, this._highValue)) != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "Can't update the result set criteria");
        }
    }

    public void setLowValue(String string) throws CTException {
        int n;
        this._lowValue = string;
        if (this.parent != null && (n = ctdb.UpdateCriteria(this.m_handle, this._lowValue, this._highValue)) != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "Can't update the result set criteria");
        }
    }

    public void setOperator(int n) throws CTException {
        if (this.parent != null) {
            throw new CTException(CTDBRET.INVARG.getErrno(), "Criteria already added to a result set");
        }
        this._operator = n;
    }
}

