/*
 * Decompiled with CFR 0.152.
 */
package FairCom.CtreeDb;

import FairCom.CtreeDb.CTBase;
import FairCom.CtreeDb.CTException;
import FairCom.CtreeDb.CTField;
import FairCom.CtreeDb.CTHANDLE;
import FairCom.CtreeDb.Types.CTDBRET;
import FairCom.CtreeDb.ctdb;

public class CTSegment
extends CTBase {
    public CTSegment() {
        this.m_handle = null;
    }

    public CTSegment(CTSegment cTSegment) {
        this.m_handle = cTSegment.m_handle;
    }

    public void finalize() {
    }

    public CTField GetField() throws CTException {
        CTHANDLE cTHANDLE = ctdb.GetSegmentField(this.m_handle);
        if (cTHANDLE == null) {
            throw new CTException(ctdb.GetError(this.m_handle), "Can't retrieve segment field");
        }
        CTField cTField = new CTField();
        cTField.m_handle = cTHANDLE;
        return cTField;
    }

    public CTField GetPartialField() throws CTException {
        CTHANDLE cTHANDLE = ctdb.GetSegmentPartialField(this.m_handle);
        if (cTHANDLE == null) {
            throw new CTException(ctdb.GetError(this.m_handle), "Can't retrieve segment field");
        }
        CTField cTField = new CTField();
        cTField.SetHandle(cTHANDLE);
        return cTField;
    }

    public String GetFieldName() throws CTException {
        CTField cTField = this.GetField();
        return cTField.GetName();
    }

    public String GetPartialFieldName() throws CTException {
        CTField cTField = this.GetPartialField();
        return cTField.GetName();
    }

    public int GetMode() throws CTException {
        return ctdb.GetSegmentMode(this.m_handle);
    }

    public void SetMode(int n) throws CTException {
        int n2 = ctdb.SetSegmentMode(this.m_handle, n);
        if (n2 != CTDBRET.OK.getErrno()) {
            throw new CTException(n2, "Can't set the segment mode");
        }
    }

    public int GetNumber() throws CTException {
        int n = ctdb.GetSegmentNbr(this.m_handle);
        return n;
    }

    public int GetStatus() {
        return ctdb.GetSegmentStatus(this.m_handle);
    }

    public void MoveSegment(int n) throws CTException {
        int n2 = ctdb.MoveSegment(this.m_handle, n);
        if (n2 != CTDBRET.OK.getErrno()) {
            throw new CTException(n2, "Can't move the index segment");
        }
    }

    public void SetField(CTField cTField) throws CTException {
        int n = ctdb.SetSegmentField(this.m_handle, cTField.m_handle);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "Can't set field for index segment");
        }
    }

    public void SetJSONField(CTField cTField, String string, int n, int n2) throws CTException {
        int n3 = ctdb.SetJSONSegmentField(this.m_handle, cTField.m_handle, string, n, n2);
        if (n3 != CTDBRET.OK.getErrno()) {
            throw new CTException(n3, "Can't set JSON field for index segment");
        }
    }
}

