/*
 * Decompiled with CFR 0.152.
 */
package FairCom.CtreeDb;

import FairCom.CtreeDb.CTBase;
import FairCom.CtreeDb.CTException;
import FairCom.CtreeDb.Types.CTDBRET;
import FairCom.CtreeDb.ctdb;
import java.util.Calendar;

public class CTSession
extends CTBase {
    public CTSession() throws CTException {
        ctdb.loadCtreeLib();
        this.m_handle = ctdb.AllocSession(0);
        if (this.m_handle == null) {
            throw new CTException(CTDBRET.NOMEMORY.getErrno(), "Not enough memory to allocate a session handle.");
        }
    }

    public CTSession(int n) throws CTException {
        ctdb.loadCtreeLib();
        this.m_handle = ctdb.AllocSession(n);
        if (this.m_handle == null) {
            throw new CTException(CTDBRET.NOMEMORY.getErrno(), "Not enough memory to allocate a session handle.");
        }
    }

    protected void finalize() {
        if (this.m_handle != null) {
            ctdb.FreeSession(this.m_handle);
            this.m_handle = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void SetDBModel(int n) throws CTException {
        ctdb.liblock.lock();
        try {
            if (ctdb.libLoaded) {
                throw new CTException(CTDBRET.ISACTIVE.getErrno(), "c-tree library already loaded.");
            }
            if (ctdb.library != 0) {
                throw new CTException(CTDBRET.ISACTIVE.getErrno(), "c-tree library model already set");
            }
            if (n != 1 && n != 2 && n != 3) {
                throw new CTException(CTDBRET.INVARG.getErrno(), "invalid c-tree model specified.");
            }
            ctdb.library = n;
        }
        finally {
            ctdb.liblock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int GetDBModel() {
        int n = 0;
        ctdb.liblock.lock();
        try {
            n = ctdb.library;
        }
        finally {
            ctdb.liblock.unlock();
        }
        return n;
    }

    public void Logon(String string, String string2, String string3) throws CTException {
        int n = ctdb.Logon(this.m_handle, string, string2, string3);
        if (n != 0) {
            throw new CTException(n, "c-tree logon error.");
        }
    }

    public void Logoff() throws CTException {
        int n = ctdb.Logoff(this.m_handle);
        if (n != 0) {
            throw new CTException(n, "c-tree logoff error.");
        }
    }

    public String GetServerName() {
        return ctdb.GetServerName(this.m_handle);
    }

    public String GetUserLogonName() {
        return ctdb.GetUserLogonName(this.m_handle);
    }

    public String GetPassword() {
        return ctdb.GetUserPassword(this.m_handle);
    }

    public int GetParam(int n) {
        return ctdb.GetSessionParams(this.m_handle, n);
    }

    public void SetParam(int n, int n2) throws CTException {
        int n3 = ctdb.SetSessionParams(this.m_handle, n, n2);
        if (n3 != 0) {
            throw new CTException(n3, "SetParam error");
        }
    }

    public boolean IsActive() {
        return ctdb.IsActiveSession(this.m_handle);
    }

    public String GetPath() throws CTException {
        String string = ctdb.GetSessionPath(this.m_handle);
        if (string == null) {
            throw new CTException(ctdb.GetError(this.m_handle), "Cannot get Session Path");
        }
        return string;
    }

    public void SetPath(String string) throws CTException {
        int n = ctdb.SetSessionPath(this.m_handle, string);
        if (n != 0) {
            throw new CTException(n, "Can't set the session path");
        }
    }

    public boolean FirstDatabase(StringBuffer stringBuffer, StringBuffer stringBuffer2) throws CTException {
        boolean bl = false;
        int n = ctdb.FirstDatabase(this.m_handle, stringBuffer, stringBuffer2);
        if (n == 0) {
            bl = true;
        } else if (n != 101) {
            throw new CTException(n, "Can't retrieve database info");
        }
        return bl;
    }

    public boolean NextDatabase(StringBuffer stringBuffer, StringBuffer stringBuffer2) throws CTException {
        boolean bl = false;
        int n = ctdb.NextDatabase(this.m_handle, stringBuffer, stringBuffer2);
        if (n == 0) {
            bl = true;
        } else if (n != 101) {
            throw new CTException(n, "Can't retrieve database info");
        }
        return bl;
    }

    public boolean FindDatabase(String string, StringBuffer stringBuffer) throws CTException {
        boolean bl = false;
        int n = ctdb.FindDatabase(this.m_handle, string, stringBuffer);
        if (n == 0) {
            bl = true;
        } else if (n != 101) {
            throw new CTException(n, "Can't retrieve database info");
        }
        return bl;
    }

    public void Create() throws CTException {
        this.Create("FAIRCOMS@localhost", "admin", "ADMIN");
    }

    public void Create(String string, String string2, String string3) throws CTException {
        int n = ctdb.CreateSession(this.m_handle, string, string2, string3);
        if (n != 0) {
            throw new CTException(n, "Can't create a new session dictionary.");
        }
    }

    public void DisconnectAll() throws CTException {
        int n = ctdb.DisconnectAll(this.m_handle);
        if (n != 0) {
            throw new CTException(n, "Error disconnecting from all databases");
        }
    }

    public void CreateDatabase(String string, String string2) throws CTException {
        int n = ctdb.CreateDatabase(this.m_handle, string, string2);
        if (n != 0) {
            throw new CTException(n, "Can't create database");
        }
    }

    public void AddDatabase(String string, String string2) throws CTException {
        int n = ctdb.AddDatabase(this.m_handle, string, string2);
        if (n != 0) {
            throw new CTException(n, "Can't add existing database");
        }
    }

    public void DeleteDatabase(String string) throws CTException {
        int n = ctdb.DeleteDatabase(this.m_handle, string);
        if (n != 0) {
            throw new CTException(n, "Can't delete database");
        }
    }

    public void DropDatabase(String string) throws CTException {
        int n = ctdb.DropDatabase(this.m_handle, string);
        if (n != 0) {
            throw new CTException(n);
        }
    }

    public int GetDatabaseUID(String string) throws CTException {
        int n = ctdb.GetDatabaseUID(this.m_handle, string);
        int n2 = ctdb.GetError(this.m_handle);
        if (n2 != 0) {
            throw new CTException(n, "Can't retrieve database UID");
        }
        return n;
    }

    public void SetExclusive(boolean bl) throws CTException {
        int n = ctdb.SetSessionExclusive(this.m_handle, bl);
        if (n != 0) {
            throw new CTException(n, "Can't set the exclusive flag");
        }
    }

    public void SetExclusive() throws CTException {
        this.SetExclusive(true);
    }

    public boolean IsExclusive() {
        return ctdb.IsSessionExclusive(this.m_handle);
    }

    public boolean IsSQLServer() {
        return ctdb.IsSQLServer(this.m_handle);
    }

    public void SetLogonOnly() throws CTException {
        this.SetLogonOnly(true);
    }

    public void SetLogonOnly(boolean bl) throws CTException {
        int n = ctdb.SetLogonOnly(this.m_handle, bl);
        if (n != 0) {
            throw new CTException(n, "Can't set the logon only flag");
        }
    }

    public boolean GetLogonOnly() {
        return ctdb.GetLogonOnly(this.m_handle);
    }

    public int GetAttachMode() {
        return ctdb.GetAttachMode(this.m_handle);
    }

    public int GetDatabaseCount() {
        return ctdb.GetDatabaseCount(this.m_handle);
    }

    public void SetSessionType(int n) throws CTException {
        int n2 = ctdb.SetSessionType(this.m_handle, n);
        if (n2 != 0) {
            throw new CTException(n2, "Can't set the session type");
        }
    }

    public void SetSessionId(int n) {
        ctdb.SetSessionId(this.m_handle, n);
    }

    public int GetSessionId() {
        return ctdb.GetSessionId(this.m_handle);
    }

    public int GetSessionType() {
        return ctdb.GetSessionType(this.m_handle);
    }

    public int GetLibType() {
        return ctdb.GetLibType(this.m_handle);
    }

    public static int SetConfigurationFile(String string) throws CTException {
        ctdb.loadCtreeLib();
        return ctdb.SetConfigurationFile(string);
    }

    public static int SetLicenseFile(String string) throws CTException {
        ctdb.loadCtreeLib();
        return ctdb.SetLicenseFile(string);
    }

    public static int SetLocalDirectory(String string) throws CTException {
        ctdb.loadCtreeLib();
        return ctdb.SetLocalDir(string);
    }

    public void SetCurrentNodeName(String string) throws CTException {
        int n = ctdb.SetCurrentNodeName(this.m_handle, string);
        if (n != 0) {
            throw new CTException(n, "Can't set the current node name");
        }
    }

    public void SetPathPrefix(String string) throws CTException {
        int n = ctdb.SetPathPrefix(this.m_handle, string);
        if (n != 0) {
            throw new CTException(n, "Can't set the path prefix");
        }
    }

    public void ClearPathPrefix() throws CTException {
        int n = ctdb.ClearPathPrefix(this.m_handle);
        if (n != 0) {
            throw new CTException(n, "Can't clear the path prefix");
        }
    }

    public String GetPathPrefix() {
        return ctdb.GetPathPrefix(this.m_handle);
    }

    public void Attach(boolean bl) throws CTException {
        int n = ctdb.AttachSession(this.m_handle, 3, bl);
        if (n != 0) {
            throw new CTException(n, "Can't attach to current session");
        }
    }

    public void Attach(CTSession cTSession) throws CTException {
        int n = ctdb.AttachSession(this.m_handle, cTSession.m_handle, 1, false);
        if (n != 0) {
            throw new CTException(n, "Can't attach to c-treeDB session");
        }
    }

    public void Detach() throws CTException {
        int n = ctdb.DetachSession(this.m_handle);
        if (n != 0) {
            throw new CTException(n, "Can't detach session");
        }
    }

    public static int StartDatabaseEngine() throws CTException {
        ctdb.loadCtreeLib();
        int n = ctdb.StartDatabaseEngine();
        if (n != 0) {
            throw new CTException(n, "Can't Start Database Engine");
        }
        return n;
    }

    public static void StopDatabaseEngine() throws CTException {
        ctdb.loadCtreeLib();
        ctdb.StopDatabaseEngine();
    }

    public String GetProductName() throws CTException {
        String string = ctdb.GetProductName(this.m_handle);
        if (string == null) {
            throw new CTException(ctdb.GetError(this.m_handle), "Cannot get Product Name");
        }
        return string;
    }

    public String GetProductVersion() throws CTException {
        String string = ctdb.GetProductVersion(this.m_handle);
        if (string == null) {
            throw new CTException(ctdb.GetError(this.m_handle), "Cannot get Product Version");
        }
        return string;
    }

    public int GetMaxConnections() throws CTException {
        int n = ctdb.GetMaxConnections(this.m_handle);
        if (n == 0) {
            throw new CTException(ctdb.GetError(this.m_handle), "Cannot get Max Connections");
        }
        return n;
    }

    public void LoadCallbackLib(String string, String string2, boolean bl) throws CTException {
        int n = ctdb.LoadCallbackLib(this.m_handle, string, string2, bl);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "Can't Load the Callback Library");
        }
    }

    public void UnLoadCallbackLib(boolean bl) throws CTException {
        int n = ctdb.UnLoadCallbackLib(this.m_handle, bl);
        if (n != CTDBRET.OK.getErrno()) {
            throw new CTException(n, "Can't Unload the Callback Library");
        }
    }

    public int SetCallbackOnRebuild(Object object, String string, int n) {
        return ctdb.SetCallbackOnRebuild(object, string, n);
    }

    public int SetSqlCallback(Object object, String string) {
        return ctdb.SetSqlCallback(this.m_handle, object, string);
    }

    public Calendar GetServerDateTime() throws CTException {
        return ctdb.GetServerDateTime(this.m_handle);
    }

    public void SetLogPath(String string) throws CTException {
        int n = ctdb.SetLogPath(this.m_handle, string);
        if (n != 0) {
            throw new CTException(n, "Can't set the log path");
        }
    }

    public void SetStatusLogPath(String string) throws CTException {
        int n = ctdb.SetStatusLogPath(this.m_handle, string);
        if (n != 0) {
            throw new CTException(n, "Can't set the log path");
        }
    }

    public void SetTempPath(String string) throws CTException {
        int n = ctdb.SetTempPath(this.m_handle, string);
        if (n != 0) {
            throw new CTException(n, "Can't set the temp path");
        }
    }

    public static void SetCommProtocolOption(int n, String string) throws Exception {
        ctdb.loadCtreeLib();
        int n2 = ctdb.SetCommProtocolOption(n, string);
        if (n2 != CTDBRET.OK.getErrno()) {
            throw new CTException(n2, "Can't set communication protocol options");
        }
    }

    public static void SetClientLibraryOption(int n, String string) throws CTException {
        ctdb.loadCtreeLib();
        int n2 = ctdb.SetClientLibraryOption(n, string);
        if (n2 != CTDBRET.OK.getErrno()) {
            throw new CTException(n2, "Can't set library options");
        }
    }

    public boolean GetFailOverState() {
        return ctdb.GetFailOverState(this.m_handle);
    }

    public void ResetFailOverState() {
        ctdb.ResetFailOverState(this.m_handle);
    }

    public boolean IsPrimaryServer() throws CTException {
        boolean[] blArray = new boolean[]{false};
        int n = ctdb.IsPrimaryServer(this.m_handle, blArray);
        if (n != 0) {
            throw new CTException(n, "Can't retrieve server role");
        }
        return blArray[0];
    }
}

