/*
 * Decompiled with CFR 0.152.
 */
package ctree.jdbc;

import ctree.jdbc.CtreeError;
import ctree.jdbc.CtreeLOBOutputStream;
import ctree.jdbc.CtreeResultSet;
import ctree.jdbc.CtreeSQLException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class CtreeBlob
implements Blob,
CtreeError {
    int columnIndex;
    CtreeResultSet rs;

    CtreeBlob(CtreeResultSet ctreeResultSet, int n) {
        this.rs = ctreeResultSet;
        this.columnIndex = n;
    }

    public InputStream getBinaryStream() throws SQLException {
        return this.rs.getBinaryStream(this.columnIndex);
    }

    public byte[] getBytes(long l, int n) throws SQLException {
        return this.rs.getBytes(this.columnIndex, (int)l - 1, n);
    }

    public long length() throws SQLException {
        return this.rs.getLength(this.columnIndex);
    }

    public long position(Blob blob, long l) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    public long position(byte[] byArray, long l) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    public OutputStream setBinaryStream(long l) throws SQLException {
        return new CtreeLOBOutputStream(this, (int)l);
    }

    public int setBytes(long l, byte[] byArray) throws SQLException {
        if (byArray == null) {
            throw new CtreeSQLException("Invalid byte object", 26055);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        this.rs.putData(this.columnIndex, (int)l, byteArrayInputStream);
        return byArray.length;
    }

    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        if (byArray == null) {
            throw new CtreeSQLException("Invalid byte object", 26055);
        }
        if (n < 0 || n > byArray.length) {
            throw new CtreeSQLException(26090);
        }
        if (n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new CtreeSQLException(26089);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n, n2);
        try {
            n2 = ((InputStream)byteArrayInputStream).available();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.rs.putData(this.columnIndex, (int)l, byteArrayInputStream);
        return n2;
    }

    public void truncate(long l) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    public InputStream getBinaryStream(long l, long l2) {
        System.out.println("To be implemented ");
        return null;
    }

    public void free() {
        System.out.println("To be implemented ");
    }
}

