/*
 * Decompiled with CFR 0.152.
 */
package ctree.jdbc;

import java.io.IOException;
import java.io.InputStream;

class CtreeHexToCharModulatorStream
extends InputStream {
    protected static final int[] hexDigits = new int[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    protected static final int HIGH_BITS_MASK = 240;
    protected static final int LOW_BITS_MASK = 15;
    protected InputStream binaryInputStream;
    protected int lowBits;

    public CtreeHexToCharModulatorStream(InputStream inputStream) {
        this.binaryInputStream = inputStream;
        this.lowBits = -1;
    }

    public int available() throws IOException {
        return this.binaryInputStream.available() * 2 + (this.lowBits == -1 ? 0 : 1);
    }

    public void close() throws IOException {
        super.close();
        this.binaryInputStream.close();
        this.binaryInputStream = null;
        this.lowBits = -1;
    }

    public int read() throws IOException {
        int n;
        if (this.lowBits != -1) {
            n = this.lowBits;
            this.lowBits = -1;
        } else {
            n = this.binaryInputStream.read();
            if (n != -1) {
                this.lowBits = hexDigits[n & 0xF];
                n = hexDigits[(n & 0xF0) >> 4];
            }
        }
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        int n3 = 0;
        if (this.lowBits != -1) {
            byArray[n] = (byte)this.lowBits;
            this.lowBits = -1;
            n3 = this.read(byArray, n + 1, n2 - 1);
            return n3 == -1 ? 1 : n3 + 1;
        }
        if (n2 % 2 == 1) {
            n3 = this.read(byArray, n, n2 - 1);
            if (n3 == n2 - 1 && (byArray[n + n2 - 1] = (byte)this.read()) != -1) {
                ++n3;
            }
        } else {
            n3 = this.binaryInputStream.read(byArray, n, n2 / 2) * 2;
            if (n3 > 0) {
                int n4 = n2 / 2;
                int n5 = 0;
                for (int i = n + n4 - 1; i >= n; --i) {
                    n5 = i + i - n;
                    byArray[n5 + 1] = (byte)hexDigits[byArray[i] & 0xF];
                    byArray[n5] = (byte)hexDigits[(byArray[i] & 0xF0) >> 4];
                }
            }
        }
        return n3 >= 0 ? n3 : -1;
    }

    public long skip(long l) throws IOException {
        if (l <= 0L) {
            return 0L;
        }
        long l2 = 0L;
        if (this.lowBits != -1) {
            this.lowBits = -1;
            l2 = this.skip(l - 1L) + 1L;
        } else if (l % 2L == 1L) {
            l2 = this.binaryInputStream.skip(l / 2L);
            if (l2 == l / 2L && this.read() != -1) {
                ++l2;
            }
        } else {
            l2 = this.binaryInputStream.skip(l / 2L) * 2L;
        }
        return l2;
    }
}

