/*
 * Decompiled with CFR 0.152.
 */
package ctree.jdbc;

import ctree.jdbc.CtreeError;
import ctree.jdbc.CtreeSQLException;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;

public class CtreeLOBOutputStream
extends OutputStream
implements CtreeError {
    protected Blob blob;
    protected Clob clob;
    protected int pos;
    protected boolean isCharStream;

    public CtreeLOBOutputStream(Blob blob, int n) throws SQLException {
        if (blob == null) {
            throw new NullPointerException();
        }
        if (n < 1) {
            throw new CtreeSQLException(26088);
        }
        this.blob = blob;
        this.isCharStream = false;
        this.pos = n;
    }

    public CtreeLOBOutputStream(Clob clob, int n) throws SQLException {
        if (clob == null) {
            throw new NullPointerException();
        }
        if (n < 1) {
            throw new CtreeSQLException(26088);
        }
        this.clob = clob;
        this.isCharStream = true;
        this.pos = n;
    }

    public void write(int n) throws IOException {
        int n2 = 0;
        int n3 = 1;
        byte[] byArray = new byte[]{(byte)n};
        this.write(byArray, n2, n3);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        try {
            if (this.isCharStream) {
                this.clob.setString(this.pos, new String(byArray), n, n2);
            } else {
                this.blob.setBytes(this.pos, byArray, n, n2);
            }
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void close() throws IOException {
        super.close();
        if (this.isCharStream) {
            this.clob = null;
        } else {
            this.blob = null;
        }
    }

    public void flush() throws IOException {
    }
}

