/*
 * Decompiled with CFR 0.152.
 */
package ctree.jdbc;

import ctree.jdbc.CtreeData;
import ctree.jdbc.CtreeError;
import ctree.jdbc.CtreeHexToCharModulatorStream;
import ctree.jdbc.CtreeResultSet;
import ctree.jdbc.CtreeSQLException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public class CtreeLongDataInputStream
extends InputStream
implements CtreeError {
    protected CtreeResultSet rs;
    protected byte[] buf;
    protected CtreeData data;
    protected InputStream istream;
    protected boolean convReqd;
    int hostType;
    int remain;

    public CtreeLongDataInputStream(CtreeResultSet ctreeResultSet, String string, int n, boolean bl) throws SQLException {
        this.rs = ctreeResultSet;
        switch (n) {
            case 15: 
            case 22: {
                n = 12;
                this.convReqd = bl;
                break;
            }
            case 14: 
            case 23: {
                n = 1;
                this.convReqd = false;
                break;
            }
            case 24: 
            case 25: {
                n = 17;
                this.convReqd = false;
                break;
            }
            default: {
                throw new CtreeSQLException(26028);
            }
        }
        this.hostType = n;
        this.buf = new byte[ctreeResultSet.getOutputDA().getMaxFieldSize()];
        this.data = new CtreeData(this.buf, 0, this.buf.length, (short)n, string);
        this.istream = null;
        this.fillBuffer();
    }

    public int available() throws IOException {
        if (this.rs.UnicodeCompatibility() && this.hostType == 17) {
            return this.istream.available() / 2;
        }
        return this.istream.available();
    }

    public void close() throws IOException {
        super.close();
        if (this.istream != null) {
            this.istream.close();
        }
        this.rs = null;
        this.buf = null;
        this.data = null;
        this.istream = null;
    }

    public int read() throws IOException {
        int n;
        int n2 = this.istream.read();
        if (n2 < 0) {
            try {
                this.fillBuffer();
            }
            catch (SQLException sQLException) {
                throw new IOException(sQLException.getMessage());
            }
            n2 = this.istream.read();
        }
        if (this.hostType == 17) {
            int n3 = this.istream.read();
            n = n2 < 0 ? n2 : (n3 < 0 ? n3 : (int)((char)((n2 << 8) + (n3 << 0))));
        } else {
            n = n2;
        }
        if (this.remain > 0 && n >= 0) {
            --this.remain;
        }
        if (this.hostType == 17 && this.remain > 0 && n >= 0) {
            --this.remain;
        }
        return n;
    }

    public long skip(long l) throws IOException {
        long l2 = l;
        long l3 = this.istream.skip(l);
        for (l2 = l - l3; l2 > 0L; l2 -= l3) {
            try {
                this.fillBuffer();
            }
            catch (SQLException sQLException) {
                break;
            }
            l3 = this.istream.skip(l2);
            if (l3 <= 0L) break;
        }
        if (l2 <= 0L) {
            l2 = 0L;
        }
        return l - l2;
    }

    protected void fillBuffer() throws SQLException {
        int n = this.data.getPosition();
        if (n >= 0) {
            this.rs.getData(this.data);
            this.remain = this.data.getPosition();
            if (this.remain > 0 || this.remain == 0 && n == 0) {
                int n2 = this.data.getLength();
                this.istream = this.convReqd ? new CtreeHexToCharModulatorStream(new ByteArrayInputStream(this.buf, 0, n2)) : new ByteArrayInputStream(this.buf, 0, n2);
                this.data.setLength(this.buf.length);
                if (this.hostType == 17) {
                    this.data.setPosition(this.remain * 2 >= this.buf.length ? n + n2 / 2 : -1);
                } else {
                    this.data.setPosition(this.remain >= this.buf.length ? n + n2 : -1);
                }
            }
        }
    }

    protected byte[] getBytes() throws SQLException {
        ByteArrayOutputStream byteArrayOutputStream = this.getByteArrayOutputStream();
        return byteArrayOutputStream == null ? null : byteArrayOutputStream.toByteArray();
    }

    protected byte[] getBytes(int n, int n2) throws SQLException {
        if (this.istream == null) {
            return null;
        }
        byte[] byArray = new byte[n2];
        try {
            this.skip(n);
            this.read(byArray, 0, n2);
        }
        catch (IOException iOException) {
            throw new CtreeSQLException(iOException.getMessage(), 26026);
        }
        return byArray;
    }

    protected String getString() throws SQLException {
        if (this.istream == null) {
            return null;
        }
        if (this.hostType == 1 || this.hostType == 17) {
            char[] cArray = null;
            try {
                int n = -1;
                int n2 = 0;
                n2 = this.remain;
                cArray = new char[n2];
                for (int i = 0; i < n2 && (n = this.read()) >= 0; ++i) {
                    cArray[i] = (char)n;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new String(cArray);
        }
        ByteArrayOutputStream byteArrayOutputStream = this.getByteArrayOutputStream();
        return byteArrayOutputStream == null ? null : byteArrayOutputStream.toString();
    }

    protected String getString(int n, int n2) throws SQLException {
        if (this.istream == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byte[] byArray = new byte[n2];
            this.skip(n - 1);
            int n3 = this.read(byArray, 0, n2);
            if (n3 > 0) {
                byteArrayOutputStream.write(byArray, 0, n3);
            }
            return byteArrayOutputStream.toString();
        }
        catch (IOException iOException) {
            throw new CtreeSQLException(iOException.getMessage(), 26026);
        }
    }

    protected ByteArrayOutputStream getByteArrayOutputStream() throws SQLException {
        if (this.istream == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            boolean bl = false;
            byte[] byArray = new byte[2 * this.buf.length];
            int n = 0;
            while ((n = this.istream.read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
                this.fillBuffer();
            }
            this.istream.close();
        }
        catch (IOException iOException) {
            throw new CtreeSQLException(iOException.getMessage(), 26026);
        }
        return byteArrayOutputStream;
    }
}

