/*
 * Decompiled with CFR 0.152.
 */
package ctree.jdbc;

import ctree.jdbc.CtreeBlob;
import ctree.jdbc.CtreeCA;
import ctree.jdbc.CtreeCharToHexModulatorStream;
import ctree.jdbc.CtreeClob;
import ctree.jdbc.CtreeConnection;
import ctree.jdbc.CtreeDA;
import ctree.jdbc.CtreeHexToCharModulatorStream;
import ctree.jdbc.CtreeParameterMetaData;
import ctree.jdbc.CtreeReaderInputStream;
import ctree.jdbc.CtreeReaderUnicodeInputStream;
import ctree.jdbc.CtreeSQLException;
import ctree.jdbc.CtreeSQLWarning;
import ctree.jdbc.CtreeStatement;
import ctree.jdbc.CtreeValue;
import ctree.jdbc.JDBCType;
import ctree.jdbc.SQLType;
import ctree.jdbc.StatementUid;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class CtreePreparedStatement
extends CtreeStatement
implements PreparedStatement {
    CtreeDA paramDA;
    CtreeCA m_prepstsqlca;
    SQLWarning warnings;
    boolean[] bound_flags;
    boolean[] need_data;
    int rowIndex = 0;
    boolean isBatchActivated = false;
    boolean valueNotBound = false;
    private int batchIncrement = 500;

    protected CtreePreparedStatement(CtreeConnection ctreeConnection, String string, int n, int n2) throws SQLException {
        super(ctreeConnection, n, n2);
        this.paramDA = new CtreeDA(20, 1, this.charSize(), this.UnicodeCompatibility(), this.getCharset(), ctreeConnection.getMaxFieldSize());
        this.m_prepstsqlca = new CtreeCA();
        this.setResultSet(this.createCtreeResultSet());
        this.setStatementID(this.CtreeGetConnection().prepare(string, this.paramDA, this.getCurrentResultSet().getOutputDA(), super.isScrollable()), string);
        if (!this.paramDA.isDescribeParamCalled) {
            this.paramDA = new CtreeDA(20, 1, this.charSize(), this.UnicodeCompatibility(), this.getCharset(), ctreeConnection.getMaxFieldSize());
            this.paramDA.setParameterCount(string);
        }
        this.getCurrentResultSet().setMaxRows(this.getMaxRows());
        this.getCurrentResultSet().setLargeMaxRows(this.getLargeMaxRows());
        this.resetBoundFlags(false);
        if (CtreePreparedStatement.traceOn()) {
            CtreePreparedStatement.trace("@CtreePreparedStatement (statementID = " + this.getStatementID() + ", statement = " + this.getStatement() + ")");
        }
    }

    public ResultSet executeQuery() throws SQLException {
        this.checkConnection();
        if (this.isBatchActivated) {
            throw new CtreeSQLException(26084);
        }
        if (CtreePreparedStatement.traceOn()) {
            CtreePreparedStatement.trace("@CtreePreparedStatement.executeQuery (statementId = " + this.getStatementID() + ", statement = " + this.getStatement() + ")");
        }
        if (this.getStatementType(this.getStatementID()) != 5 && !this.gotAllBoundFlags()) {
            throw new CtreeSQLException(26029);
        }
        if (this.getCurrentResultSet() != null) {
            this.setResultSet(this.recreateCtreeResultSet());
        } else {
            this.setResultSet(this.createCtreeResultSet());
        }
        this.CtreeGetConnection().execute(this.getStatementID(), this.paramDA, this.m_prepstsqlca);
        this.getStatementID().setCursorName(this.cursorName);
        if (this.CtreeGetConnection().hasResultSet(this.getStatementID())) {
            this.getCurrentResultSet().setMaxRows(this.getMaxRows());
            this.getCurrentResultSet().setLargeMaxRows(this.getLargeMaxRows());
            this.getCurrentResultSet().resizeResultDA();
            this.getCurrentResultSet().initResultSet();
            if (this.isScrollable()) {
                this.getCurrentResultSet().SetNOfRows(this.CtreeGetConnection().getNOfRows(this.getStatementID()));
            }
            return this.getCurrentResultSet();
        }
        throw new CtreeSQLException(26033);
    }

    public int executeUpdate() throws SQLException {
        this.checkConnection();
        boolean bl = this.anyParamNeedsData();
        if (this.isBatchActivated) {
            throw new CtreeSQLException(26084);
        }
        if (CtreePreparedStatement.traceOn()) {
            CtreePreparedStatement.trace("@CtreePreparedStatement.executeUpdate (statementId = " + this.getStatementID() + ", statement = " + this.getStatement() + ")");
        }
        if (this.getStatementType(this.getStatementID()) != 5 && !this.gotAllBoundFlags()) {
            throw new CtreeSQLException(26029);
        }
        boolean bl2 = this.CtreeGetConnection().getAutoCommit();
        if (bl2 && bl) {
            this.CtreeGetConnection().setAutoCommit(false);
        }
        try {
            boolean bl3 = false;
            bl3 = this.CtreeGetConnection().execute(this.getStatementID(), this.paramDA, this.m_prepstsqlca);
            if (bl3) {
                this.putData();
            }
        }
        catch (SQLException sQLException) {
            if (bl2 && bl) {
                this.CtreeGetConnection().setAutoCommit(true);
            }
            throw sQLException;
        }
        if (bl2 && bl) {
            this.CtreeGetConnection().setAutoCommit(true);
        }
        if (this.CtreeGetConnection().hasResultSet(this.getStatementID())) {
            throw new CtreeSQLException(26031);
        }
        this.setResultSet(null);
        return this.CtreeGetConnection().getRowCount(this.getStatementID());
    }

    public boolean execute() throws SQLException {
        this.checkConnection();
        boolean bl = this.anyParamNeedsData();
        if (this.isBatchActivated) {
            throw new CtreeSQLException(26084);
        }
        if (CtreePreparedStatement.traceOn()) {
            CtreePreparedStatement.trace("@CtreePreparedStatement.execute (statementId = " + this.getStatementID() + ", statement = " + this.getStatement() + ")");
        }
        if (this.getStatementType(this.getStatementID()) != 5 && !this.gotAllBoundFlags()) {
            throw new CtreeSQLException(26029);
        }
        if (this.getCurrentResultSet() != null) {
            this.setResultSet(this.recreateCtreeResultSet());
        } else {
            this.setResultSet(this.createCtreeResultSet());
        }
        this.getStatementID().setCursorName(this.cursorName);
        boolean bl2 = this.CtreeGetConnection().getAutoCommit();
        if (bl2 && bl) {
            this.CtreeGetConnection().setAutoCommit(false);
        }
        try {
            this.CtreeGetConnection().execute(this.getStatementID(), this.paramDA, this.m_prepstsqlca);
            this.putData();
        }
        catch (SQLException sQLException) {
            if (bl2 && bl) {
                this.CtreeGetConnection().setAutoCommit(true);
            }
            throw sQLException;
        }
        if (bl2 && bl) {
            this.CtreeGetConnection().setAutoCommit(true);
        }
        if (this.CtreeGetConnection().hasResultSet(this.getStatementID())) {
            this.getCurrentResultSet().setMaxRows(this.getMaxRows());
            this.getCurrentResultSet().setLargeMaxRows(this.getLargeMaxRows());
            this.getCurrentResultSet().resizeResultDA();
            this.getCurrentResultSet().initResultSet();
            if (this.isScrollable()) {
                this.getCurrentResultSet().SetNOfRows(this.CtreeGetConnection().getNOfRows(this.getStatementID()));
            }
            return true;
        }
        int n = this.CtreeGetConnection().getRowCount(this.getStatementID());
        this.setUpdateCount(n);
        this.setResultSet(null);
        return false;
    }

    public void setNull(int n, int n2) throws SQLException {
        SQLType sQLType = CtreeDA.typesToJdbcTypes(n2);
        this.paramDA.makeNull(n - 1, this.rowIndex, sQLType);
        this.setBoundFlag(n - 1);
    }

    private void setNULL(int n) throws SQLException {
        short s = this.paramDA.getHostType(n);
        this.paramDA.makeNull(n, this.rowIndex, CtreeDA.typesToJdbcTypes(s));
    }

    public void setNull(int n, SQLType sQLType) throws SQLException {
        this.paramDA.makeNull(n - 1, this.rowIndex, sQLType);
        this.setBoundFlag(n - 1);
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        this.paramDA.setBooleanValue(n - 1, this.rowIndex, bl);
        this.setBoundFlag(n - 1);
    }

    public void setByte(int n, byte by) throws SQLException {
        this.paramDA.setByteValue(n - 1, this.rowIndex, by);
        this.setBoundFlag(n - 1);
    }

    public void setShort(int n, short s) throws SQLException {
        this.paramDA.setShortValue(n - 1, this.rowIndex, s);
        this.setBoundFlag(n - 1);
    }

    public void setInt(int n, int n2) throws SQLException {
        this.paramDA.setIntegerValue(n - 1, this.rowIndex, n2);
        this.setBoundFlag(n - 1);
    }

    public void setLong(int n, long l) throws SQLException {
        this.paramDA.setLongValue(n - 1, this.rowIndex, l);
        this.setBoundFlag(n - 1);
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        if (bigDecimal != null) {
            this.paramDA.setBigDecimal(n - 1, this.rowIndex, bigDecimal);
        } else {
            this.setNULL(n - 1);
        }
        this.setBoundFlag(n - 1);
    }

    public void setFloat(int n, float f) throws SQLException {
        this.paramDA.setFloatValue(n - 1, this.rowIndex, f);
        this.setBoundFlag(n - 1);
    }

    public void setDouble(int n, double d) throws SQLException {
        this.paramDA.setDoubleValue(n - 1, this.rowIndex, d);
        this.setBoundFlag(n - 1);
    }

    public void setString(int n, String string) throws SQLException {
        Object object;
        --n;
        if (!this.paramDA.isDescribeParamCalled) {
            if (this.UnicodeCompatibility()) {
                this.paramDA.setSqlTypes(n, (short)18);
            } else {
                this.paramDA.setSqlTypes(n, (short)21);
            }
            object = new Object();
            this.paramDA.setHostTypes(n, object, JDBCType.VARCHAR);
        }
        if (string == null) {
            this.setNULL(n);
            this.setBoundFlag(n);
        } else {
            object = this.paramDA.getSqlType(n);
            if (object == JDBCType.LONGVARBINARY || object == JDBCType.LONGVARCHAR || object == JDBCType.BLOB || object == JDBCType.CLOB) {
                if (object == JDBCType.CLOB || object == JDBCType.LONGVARCHAR) {
                    this.setCharacterStream(n + 1, (Reader)new StringReader(string), string.length());
                } else {
                    this.setAsciiStream(n + 1, (InputStream)new ByteArrayInputStream(string.getBytes()), string.length());
                }
            } else {
                this.paramDA.setString(n, this.rowIndex, string);
                this.setBoundFlag(n);
            }
        }
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        Object object;
        --n;
        if (!this.paramDA.isDescribeParamCalled) {
            this.paramDA.setSqlTypes(n, (short)12);
            object = new Object();
            this.paramDA.setHostTypes(n, object, JDBCType.BINARY);
        }
        if ((object = this.paramDA.getSqlType(n)) == JDBCType.LONGVARBINARY || object == JDBCType.LONGVARCHAR) {
            this.setBinaryStream(n + 1, (InputStream)new ByteArrayInputStream(byArray), byArray.length);
        } else {
            if (byArray != null) {
                this.paramDA.setBytes(n, this.rowIndex, byArray);
            } else {
                this.setNULL(n);
            }
            this.setBoundFlag(n);
        }
    }

    public void setDate(int n, Date date) throws SQLException {
        if (date != null) {
            this.paramDA.setDate(n - 1, this.rowIndex, date);
        } else {
            this.setNULL(n - 1);
        }
        this.setBoundFlag(n - 1);
    }

    public void setTime(int n, Time time) throws SQLException {
        if (time != null) {
            this.paramDA.setTime(n - 1, this.rowIndex, time);
        } else {
            this.setNULL(n - 1);
        }
        this.setBoundFlag(n - 1);
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        if (timestamp != null) {
            this.paramDA.setTimestamp(n - 1, this.rowIndex, timestamp);
        } else {
            this.setNULL(n - 1);
        }
        this.setBoundFlag(n - 1);
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        Object object;
        if (--n < 0) {
            throw new CtreeSQLException(26049);
        }
        if (n2 < 0) {
            throw new CtreeSQLException(26089);
        }
        if (!this.paramDA.isDescribeParamCalled) {
            this.paramDA.setSqlTypes(n, (short)14);
            object = new Object();
            this.paramDA.setHostTypes(n, object, JDBCType.LONGVARCHAR);
        }
        if ((object = this.paramDA.getSqlType(n)) == JDBCType.LONGVARBINARY || object == JDBCType.LONGVARCHAR || object == JDBCType.BLOB || object == JDBCType.CLOB) {
            this.setNull(n + 1, (SQLType)object);
            if (object == JDBCType.LONGVARBINARY || object == JDBCType.BLOB) {
                this.paramDA.setBinaryStream(n, this.rowIndex, new CtreeCharToHexModulatorStream(inputStream), n2, (SQLType)object);
            } else if (this.UnicodeCompatibility()) {
                try {
                    byte[] byArray = new byte[inputStream.available()];
                    inputStream.read(byArray);
                    this.setCharacterStream(n + 1, (Reader)new StringReader(new String(byArray)), inputStream.available());
                }
                catch (Exception exception) {}
            } else {
                this.paramDA.setAsciiStream(n, this.rowIndex, inputStream, n2, (SQLType)object);
            }
            this.paramDA.setOutFlag(n);
            this.setNeedDataFlag(n);
        } else {
            try {
                int n3 = 0;
                String string = "";
                byte[] byArray = new byte[n2];
                DataInputStream dataInputStream = new DataInputStream(inputStream);
                n3 = dataInputStream.read(byArray);
                if (object == JDBCType.VARCHAR || object == JDBCType.CHAR) {
                    string = n3 > n2 ? new String(byArray, 0, n2) : new String(byArray, 0, n3);
                    this.paramDA.setString(n, this.rowIndex, string);
                } else {
                    this.paramDA.setBytes(n, this.rowIndex, byArray);
                }
                dataInputStream.close();
            }
            catch (IOException iOException) {
                throw new CtreeSQLException(iOException.getMessage(), 26055);
            }
        }
        this.setBoundFlag(n);
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        Object object;
        if (!this.paramDA.isDescribeParamCalled) {
            this.paramDA.setSqlTypes(n - 1, (short)14);
            object = new Object();
            this.paramDA.setHostTypes(n - 1, object, JDBCType.LONGVARCHAR);
        }
        if ((object = this.paramDA.getSqlType(n - 1)) == JDBCType.LONGVARBINARY || object == JDBCType.BLOB) {
            this.setNull(n, (SQLType)object);
            this.paramDA.setUnicodeStream(n - 1, this.rowIndex, new CtreeHexToCharModulatorStream(inputStream), n2 * 2, (SQLType)object);
            this.setBoundFlag(n - 1);
            this.setNeedDataFlag(n - 1);
            this.paramDA.setOutFlag(n - 1);
        } else if (object == JDBCType.LONGVARCHAR || object == JDBCType.CLOB) {
            this.setNull(n, (SQLType)object);
            this.paramDA.setUnicodeStream(n - 1, this.rowIndex, inputStream, n2, (SQLType)object);
            this.setBoundFlag(n - 1);
            this.setNeedDataFlag(n - 1);
            this.paramDA.setOutFlag(n - 1);
        } else {
            byte[] byArray = new byte[n2];
            try {
                DataInputStream dataInputStream = new DataInputStream(inputStream);
                dataInputStream.readFully(byArray);
                dataInputStream.close();
            }
            catch (IOException iOException) {
                throw new CtreeSQLException(iOException.getMessage(), 26055);
            }
            this.paramDA.setBytes(n - 1, this.rowIndex, byArray);
        }
        this.setBoundFlag(n - 1);
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        Object object;
        if (--n < 0) {
            throw new CtreeSQLException(26049);
        }
        if (n2 < 0) {
            throw new CtreeSQLException(26089);
        }
        if (!this.paramDA.isDescribeParamCalled) {
            this.paramDA.setSqlTypes(n, (short)15);
            object = new Object();
            this.paramDA.setHostTypes(n, object, JDBCType.LONGVARBINARY);
        }
        if ((object = this.paramDA.getSqlType(n)) == JDBCType.LONGVARBINARY || object == JDBCType.LONGVARCHAR || object == JDBCType.BLOB || object == JDBCType.CLOB) {
            this.setNull(n + 1, (SQLType)object);
            if (object == JDBCType.LONGVARBINARY || object == JDBCType.BLOB) {
                this.paramDA.setBinaryStream(n, this.rowIndex, inputStream, n2, (SQLType)object);
            } else {
                this.paramDA.setAsciiStream(n, this.rowIndex, new CtreeHexToCharModulatorStream(inputStream), n2, (SQLType)object);
            }
            this.paramDA.setOutFlag(n);
            this.setNeedDataFlag(n);
        } else {
            try {
                byte[] byArray = new byte[n2];
                DataInputStream dataInputStream = new DataInputStream(inputStream);
                dataInputStream.readFully(byArray);
                dataInputStream.close();
                this.paramDA.setBytes(n, this.rowIndex, byArray);
            }
            catch (IOException iOException) {
                throw new CtreeSQLException(iOException.getMessage(), 26055);
            }
        }
        this.setBoundFlag(n);
    }

    public void clearParameters() throws SQLException {
        this.resetBoundFlags(false);
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        if (object != null) {
            this.paramDA.setScale(n - 1, n3);
            this.setObject(n, object, n2);
        } else {
            this.setNULL(n - 1);
        }
        this.setBoundFlag(n - 1);
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        SQLType sQLType = CtreeDA.typesToJdbcTypes(n2);
        this.setObject(n, object, sQLType);
    }

    public void setObject(int n, Object object, SQLType sQLType) throws SQLException {
        block20: {
            block19: {
                if (object == null) break block19;
                this.paramDA.setType(n - 1, sQLType);
                switch ((JDBCType)sQLType) {
                    case TINYINT: {
                        this.setObject(n, new CtreeValue(object, this.UnicodeCompatibility()).getByte());
                        break block20;
                    }
                    case SMALLINT: {
                        this.setObject(n, new CtreeValue(object, this.UnicodeCompatibility()).getShort());
                        break block20;
                    }
                    case INTEGER: {
                        this.setObject(n, new CtreeValue(object, this.UnicodeCompatibility()).getInteger());
                        break block20;
                    }
                    case BIGINT: {
                        this.setObject(n, new CtreeValue(object, this.UnicodeCompatibility()).getLong());
                        break block20;
                    }
                    case REAL: {
                        this.setObject(n, new CtreeValue(object, this.UnicodeCompatibility()).getFloat());
                        break block20;
                    }
                    case FLOAT: 
                    case DOUBLE: {
                        this.setObject(n, new CtreeValue(object, this.UnicodeCompatibility()).getDouble());
                        break block20;
                    }
                    case NUMERIC: 
                    case DECIMAL: {
                        this.setObject(n, new CtreeValue(object, this.UnicodeCompatibility()).getBigDecimal(127));
                        break block20;
                    }
                    case BIT: {
                        this.setObject(n, new CtreeValue(object, this.UnicodeCompatibility()).getBoolean());
                        break block20;
                    }
                    case CHAR: 
                    case VARCHAR: {
                        this.setObject(n, new CtreeValue(object, this.UnicodeCompatibility()).getString());
                        break block20;
                    }
                    case BINARY: 
                    case VARBINARY: {
                        this.setObject(n, new CtreeValue(object, this.UnicodeCompatibility()).getBytes());
                        break block20;
                    }
                    case CLOB: {
                        this.setClob(n, (CtreeClob)object);
                        break block20;
                    }
                    case LONGVARCHAR: {
                        this.setObject(n, object);
                        break block20;
                    }
                    case BLOB: {
                        this.setBlob(n, (CtreeBlob)object);
                        break block20;
                    }
                    case LONGVARBINARY: {
                        this.setObject(n, object);
                        break block20;
                    }
                    case DATE: {
                        this.setObject(n, new CtreeValue(object, this.UnicodeCompatibility()).getDate());
                        break block20;
                    }
                    case TIME: {
                        this.setObject(n, new CtreeValue(object, this.UnicodeCompatibility()).getTime());
                        break block20;
                    }
                    case TIMESTAMP: {
                        this.setObject(n, new CtreeValue(object, this.UnicodeCompatibility()).getTimestamp());
                        break block20;
                    }
                    default: {
                        throw new CtreeSQLException("Invalid conversion error ", 26065);
                    }
                }
            }
            this.setNULL(n - 1);
        }
        this.setBoundFlag(n - 1);
    }

    public void setObject(int n, Object object) throws SQLException {
        if (object == null) {
            this.setNULL(n - 1);
            this.setBoundFlag(n - 1);
        } else {
            if (object instanceof Array) {
                throw new CtreeSQLException(26065);
            }
            if (object instanceof InputStream) {
                try {
                    this.setBinaryStream(n, (InputStream)object, ((InputStream)object).available());
                }
                catch (IOException iOException) {
                    throw new CtreeSQLException(iOException.getMessage(), 26055);
                }
            } else if (object instanceof BigDecimal) {
                this.setBigDecimal(n, (BigDecimal)object);
            } else if (object instanceof Blob) {
                this.setBlob(n, (CtreeBlob)object);
            } else if (object instanceof Boolean) {
                this.setBoolean(n, (Boolean)object);
            } else if (object instanceof Byte) {
                this.setByte(n, (Byte)object);
            } else if (object instanceof byte[]) {
                this.setBytes(n, (byte[])object);
            } else if (object instanceof Clob) {
                this.setClob(n, (CtreeClob)object);
            } else if (object instanceof Date) {
                this.setDate(n, (Date)object);
            } else if (object instanceof Double) {
                this.setDouble(n, (Double)object);
            } else if (object instanceof Float) {
                this.setFloat(n, ((Float)object).floatValue());
            } else if (object instanceof Integer) {
                this.setInt(n, (Integer)object);
            } else if (object instanceof Long) {
                this.setLong(n, (Long)object);
            } else {
                if (object instanceof Ref) {
                    throw new CtreeSQLException(26065);
                }
                if (object instanceof Short) {
                    this.setShort(n, (Short)object);
                } else if (object instanceof String) {
                    this.setString(n, (String)object);
                } else if (object instanceof Time) {
                    this.setTime(n, (Time)object);
                } else if (object instanceof Timestamp) {
                    this.setTimestamp(n, (Timestamp)object);
                } else {
                    if (object instanceof URL) {
                        throw new CtreeSQLException(26065);
                    }
                    throw new CtreeSQLException(26055);
                }
            }
        }
    }

    public int getNparams() {
        if (this.getStatementType(this.getStatementID()) != 5) {
            int n = this.paramDA.getNColumns();
            if (this.isBatchActivated) {
                --n;
            }
            return n;
        }
        return 0;
    }

    private void resetBoundFlags(boolean bl) {
        int n = this.paramDA.getNColumns();
        if (n != 0) {
            if (bl && this.bound_flags != null) {
                int n2 = this.bound_flags.length;
                if (n2 != n) {
                    boolean[] blArray = new boolean[n];
                    boolean[] blArray2 = new boolean[n];
                    if (n < n2) {
                        n2 = n;
                    }
                    System.arraycopy(this.bound_flags, 0, blArray, 0, n2);
                    System.arraycopy(this.need_data, 0, blArray2, 0, n2);
                    while (n2 < n) {
                        blArray[n2] = false;
                        blArray2[n2] = false;
                        ++n2;
                    }
                    this.bound_flags = blArray;
                    this.need_data = blArray2;
                }
            } else {
                if (this.bound_flags == null || this.bound_flags.length != n) {
                    this.bound_flags = new boolean[n];
                    this.need_data = new boolean[n];
                }
                for (int i = 0; i < n; ++i) {
                    this.bound_flags[i] = false;
                    this.need_data[i] = false;
                }
            }
        } else {
            this.bound_flags = null;
            this.need_data = null;
        }
    }

    protected void setBoundFlag(int n) {
        short s = this.paramDA.getNColumns();
        if (n >= 0 && n < s) {
            this.bound_flags[n] = true;
        }
    }

    protected void setNeedDataFlag(int n) {
        short s = this.paramDA.getNColumns();
        if (n >= 0 && n < s) {
            this.need_data[n] = true;
        }
    }

    private boolean gotAllBoundFlags() {
        int n = this.paramDA.getNColumns();
        if (n != 0) {
            if (this.isBatchActivated) {
                --n;
            }
            for (int i = 0; i < n; ++i) {
                if (this.bound_flags[i]) continue;
                return false;
            }
        }
        return true;
    }

    private boolean anyParamNeedsData() {
        int n = this.paramDA.getNColumns();
        if (n != 0) {
            if (this.isBatchActivated) {
                --n;
            }
            for (int i = 0; i < n; ++i) {
                if (this.need_data == null || !this.need_data[i]) continue;
                return true;
            }
        }
        return false;
    }

    protected void putData() throws SQLException {
        CtreeConnection ctreeConnection = this.CtreeGetConnection();
        StatementUid statementUid = this.getStatementID();
        if (this.m_prepstsqlca.Sqlerrd[2] == 0) {
            return;
        }
        for (int i = this.paramDA.getNColumns() - 1; i >= 0; --i) {
            int n;
            if (!this.need_data[i]) continue;
            switch (this.paramDA.getHostType(i)) {
                case 15: {
                    n = 12;
                    break;
                }
                case 14: {
                    n = 1;
                    break;
                }
                case 24: {
                    n = 17;
                    break;
                }
                case 22: {
                    n = 12;
                    break;
                }
                case 23: {
                    n = 1;
                    break;
                }
                default: {
                    throw new CtreeSQLException(26028);
                }
            }
            ctreeConnection.putData(statementUid, this.paramDA.getInputStream(i, 0), n, this.paramDA.getString(i, 0), 0);
        }
    }

    public int getStatementType(StatementUid statementUid) {
        return this.CtreeGetConnection().getStatementType(statementUid);
    }

    public SQLWarning getWarnings() throws SQLException {
        String string = this.m_prepstsqlca.getSqlwarn();
        CtreeSQLWarning ctreeSQLWarning = null;
        if (string != null) {
            if (string.charAt(1) == 'W') {
                if (ctreeSQLWarning == null) {
                    ctreeSQLWarning = new CtreeSQLWarning(26070);
                } else {
                    ctreeSQLWarning.setNextWarning(new CtreeSQLWarning(26070));
                }
            }
            if (string.charAt(2) == 'W') {
                if (ctreeSQLWarning == null) {
                    ctreeSQLWarning = new CtreeSQLWarning(26071);
                } else {
                    ctreeSQLWarning.setNextWarning(new CtreeSQLWarning(26071));
                }
            }
            if (string.charAt(3) == 'W') {
                if (ctreeSQLWarning == null) {
                    ctreeSQLWarning = new CtreeSQLWarning(26072);
                } else {
                    ctreeSQLWarning.setNextWarning(new CtreeSQLWarning(26072));
                }
            }
            if (string.charAt(4) == 'W') {
                if (ctreeSQLWarning == null) {
                    ctreeSQLWarning = new CtreeSQLWarning(26073);
                } else {
                    ctreeSQLWarning.setNextWarning(new CtreeSQLWarning(26073));
                }
            }
            if (string.charAt(6) == 'W') {
                if (ctreeSQLWarning == null) {
                    ctreeSQLWarning = new CtreeSQLWarning(26074);
                } else {
                    ctreeSQLWarning.setNextWarning(new CtreeSQLWarning(26074));
                }
            }
        }
        if (this.warnings != null) {
            for (SQLWarning sQLWarning = this.warnings; sQLWarning != null; sQLWarning = sQLWarning.getNextWarning()) {
                if (ctreeSQLWarning == null) {
                    ctreeSQLWarning = new CtreeSQLWarning(sQLWarning.getErrorCode());
                    continue;
                }
                ctreeSQLWarning.setNextWarning(new CtreeSQLWarning(sQLWarning.getErrorCode()));
            }
        }
        return this.warnings;
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        Object object;
        if (n < 0) {
            throw new CtreeSQLException(26049);
        }
        if (n2 < 0) {
            throw new CtreeSQLException(26089);
        }
        InputStream inputStream = null;
        --n;
        if (!this.paramDA.isDescribeParamCalled) {
            this.paramDA.setSqlTypes(n, (short)14);
            object = new Object();
            this.paramDA.setHostTypes(n, object, JDBCType.LONGVARCHAR);
        }
        if ((object = this.paramDA.getSqlType(n)) == JDBCType.LONGVARBINARY || object == JDBCType.LONGVARCHAR || object == JDBCType.BLOB || object == JDBCType.CLOB) {
            short s = this.paramDA.getHostType(n);
            inputStream = s == 24 || s == 25 ? new CtreeReaderUnicodeInputStream(reader) : new CtreeReaderInputStream(reader);
            this.setNull(n + 1, (SQLType)object);
            if (object == JDBCType.LONGVARBINARY || object == JDBCType.BLOB) {
                this.paramDA.setBinaryStream(n, this.rowIndex, new CtreeCharToHexModulatorStream(inputStream), n2, (SQLType)object);
            } else {
                this.paramDA.setAsciiStream(n, this.rowIndex, inputStream, n2, (SQLType)object);
            }
            this.paramDA.setOutFlag(n);
            this.setNeedDataFlag(n);
        } else {
            try {
                byte[] byArray = new byte[n2];
                if (object == JDBCType.VARCHAR || object == JDBCType.CHAR) {
                    char[] cArray = new char[n2];
                    int n3 = reader.read(cArray);
                    String string = n3 < n2 ? new String(cArray, 0, n3) : new String(cArray, 0, n2);
                    this.paramDA.setString(n, this.rowIndex, string);
                } else {
                    inputStream = new CtreeReaderInputStream(reader);
                    CtreeCharToHexModulatorStream ctreeCharToHexModulatorStream = new CtreeCharToHexModulatorStream(inputStream);
                    int n4 = ctreeCharToHexModulatorStream.read(byArray);
                    if (n4 < n2) {
                        byte[] byArray2 = new byte[n4];
                        System.arraycopy(byArray, 0, byArray2, 0, n4);
                        this.paramDA.setBytes(n, this.rowIndex, byArray2);
                    } else {
                        this.paramDA.setBytes(n, this.rowIndex, byArray);
                    }
                }
            }
            catch (IOException iOException) {
                System.out.println("EOF Exception is read()  " + iOException.getMessage());
                throw new CtreeSQLException(iOException.getMessage(), 26055);
            }
        }
        this.setBoundFlag(n);
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.setTime(n, time);
        if (this.warnings != null) {
            this.warnings.setNextWarning(new CtreeSQLWarning(26076));
        } else {
            this.warnings = new CtreeSQLWarning(26076);
        }
    }

    public void setArray(int n, Array array) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.setDate(n, date);
        if (this.warnings != null) {
            this.warnings.setNextWarning(new CtreeSQLWarning(26076));
        } else {
            this.warnings = new CtreeSQLWarning(26076);
        }
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.setTimestamp(n, timestamp);
        if (this.warnings != null) {
            this.warnings.setNextWarning(new CtreeSQLWarning(26076));
        } else {
            this.warnings = new CtreeSQLWarning(26076);
        }
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        Object object;
        if (--n < 0) {
            throw new CtreeSQLException(26049);
        }
        if (blob == null) {
            throw new CtreeSQLException(26091);
        }
        if (!this.paramDA.isDescribeParamCalled) {
            this.paramDA.setSqlTypes(n, (short)22);
            object = new Object();
            this.paramDA.setHostTypes(n, object, JDBCType.BLOB);
        }
        if ((object = this.paramDA.getSqlType(n)) != JDBCType.BLOB) {
            throw new CtreeSQLException(26091);
        }
        this.setBinaryStream(n + 1, blob.getBinaryStream(), (int)blob.length());
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        this.setNull(n, n2);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        ResultSet resultSet = this.getResultSet();
        if (resultSet != null) {
            return resultSet.getMetaData();
        }
        return null;
    }

    public void setRef(int n, Ref ref) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    public void addBatch() throws SQLException {
        if (!this.isBatchActivated) {
            short s = this.paramDA.getNColumns();
            short s2 = this.paramDA.getNRows();
            if (s2 < this.batchIncrement) {
                s2 = (short)this.batchIncrement;
            }
            this.paramDA.resize((short)(s + 1), s2);
            this.resetBoundFlags(true);
            this.isBatchActivated = true;
            this.paramDA.setOutFlag(s);
            this.paramDA.setType(s, JDBCType.INTEGER);
            this.setBoundFlag(s);
        }
        if (!this.gotAllBoundFlags()) {
            this.valueNotBound = true;
        }
        ++this.rowIndex;
        if (this.rowIndex == this.paramDA.getNRows()) {
            this.paramDA.setNRows((short)(this.rowIndex + this.batchIncrement));
        }
    }

    public int[] executeBatch() throws SQLException {
        this.checkConnection();
        if (this.rowIndex == 0) {
            int[] nArray = new int[]{};
            return nArray;
        }
        if (this.valueNotBound) {
            throw new CtreeSQLException(26086);
        }
        this.paramDA.setArraySize(this.rowIndex - 1);
        this.paramDA.setNRows((short)this.rowIndex);
        this.CtreeGetConnection().executeBatch(this.getStatementID(), this.paramDA, this.m_prepstsqlca);
        this.clearBatch();
        return this.CtreeGetConnection().getRowCounts(this.getStatementID());
    }

    public void clearBatch() throws SQLException {
        this.rowIndex = 0;
        if (this.isBatchActivated) {
            this.paramDA.setNColumns((short)(this.paramDA.getNColumns() - 1));
            this.isBatchActivated = false;
        }
    }

    public void setClob(int n, Clob clob) throws SQLException {
        Object object;
        if (--n < 0) {
            throw new CtreeSQLException(26049);
        }
        if (clob == null) {
            throw new CtreeSQLException(26091);
        }
        if (!this.paramDA.isDescribeParamCalled) {
            this.paramDA.setSqlTypes(n, (short)23);
            object = new Object();
            this.paramDA.setHostTypes(n, object, JDBCType.CLOB);
        }
        if ((object = this.paramDA.getSqlType(n)) != JDBCType.CLOB) {
            throw new CtreeSQLException(26091);
        }
        this.setAsciiStream(n + 1, clob.getAsciiStream(), (int)clob.length());
    }

    public void setURL(int n, URL uRL) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        if (!this.gotAllBoundFlags()) {
            this.CtreeGetConnection().connectionID.DescribeParam(this.getStatementID(), this.paramDA, this.m_prepstsqlca);
        }
        return new CtreeParameterMetaData(this.paramDA);
    }
}

