/*
 * Decompiled with CFR 0.152.
 */
package ctree.jdbc;

import ctree.jdbc.CtreeBlob;
import ctree.jdbc.CtreeCA;
import ctree.jdbc.CtreeClob;
import ctree.jdbc.CtreeConnection;
import ctree.jdbc.CtreeDA;
import ctree.jdbc.CtreeData;
import ctree.jdbc.CtreeError;
import ctree.jdbc.CtreeInt;
import ctree.jdbc.CtreeJDBCObject;
import ctree.jdbc.CtreeLongDataInputStream;
import ctree.jdbc.CtreeResultSetMetaData;
import ctree.jdbc.CtreeSQLException;
import ctree.jdbc.CtreeSQLWarning;
import ctree.jdbc.CtreeStatement;
import ctree.jdbc.CtreeUnicodeInputStream;
import ctree.jdbc.CursorT;
import ctree.jdbc.StatementUid;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CtreeResultSet
extends CtreeJDBCObject
implements ResultSet,
CtreeError {
    private static final PrintStream o = System.out;
    public static int DH_FD_FETCH_NEXT = 4;
    public static int DH_FD_FETCH_FIRST = 8;
    public static int DH_FD_FETCH_LAST = 16;
    public static int DH_FD_FETCH_PRIOR = 32;
    public static int DH_FD_FETCH_ABSOLUTE = 64;
    public static int DH_FD_FETCH_RELATIVE = 128;
    private CtreeDA resultDA;
    private CtreeResultSetMetaData metaData;
    private CtreeStatement statement;
    private StatementUid stmtID;
    private SQLWarning warnings = null;
    private boolean afterLastRow;
    private int currentRowIndex = -1;
    private int currentColumnIndex = -1;
    private boolean lastNull;
    private int current_row_no;
    private int last_row_no;
    private int rowsFetched = 0;
    private boolean isClosed;
    private boolean Is_MaxRows_are_zero = true;
    private long Maxrows_to_be_fetched;
    boolean isEmpty = false;
    private CtreeCA m_ressqlca;
    boolean found = true;
    private boolean isResultSetOpen;

    void setSchemaValue(String string) throws SQLException {
        if (string == "") {
            this.isEmpty = true;
        }
    }

    void setSchemaValue(String string, String string2) throws SQLException {
        if (string == "" || string2 == "") {
            this.isEmpty = true;
        }
    }

    protected CtreeResultSet() {
        this.current_row_no = 0;
        this.lastNull = true;
        this.statement = null;
        this.afterLastRow = false;
        this.isEmpty = true;
        this.isResultSetOpen = true;
        this.isClosed = false;
    }

    protected CtreeResultSet(CtreeStatement ctreeStatement) throws SQLException {
        this.afterLastRow = false;
        this.current_row_no = 0;
        this.lastNull = true;
        this.statement = ctreeStatement;
        if (this.statement == null) {
            throw new CtreeSQLException(26038);
        }
        this.m_ressqlca = new CtreeCA();
        this.Maxrows_to_be_fetched = ctreeStatement.getLargeMaxRows();
        if (this.Maxrows_to_be_fetched != 0L) {
            this.Is_MaxRows_are_zero = false;
        }
        this.resultDA = new CtreeDA(10, 1, this.statement.charSize(), this.statement.UnicodeCompatibility(), this.statement.getCharset(), ctreeStatement.getMaxFieldSize());
        this.isResultSetOpen = true;
        this.isClosed = false;
    }

    protected CtreeResultSet(CtreeResultSet ctreeResultSet) {
        this.current_row_no = 0;
        this.afterLastRow = false;
        this.lastNull = true;
        this.isResultSetOpen = true;
        this.lastNull = ctreeResultSet.lastNull;
        this.statement = ctreeResultSet.statement;
        this.resultDA = ctreeResultSet.resultDA;
        this.m_ressqlca = ctreeResultSet.m_ressqlca;
        this.metaData = ctreeResultSet.metaData;
        this.Maxrows_to_be_fetched = ctreeResultSet.Maxrows_to_be_fetched;
        this.Is_MaxRows_are_zero = ctreeResultSet.Is_MaxRows_are_zero;
        this.stmtID = ctreeResultSet.stmtID;
        this.found = ctreeResultSet.found;
        ctreeResultSet.statement = null;
        ctreeResultSet.resultDA = null;
        ctreeResultSet.m_ressqlca = null;
        ctreeResultSet.Is_MaxRows_are_zero = true;
        ctreeResultSet.stmtID = null;
        ctreeResultSet.found = true;
        this.m_ressqlca.setErrorCode(0);
        this.isClosed = false;
    }

    protected void finalize() {
        this.statement = null;
        if (this.resultDA != null) {
            this.resultDA.close();
            this.resultDA = null;
        }
        this.metaData = null;
    }

    private void checkConnection() throws SQLException {
        if (this.statement == null) {
            throw new CtreeSQLException(26002);
        }
    }

    private void checkResultDA() throws SQLException {
        if (this.isClosed) {
            throw new CtreeSQLException(26046);
        }
        if (this.resultDA == null || !this.isResultSetOpen) {
            throw new CtreeSQLException(26033);
        }
    }

    public void initResultSet() throws SQLException {
    }

    public CtreeDA getOutputDA() throws SQLException {
        if (this.resultDA == null) {
            this.resultDA = new CtreeDA(10, 1, this.charSize(), this.UnicodeCompatibility(), this.statement.getCharset(), this.statement.getMaxFieldSize());
        }
        return this.resultDA;
    }

    private int charSize() {
        return this.statement.charSize();
    }

    protected boolean getRow(int n, int n2) throws SQLException {
        if (!this.isResultSetOpen) {
            if (CtreeResultSet.traceOn()) {
                CtreeResultSet.trace("@CtreeResultSet getRow:  result set not open");
            }
            if (this.isClosed) {
                throw new CtreeSQLException(26046);
            }
            return false;
        }
        if (this.isEmpty) {
            if (CtreeResultSet.traceOn()) {
                CtreeResultSet.trace("@CtreeResultSet getRow:  result set empty");
            }
            if (this.statement != null && this.statement.getConnection().getAutoCommit()) {
                if (CtreeResultSet.traceOn()) {
                    CtreeResultSet.trace("@CtreeResultSet closing result set 1");
                }
                this.isResultSetOpen = false;
            }
            return false;
        }
        this.checkConnection();
        this.checkResultDA();
        CursorT cursorT = this.statement.CtreeGetConnection().getCursor(this.stmtID);
        cursorT.setOperation(n);
        cursorT.setPosition(n2);
        if (CtreeResultSet.traceOn()) {
            CtreeResultSet.trace("@CtreeResultSet getRow: operation = " + n + ", position = " + n2);
        }
        CtreeInt ctreeInt = new CtreeInt(n2);
        if (this.Is_MaxRows_are_zero || this.Maxrows_to_be_fetched-- != 0L) {
            this.getWarnings();
            if (n != DH_FD_FETCH_NEXT || this.currentRowIndex == -1 || this.currentRowIndex == this.resultDA.getNRows() - 1) {
                if (CtreeResultSet.traceOn()) {
                    CtreeResultSet.trace("@CtreeResultSet getRow 1:  result set doing fetch, operation = " + n + ", position = " + n2);
                    CtreeResultSet.trace("@CtreeResultSet getRow 1:  result set doing fetch, currentRowIndex = " + this.currentRowIndex);
                    CtreeResultSet.trace("@CtreeResultSet getRow 1:  resultDA.getNRows() = " + this.resultDA.getNRows());
                    CtreeResultSet.trace("@CtreeResultSet getRow 1:  curCursor.getPosition() = " + cursorT.getPosition());
                }
                if (this.m_ressqlca.Sqlcode != 0 && this.m_ressqlca.Sqlcode != 100) {
                    if (CtreeResultSet.traceOn()) {
                        CtreeResultSet.trace("@CtreeResultSet getRow:  previous fetch had error: " + this.m_ressqlca.Sqlcode);
                    }
                    CtreeSQLException ctreeSQLException = new CtreeSQLException(this.m_ressqlca);
                    if (this.statement.getConnection().getAutoCommit()) {
                        try {
                            ((CtreeConnection)this.statement.getConnection()).connectionID.Rollback(this.m_ressqlca);
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    throw ctreeSQLException;
                }
                if (this.m_ressqlca.Sqlcode == 100 && !this.statement.isScrollable()) {
                    if (CtreeResultSet.traceOn()) {
                        CtreeResultSet.trace("@CtreeResultSet getRow: FETCH NEXT, previous code SQL_NOT_FOUND");
                    }
                    if (!this.statement.isScrollable()) {
                        if (CtreeResultSet.traceOn()) {
                            CtreeResultSet.trace("setting currentRowIndex to -1");
                        }
                        this.current_row_no = -1;
                        this.currentRowIndex = -1;
                        if (this.statement.getConnection().getAutoCommit()) {
                            if (CtreeResultSet.traceOn()) {
                                CtreeResultSet.trace("@CtreeResultSet closing result set 2");
                            }
                            this.isResultSetOpen = false;
                        }
                    }
                    if (CtreeResultSet.traceOn()) {
                        CtreeResultSet.trace("@CtreeResultSet returning from getRow 1:  current_row_no = " + this.current_row_no);
                    }
                    return false;
                }
                if (CtreeResultSet.traceOn()) {
                    CtreeResultSet.trace("@CtreeResultSet getRow:  before call fetch");
                    CtreeResultSet.trace("resultDA = " + this.resultDA);
                    CtreeResultSet.trace("resultDA.nVars = " + this.resultDA.getNVars());
                    CtreeResultSet.trace("resultDA.nRows = " + this.resultDA.getNRows());
                }
                if (this.statement.isScrollable() && this.resultDA.getNRows() == 0) {
                    this.resultDA.setNRows((short)1);
                }
                this.found = this.statement.fetch(this.stmtID, this.resultDA, this.m_ressqlca);
                if (CtreeResultSet.traceOn()) {
                    CtreeResultSet.trace("@CtreeResultSet getRow:  after call fetch, found = " + this.found);
                    CtreeResultSet.trace("resultDA = " + this.resultDA);
                    CtreeResultSet.trace("resultDA.nVars = " + this.resultDA.getNVars());
                    CtreeResultSet.trace("resultDA.nRows = " + this.resultDA.getNRows());
                    CtreeResultSet.trace("setting currentRowIndex to -1");
                }
                this.currentRowIndex = -1;
                if (!this.found) {
                    if (!this.statement.isScrollable()) {
                        this.current_row_no = -1;
                        if (this.statement.getConnection().getAutoCommit()) {
                            if (CtreeResultSet.traceOn()) {
                                CtreeResultSet.trace("@CtreeResultSet closing result set 3");
                            }
                            this.isResultSetOpen = false;
                        }
                    } else {
                        this.current_row_no = cursorT.getPosition();
                    }
                    if (CtreeResultSet.traceOn()) {
                        CtreeResultSet.trace("@CtreeResultSet returning from getRow 2:  current_row_no = " + this.current_row_no);
                    }
                    return false;
                }
            } else if (CtreeResultSet.traceOn()) {
                CtreeResultSet.trace("@CtreeResultSet getRow 2:  result set doing fetch, operation = " + n + ", position = " + n2);
                CtreeResultSet.trace("@CtreeResultSet getRow 2:  result set doing fetch, currentRowIndex = " + this.currentRowIndex);
                CtreeResultSet.trace("@CtreeResultSet getRow 2:  resultDA.getNRows() = " + this.resultDA.getNRows());
                CtreeResultSet.trace("@CtreeResultSet getRow 2:  curCursor.getPosition() = " + cursorT.getPosition());
            }
            if (this.currentRowIndex < this.resultDA.getNRows() - 1) {
                ++this.rowsFetched;
                this.current_row_no = this.statement.isScrollable() ? cursorT.getPosition() : ++this.current_row_no;
                ++this.currentRowIndex;
                if (CtreeResultSet.traceOn()) {
                    CtreeResultSet.trace("@CtreeResultSet returning from getRow 4:  current_row_no = " + this.current_row_no);
                }
                return true;
            }
            if (CtreeResultSet.traceOn()) {
                CtreeResultSet.trace("@CtreeResultSet returning from getRow 5:  current_row_no = " + this.current_row_no);
            }
            return false;
        }
        if (CtreeResultSet.traceOn()) {
            CtreeResultSet.trace("@CtreeResultSet getRow:  result set max row bypass");
        }
        if (this.statement.getConnection().getAutoCommit()) {
            if (CtreeResultSet.traceOn()) {
                CtreeResultSet.trace("@CtreeResultSet closing result set 4");
            }
            this.isResultSetOpen = false;
        }
        if (CtreeResultSet.traceOn()) {
            CtreeResultSet.trace("@CtreeResultSet returning from getRow 6:  current_row_no = " + this.current_row_no);
        }
        return false;
    }

    @Override
    public boolean next() throws SQLException {
        boolean bl;
        if (CtreeResultSet.traceOn()) {
            CtreeResultSet.trace("@CtreeResultSet next");
        }
        this.setAfterLastRow(!(bl = this.getRow(DH_FD_FETCH_NEXT, 0)));
        return bl;
    }

    @Override
    public void close() throws SQLException {
        if (CtreeResultSet.traceOn()) {
            CtreeResultSet.trace("@CtreeResultSet close ");
        }
        if (this.stmtID != null) {
            this.statement.closeCursor(this.stmtID);
        }
        this.removeWarnings();
        this.isClosed = true;
        this.isResultSetOpen = false;
    }

    @Override
    public boolean wasNull() throws SQLException {
        if (this.currentColumnIndex < 0) {
            throw new CtreeSQLException(26049);
        }
        short s = this.resultDA.getHostType(this.currentColumnIndex);
        if (s == 14 || s == 23 || s == 24) {
            String string = new CtreeLongDataInputStream(this, this.resultDA.getString(this.currentColumnIndex, this.currentRowIndex), s, true).getString();
            return string == null;
        }
        if (s == 15 || s == 22) {
            String string = new CtreeLongDataInputStream(this, this.resultDA.getString(this.currentColumnIndex, this.currentRowIndex), s, true).getString();
            return string == null;
        }
        return this.lastNull;
    }

    @Override
    public String getString(int n) throws SQLException {
        if (this.currentRowIndex < 0) {
            throw new CtreeSQLException(26048);
        }
        this.checkResultDA();
        this.currentColumnIndex = n - 1;
        this.lastNull = this.resultDA.wasNull(this.currentColumnIndex, this.currentRowIndex);
        if (this.lastNull) {
            return null;
        }
        short s = this.resultDA.getHostType(this.currentColumnIndex);
        if (s == 15 || s == 14 || s == 22 || s == 23 || s == 24) {
            return new CtreeLongDataInputStream(this, this.resultDA.getString(this.currentColumnIndex, this.currentRowIndex), s, true).getString();
        }
        return this.resultDA.getString(this.currentColumnIndex, this.currentRowIndex);
    }

    @Override
    public boolean getBoolean(int n) throws SQLException {
        this.checkResultDA();
        this.currentColumnIndex = n - 1;
        this.lastNull = this.resultDA.wasNull(this.currentColumnIndex, this.currentRowIndex);
        if (this.lastNull) {
            return false;
        }
        return this.resultDA.getBooleanValue(this.currentColumnIndex, this.currentRowIndex);
    }

    @Override
    public byte getByte(int n) throws SQLException {
        this.checkResultDA();
        this.currentColumnIndex = n - 1;
        this.lastNull = this.resultDA.wasNull(this.currentColumnIndex, this.currentRowIndex);
        if (this.lastNull) {
            return 0;
        }
        return this.resultDA.getByteValue(this.currentColumnIndex, this.currentRowIndex);
    }

    @Override
    public short getShort(int n) throws SQLException {
        this.checkResultDA();
        this.currentColumnIndex = n - 1;
        this.lastNull = this.resultDA.wasNull(this.currentColumnIndex, this.currentRowIndex);
        if (this.lastNull) {
            return 0;
        }
        return this.resultDA.getShortValue(this.currentColumnIndex, this.currentRowIndex);
    }

    @Override
    public int getInt(int n) throws SQLException {
        this.checkResultDA();
        this.currentColumnIndex = n - 1;
        this.lastNull = this.resultDA.wasNull(this.currentColumnIndex, this.currentRowIndex);
        if (this.lastNull) {
            return 0;
        }
        return this.resultDA.getIntegerValue(this.currentColumnIndex, this.currentRowIndex);
    }

    @Override
    public long getLong(int n) throws SQLException {
        this.checkResultDA();
        this.currentColumnIndex = n - 1;
        this.lastNull = this.resultDA.wasNull(this.currentColumnIndex, this.currentRowIndex);
        if (this.lastNull) {
            return 0L;
        }
        return this.resultDA.getLongValue(this.currentColumnIndex, this.currentRowIndex);
    }

    @Override
    public float getFloat(int n) throws SQLException {
        this.checkResultDA();
        this.currentColumnIndex = n - 1;
        this.lastNull = this.resultDA.wasNull(this.currentColumnIndex, this.currentRowIndex);
        if (this.lastNull) {
            return 0.0f;
        }
        return this.resultDA.getFloatValue(this.currentColumnIndex, this.currentRowIndex);
    }

    @Override
    public double getDouble(int n) throws SQLException {
        this.checkResultDA();
        this.currentColumnIndex = n - 1;
        this.lastNull = this.resultDA.wasNull(this.currentColumnIndex, this.currentRowIndex);
        if (this.lastNull) {
            return 0.0;
        }
        return this.resultDA.getDoubleValue(this.currentColumnIndex, this.currentRowIndex);
    }

    @Override
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        this.checkResultDA();
        this.currentColumnIndex = n - 1;
        this.lastNull = this.resultDA.wasNull(this.currentColumnIndex, this.currentRowIndex);
        if (this.lastNull) {
            return null;
        }
        return this.resultDA.getBigDecimal(this.currentColumnIndex, this.currentRowIndex, n2);
    }

    @Override
    public byte[] getBytes(int n) throws SQLException {
        this.checkResultDA();
        this.currentColumnIndex = n - 1;
        this.lastNull = this.resultDA.wasNull(this.currentColumnIndex, this.currentRowIndex);
        if (this.lastNull) {
            return null;
        }
        short s = this.resultDA.getHostType(this.currentColumnIndex);
        if (s == 15 || s == 14 || s == 22 || s == 23 || s == 24) {
            return new CtreeLongDataInputStream(this, this.resultDA.getString(this.currentColumnIndex, this.currentRowIndex), s, false).getBytes();
        }
        return this.resultDA.getBytes(this.currentColumnIndex, this.currentRowIndex);
    }

    byte[] getBytes(int n, int n2, int n3) throws SQLException {
        this.checkResultDA();
        this.currentColumnIndex = n - 1;
        this.lastNull = this.resultDA.wasNull(this.currentColumnIndex, this.currentRowIndex);
        if (this.lastNull) {
            return null;
        }
        short s = this.resultDA.getHostType(this.currentColumnIndex);
        if (s == 22 || s == 15) {
            return new CtreeLongDataInputStream(this, this.resultDA.getString(this.currentColumnIndex, this.currentRowIndex), s, false).getBytes(n2, n3);
        }
        throw new CtreeSQLException("in getBytes : only supported for BLOB,CLOB,LVC & LVB host types.", 26055);
    }

    @Override
    public Date getDate(int n) throws SQLException {
        this.checkResultDA();
        this.currentColumnIndex = n - 1;
        this.lastNull = this.resultDA.wasNull(this.currentColumnIndex, this.currentRowIndex);
        if (this.lastNull) {
            return null;
        }
        return this.resultDA.getDate(this.currentColumnIndex, this.currentRowIndex);
    }

    @Override
    public Time getTime(int n) throws SQLException {
        this.checkResultDA();
        this.currentColumnIndex = n - 1;
        this.lastNull = this.resultDA.wasNull(this.currentColumnIndex, this.currentRowIndex);
        if (this.lastNull) {
            return null;
        }
        return this.resultDA.getTime(this.currentColumnIndex, this.currentRowIndex);
    }

    @Override
    public Timestamp getTimestamp(int n) throws SQLException {
        this.checkResultDA();
        this.currentColumnIndex = n - 1;
        this.lastNull = this.resultDA.wasNull(this.currentColumnIndex, this.currentRowIndex);
        if (this.lastNull) {
            return null;
        }
        return this.resultDA.getTimestamp(this.currentColumnIndex, this.currentRowIndex);
    }

    @Override
    public InputStream getAsciiStream(int n) throws SQLException {
        this.checkResultDA();
        this.currentColumnIndex = n - 1;
        this.lastNull = this.resultDA.wasNull(this.currentColumnIndex, this.currentRowIndex);
        if (this.lastNull) {
            return null;
        }
        short s = this.resultDA.getHostType(this.currentColumnIndex);
        if (s == 15 || s == 22) {
            String string = new CtreeLongDataInputStream(this, this.resultDA.getString(this.currentColumnIndex, this.currentRowIndex), s, true).getString();
            if (string == null) {
                return null;
            }
            return new CtreeLongDataInputStream(this, this.resultDA.getString(this.currentColumnIndex, this.currentRowIndex), s, true);
        }
        if (s == 14 || s == 23 || s == 24) {
            String string = new CtreeLongDataInputStream(this, this.resultDA.getString(this.currentColumnIndex, this.currentRowIndex), s, true).getString();
            if (string == null) {
                return null;
            }
            return new CtreeLongDataInputStream(this, this.resultDA.getString(this.currentColumnIndex, this.currentRowIndex), s, true);
        }
        return this.resultDA.getAsciiStream(this.currentColumnIndex, this.currentRowIndex);
    }

    @Override
    public InputStream getUnicodeStream(int n) throws SQLException {
        this.checkResultDA();
        this.currentColumnIndex = n - 1;
        this.lastNull = this.resultDA.wasNull(this.currentColumnIndex, this.currentRowIndex);
        if (this.lastNull) {
            return null;
        }
        short s = this.resultDA.getHostType(this.currentColumnIndex);
        if (s == 15 || s == 22) {
            String string = new CtreeLongDataInputStream(this, this.resultDA.getString(this.currentColumnIndex, this.currentRowIndex), s, true).getString();
            if (string == null) {
                return null;
            }
            return new CtreeUnicodeInputStream(new CtreeLongDataInputStream(this, this.resultDA.getString(this.currentColumnIndex, this.currentRowIndex), s, false));
        }
        if (s == 14 || s == 23 || s == 24) {
            String string = new CtreeLongDataInputStream(this, this.resultDA.getString(this.currentColumnIndex, this.currentRowIndex), s, true).getString();
            if (string == null) {
                return null;
            }
            return new CtreeUnicodeInputStream(new CtreeLongDataInputStream(this, this.resultDA.getString(this.currentColumnIndex, this.currentRowIndex), s, false));
        }
        return this.resultDA.getUnicodeStream(this.currentColumnIndex, this.currentRowIndex);
    }

    @Override
    public InputStream getBinaryStream(int n) throws SQLException {
        this.checkResultDA();
        this.currentColumnIndex = n - 1;
        this.lastNull = this.resultDA.wasNull(this.currentColumnIndex, this.currentRowIndex);
        if (this.lastNull) {
            return null;
        }
        short s = this.resultDA.getHostType(this.currentColumnIndex);
        if (s == 15 || s == 22) {
            String string = new CtreeLongDataInputStream(this, this.resultDA.getString(this.currentColumnIndex, this.currentRowIndex), s, true).getString();
            if (string == null) {
                return null;
            }
            return new CtreeLongDataInputStream(this, this.resultDA.getString(this.currentColumnIndex, this.currentRowIndex), s, false);
        }
        if (s == 14 || s == 23 || s == 24) {
            String string = new CtreeLongDataInputStream(this, this.resultDA.getString(this.currentColumnIndex, this.currentRowIndex), s, true).getString();
            if (string == null) {
                return null;
            }
            return new CtreeLongDataInputStream(this, this.resultDA.getString(this.currentColumnIndex, this.currentRowIndex), s, false);
        }
        return this.resultDA.getBinaryStream(this.currentColumnIndex, this.currentRowIndex);
    }

    @Override
    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    @Override
    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    @Override
    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    @Override
    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    @Override
    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    @Override
    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    @Override
    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    @Override
    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    @Override
    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    @Override
    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    @Override
    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    @Override
    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    @Override
    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    @Override
    public Object getObject(int n) throws SQLException {
        this.checkResultDA();
        this.currentColumnIndex = n - 1;
        this.lastNull = this.resultDA.wasNull(this.currentColumnIndex, this.currentRowIndex);
        if (this.lastNull) {
            return null;
        }
        short s = this.resultDA.getHostType(this.currentColumnIndex);
        switch (s) {
            case 15: {
                return new CtreeLongDataInputStream(this, this.resultDA.getString(this.currentColumnIndex, this.currentRowIndex), s, false).getBytes();
            }
            case 14: 
            case 24: {
                return new CtreeLongDataInputStream(this, this.resultDA.getString(this.currentColumnIndex, this.currentRowIndex), s, true).getString();
            }
            case 22: {
                return this.getBlob(n);
            }
            case 23: {
                return this.getClob(n);
            }
        }
        return this.resultDA.getObject(this.currentColumnIndex, this.currentRowIndex);
    }

    public void setMaxRows(int n) {
        this.Maxrows_to_be_fetched = n;
        if (this.Maxrows_to_be_fetched != 0L) {
            this.Is_MaxRows_are_zero = false;
        }
    }

    public void setLargeMaxRows(long l) {
        this.Maxrows_to_be_fetched = l;
        if (this.Maxrows_to_be_fetched != 0L) {
            this.Is_MaxRows_are_zero = false;
        }
    }

    public void setMaxFieldSize(int n) {
        this.resultDA.setMaxFieldSize(n);
    }

    public void resizeResultDA() {
        this.resultDA.resize(this.resultDA.getNColumns(), this.resultDA.getArraySize());
    }

    @Override
    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    @Override
    public <T> T getObject(int n, Class<T> clazz) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public <T> T getObject(String string, Class<T> clazz) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.isClosed) {
            throw new CtreeSQLException(26046);
        }
        CtreeSQLWarning ctreeSQLWarning = null;
        String string = this.m_ressqlca.getSqlwarn();
        if (string != null) {
            if (string.charAt(1) == 'W') {
                if (ctreeSQLWarning == null) {
                    ctreeSQLWarning = new CtreeSQLWarning(26070);
                } else {
                    ctreeSQLWarning.setNextWarning(new CtreeSQLWarning(26070));
                }
            }
            if (string.charAt(2) == 'W') {
                if (ctreeSQLWarning == null) {
                    ctreeSQLWarning = new CtreeSQLWarning(26071);
                } else {
                    ctreeSQLWarning.setNextWarning(new CtreeSQLWarning(26071));
                }
            }
            if (string.charAt(3) == 'W') {
                if (ctreeSQLWarning == null) {
                    ctreeSQLWarning = new CtreeSQLWarning(26072);
                } else {
                    ctreeSQLWarning.setNextWarning(new CtreeSQLWarning(26072));
                }
            }
            if (string.charAt(4) == 'W') {
                if (ctreeSQLWarning == null) {
                    ctreeSQLWarning = new CtreeSQLWarning(26073);
                } else {
                    ctreeSQLWarning.setNextWarning(new CtreeSQLWarning(26073));
                }
            }
            if (string.charAt(6) == 'W') {
                if (ctreeSQLWarning == null) {
                    ctreeSQLWarning = new CtreeSQLWarning(26074);
                } else {
                    ctreeSQLWarning.setNextWarning(new CtreeSQLWarning(26074));
                }
            }
        }
        if (this.warnings != null) {
            for (SQLWarning sQLWarning = this.warnings; sQLWarning != null; sQLWarning = sQLWarning.getNextWarning()) {
                if (ctreeSQLWarning == null) {
                    ctreeSQLWarning = new CtreeSQLWarning(sQLWarning.getErrorCode());
                    continue;
                }
                ctreeSQLWarning.setNextWarning(new CtreeSQLWarning(sQLWarning.getErrorCode()));
            }
        }
        return ctreeSQLWarning;
    }

    @Override
    public void clearWarnings() throws SQLException {
        if (this.isClosed) {
            throw new CtreeSQLException(26046);
        }
        this.removeWarnings();
    }

    private void removeWarnings() throws SQLException {
        while (this.warnings != null) {
            SQLWarning sQLWarning = this.warnings.getNextWarning();
            this.warnings.setNextWarning(null);
            this.warnings = sQLWarning;
        }
    }

    @Override
    public String getCursorName() throws SQLException {
        if (this.isClosed) {
            throw new CtreeSQLException(26046);
        }
        return this.statement.CtreeGetConnection().getCursorName(this.stmtID);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkResultDA();
        if (this.metaData == null) {
            this.metaData = new CtreeResultSetMetaData(this.resultDA);
        }
        return this.metaData;
    }

    @Override
    public int findColumn(String string) throws SQLException {
        if (string == null) {
            throw new CtreeSQLException(26055);
        }
        if (this.metaData == null) {
            this.metaData = new CtreeResultSetMetaData(this.resultDA);
        }
        return this.metaData.getColumnIndex(string) + 1;
    }

    public boolean getData(CtreeData ctreeData) throws SQLException {
        this.checkConnection();
        boolean bl = this.statement.getData(ctreeData);
        return bl;
    }

    public void setStatementID(StatementUid statementUid) {
        this.stmtID = statementUid;
    }

    public StatementUid getStatementID() {
        return this.stmtID;
    }

    void print() throws SQLException {
        if (this.resultDA != null) {
            this.resultDA.print("CtreeResultSet PRINT");
        } else {
            o.println("CtreeResultSet has nodata");
        }
    }

    @Override
    public void beforeFirst() throws SQLException {
        if (CtreeResultSet.traceOn()) {
            CtreeResultSet.trace("@CtreeResultSet beforeFirst()");
        }
        if (this.statement.getResultSetType() == 1003) {
            throw new CtreeSQLException(26065);
        }
        this.getRow(DH_FD_FETCH_ABSOLUTE, 1);
        this.getRow(DH_FD_FETCH_PRIOR, 0);
        this.afterLastRow = false;
    }

    @Override
    public void afterLast() throws SQLException {
        if (CtreeResultSet.traceOn()) {
            CtreeResultSet.trace("@CtreeResultSet afterLast()");
        }
        if (this.statement.getResultSetType() == 1003) {
            throw new CtreeSQLException(26065);
        }
        this.getRow(DH_FD_FETCH_LAST, 0);
        this.getRow(DH_FD_FETCH_NEXT, 0);
        this.setAfterLastRow(true);
        if (CtreeResultSet.traceOn()) {
            CtreeResultSet.trace("@CtreeResultSet after AfterLast:  current_row_no = " + this.current_row_no);
        }
    }

    @Override
    public boolean first() throws SQLException {
        if (CtreeResultSet.traceOn()) {
            CtreeResultSet.trace("@CtreeResultSet first()");
        }
        if (this.statement.getResultSetType() == 1003) {
            throw new CtreeSQLException(26065);
        }
        this.afterLastRow = false;
        return this.getRow(DH_FD_FETCH_ABSOLUTE, 1);
    }

    @Override
    public boolean last() throws SQLException {
        if (CtreeResultSet.traceOn()) {
            CtreeResultSet.trace("@CtreeResultSet last()");
        }
        if (this.statement.getResultSetType() == 1003) {
            throw new CtreeSQLException(26065);
        }
        this.afterLastRow = false;
        return this.getRow(DH_FD_FETCH_LAST, 0);
    }

    @Override
    public int getRow() throws SQLException {
        if (this.isClosed) {
            throw new CtreeSQLException(26046);
        }
        if (this.current_row_no >= 0) {
            if (this.statement.isScrollable() && this.m_ressqlca != null && this.m_ressqlca.Sqlcode == 100) {
                return 0;
            }
            return this.current_row_no;
        }
        return 0;
    }

    @Override
    public boolean absolute(int n) throws SQLException {
        boolean bl;
        if (this.statement.getResultSetType() == 1003) {
            throw new CtreeSQLException(26065);
        }
        if (n < 0) {
            n = this.last_row_no + 1 + n;
        }
        if (n <= 0) {
            this.afterLastRow = false;
            this.current_row_no = -1;
            bl = false;
        } else {
            bl = this.getRow(DH_FD_FETCH_ABSOLUTE, n);
            if (n < 0) {
                this.setAfterLastRow(false);
                if (!bl) {
                    this.current_row_no = -1;
                }
            } else {
                this.setAfterLastRow(!bl);
            }
        }
        return bl;
    }

    @Override
    public boolean relative(int n) throws SQLException {
        if (this.statement.getResultSetType() == 1003) {
            throw new CtreeSQLException(26065);
        }
        boolean bl = this.getRow(DH_FD_FETCH_RELATIVE, n);
        if (n < 0) {
            this.setAfterLastRow(false);
            if (!bl) {
                this.current_row_no = -1;
            }
        } else {
            this.setAfterLastRow(!bl);
        }
        return bl;
    }

    @Override
    public boolean previous() throws SQLException {
        if (CtreeResultSet.traceOn()) {
            CtreeResultSet.trace("@CtreeResultSet previous()");
        }
        if (this.statement.getResultSetType() == 1003) {
            throw new CtreeSQLException(26065);
        }
        this.afterLastRow = false;
        return this.getRow(DH_FD_FETCH_PRIOR, 0);
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        if (CtreeResultSet.traceOn()) {
            CtreeResultSet.trace("@CtreeResultSet setFetchDirection()");
        }
        if (this.isClosed) {
            throw new CtreeSQLException(26046);
        }
        if (this.statement.getResultSetType() == 1003 && n != 1000) {
            throw new CtreeSQLException(26065);
        }
        if (this.warnings != null) {
            this.warnings.setNextWarning(new CtreeSQLWarning(26077));
        } else {
            this.warnings = new CtreeSQLWarning(26077);
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        if (this.isClosed) {
            throw new CtreeSQLException(26046);
        }
        if (this.warnings != null) {
            this.warnings.setNextWarning(new CtreeSQLWarning(26077));
        } else {
            this.warnings = new CtreeSQLWarning(26077);
        }
        return 1000;
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        if (this.isClosed) {
            throw new CtreeSQLException(26046);
        }
        if (this.warnings != null) {
            this.warnings.setNextWarning(new CtreeSQLWarning(26077));
        } else {
            this.warnings = new CtreeSQLWarning(26077);
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        if (this.isClosed) {
            throw new CtreeSQLException(26046);
        }
        if (this.warnings != null) {
            this.warnings.setNextWarning(new CtreeSQLWarning(26077));
        } else {
            this.warnings = new CtreeSQLWarning(26077);
        }
        return 0;
    }

    @Override
    public int getType() throws SQLException {
        if (this.isClosed) {
            throw new CtreeSQLException(26046);
        }
        if (CtreeResultSet.traceOn()) {
            CtreeResultSet.trace("@CtreeResultSet getType()");
        }
        return 1003;
    }

    @Override
    public int getConcurrency() throws SQLException {
        if (this.isClosed) {
            throw new CtreeSQLException(26046);
        }
        return 1007;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        if (this.isClosed) {
            throw new CtreeSQLException(26046);
        }
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        if (this.isClosed) {
            throw new CtreeSQLException(26046);
        }
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        if (this.isClosed) {
            throw new CtreeSQLException(26046);
        }
        return false;
    }

    @Override
    public void updateNull(int n) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public void updateBoolean(int n, boolean bl) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public void updateByte(int n, byte by) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public void updateShort(int n, short s) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public void updateInt(int n, int n2) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public void updateLong(int n, long l) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public void updateFloat(int n, float f) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public void updateDouble(int n, double d) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public void updateString(int n, String string) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public void updateBytes(int n, byte[] byArray) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public void updateDate(int n, Date date) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public void updateTime(int n, Time time) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public void updateNull(String string) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public void updateBoolean(String string, boolean bl) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public void updateByte(String string, byte by) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public void updateShort(String string, short s) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public void updateInt(String string, int n) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public void updateLong(String string, long l) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public void updateFloat(String string, float f) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public void updateDouble(String string, double d) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public void updateString(String string, String string2) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public void updateDate(String string, Date date) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public void updateTime(String string, Time time) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public void updateObject(int n, Object object, int n2) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public void updateObject(int n, Object object) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public void insertRow() throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public void updateRow() throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public Statement getStatement() throws SQLException {
        if (this.isClosed) {
            throw new CtreeSQLException(26046);
        }
        return this.statement;
    }

    public Object getObject(int n, Map map) throws SQLException {
        if (this.warnings != null) {
            this.warnings.setNextWarning(new CtreeSQLWarning(26075));
        } else {
            this.warnings = new CtreeSQLWarning(26075);
        }
        return this.getObject(n);
    }

    @Override
    public Ref getRef(int n) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public Blob getBlob(int n) throws SQLException {
        this.checkResultDA();
        this.currentColumnIndex = n - 1;
        short s = this.resultDA.getHostType(n - 1);
        if (s == 22 || s == 15) {
            CtreeBlob ctreeBlob = new CtreeBlob(this, n);
            return ctreeBlob;
        }
        throw new CtreeSQLException(26091);
    }

    @Override
    public Clob getClob(int n) throws SQLException {
        this.checkResultDA();
        this.currentColumnIndex = n - 1;
        short s = this.resultDA.getHostType(n - 1);
        if (s == 23 || s == 14 || s == 24) {
            CtreeClob ctreeClob = new CtreeClob(this, n);
            return ctreeClob;
        }
        throw new CtreeSQLException(26091);
    }

    @Override
    public Array getArray(int n) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    public Object getObject(String string, Map map) throws SQLException {
        if (this.warnings != null) {
            this.warnings.setNextWarning(new CtreeSQLWarning(26075));
        } else {
            this.warnings = new CtreeSQLWarning(26075);
        }
        return this.getObject(string);
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumn(string));
    }

    @Override
    public Array getArray(String string) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public Date getDate(int n, Calendar calendar) throws SQLException {
        if (this.warnings != null) {
            this.warnings.setNextWarning(new CtreeSQLWarning(26076));
        } else {
            this.warnings = new CtreeSQLWarning(26076);
        }
        return this.getDate(n);
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        if (this.warnings != null) {
            this.warnings.setNextWarning(new CtreeSQLWarning(26076));
        } else {
            this.warnings = new CtreeSQLWarning(26076);
        }
        return this.getDate(string);
    }

    @Override
    public Time getTime(int n, Calendar calendar) throws SQLException {
        if (this.warnings != null) {
            this.warnings.setNextWarning(new CtreeSQLWarning(26076));
        } else {
            this.warnings = new CtreeSQLWarning(26076);
        }
        return this.getTime(n);
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        if (this.warnings != null) {
            this.warnings.setNextWarning(new CtreeSQLWarning(26076));
        } else {
            this.warnings = new CtreeSQLWarning(26076);
        }
        return this.getTime(string);
    }

    @Override
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        if (this.warnings != null) {
            this.warnings.setNextWarning(new CtreeSQLWarning(26076));
        } else {
            this.warnings = new CtreeSQLWarning(26076);
        }
        return this.getTimestamp(n);
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        if (this.warnings != null) {
            this.warnings.setNextWarning(new CtreeSQLWarning(26076));
        } else {
            this.warnings = new CtreeSQLWarning(26076);
        }
        return this.getTimestamp(string);
    }

    @Override
    public boolean isLast() throws SQLException {
        if (this.isClosed) {
            throw new CtreeSQLException(26046);
        }
        if (this.statement.getResultSetType() == 1003) {
            throw new CtreeSQLException(26065);
        }
        return this.isEmpty ? false : this.current_row_no == this.last_row_no;
    }

    @Override
    public void updateObject(String string, Object object) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public void updateObject(String string, Object object, int n) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public boolean isFirst() throws SQLException {
        if (this.isClosed) {
            throw new CtreeSQLException(26046);
        }
        if (this.statement.getResultSetType() == 1003) {
            throw new CtreeSQLException(26065);
        }
        return this.current_row_no == 1;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        if (CtreeResultSet.traceOn()) {
            CtreeResultSet.trace("@CtreeResultSet isBeforeFirst:  current_row_no = " + this.current_row_no);
        }
        if (this.isClosed) {
            throw new CtreeSQLException(26046);
        }
        if (this.statement.getResultSetType() == 1003) {
            throw new CtreeSQLException(26065);
        }
        return this.current_row_no <= 0 && !this.afterLastRow && !this.isEmpty;
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        return this.getBigDecimal(n, -475);
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(string, -475);
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        if (CtreeResultSet.traceOn() && this.m_ressqlca != null) {
            CtreeResultSet.trace("@CtreeResultSet isAfterLast:  sqlcode = " + this.m_ressqlca.Sqlcode + ", current_row_no = " + this.current_row_no);
        }
        if (this.isClosed) {
            throw new CtreeSQLException(26046);
        }
        if (this.statement.getResultSetType() == 1003) {
            return this.current_row_no < 0 && this.rowsFetched > 0;
        }
        return this.afterLastRow;
    }

    @Override
    public Reader getCharacterStream(int n) throws SQLException {
        this.checkResultDA();
        this.currentColumnIndex = n - 1;
        this.lastNull = this.resultDA.wasNull(this.currentColumnIndex, this.currentRowIndex);
        short s = this.resultDA.getHostType(this.currentColumnIndex);
        if (s == 15 || s == 22) {
            String string = new CtreeLongDataInputStream(this, this.resultDA.getString(this.currentColumnIndex, this.currentRowIndex), s, true).getString();
            if (string == null) {
                return null;
            }
            return new InputStreamReader(new CtreeLongDataInputStream(this, this.resultDA.getString(this.currentColumnIndex, this.currentRowIndex), s, true));
        }
        if (s == 14 || s == 23 || s == 24) {
            String string = new CtreeLongDataInputStream(this, this.resultDA.getString(this.currentColumnIndex, this.currentRowIndex), s, true).getString();
            if (string == null) {
                return null;
            }
            return new InputStreamReader(new CtreeLongDataInputStream(this, this.resultDA.getString(this.currentColumnIndex, this.currentRowIndex), s, true));
        }
        Reader reader = this.resultDA.getCharacterStream(this.currentColumnIndex, this.currentRowIndex);
        return reader;
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    @Override
    public URL getURL(int n) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public URL getURL(String string) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public void updateRef(int n, Ref ref) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public void updateRef(String string, Ref ref) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public void updateBlob(int n, Blob blob) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public void updateBlob(String string, Blob blob) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public void updateClob(int n, Clob clob) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public void updateClob(String string, Clob clob) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public void updateArray(int n, Array array) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    @Override
    public void updateArray(String string, Array array) throws SQLException {
        throw new CtreeSQLException(26065);
    }

    int getLength(int n) throws SQLException {
        this.checkResultDA();
        this.currentColumnIndex = n - 1;
        this.lastNull = this.resultDA.wasNull(this.currentColumnIndex, this.currentRowIndex);
        if (this.lastNull) {
            return 0;
        }
        short s = this.resultDA.getHostType(this.currentColumnIndex);
        int n2 = 0;
        if (s == 22 || s == 23 || s == 15 || s == 14 || s == 24) {
            boolean bl = false;
            String string = this.resultDA.getString(this.currentColumnIndex, this.currentRowIndex);
            CtreeLongDataInputStream ctreeLongDataInputStream = new CtreeLongDataInputStream(this, string, s, bl);
            n2 = ctreeLongDataInputStream.getString().length();
            return n2;
        }
        throw new CtreeSQLException(26055);
    }

    String getString(int n, int n2, int n3) throws SQLException {
        this.checkResultDA();
        this.currentColumnIndex = n - 1;
        this.lastNull = this.resultDA.wasNull(this.currentColumnIndex, this.currentRowIndex);
        if (this.lastNull) {
            return null;
        }
        short s = this.resultDA.getHostType(this.currentColumnIndex);
        if (s == 23 || s == 14 || s == 24) {
            return new CtreeLongDataInputStream(this, this.resultDA.getString(this.currentColumnIndex, this.currentRowIndex), s, true).getString(n2, n3);
        }
        throw new CtreeSQLException(26055);
    }

    void putData(int n, int n2, InputStream inputStream) throws SQLException {
        --n2;
        CtreeConnection ctreeConnection = (CtreeConnection)this.getStatement().getConnection();
        StatementUid statementUid = this.getStatementID();
        this.checkResultDA();
        this.currentColumnIndex = n - 1;
        this.lastNull = this.resultDA.wasNull(this.currentColumnIndex, this.currentRowIndex);
        if (this.lastNull) {
            n2 = 0;
        }
        int n3 = this.resultDA.getHostType(this.currentColumnIndex);
        switch (n3) {
            case 15: 
            case 22: {
                n3 = 12;
                break;
            }
            case 14: 
            case 23: {
                n3 = 1;
                break;
            }
            case 24: 
            case 25: {
                n2 *= 2;
                n3 = 17;
                break;
            }
            default: {
                throw new CtreeSQLException(26028);
            }
        }
        ctreeConnection.putData(statementUid, inputStream, n3, this.resultDA.getString(this.currentColumnIndex, this.currentRowIndex), n2);
    }

    @Override
    public int getHoldability() throws SQLException {
        if (this.isClosed) {
            throw new CtreeSQLException(26046);
        }
        if (this.statement == null) {
            throw new CtreeSQLException(26038);
        }
        return this.statement.getResultSetHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    public boolean isWrapperFor(Class clazz) throws SQLException {
        return this.getClass().getName().equals(clazz.getName());
    }

    public CtreeResultSet unwrap(Class clazz) throws SQLException {
        boolean bl = clazz.getName().equals(this.getClass().getName());
        if (!bl) {
            throw new CtreeSQLException(26094);
        }
        return this;
    }

    public boolean UnicodeCompatibility() {
        return this.statement.UnicodeCompatibility();
    }

    protected void SetNOfRows(int n) {
        this.last_row_no = n;
        if (n <= 0) {
            this.isEmpty = true;
        }
    }

    private void setAfterLastRow(boolean bl) {
        this.afterLastRow = this.isEmpty ? false : bl;
    }
}

