/*
 * Decompiled with CFR 0.152.
 */
package ctree.jdbc;

import ctree.jdbc.CtreeCA;
import ctree.jdbc.CtreeErrorObject;
import java.sql.SQLException;
import java.util.Hashtable;

public class CtreeSQLException
extends SQLException {
    private static Hashtable ErrorTable = new Hashtable();
    private static int ErrorPosition;

    CtreeSQLException(String string, String string2, int n) {
        super(string, string2, n);
    }

    public CtreeSQLException(int n) {
        super(CtreeSQLException.getErrorMessage(n), CtreeSQLException.getSQLState(n), n);
    }

    CtreeSQLException(String string, int n) {
        super(string, CtreeSQLException.getSQLState(n), n);
    }

    CtreeSQLException(CtreeCA ctreeCA) {
        super(ctreeCA.getErrorMessage(), ctreeCA.getSqlstate(), ctreeCA.getErrorCode());
        ErrorPosition = ctreeCA.Sqlerrd[4];
    }

    public static void add(int n, String string, String string2) {
        ErrorTable.put(n, new CtreeErrorObject(string, string2));
    }

    public static String getErrorMessage(int n) {
        CtreeErrorObject ctreeErrorObject = (CtreeErrorObject)ErrorTable.get(n);
        if (ctreeErrorObject != null) {
            return ctreeErrorObject.getErrorMessage();
        }
        return "";
    }

    public static String getSQLState(int n) {
        CtreeErrorObject ctreeErrorObject = (CtreeErrorObject)ErrorTable.get(n);
        if (ctreeErrorObject != null) {
            return ctreeErrorObject.getSQLState();
        }
        return "";
    }

    public static int getErrorPosition() {
        return ErrorPosition;
    }

    static {
        CtreeSQLException.add(26001, "08001", "Unable to connect to data source");
        CtreeSQLException.add(26002, "08003", "Connection does not exist");
        CtreeSQLException.add(26003, "08S01", "Communication link failure");
        CtreeSQLException.add(26004, "08597", "Connect String not specified/incorrect");
        CtreeSQLException.add(26005, "08808", "Connection to data source timed out");
        CtreeSQLException.add(26006, "0850k", "TCP/IP Remote HostName is unknown");
        CtreeSQLException.add(26007, "08801", "SQL client bind to daemon failed");
        CtreeSQLException.add(26008, "08802", "SQL client bind to SQL server failed");
        CtreeSQLException.add(26009, "08803", "SQL Network service entry is not available");
        CtreeSQLException.add(26010, "08804", "Invalid TCP/IP hostname");
        CtreeSQLException.add(26011, "08806", "Network error on server");
        CtreeSQLException.add(26012, "08807", "Invalid protocol");
        CtreeSQLException.add(26013, "08816", "Invalid host name in connect string");
        CtreeSQLException.add(26014, "08809", "Duplicate connection name");
        CtreeSQLException.add(26015, "08810", "No active connection");
        CtreeSQLException.add(26016, "08812", "Multiple local connections");
        CtreeSQLException.add(26017, "08813", "Invalid protocol in connect_string");
        CtreeSQLException.add(26018, "08814", "Exceeding permissible number of connections");
        CtreeSQLException.add(26019, "22818", "Invalid date value");
        CtreeSQLException.add(26020, "22819", "Invalid date string");
        CtreeSQLException.add(26021, "22820", "Invalid number");
        CtreeSQLException.add(26022, "22821", "Invalid number string");
        CtreeSQLException.add(26023, "22822", "Invalid time value");
        CtreeSQLException.add(26024, "22523", "Invalid time string");
        CtreeSQLException.add(26025, "22007", "Invalid time stamp string");
        CtreeSQLException.add(26026, "s0501", "SQL internal error");
        CtreeSQLException.add(26027, "s0502", "Memory allocation failure");
        CtreeSQLException.add(26028, "22509", "Inconsistent types");
        CtreeSQLException.add(26029, "22515", "Missing input parameters");
        CtreeSQLException.add(26030, "0a000", "Sorry operation not yet implemented");
        CtreeSQLException.add(26031, "24538", "Executing select statement");
        CtreeSQLException.add(26032, "24539", "Cursor not closed");
        CtreeSQLException.add(26033, "24540", "Open for non select statement");
        CtreeSQLException.add(26034, "22553", "Overflow error");
        CtreeSQLException.add(26035, "08555", "Database not specified or improperly specified");
        CtreeSQLException.add(26036, "08556", "Database not specified or Database not started");
        CtreeSQLException.add(26037, "22562", "Input parameter size too high");
        CtreeSQLException.add(26038, "26000", "Invalid statement type");
        CtreeSQLException.add(26039, "07001", "Wrong number of parameters");
        CtreeSQLException.add(26040, "2250x", "Numeric value out of range");
        CtreeSQLException.add(26041, "2250y", "Data truncated");
        CtreeSQLException.add(26042, "22800", "Remote procedure call error");
        CtreeSQLException.add(26043, "S1001", "Memory allocation failure");
        CtreeSQLException.add(26044, "S1109", "Invalid Cursor position");
        CtreeSQLException.add(26045, "S1010", "Function sequence error");
        CtreeSQLException.add(26046, "24000", "Invalid cursor state");
        CtreeSQLException.add(26047, "S1106", "Fetch type out of range");
        CtreeSQLException.add(26048, "S1107", "Row value out of range");
        CtreeSQLException.add(26049, "S1002", "Invalid column number");
        CtreeSQLException.add(26050, "S1C00", "Driver not capable");
        CtreeSQLException.add(26051, "S1T00", "Timeout expired");
        CtreeSQLException.add(26052, "S1090", "Invalid string or buffer length");
        CtreeSQLException.add(26053, "34000", "Invalid cursor name");
        CtreeSQLException.add(26054, "3C000", "Duplicate cursor name");
        CtreeSQLException.add(26055, "S1009", "Invalid argument value");
        CtreeSQLException.add(26056, "S1004", "SQL data type out of range");
        CtreeSQLException.add(26057, "S1008", "Operation canceled");
        CtreeSQLException.add(26058, "S1094", "Invalid scale value");
        CtreeSQLException.add(26059, "S1104", "Invalid precision value");
        CtreeSQLException.add(26060, "S1093", "Invalid parameter number");
        CtreeSQLException.add(26061, "S1009", "Invalid argument value");
        CtreeSQLException.add(26062, "08004", "Data source rejected establishment of connection");
        CtreeSQLException.add(26063, "S1000", "General error");
        CtreeSQLException.add(26064, "01002", "Disconnect error");
        CtreeSQLException.add(26065, "IM001", "Driver does not support this function");
        CtreeSQLException.add(26066, "IM002", "No default driver specified");
        CtreeSQLException.add(26067, "IM003", "Specified driver could not be loaded");
        CtreeSQLException.add(26068, "S1015", "No cursor name available");
        CtreeSQLException.add(26069, "07006", "Restricted data type attribute violation");
        CtreeSQLException.add(26084, "24541", "Batch must be either executed or cleared");
        CtreeSQLException.add(26085, "24542", "Batch update does not support more than 500 sets of parameter values");
        CtreeSQLException.add(26086, "24543", "Error occurred in batching - values of all parameters not supplied");
        CtreeSQLException.add(26087, "08817", "Connection failed - permission denied for creation of thread");
        CtreeSQLException.add(26080, "ISO 9075", "Database name exceeded the maximum length");
        CtreeSQLException.add(26081, "ISO 9075", "User name exceeded the maximum length");
        CtreeSQLException.add(26082, "ISO 9075", "Password exceeded the maximum length");
        CtreeSQLException.add(26083, "ISO 9075", "Database options exceeded the maximum length");
        CtreeSQLException.add(26088, "P0001", "Invalid Position");
        CtreeSQLException.add(26089, "P0002", "Invalid Length");
        CtreeSQLException.add(26090, "P0003", "Invalid Offset");
        CtreeSQLException.add(26091, "P0004", "Unsupported Operation");
        CtreeSQLException.add(26092, "P0005", "Unsupported client information property name");
        CtreeSQLException.add(26093, "P0006", "Client information value length truncated");
        CtreeSQLException.add(26094, "P0007", "No object found implementing the given interface");
        CtreeSQLException.add(26095, "P0008", "Statement is already closed");
        CtreeSQLException.add(26096, "P0009", "Invalid timeout; should be a positive number");
        CtreeSQLException.add(-30011, "k0k02", "memory allocation failure");
        CtreeSQLException.add(-30002, "k0k02", "invalid network handle");
        CtreeSQLException.add(-30003, "k0k03", "invalid sqlnetwork INTERFACE");
        CtreeSQLException.add(-30004, "k0k04", "invalid sqlnetwork INTERFACE procedure");
        CtreeSQLException.add(-30005, "k0k05", "INTERFACE is already attached");
        CtreeSQLException.add(-30006, "k0k06", "INTERFACE entry not found");
        CtreeSQLException.add(-30007, "k0k07", "INTERFACE is already registered");
        CtreeSQLException.add(-30008, "k0k08", "mismatch in pkt header size and argument size");
        CtreeSQLException.add(-30009, "k0k09", "invalid server id");
        CtreeSQLException.add(-30010, "k0k10", "reply does not match the request");
        CtreeSQLException.add(-30031, "k0k11", "error in transmission of packet");
        CtreeSQLException.add(-30032, "k0k12", "error in reception of packet");
        CtreeSQLException.add(-30033, "k0k13", "no packet received");
        CtreeSQLException.add(-30034, "k0k14", "connection reset");
        CtreeSQLException.add(-30051, "k0k15", "network handle is inprocess handle");
        CtreeSQLException.add(-30061, "k0k16", "could not connect to sql network daemon");
        CtreeSQLException.add(-30062, "k0k17", "error in number of arguments");
        CtreeSQLException.add(-30063, "k0k18", "requested INTERFACE not registered");
        CtreeSQLException.add(-30064, "k0k19", "invalid INTERFACE procedure id");
        CtreeSQLException.add(-30065, "k0k20", "requested server executable not found");
        CtreeSQLException.add(-30066, "k0k21", "invalid configuration information");
        CtreeSQLException.add(-30067, "k0k22", "INTERFACE not supported");
        CtreeSQLException.add(-30091, "k0k23", "invalid service name");
        CtreeSQLException.add(-30092, "k0k24", "invalid host");
        CtreeSQLException.add(-30093, "k0k25", "error in tcp/ip accept call");
        CtreeSQLException.add(-30094, "k0k26", "error in tcp/ip connect call");
        CtreeSQLException.add(-30095, "k0k27", "error in tcp/ip bind call");
        CtreeSQLException.add(-30096, "k0k28", "error in creating socket");
        CtreeSQLException.add(-30097, "k0k29", "error in setting socket option");
        CtreeSQLException.add(-30099, "k0k08", "error in marshaling");
        CtreeSQLException.add(-30100, "k0k08", "error in unmarshaling");
        CtreeSQLException.add(-30101, "k0k30", "interrupt occured");
        CtreeSQLException.add(-30102, "k0k31", "Client/Server not WideChar Compatible");
        CtreeSQLException.add(-30103, "k0k32", "Socket Timed out");
        CtreeSQLException.add(-30012, "S1000", "Query has timed out");
        CtreeSQLException.add(-17084, "00084", "Maximum users exceeded");
        CtreeSQLException.add(-17530, "00530", "Client does not match server");
    }
}

