/*
 * Decompiled with CFR 0.152.
 */
package ctree.jdbc;

import ctree.jdbc.CtreeSQLProcInfo;
import ctree.jdbc.SQLPacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class CtreeSQLProcColInfo {
    private int pci_proccolid;
    private String pci_col;
    private String pci_datatype;
    private CtreeSQLProcInfo.CtreeSQLProcColtype pci_coltype;
    private int pci_width;
    private int pci_scale;
    private boolean pci_nonull;
    private String pci_default;

    public void unmarshal(SQLPacket sQLPacket, CtreeSQLProcInfo.CtreeSQLProcType ctreeSQLProcType) throws IOException {
        DataInputStream dataInputStream = sQLPacket.getInputStream();
        if (ctreeSQLProcType != CtreeSQLProcInfo.CtreeSQLProcType.TRG) {
            this.pci_proccolid = dataInputStream.readInt();
        }
        this.pci_col = sQLPacket.unmarshalString();
        if (ctreeSQLProcType != CtreeSQLProcInfo.CtreeSQLProcType.TRG) {
            this.pci_datatype = sQLPacket.unmarshalString();
            this.pci_coltype = CtreeSQLProcInfo.CtreeSQLProcColtype.fromInt(dataInputStream.readInt());
            this.pci_width = dataInputStream.readInt();
            this.pci_scale = dataInputStream.readInt();
            this.pci_nonull = dataInputStream.readInt() != 0;
            this.pci_default = sQLPacket.unmarshalString();
        }
    }

    public void marshal(SQLPacket sQLPacket, CtreeSQLProcInfo.CtreeSQLProcType ctreeSQLProcType) throws IOException {
        DataOutputStream dataOutputStream = sQLPacket.getOutputStream();
        if (ctreeSQLProcType != CtreeSQLProcInfo.CtreeSQLProcType.TRG) {
            dataOutputStream.writeInt(this.pci_proccolid);
        }
        sQLPacket.marshalString(this.pci_col);
        if (ctreeSQLProcType != CtreeSQLProcInfo.CtreeSQLProcType.TRG) {
            sQLPacket.marshalString(this.pci_datatype);
            dataOutputStream.writeInt(this.pci_coltype.value());
            dataOutputStream.writeInt(this.pci_width);
            dataOutputStream.writeInt(this.pci_scale);
            dataOutputStream.writeInt(this.pci_nonull ? 1 : 0);
            sQLPacket.marshalString(this.pci_default);
        }
    }

    public void setPci_proccolid(int n) {
        this.pci_proccolid = n;
    }

    public void setPci_col(String string) {
        this.pci_col = string;
    }

    public void setPci_datatype(String string) {
        this.pci_datatype = string;
    }

    public void setPci_coltype(CtreeSQLProcInfo.CtreeSQLProcColtype ctreeSQLProcColtype) {
        this.pci_coltype = ctreeSQLProcColtype;
    }

    public void setPci_width(int n) {
        this.pci_width = n;
    }

    public void setPci_scale(int n) {
        this.pci_scale = n;
    }

    public void setPci_nonull(boolean bl) {
        this.pci_nonull = bl;
    }

    public void setPci_default(String string) {
        this.pci_default = string;
    }

    public int getPci_proccolid() {
        return this.pci_proccolid;
    }

    public String getPci_col() {
        return this.pci_col;
    }

    public String getPci_datatype() {
        return this.pci_datatype;
    }

    public CtreeSQLProcInfo.CtreeSQLProcColtype getPci_coltype() {
        return this.pci_coltype;
    }

    public int getPci_width() {
        return this.pci_width;
    }

    public int getPci_scale() {
        return this.pci_scale;
    }

    public boolean isPci_nonull() {
        return this.pci_nonull;
    }

    public String getPci_default() {
        return this.pci_default;
    }
}

