/*
 * Decompiled with CFR 0.152.
 */
package ctree.jdbc;

import ctree.jdbc.CtreeError;
import ctree.jdbc.CtreeSQLProcColInfo;
import ctree.jdbc.SQLPacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CtreeSQLProcInfo
implements CtreeError {
    private CtreeSQLProcType kind;
    private String owner = "";
    private String name = "";
    private String run = "";
    private ArrayList<CtreeSQLProcColInfo> proc_colinfo = new ArrayList();
    private int col_num;
    private String src_import = "";
    private String src_txt = "";
    private byte[] bin = new byte[1];
    private int bin_len;
    private CtreeSQLProcOptions options;
    private CtreeSQLProcRuntime sqlp_runtime;
    private String sqlp_lang = "JAVA";
    private boolean has_result_set;
    private boolean has_return_value;
    private boolean built_in;
    private String tbl_name = "";
    private String tbl_owner = "";
    private char trigger_time;
    private char trigger_event;
    private boolean refers_to_old;
    private boolean refers_to_new;
    private char statement_or_row;
    private byte[] raw = new byte[1];
    int raw_len;

    public void AddParam(CtreeSQLProcColInfo ctreeSQLProcColInfo) {
        this.proc_colinfo.add(ctreeSQLProcColInfo);
        ++this.col_num;
    }

    public void AddResultSetColumn(CtreeSQLProcColInfo ctreeSQLProcColInfo) {
        this.proc_colinfo.add(ctreeSQLProcColInfo);
        ++this.col_num;
        this.has_result_set = true;
    }

    public CtreeSQLProcInfo(String string, String string2, CtreeSQLProcType ctreeSQLProcType) {
        this.owner = string;
        this.name = string2;
        this.kind = ctreeSQLProcType;
        this.sqlp_runtime = CtreeSQLProcRuntime.JVM;
        this.options = CtreeSQLProcOptions.NONE;
        this.col_num = 0;
        this.built_in = false;
    }

    public void marshal(SQLPacket sQLPacket, int n) throws IOException {
        int n2;
        DataOutputStream dataOutputStream = sQLPacket.getOutputStream();
        DataOutputStream dataOutputStream2 = new DataOutputStream(dataOutputStream);
        if (n == 1) {
            dataOutputStream2.writeInt(this.options.value);
        }
        dataOutputStream2.writeInt(this.kind.value);
        sQLPacket.marshalString(this.owner);
        sQLPacket.marshalString(this.name);
        dataOutputStream2.writeInt(this.sqlp_runtime.value);
        sQLPacket.marshalString(this.sqlp_lang);
        sQLPacket.marshalString(this.run);
        sQLPacket.marshalString(this.src_import);
        sQLPacket.marshalString(this.src_txt);
        dataOutputStream2.writeInt(this.bin_len);
        dataOutputStream2.write(this.bin, 0, this.bin_len);
        int n3 = this.bin_len % 4;
        if (n3 != 0) {
            byte[] byArray = new byte[]{0, 0, 0, 0};
            dataOutputStream2.write(byArray, 0, 4 - n3);
        }
        if (n == 0) {
            dataOutputStream2.writeInt(this.options.value);
        }
        dataOutputStream2.writeInt(this.col_num);
        for (n2 = 0; n2 < this.col_num; ++n2) {
            CtreeSQLProcColInfo ctreeSQLProcColInfo = this.proc_colinfo.get(n2);
            ctreeSQLProcColInfo.marshal(sQLPacket, this.kind);
        }
        if (this.kind == CtreeSQLProcType.STP || this.kind == CtreeSQLProcType.UDF) {
            n2 = this.has_result_set ? 1 : 0;
            n2 += this.has_return_value ? 2 : 0;
            dataOutputStream2.writeInt(n2 += this.built_in ? 4 : 0);
        } else if (this.kind == CtreeSQLProcType.TRG) {
            sQLPacket.marshalString(this.tbl_name);
            sQLPacket.marshalString(this.tbl_owner);
            dataOutputStream2.writeInt(this.trigger_time);
            dataOutputStream2.writeInt(this.trigger_event);
            dataOutputStream2.writeInt(this.statement_or_row);
            n2 = this.refers_to_old ? 1 : 0;
            dataOutputStream2.writeInt(n2 += this.refers_to_new ? 2 : 0);
        }
    }

    public void unmarshal(SQLPacket sQLPacket, int n) throws IOException {
        int n2;
        DataInputStream dataInputStream = sQLPacket.getInputStream();
        if (n == 1) {
            this.options.value = dataInputStream.readInt();
        }
        int n3 = sQLPacket.unmarshalInt();
        this.kind = CtreeSQLProcType.fromInt(n3);
        this.owner = sQLPacket.unmarshalString();
        this.name = sQLPacket.unmarshalString();
        this.sqlp_runtime.value = dataInputStream.readInt();
        this.sqlp_lang = sQLPacket.unmarshalString();
        this.run = sQLPacket.unmarshalString();
        this.src_import = sQLPacket.unmarshalString();
        this.src_txt = sQLPacket.unmarshalString();
        this.bin_len = dataInputStream.readInt();
        this.bin = new byte[this.bin_len];
        dataInputStream.read(this.bin, 0, this.bin_len);
        int n4 = this.bin_len % 4;
        if (n4 != 0) {
            dataInputStream.skipBytes(4 - n4);
        }
        if (n == 0) {
            this.options.value = dataInputStream.readInt();
        }
        this.col_num = dataInputStream.readInt();
        for (n2 = 0; n2 < this.col_num; ++n2) {
            CtreeSQLProcColInfo ctreeSQLProcColInfo = new CtreeSQLProcColInfo();
            ctreeSQLProcColInfo.unmarshal(sQLPacket, this.kind);
            this.proc_colinfo.add(ctreeSQLProcColInfo);
        }
        if (this.kind == CtreeSQLProcType.STP || this.kind == CtreeSQLProcType.UDF) {
            n2 = dataInputStream.readInt();
            this.has_result_set = (n2 & 1) == 1;
            this.has_return_value = (n2 & 2) == 2;
            this.built_in = (n2 & 4) == 4;
        } else if (this.kind == CtreeSQLProcType.TRG) {
            this.tbl_name = sQLPacket.unmarshalString();
            this.tbl_owner = sQLPacket.unmarshalString();
            this.trigger_time = (char)dataInputStream.readInt();
            this.trigger_event = (char)dataInputStream.readInt();
            this.statement_or_row = (char)dataInputStream.readInt();
            n2 = dataInputStream.readInt();
            this.refers_to_old = (n2 & 1) == 1;
            this.refers_to_new = (n2 & 2) == 2;
        }
    }

    public void setImport(String string) {
        this.src_import = string;
    }

    public void setBody(String string) {
        this.src_txt = string;
    }

    public void setByteCode(byte[] byArray) {
        this.bin = byArray;
        this.bin_len = byArray.length;
    }

    public void setHasReturnValue(boolean bl) {
        this.has_return_value = bl;
    }

    void setOptions(CtreeSQLProcOptions ctreeSQLProcOptions) {
        this.options = ctreeSQLProcOptions;
    }

    public void setOwner(String string) {
        this.owner = string;
    }

    public void setTbl_name(String string) {
        this.tbl_name = string;
    }

    public void setTbl_owner(String string) {
        this.tbl_owner = string;
    }

    public void setTrigger_time(char c) {
        this.trigger_time = c;
    }

    public void setTrigger_event(char c) {
        this.trigger_event = c;
    }

    public void setRefers_to_old(boolean bl) {
        this.refers_to_old = bl;
    }

    public void setRefers_to_new(boolean bl) {
        this.refers_to_new = bl;
    }

    public void setStatement_or_row(char c) {
        this.statement_or_row = c;
    }

    public void setRun(String string) {
        this.run = string;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getName() {
        return this.name;
    }

    public String getRun() {
        return this.run;
    }

    public ArrayList<CtreeSQLProcColInfo> getProc_colinfo() {
        return this.proc_colinfo;
    }

    public String getTbl_name() {
        return this.tbl_name;
    }

    public char getTrigger_time() {
        return this.trigger_time;
    }

    public char getTrigger_event() {
        return this.trigger_event;
    }

    public boolean isRefers_to_old() {
        return this.refers_to_old;
    }

    public boolean isRefers_to_new() {
        return this.refers_to_new;
    }

    public char getStatement_or_row() {
        return this.statement_or_row;
    }

    public CtreeSQLProcType getKind() {
        return this.kind;
    }

    public String getSrc_import() {
        return this.src_import;
    }

    public String getSrc_txt() {
        return this.src_txt;
    }

    public byte[] getBin() {
        return this.bin;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CtreeSQLProcOptions {
        NONE(0),
        ALTER_CHECK(1),
        ALTER_NOCHECK(2);

        public int value;

        private CtreeSQLProcOptions(int n2) {
            this.value = n2;
        }

        public int value() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CtreeSQLProcRuntime {
        JVM(0),
        CLIRT(1);

        public int value;

        private CtreeSQLProcRuntime(int n2) {
            this.value = n2;
        }

        public int value() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CtreeSQLProcType {
        STP(0),
        UDF(1),
        TRG(2),
        INVALID(-1);

        private final int value;

        private CtreeSQLProcType(int n2) {
            this.value = n2;
        }

        public int value() {
            return this.value;
        }

        public static CtreeSQLProcType fromInt(int n) {
            switch (n) {
                case 0: {
                    return STP;
                }
                case 1: {
                    return UDF;
                }
                case 2: {
                    return TRG;
                }
            }
            return INVALID;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CtreeSQLProcColtype {
        SQL_PROC_ARG_UNKNOWN(0),
        SQL_PROC_ARG_IN(1),
        SQL_PROC_ARG_INOUT(2),
        SQL_PROC_RESULT(3),
        SQL_PROC_ARG_OUT(4),
        SQL_PROC_RETURN(5),
        SQL_UDF_RETURN(6),
        SQL_PROC_ARG_INVALID(-1);

        private int value;

        private CtreeSQLProcColtype(int n2) {
            this.value = n2;
        }

        public int value() {
            return this.value;
        }

        public static CtreeSQLProcColtype fromInt(int n) {
            switch (n) {
                case 0: {
                    return SQL_PROC_ARG_UNKNOWN;
                }
                case 1: {
                    return SQL_PROC_ARG_IN;
                }
                case 2: {
                    return SQL_PROC_ARG_INOUT;
                }
                case 3: {
                    return SQL_PROC_RESULT;
                }
                case 4: {
                    return SQL_PROC_ARG_OUT;
                }
                case 5: {
                    return SQL_PROC_RETURN;
                }
                case 6: {
                    return SQL_UDF_RETURN;
                }
                case -1: {
                    return SQL_PROC_ARG_INVALID;
                }
            }
            return SQL_PROC_ARG_INVALID;
        }
    }
}

