/*
 * Decompiled with CFR 0.152.
 */
package ctree.jdbc;

import ctree.jdbc.CtreeError;
import ctree.jdbc.SQLControlPacket;
import ctree.jdbc.SQLNetworkException;
import ctree.jdbc.SQLTransport;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public final class CtreeSQLTransportImpl
extends SQLTransport
implements CtreeError {
    private Socket socket;
    private SSLSocket sslSocket = null;

    public CtreeSQLTransportImpl(Socket socket) {
        this.socket = socket;
        this.ControlPacket = new SQLControlPacket();
    }

    public void close() throws IOException {
        if (this.socket != null) {
            this.socket.close();
        }
        this.socket = null;
        this.ControlPacket = null;
    }

    public void finalize() throws IOException {
        this.close();
    }

    public void send(byte[] byArray) throws IOException, SQLNetworkException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (this.socket == null) {
            throw new SQLNetworkException(-30103);
        }
        this.ControlPacket.marshal(byteArrayOutputStream);
        byteArrayOutputStream.write(byArray);
        OutputStream outputStream = this.getOutputStream();
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        outputStream.write(byArray2);
    }

    public byte[] receive(int n) throws SQLNetworkException, IOException {
        int n2;
        int n3;
        byte[] byArray = new byte[n];
        InputStream inputStream = this.getInputStream();
        for (n2 = 0; n2 < n; n2 += n3) {
            n3 = 0;
            try {
                n3 = inputStream.read(byArray, n2, n - n2);
            }
            catch (InterruptedIOException interruptedIOException) {
                this.close();
                throw new SQLNetworkException(-30103);
            }
            if (n3 >= 0) continue;
            throw new SQLNetworkException(-30008);
        }
        if (n2 != n) {
            System.out.println("check " + n2 + " " + n);
            throw new SQLNetworkException(-30008);
        }
        return byArray;
    }

    public InputStream getInputStream() throws IOException, SQLNetworkException {
        if (this.socket == null) {
            throw new SQLNetworkException(-30103);
        }
        if (this.sslSocket != null) {
            return this.sslSocket.getInputStream();
        }
        return this.socket.getInputStream();
    }

    private OutputStream getOutputStream() throws IOException, SQLNetworkException {
        if (this.socket == null) {
            throw new SQLNetworkException(-30103);
        }
        if (this.sslSocket != null) {
            return this.sslSocket.getOutputStream();
        }
        return this.socket.getOutputStream();
    }

    public void unmarshal(InputStream inputStream) throws IOException {
        this.ControlPacket.unmarshal(inputStream);
    }

    boolean isSHM() {
        return false;
    }

    public void SslHandshake(int n) throws IOException {
        SSLSocketFactory sSLSocketFactory;
        if (n == 1) {
            X509TrustManager x509TrustManager = new X509TrustManager(){

                public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
                }

                public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
                }

                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            };
            SSLContext sSLContext = null;
            try {
                sSLContext = SSLContext.getInstance("TLSv1.2");
                sSLContext.init(null, new TrustManager[]{x509TrustManager}, null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            sSLSocketFactory = sSLContext.getSocketFactory();
        } else {
            sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        }
        this.sslSocket = (SSLSocket)sSLSocketFactory.createSocket(this.socket, null, this.socket.getPort(), false);
    }
}

