/*
 * Decompiled with CFR 0.152.
 */
package ctree.jdbc;

import ctree.jdbc.CtreeError;
import ctree.jdbc.CtreeSQLException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Properties;
import java.util.StringTokenizer;

class CtreeURL
implements CtreeError {
    protected static final int DH_MAX_DBNAME_LEN = 64;
    String urlStr;
    String ipv6Addr;
    String substitutedUrlStr;
    private String portStr;
    private String dbName;
    private String host;
    private boolean oldFormat;
    private boolean partialParse;
    private String user;
    private String password;
    private Charset charset;
    public static Charset defaultCharset = Charset.forName("UTF-8");
    private int sslSetting = 0;

    CtreeURL(String string, boolean bl) throws CtreeSQLException {
        this.urlStr = string;
        if (!string.contains("//")) {
            this.oldFormat = true;
            StringBuffer stringBuffer = new StringBuffer("");
            StringBuffer stringBuffer2 = new StringBuffer("");
            boolean bl2 = false;
            boolean bl3 = false;
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c == '[') {
                    bl2 = true;
                    stringBuffer.append("dummyhostname");
                    if (++i >= n) break;
                    c = string.charAt(i);
                    while (c != ']') {
                        stringBuffer2.append(c);
                        if (++i >= n) break;
                        c = string.charAt(i);
                    }
                    if (c != ']') continue;
                    bl3 = true;
                    continue;
                }
                stringBuffer.append(c);
            }
            if (bl2 && bl3) {
                this.substitutedUrlStr = stringBuffer.toString();
                this.ipv6Addr = stringBuffer2.toString();
            } else {
                this.substitutedUrlStr = string;
                this.ipv6Addr = null;
            }
        } else {
            this.substitutedUrlStr = string;
            this.ipv6Addr = null;
            this.oldFormat = false;
        }
        this.parseURL(bl);
    }

    public String getPortStr() {
        return this.portStr;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getHost() {
        return this.host;
    }

    private Properties queryStringToProperties(String string, String string2) {
        Properties properties = new Properties();
        String[] stringArray = string.split("&");
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            String[] stringArray2 = string3.split("=", 2);
            if (stringArray2.length != 2) continue;
            try {
                String string4 = URLDecoder.decode(stringArray2[0], string2);
                String string5 = URLDecoder.decode(stringArray2[1], string2);
                if (properties.containsKey(string4)) continue;
                properties.setProperty(string4, string5);
                continue;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException);
            }
        }
        return properties;
    }

    private void parseURL(boolean bl) throws CtreeSQLException {
        String string;
        URI uRI;
        boolean bl2 = this.partialParse = !bl;
        if (this.oldFormat) {
            this.validateOldFormat(this.substitutedUrlStr, bl);
            return;
        }
        if (!this.substitutedUrlStr.toLowerCase().startsWith("jdbc:ctree:")) {
            throw new CtreeSQLException("url does not start with jdbc:ctree", 26012);
        }
        try {
            uRI = new URI(this.substitutedUrlStr.substring(5));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new CtreeSQLException(26004);
        }
        this.host = uRI.getHost();
        if (this.host == null) {
            this.host = "";
        }
        if ((string = uRI.getPath()) == null || string.length() < 2) {
            throw new CtreeSQLException("url does not contain a database", 26004);
        }
        String string2 = this.portStr = uRI.getPort() == -1 ? "6597" : "" + uRI.getPort();
        if (this.ipv6Addr != null) {
            this.host = this.ipv6Addr;
        }
        this.dbName = string.replace("/", "");
        if (!bl && uRI.getQuery() != null) {
            Properties properties = this.queryStringToProperties(uRI.getQuery(), "UTF-8");
            if (properties.containsKey("characterEncoding")) {
                this.charset = Charset.forName(properties.getProperty("characterEncoding"));
            }
            if (properties.containsKey("password")) {
                this.password = properties.getProperty("password");
            }
            if (properties.containsKey("user")) {
                this.user = properties.getProperty("user");
            }
            if (properties.containsKey("ssl")) {
                if (properties.getProperty("ssl").equalsIgnoreCase("basic")) {
                    this.sslSetting = 1;
                } else if (properties.getProperty("ssl").equalsIgnoreCase("peerAuthentication")) {
                    this.sslSetting = 2;
                }
            }
        }
    }

    private void validateOldFormat(String string, boolean bl) throws CtreeSQLException {
        Object object;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        int n2 = stringTokenizer.countTokens();
        String string5 = null;
        if (n2 < 6) {
            string5 = string;
        } else {
            for (int i = 0; i < 6; ++i) {
                object = stringTokenizer.nextToken();
                if (string5 == null) {
                    string5 = object;
                    continue;
                }
                string5 = string5.concat(":");
                string5 = string5.concat((String)object);
            }
        }
        StringTokenizer stringTokenizer2 = new StringTokenizer(string5, "?");
        if (stringTokenizer2.countTokens() > 1) {
            string5 = stringTokenizer2.nextToken();
            string4 = stringTokenizer2.nextToken();
            if (stringTokenizer2.hasMoreTokens()) {
                throw new CtreeSQLException(26004);
            }
        }
        if ((stringTokenizer2 = new StringTokenizer(string5, "/")).countTokens() < 3) {
            stringTokenizer2 = new StringTokenizer(string5, ":");
            if (stringTokenizer2.countTokens() < 4) {
                throw new CtreeSQLException(26004);
            }
            n = 0;
            while (stringTokenizer2.hasMoreTokens()) {
                switch (n) {
                    case 0: {
                        string2 = stringTokenizer2.nextToken();
                        if (string2.toLowerCase().equals("jdbc")) break;
                        throw new CtreeSQLException(26012);
                    }
                    case 1: {
                        if (stringTokenizer2.nextToken().toLowerCase().equals("ctree")) break;
                        throw new CtreeSQLException(26012);
                    }
                    case 2: {
                        string3 = stringTokenizer2.nextToken();
                        object = new StringTokenizer(string3, "@");
                        if (((StringTokenizer)object).countTokens() == 2) {
                            this.portStr = ((StringTokenizer)object).nextToken();
                            this.host = ((StringTokenizer)object).nextToken();
                        } else {
                            this.portStr = string3;
                            this.host = "";
                        }
                        if (this.ipv6Addr == null) break;
                        this.host = this.ipv6Addr;
                        break;
                    }
                    case 3: {
                        this.dbName = stringTokenizer2.nextToken();
                        break;
                    }
                    case 4: {
                        stringTokenizer2.nextToken();
                        break;
                    }
                    default: {
                        System.out.println("failed in def");
                        return;
                    }
                }
                ++n;
            }
            if (this.portStr == null) {
                this.portStr = new String("6597");
            }
            if (string4 != null) {
                stringTokenizer2 = new StringTokenizer(string4, "&");
                while (!bl && stringTokenizer2.hasMoreTokens()) {
                    object = stringTokenizer2.nextToken();
                    if (((String)object).startsWith("characterEncoding=")) {
                        String string6 = ((String)object).substring(((String)object).indexOf("=") + 1);
                        this.charset = Charset.forName(string6);
                    }
                    if (((String)object).startsWith("password=")) {
                        this.password = ((String)object).substring(((String)object).indexOf("=") + 1);
                    }
                    if (!((String)object).startsWith("user=")) continue;
                    this.user = ((String)object).substring(((String)object).indexOf("=") + 1);
                }
            }
            return;
        }
        object = null;
        n = 0;
        while (stringTokenizer2.hasMoreTokens()) {
            switch (n) {
                case 0: {
                    string2 = stringTokenizer2.nextToken();
                    break;
                }
                case 1: {
                    string3 = stringTokenizer2.nextToken();
                    break;
                }
                case 2: {
                    object = stringTokenizer2.nextToken();
                    break;
                }
                default: {
                    throw new CtreeSQLException(26012);
                }
            }
            ++n;
        }
        StringTokenizer stringTokenizer3 = new StringTokenizer(string2, ":");
        StringTokenizer stringTokenizer4 = new StringTokenizer(string3, "@");
        StringTokenizer stringTokenizer5 = new StringTokenizer((String)object, ":");
        if (stringTokenizer3.countTokens() != 2 || stringTokenizer4.countTokens() != 2 || stringTokenizer5.countTokens() != 1) {
            throw new CtreeSQLException(26004);
        }
        n = 0;
        while (stringTokenizer3.hasMoreTokens()) {
            switch (n) {
                case 0: {
                    string3 = stringTokenizer3.nextToken();
                    if (string3.equals("jdbc")) break;
                    throw new CtreeSQLException(26012);
                }
                case 1: {
                    string3 = stringTokenizer3.nextToken();
                    if (string3.equals("ctree")) break;
                    throw new CtreeSQLException(26012);
                }
                default: {
                    throw new CtreeSQLException(26012);
                }
            }
            ++n;
        }
        n = 0;
        while (stringTokenizer4.hasMoreTokens()) {
            switch (n) {
                case 0: {
                    this.portStr = stringTokenizer4.nextToken().trim();
                    if (this.ipv6Addr == null) break;
                    this.host = this.ipv6Addr.trim();
                    break;
                }
                case 1: {
                    this.host = stringTokenizer4.nextToken().trim();
                    break;
                }
                default: {
                    throw new CtreeSQLException(26012);
                }
            }
            ++n;
        }
        n = 0;
        while (stringTokenizer5.hasMoreTokens()) {
            switch (n) {
                case 0: {
                    this.dbName = stringTokenizer5.nextToken();
                    break;
                }
                default: {
                    throw new CtreeSQLException(26012);
                }
            }
            ++n;
        }
    }

    public Charset getCharset() {
        if (this.partialParse) {
            try {
                this.parseURL(false);
            }
            catch (CtreeSQLException ctreeSQLException) {
                // empty catch block
            }
        }
        return this.charset != null ? this.charset : defaultCharset;
    }

    public String getUser() {
        if (this.partialParse) {
            try {
                this.parseURL(false);
            }
            catch (CtreeSQLException ctreeSQLException) {
                // empty catch block
            }
        }
        return this.user;
    }

    public String getPassword() {
        if (this.partialParse) {
            try {
                this.parseURL(false);
            }
            catch (CtreeSQLException ctreeSQLException) {
                // empty catch block
            }
        }
        return this.password;
    }

    public int getSSL() {
        if (this.partialParse) {
            try {
                this.parseURL(false);
            }
            catch (CtreeSQLException ctreeSQLException) {
                // empty catch block
            }
        }
        return this.sslSetting;
    }
}

