/*
 * Decompiled with CFR 0.152.
 */
package ctree.jdbc;

import ctree.jdbc.CtreeError;
import ctree.jdbc.CtreeHexToCharModulatorStream;
import ctree.jdbc.CtreeSQLException;
import ctree.jdbc.CtreeUnicodeInputStream;
import ctree.jdbc.JDBCType;
import ctree.jdbc.SQLPacket;
import ctree.jdbc.SQLType;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;

public final class CtreeValue
implements CtreeError,
Serializable {
    private Object data;
    private short hostType;
    private SQLType sqlType;
    private InputStream in;
    private int length;
    private boolean unicodeCompatibility = false;

    public CtreeValue(boolean bl) {
        this.unicodeCompatibility = bl;
        this.hostType = (short)-1;
        this.data = null;
        this.sqlType = null;
    }

    public CtreeValue(Object object, boolean bl) throws SQLException {
        this.unicodeCompatibility = bl;
        this.setCtreeValue(object);
    }

    public CtreeValue(String string, SQLType sQLType, boolean bl) throws SQLException {
        this.unicodeCompatibility = bl;
        switch ((JDBCType)sQLType) {
            case NUMERIC: {
                this.data = string;
                if (this.unicodeCompatibility) {
                    this.hostType = (short)17;
                    break;
                }
                this.hostType = 1;
                break;
            }
            case BIGINT: {
                this.data = Long.valueOf(string);
                this.hostType = (short)16;
                break;
            }
            case INTEGER: {
                this.data = Integer.valueOf(string);
                this.hostType = (short)4;
                break;
            }
            case SMALLINT: {
                this.data = Short.valueOf(string);
                this.hostType = (short)3;
                break;
            }
            case TINYINT: {
                this.data = Byte.valueOf(string);
                this.hostType = (short)11;
                break;
            }
            case BIT: {
                this.data = Boolean.valueOf(string);
                this.hostType = (short)3;
                break;
            }
            case DATE: {
                this.data = string;
                if (this.unicodeCompatibility) {
                    this.hostType = (short)17;
                    break;
                }
                this.hostType = 1;
                break;
            }
            case TIME: {
                this.data = string;
                if (this.unicodeCompatibility) {
                    this.hostType = (short)17;
                    break;
                }
                this.hostType = 1;
                break;
            }
            case TIMESTAMP: {
                this.data = string;
                if (this.unicodeCompatibility) {
                    this.hostType = (short)17;
                    break;
                }
                this.hostType = 1;
                break;
            }
            case REAL: {
                this.data = Float.valueOf(string);
                this.hostType = (short)5;
                break;
            }
            case FLOAT: 
            case DOUBLE: {
                this.data = Double.valueOf(string);
                this.hostType = (short)6;
                break;
            }
            case CHAR: {
                this.hostType = this.unicodeCompatibility ? (short)17 : (short)1;
                this.data = string;
                break;
            }
            case VARCHAR: {
                this.hostType = this.unicodeCompatibility ? (short)18 : (short)1;
                this.data = string;
                break;
            }
            case CLOB: {
                this.hostType = (short)23;
                this.data = string;
                break;
            }
            case LONGVARCHAR: {
                this.hostType = (short)14;
                this.data = string;
                break;
            }
            case BINARY: {
                this.hostType = (short)12;
                this.data = string;
                break;
            }
            case VARBINARY: {
                this.hostType = (short)26;
                this.data = string;
                break;
            }
            case BLOB: {
                this.sqlType = JDBCType.CHAR;
                this.hostType = (short)22;
                this.data = string;
                this.data = this.getBytes();
                break;
            }
            case LONGVARBINARY: {
                this.sqlType = JDBCType.CHAR;
                this.hostType = (short)15;
                this.data = string;
                this.data = this.getBytes();
                break;
            }
            default: {
                this.reportUnknownTypeError(sQLType);
            }
        }
        this.sqlType = sQLType;
    }

    public CtreeValue(InputStream inputStream, int n, SQLType sQLType) {
        this.in = inputStream;
        this.data = null;
        this.length = n;
        this.sqlType = sQLType;
        if (sQLType == JDBCType.LONGVARBINARY) {
            this.hostType = (short)15;
        } else if (sQLType == JDBCType.BLOB) {
            this.hostType = (short)22;
        } else if (sQLType == JDBCType.LONGVARCHAR) {
            this.hostType = (short)14;
        } else if (sQLType == JDBCType.CLOB) {
            this.hostType = (short)23;
        }
    }

    public void setCtreeValue(Object object) throws SQLException {
        if (object instanceof Integer) {
            this.sqlType = JDBCType.INTEGER;
            this.hostType = (short)4;
        } else if (object instanceof Long) {
            this.sqlType = JDBCType.BIGINT;
            this.hostType = (short)16;
        } else if (object instanceof Short) {
            this.sqlType = JDBCType.SMALLINT;
            this.hostType = (short)3;
        } else if (object instanceof Byte) {
            this.sqlType = JDBCType.TINYINT;
            this.hostType = (short)11;
        } else if (object instanceof Boolean) {
            this.sqlType = JDBCType.BIT;
            this.hostType = (short)13;
        } else if (object instanceof BigDecimal) {
            this.sqlType = JDBCType.NUMERIC;
            this.hostType = (short)2;
        } else if (object instanceof Float) {
            this.sqlType = JDBCType.REAL;
            this.hostType = (short)5;
        } else if (object instanceof Double) {
            this.sqlType = JDBCType.DOUBLE;
            this.hostType = (short)6;
        } else if (object instanceof Date) {
            this.sqlType = JDBCType.DATE;
            this.hostType = (short)7;
        } else if (object instanceof Time) {
            this.sqlType = JDBCType.TIME;
            this.hostType = (short)9;
        } else if (object instanceof Timestamp) {
            this.sqlType = JDBCType.TIMESTAMP;
            this.hostType = (short)10;
        } else if (object instanceof String) {
            this.sqlType = JDBCType.VARCHAR;
            this.hostType = this.unicodeCompatibility ? (short)18 : (short)1;
        } else if (object instanceof InputStream) {
            this.sqlType = JDBCType.LONGVARBINARY;
            this.hostType = (short)12;
        } else if (object instanceof byte[]) {
            this.sqlType = JDBCType.VARBINARY;
            this.hostType = (short)26;
        } else {
            throw new CtreeSQLException(26065);
        }
        this.data = object;
    }

    public boolean isNull() {
        return this.data == null;
    }

    void checkForNull() throws SQLException {
        if (this.isNull()) {
            throw new SQLException("NULL value");
        }
    }

    public void makeNull() {
        this.data = null;
    }

    void checkForType() throws SQLException {
        switch ((JDBCType)this.sqlType) {
            case NUMERIC: 
            case BIGINT: 
            case INTEGER: 
            case SMALLINT: 
            case TINYINT: 
            case BIT: 
            case DATE: 
            case TIME: 
            case TIMESTAMP: 
            case REAL: 
            case FLOAT: 
            case DOUBLE: 
            case CHAR: 
            case VARCHAR: 
            case CLOB: 
            case LONGVARCHAR: 
            case BINARY: 
            case VARBINARY: 
            case BLOB: 
            case LONGVARBINARY: 
            case DECIMAL: {
                break;
            }
            default: {
                this.reportUnknownTypeError(this.hostType);
            }
        }
    }

    void print() throws SQLException {
        switch ((JDBCType)this.sqlType) {
            case TINYINT: {
                break;
            }
            case SMALLINT: {
                break;
            }
            case INTEGER: {
                break;
            }
            case BIGINT: {
                break;
            }
            case REAL: {
                break;
            }
            case FLOAT: {
                break;
            }
            case DOUBLE: {
                break;
            }
            case NUMERIC: {
                break;
            }
            case DECIMAL: {
                break;
            }
            case BIT: {
                break;
            }
            case CHAR: {
                break;
            }
            case VARCHAR: {
                break;
            }
            case LONGVARCHAR: {
                break;
            }
            case BINARY: {
                break;
            }
            case VARBINARY: {
                break;
            }
            case BLOB: {
                break;
            }
            case CLOB: {
                break;
            }
            case LONGVARBINARY: {
                break;
            }
            case DATE: {
                break;
            }
            case TIME: {
                break;
            }
            case TIMESTAMP: {
                break;
            }
            default: {
                this.reportUnknownTypeError(this.hostType);
            }
        }
    }

    public String getString() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        String string = null;
        switch ((JDBCType)this.sqlType) {
            case BINARY: 
            case VARBINARY: {
                byte[] byArray = (byte[])this.data;
                int n = byArray.length;
                String string2 = "0123456789ABCDEF";
                char[] cArray = new char[n * 2];
                for (int i = 0; i < n; ++i) {
                    cArray[i * 2] = string2.charAt(byArray[i] >> 4 & 0xF);
                    cArray[i * 2 + 1] = string2.charAt(byArray[i] & 0xF);
                }
                string = new String(cArray);
                break;
            }
            default: {
                string = this.data.toString();
            }
        }
        return string;
    }

    public byte[] getBytes() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        byte[] byArray = null;
        switch ((JDBCType)this.sqlType) {
            case CHAR: 
            case VARCHAR: {
                return ((String)this.data).getBytes();
            }
            case BINARY: 
            case VARBINARY: {
                byArray = (byte[])this.data;
                break;
            }
            case CLOB: 
            case LONGVARCHAR: 
            case BLOB: 
            case LONGVARBINARY: {
                this.reportUnsupportedConvError(this.sqlType, (SQLType)JDBCType.BINARY);
            }
            default: {
                this.reportInvalidConvError(this.sqlType, (SQLType)JDBCType.BINARY);
            }
        }
        return byArray;
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        if (this.isNull()) {
            return null;
        }
        switch ((JDBCType)this.sqlType) {
            case TINYINT: {
                return new BigDecimal(((Byte)this.data).longValue()).setScale(n, RoundingMode.DOWN);
            }
            case SMALLINT: {
                return new BigDecimal(((Short)this.data).longValue()).setScale(n, RoundingMode.DOWN);
            }
            case INTEGER: {
                return new BigDecimal(((Integer)this.data).longValue()).setScale(n, RoundingMode.DOWN);
            }
            case BIGINT: {
                if (n == -475) {
                    return new BigDecimal((Long)this.data);
                }
                return new BigDecimal((Long)this.data).setScale(n, RoundingMode.DOWN);
            }
            case REAL: {
                if (n == -475) {
                    return new BigDecimal(((Float)this.data).doubleValue());
                }
                return new BigDecimal(((Float)this.data).doubleValue()).setScale(n, RoundingMode.DOWN);
            }
            case FLOAT: 
            case DOUBLE: {
                if (n == -475) {
                    return new BigDecimal((Double)this.data);
                }
                return new BigDecimal((Double)this.data).setScale(n, RoundingMode.DOWN);
            }
            case NUMERIC: 
            case DECIMAL: {
                if (n == -475) {
                    return (BigDecimal)this.data;
                }
                return ((BigDecimal)this.data).setScale(n, RoundingMode.DOWN);
            }
            case BIT: {
                if (((Boolean)this.data).booleanValue()) {
                    return new BigDecimal(1L).setScale(n, RoundingMode.DOWN);
                }
                return new BigDecimal(0L).setScale(n, RoundingMode.DOWN);
            }
            case CHAR: 
            case VARCHAR: {
                BigDecimal bigDecimal = new BigDecimal(((String)this.data).trim());
                if (n == -475) {
                    return bigDecimal;
                }
                return bigDecimal.setScale(n, 1);
            }
            case CLOB: 
            case LONGVARCHAR: {
                this.reportUnsupportedConvError(this.sqlType, (SQLType)JDBCType.NUMERIC);
            }
        }
        this.reportInvalidConvError(this.sqlType, (SQLType)JDBCType.NUMERIC);
        return null;
    }

    public Long getLong() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        this.checkForType();
        switch ((JDBCType)this.sqlType) {
            case TINYINT: {
                return ((Byte)this.data).longValue();
            }
            case SMALLINT: {
                return ((Short)this.data).longValue();
            }
            case INTEGER: {
                return ((Integer)this.data).longValue();
            }
            case BIGINT: {
                return (Long)this.data;
            }
            case REAL: {
                float f = ((Float)this.data).floatValue();
                if (f > 9.223372E18f || f < -9.223372E18f) {
                    throw new CtreeSQLException(26034);
                }
                return ((Float)this.data).longValue();
            }
            case FLOAT: 
            case DOUBLE: {
                double d = (Double)this.data;
                if (d > 9.223372036854776E18 || d < -9.223372036854776E18) {
                    throw new CtreeSQLException(26034);
                }
                return ((Double)this.data).longValue();
            }
            case NUMERIC: 
            case DECIMAL: {
                if (((BigDecimal)this.data).compareTo(new BigDecimal(Long.MAX_VALUE)) == 1 || ((BigDecimal)this.data).compareTo(new BigDecimal(Long.MIN_VALUE)) == -1) {
                    throw new CtreeSQLException(26034);
                }
                return ((BigDecimal)this.data).longValue();
            }
            case BIT: {
                if (((Boolean)this.data).booleanValue()) {
                    return 1L;
                }
                return 0L;
            }
            case CHAR: 
            case VARCHAR: {
                Double d = Double.valueOf((String)this.data);
                if (d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) {
                    throw new CtreeSQLException(26034);
                }
                if (d <= 9.223372036854776E18 && d >= -9.223372036854776E18) {
                    return d.longValue();
                }
                throw new CtreeSQLException(26034);
            }
            case CLOB: 
            case LONGVARCHAR: {
                this.reportUnsupportedConvError(this.sqlType, (SQLType)JDBCType.BIGINT);
            }
        }
        this.reportInvalidConvError(this.sqlType, (SQLType)JDBCType.BIGINT);
        return null;
    }

    public Integer getInteger() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        switch ((JDBCType)this.sqlType) {
            case TINYINT: {
                return ((Byte)this.data).intValue();
            }
            case SMALLINT: {
                return ((Short)this.data).intValue();
            }
            case INTEGER: {
                return (Integer)this.data;
            }
            case BIGINT: {
                long l = (Long)this.data;
                if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
                    throw new CtreeSQLException(26034);
                }
                return ((Long)this.data).intValue();
            }
            case REAL: {
                float f = ((Float)this.data).floatValue();
                if (f > 2.1474836E9f || f < -2.1474836E9f) {
                    throw new CtreeSQLException(26034);
                }
                return ((Float)this.data).intValue();
            }
            case FLOAT: 
            case DOUBLE: {
                double d = (Double)this.data;
                if (d > 2.147483647E9 || d < -2.147483648E9) {
                    throw new CtreeSQLException(26034);
                }
                return ((Double)this.data).intValue();
            }
            case NUMERIC: 
            case DECIMAL: {
                double d = ((BigDecimal)this.data).doubleValue();
                if (d > 2.147483647E9 || d < -2.147483648E9) {
                    throw new CtreeSQLException(26034);
                }
                return ((BigDecimal)this.data).intValue();
            }
            case BIT: {
                if (((Boolean)this.data).booleanValue()) {
                    return 1;
                }
                return 0;
            }
            case CHAR: 
            case VARCHAR: {
                Double d = Double.valueOf((String)this.data);
                if (d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) {
                    throw new CtreeSQLException(26034);
                }
                if (d <= 2.147483647E9 && d >= -2.147483648E9) {
                    return d.intValue();
                }
                throw new CtreeSQLException(26034);
            }
            case CLOB: 
            case LONGVARCHAR: {
                this.reportUnsupportedConvError(this.sqlType, (SQLType)JDBCType.INTEGER);
            }
        }
        this.reportInvalidConvError(this.sqlType, (SQLType)JDBCType.INTEGER);
        return null;
    }

    public Short getShort() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        switch ((JDBCType)this.sqlType) {
            case TINYINT: {
                return ((Byte)this.data).shortValue();
            }
            case SMALLINT: {
                return (Short)this.data;
            }
            case INTEGER: {
                int n = (Integer)this.data;
                if (n > Short.MAX_VALUE || n < Short.MIN_VALUE) {
                    throw new CtreeSQLException(26034);
                }
                return ((Integer)this.data).shortValue();
            }
            case BIGINT: {
                long l = (Long)this.data;
                if (l > 32767L || l < -32768L) {
                    throw new CtreeSQLException(26034);
                }
                return ((Long)this.data).shortValue();
            }
            case REAL: {
                float f = ((Float)this.data).floatValue();
                if (f > 32767.0f || f < -32768.0f) {
                    throw new CtreeSQLException(26034);
                }
                return ((Float)this.data).shortValue();
            }
            case FLOAT: 
            case DOUBLE: {
                double d = (Double)this.data;
                if (d > 32767.0 || d < -32768.0) {
                    throw new CtreeSQLException(26034);
                }
                return ((Double)this.data).shortValue();
            }
            case NUMERIC: 
            case DECIMAL: {
                double d = ((BigDecimal)this.data).doubleValue();
                if (d > 32767.0 || d < -32768.0) {
                    throw new CtreeSQLException(26034);
                }
                return ((BigDecimal)this.data).shortValue();
            }
            case BIT: {
                if (((Boolean)this.data).booleanValue()) {
                    return (short)1;
                }
                return (short)0;
            }
            case CHAR: 
            case VARCHAR: {
                Double d = Double.valueOf((String)this.data);
                if (d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) {
                    throw new CtreeSQLException(26034);
                }
                if (d <= 32767.0 && d >= -32768.0) {
                    return d.shortValue();
                }
                throw new CtreeSQLException(26034);
            }
            case CLOB: 
            case LONGVARCHAR: {
                this.reportUnsupportedConvError(this.sqlType, (SQLType)JDBCType.SMALLINT);
            }
        }
        this.reportInvalidConvError(this.sqlType, (SQLType)JDBCType.SMALLINT);
        return null;
    }

    public Byte getByte() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        switch ((JDBCType)this.sqlType) {
            case TINYINT: {
                return (Byte)this.data;
            }
            case SMALLINT: {
                short s = (Short)this.data;
                if (s > 127 || s < -128) {
                    throw new CtreeSQLException(26034);
                }
                return ((Short)this.data).byteValue();
            }
            case INTEGER: {
                int n = (Integer)this.data;
                if (n > 127 || n < -128) {
                    throw new CtreeSQLException(26034);
                }
                return ((Integer)this.data).byteValue();
            }
            case BIGINT: {
                long l = (Long)this.data;
                if (l > 127L || l < -128L) {
                    throw new CtreeSQLException(26034);
                }
                return ((Long)this.data).byteValue();
            }
            case REAL: {
                float f = ((Float)this.data).floatValue();
                if (f > 127.0f || f < -128.0f) {
                    throw new CtreeSQLException(26034);
                }
                return ((Float)this.data).byteValue();
            }
            case FLOAT: 
            case DOUBLE: {
                double d = (Double)this.data;
                if (d > 127.0 || d < -128.0) {
                    throw new CtreeSQLException(26034);
                }
                return ((Double)this.data).byteValue();
            }
            case NUMERIC: 
            case DECIMAL: {
                double d = ((BigDecimal)this.data).doubleValue();
                if (d > 127.0 || d < -128.0) {
                    throw new CtreeSQLException(26034);
                }
                return ((BigDecimal)this.data).byteValue();
            }
            case BIT: {
                if (((Boolean)this.data).booleanValue()) {
                    return (byte)1;
                }
                return (byte)0;
            }
            case CHAR: 
            case VARCHAR: {
                Double d = Double.valueOf((String)this.data);
                if (d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) {
                    throw new CtreeSQLException(26034);
                }
                if (d <= 127.0 && d >= -128.0) {
                    return d.byteValue();
                }
                throw new CtreeSQLException(26034);
            }
            case CLOB: 
            case LONGVARCHAR: {
                this.reportUnsupportedConvError(this.sqlType, (SQLType)JDBCType.TINYINT);
            }
        }
        this.reportInvalidConvError(this.sqlType, (SQLType)JDBCType.TINYINT);
        return null;
    }

    public Boolean getBoolean() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        switch ((JDBCType)this.sqlType) {
            case TINYINT: {
                byte by = (Byte)this.data;
                if (by == 0) {
                    return false;
                }
                if (by == 1) {
                    return true;
                }
                throw new CtreeSQLException(26034);
            }
            case SMALLINT: {
                short s = (Short)this.data;
                if (s == 0) {
                    return false;
                }
                if (s == 1) {
                    return true;
                }
                throw new CtreeSQLException(26034);
            }
            case INTEGER: {
                int n = (Integer)this.data;
                if (n == 0) {
                    return false;
                }
                if (n == 1) {
                    return true;
                }
                throw new CtreeSQLException(26034);
            }
            case BIGINT: {
                long l = (Long)this.data;
                if (l == 0L) {
                    return false;
                }
                if (l == 1L) {
                    return true;
                }
                throw new CtreeSQLException(26034);
            }
            case REAL: {
                float f = ((Float)this.data).floatValue();
                if (f == 0.0f) {
                    return false;
                }
                if (f == 1.0f) {
                    return true;
                }
                throw new CtreeSQLException(26034);
            }
            case FLOAT: 
            case DOUBLE: {
                double d = (Double)this.data;
                if (d == 0.0) {
                    return false;
                }
                if (d == 1.0) {
                    return true;
                }
                throw new CtreeSQLException(26034);
            }
            case NUMERIC: 
            case DECIMAL: {
                double d = ((BigDecimal)this.data).doubleValue();
                if (d > 1.0 || d < 0.0) {
                    throw new CtreeSQLException(26034);
                }
                if (((BigDecimal)this.data).intValue() == 0) {
                    return false;
                }
                return true;
            }
            case BIT: {
                return (Boolean)this.data;
            }
            case CHAR: 
            case VARCHAR: {
                String string = ((String)this.data).trim();
                if (string.equals("1") || string.toUpperCase().trim().equals("TRUE")) {
                    return true;
                }
                if (string.equals("0") || string.toUpperCase().trim().equals("FALSE")) {
                    return false;
                }
                if (Integer.valueOf(string) < 0 || Integer.valueOf(string) >= 2) {
                    throw new CtreeSQLException(26034);
                }
                throw new CtreeSQLException(26052);
            }
            case CLOB: 
            case LONGVARCHAR: {
                this.reportUnsupportedConvError(this.sqlType, (SQLType)JDBCType.BIT);
            }
        }
        this.reportInvalidConvError(this.sqlType, (SQLType)JDBCType.BIT);
        return null;
    }

    public Float getFloat() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        switch ((JDBCType)this.sqlType) {
            case TINYINT: {
                return Float.valueOf(((Byte)this.data).floatValue());
            }
            case SMALLINT: {
                return Float.valueOf(((Short)this.data).floatValue());
            }
            case INTEGER: {
                return Float.valueOf(((Integer)this.data).floatValue());
            }
            case BIGINT: {
                return Float.valueOf(((Long)this.data).floatValue());
            }
            case REAL: {
                return (Float)this.data;
            }
            case FLOAT: 
            case DOUBLE: {
                double d = (Double)this.data;
                if (d > 3.4028234663852886E38 && d < 1.4E-45) {
                    throw new CtreeSQLException(26034);
                }
                return Float.valueOf(((Double)this.data).floatValue());
            }
            case NUMERIC: 
            case DECIMAL: {
                double d = ((BigDecimal)this.data).doubleValue();
                if (d > 3.4028234663852886E38 || d < 1.4E-45) {
                    throw new CtreeSQLException(26034);
                }
                return Float.valueOf(((BigDecimal)this.data).floatValue());
            }
            case BIT: {
                if (((Boolean)this.data).booleanValue()) {
                    return Float.valueOf(1.0f);
                }
                return Float.valueOf(0.0f);
            }
            case CHAR: 
            case VARCHAR: {
                Double d = Double.valueOf((String)this.data);
                if (d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) {
                    throw new CtreeSQLException(26034);
                }
                if (d <= 3.4028234663852886E38 && d >= 1.4E-45) {
                    return Float.valueOf(d.floatValue());
                }
                throw new CtreeSQLException(26034);
            }
            case CLOB: 
            case LONGVARCHAR: {
                this.reportUnsupportedConvError(this.sqlType, (SQLType)JDBCType.REAL);
            }
        }
        this.reportInvalidConvError(this.sqlType, (SQLType)JDBCType.REAL);
        return null;
    }

    public Double getDouble() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        switch ((JDBCType)this.sqlType) {
            case TINYINT: {
                return ((Byte)this.data).doubleValue();
            }
            case SMALLINT: {
                return ((Short)this.data).doubleValue();
            }
            case INTEGER: {
                return ((Integer)this.data).doubleValue();
            }
            case BIGINT: {
                return ((Long)this.data).doubleValue();
            }
            case REAL: {
                return ((Float)this.data).doubleValue();
            }
            case FLOAT: 
            case DOUBLE: {
                return (Double)this.data;
            }
            case NUMERIC: 
            case DECIMAL: {
                return ((BigDecimal)this.data).doubleValue();
            }
            case BIT: {
                if (((Boolean)this.data).booleanValue()) {
                    return 1.0;
                }
                return 0.0;
            }
            case CHAR: 
            case VARCHAR: {
                Double d = Double.valueOf((String)this.data);
                if (d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) {
                    throw new CtreeSQLException(26034);
                }
                if (d <= Double.MAX_VALUE && d >= Double.MIN_VALUE) {
                    return d;
                }
                throw new CtreeSQLException(26034);
            }
            case CLOB: 
            case LONGVARCHAR: {
                this.reportUnsupportedConvError(this.sqlType, (SQLType)JDBCType.DOUBLE);
            }
        }
        this.reportInvalidConvError(this.sqlType, (SQLType)JDBCType.DOUBLE);
        return null;
    }

    public Date getDate() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        switch ((JDBCType)this.sqlType) {
            case NUMERIC: 
            case BIGINT: 
            case INTEGER: 
            case SMALLINT: 
            case TINYINT: 
            case BIT: 
            case REAL: 
            case FLOAT: 
            case DOUBLE: 
            case DECIMAL: {
                this.reportInvalidConvError(this.sqlType, (SQLType)JDBCType.DATE);
            }
            case CHAR: 
            case VARCHAR: {
                try {
                    Date date = Date.valueOf(((String)this.data).trim());
                    return date;
                }
                catch (Exception exception) {
                    throw new CtreeSQLException("Improper format of the date string\nExpected date string format: yyyy-mm-dd.", 26065);
                }
            }
            case CLOB: 
            case LONGVARCHAR: {
                this.reportUnsupportedConvError(this.sqlType, (SQLType)JDBCType.DATE);
            }
            case BINARY: 
            case VARBINARY: 
            case BLOB: 
            case LONGVARBINARY: {
                this.reportInvalidConvError(this.hostType, (SQLType)JDBCType.DATE);
            }
            case DATE: {
                return (Date)this.data;
            }
            case TIME: {
                this.reportInvalidConvError(this.hostType, (SQLType)JDBCType.DATE);
            }
            case TIMESTAMP: {
                return new Date(((Timestamp)this.data).getTime());
            }
        }
        this.reportInvalidConvError(this.hostType, (SQLType)JDBCType.DATE);
        return null;
    }

    public Time getTime() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        switch ((JDBCType)this.sqlType) {
            case NUMERIC: 
            case BIGINT: 
            case INTEGER: 
            case SMALLINT: 
            case TINYINT: 
            case BIT: 
            case REAL: 
            case FLOAT: 
            case DOUBLE: 
            case DECIMAL: {
                this.reportInvalidConvError(this.hostType, (SQLType)JDBCType.TIME);
            }
            case CHAR: 
            case VARCHAR: {
                try {
                    Time time = Time.valueOf(((String)this.data).trim());
                    return time;
                }
                catch (Exception exception) {
                    throw new CtreeSQLException("Improper format of the Time string\nExpected Time string format: hh:mm:ss.", 26065);
                }
            }
            case CLOB: 
            case LONGVARCHAR: {
                this.reportUnsupportedConvError(this.hostType, (SQLType)JDBCType.TIME);
            }
            case DATE: 
            case BINARY: 
            case VARBINARY: 
            case BLOB: 
            case LONGVARBINARY: {
                this.reportInvalidConvError(this.hostType, (SQLType)JDBCType.TIME);
            }
            case TIME: {
                return (Time)this.data;
            }
            case TIMESTAMP: {
                return new Time(((Timestamp)this.data).getTime());
            }
        }
        this.reportInvalidConvError(this.hostType, (SQLType)JDBCType.TIME);
        return null;
    }

    public Timestamp getTimestamp() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        switch ((JDBCType)this.sqlType) {
            case NUMERIC: 
            case BIGINT: 
            case INTEGER: 
            case SMALLINT: 
            case TINYINT: 
            case BIT: 
            case REAL: 
            case FLOAT: 
            case DOUBLE: 
            case DECIMAL: {
                this.reportInvalidConvError(this.hostType, (SQLType)JDBCType.TIMESTAMP);
            }
            case CHAR: 
            case VARCHAR: {
                try {
                    Timestamp timestamp = Timestamp.valueOf(((String)this.data).trim());
                    return timestamp;
                }
                catch (Exception exception) {
                    throw new CtreeSQLException("Improper format of the Timestamp string\nExpected Timestamp string format: yyyy-mm-dd hh:mm:ss.fffffffff.", 26065);
                }
            }
            case CLOB: 
            case LONGVARCHAR: {
                this.reportUnsupportedConvError(this.hostType, (SQLType)JDBCType.TIMESTAMP);
            }
            case DATE: 
            case BINARY: 
            case VARBINARY: 
            case BLOB: 
            case LONGVARBINARY: {
                return new Timestamp(((Date)this.data).getTime());
            }
            case TIME: {
                return new Timestamp(((Time)this.data).getTime());
            }
            case TIMESTAMP: {
                return (Timestamp)this.data;
            }
        }
        return new Timestamp(((Time)this.data).getTime());
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public int available() {
        return this.length;
    }

    public Reader getCharacterStream() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        switch ((JDBCType)this.sqlType) {
            case CHAR: 
            case VARCHAR: {
                StringReader stringReader = new StringReader(this.getString());
                return stringReader;
            }
            case BINARY: 
            case VARBINARY: {
                return new InputStreamReader(new CtreeHexToCharModulatorStream(new ByteArrayInputStream(this.getBytes())));
            }
        }
        this.reportInvalidConvError(this.hostType, (SQLType)JDBCType.CHAR);
        return null;
    }

    public InputStream getAsciiStream() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        switch ((JDBCType)this.sqlType) {
            case CHAR: 
            case VARCHAR: {
                return new ByteArrayInputStream(this.getString().getBytes());
            }
            case BINARY: 
            case VARBINARY: {
                return new CtreeHexToCharModulatorStream(new ByteArrayInputStream(this.getBytes()));
            }
        }
        this.reportInvalidConvError(this.hostType, (SQLType)JDBCType.CHAR);
        return null;
    }

    public InputStream getUnicodeStream() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return new CtreeUnicodeInputStream(this.getAsciiStream());
    }

    public InputStream getBinaryStream() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        switch ((JDBCType)this.sqlType) {
            case BINARY: 
            case VARBINARY: {
                return new ByteArrayInputStream(this.getBytes());
            }
            case CHAR: 
            case VARCHAR: {
                return this.getAsciiStream();
            }
        }
        this.reportInvalidConvError(this.hostType, (SQLType)JDBCType.BINARY);
        return null;
    }

    public Object getObject() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        switch ((JDBCType)this.sqlType) {
            case TINYINT: {
                return ((Byte)this.data).intValue();
            }
            case SMALLINT: {
                return ((Short)this.data).intValue();
            }
            case FLOAT: {
                return (double)((Double)this.data);
            }
        }
        return this.data;
    }

    public SQLType getType() {
        return this.sqlType;
    }

    public int getHostType() {
        return this.hostType;
    }

    public long getLongValue() throws SQLException {
        return this.getLong();
    }

    public int getIntegerValue() throws SQLException {
        return this.getInteger();
    }

    public short getShortValue() throws SQLException {
        return this.getShort();
    }

    public byte getByteValue() throws SQLException {
        return this.getByte();
    }

    public boolean getBooleanValue() throws SQLException {
        return this.getBoolean();
    }

    public float getFloatValue() throws SQLException {
        return this.getFloat().floatValue();
    }

    public double getDoubleValue() throws SQLException {
        return this.getDouble();
    }

    public SQLType getSqlType() {
        return this.sqlType;
    }

    private void reportUnknownTypeError(SQLType sQLType) throws SQLException {
        throw new CtreeSQLException("Unknown type error " + sQLType, 26065);
    }

    private void reportUnknownTypeError(short s) throws SQLException {
        throw new CtreeSQLException("Unknown type error " + s, 26065);
    }

    private void reportUnsupportedConvError(int n, SQLType sQLType) throws SQLException {
        throw new CtreeSQLException("Unsupported conversion error from " + CtreeValue.getHostTypeName(n) + " to " + CtreeValue.getSqlTypeName(sQLType), 26065);
    }

    private void reportUnsupportedConvError(SQLType sQLType, SQLType sQLType2) throws SQLException {
        throw new CtreeSQLException("Unsupported conversion error from " + CtreeValue.getSqlTypeName(sQLType) + " to " + CtreeValue.getSqlTypeName(sQLType2), 26065);
    }

    private void reportInvalidConvError(int n, SQLType sQLType) throws SQLException {
        throw new CtreeSQLException("Invalid conversion error from " + CtreeValue.getHostTypeName(n) + " to " + CtreeValue.getSqlTypeName(sQLType), 26065);
    }

    private void reportInvalidConvError(SQLType sQLType, SQLType sQLType2) throws SQLException {
        throw new CtreeSQLException("Invalid conversion error from " + CtreeValue.getSqlTypeName(sQLType) + " to " + CtreeValue.getSqlTypeName(sQLType2), 26065);
    }

    public void marshal(SQLPacket sQLPacket) throws IOException, CtreeSQLException {
        DataOutputStream dataOutputStream = sQLPacket.getOutputStream();
        switch ((JDBCType)this.sqlType) {
            case TINYINT: {
                dataOutputStream.writeInt(((Byte)this.data).intValue());
                break;
            }
            case SMALLINT: {
                dataOutputStream.writeInt(((Short)this.data).intValue());
                break;
            }
            case INTEGER: {
                dataOutputStream.writeInt((Integer)this.data);
                break;
            }
            case BIGINT: {
                long l = (Long)this.data;
                dataOutputStream.writeInt((int)l);
                dataOutputStream.writeInt((int)(l >>> 32) & 0xFFFFFFFF);
                break;
            }
            case REAL: {
                dataOutputStream.writeFloat(((Float)this.data).floatValue());
                break;
            }
            case FLOAT: 
            case DOUBLE: {
                dataOutputStream.writeDouble((Double)this.data);
                break;
            }
            case NUMERIC: 
            case DECIMAL: {
                if (CtreeValue.isCharType(this.hostType)) {
                    sQLPacket.marshalString((String)this.data);
                    break;
                }
                sQLPacket.marshalNum((BigDecimal)this.data);
                break;
            }
            case BIT: {
                dataOutputStream.writeInt(1);
                dataOutputStream.writeBoolean((Boolean)this.data);
                byte[] byArray = new byte[]{0, 0, 0};
                dataOutputStream.write(byArray, 0, 3);
                break;
            }
            case CHAR: 
            case VARCHAR: 
            case CLOB: 
            case LONGVARCHAR: {
                sQLPacket.marshalString((String)this.data);
                break;
            }
            case BINARY: 
            case VARBINARY: {
                byte[] byArray = (byte[])this.data;
                dataOutputStream.writeInt(byArray.length);
                byte[] byArray2 = new byte[]{0, 0, 0, 0};
                dataOutputStream.write(byArray, 0, byArray.length);
                int n = byArray.length % 4;
                if (n <= 0) break;
                dataOutputStream.write(byArray2, 0, 4 - n);
                break;
            }
            case BLOB: 
            case LONGVARBINARY: {
                sQLPacket.marshalString((String)this.data);
                break;
            }
            case DATE: {
                if (CtreeValue.isCharType(this.hostType)) {
                    sQLPacket.marshalString((String)this.data);
                    break;
                }
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.clear();
                gregorianCalendar.setTime(new java.util.Date(((Date)this.data).getTime()));
                dataOutputStream.writeShort(gregorianCalendar.get(1));
                dataOutputStream.writeByte(gregorianCalendar.get(2) + 1);
                dataOutputStream.writeByte(gregorianCalendar.get(5));
                break;
            }
            case TIME: {
                if (CtreeValue.isCharType(this.hostType)) {
                    sQLPacket.marshalString((String)this.data);
                    break;
                }
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(((Time)this.data).getTime());
                dataOutputStream.writeInt(calendar.get(14));
                dataOutputStream.writeShort(calendar.get(13));
                dataOutputStream.writeByte(calendar.get(12));
                dataOutputStream.writeByte(calendar.get(11));
                break;
            }
            case TIMESTAMP: {
                if (CtreeValue.isCharType(this.hostType)) {
                    sQLPacket.marshalString((String)this.data);
                    break;
                }
                Timestamp timestamp = (Timestamp)this.data;
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(timestamp.getTime());
                dataOutputStream.writeShort(calendar.get(1));
                dataOutputStream.writeByte(calendar.get(2) + 1);
                dataOutputStream.writeByte(calendar.get(5));
                dataOutputStream.writeInt(calendar.get(14));
                dataOutputStream.writeShort(calendar.get(13));
                dataOutputStream.writeByte(calendar.get(12));
                dataOutputStream.writeByte(calendar.get(11));
            }
        }
    }

    public void unmarshal(SQLPacket sQLPacket) throws IOException {
        DataInputStream dataInputStream = sQLPacket.getInputStream();
        this.unmarshal(sQLPacket, this.hostType);
    }

    public void unmarshal(SQLPacket sQLPacket, short s) throws IOException {
        DataInputStream dataInputStream = sQLPacket.getInputStream();
        this.hostType = s;
        this.setSqlType(s);
        switch ((JDBCType)this.sqlType) {
            case TINYINT: {
                this.data = (byte)dataInputStream.readInt();
                break;
            }
            case SMALLINT: {
                this.data = (short)dataInputStream.readInt();
                break;
            }
            case INTEGER: {
                this.data = dataInputStream.readInt();
                break;
            }
            case BIGINT: {
                this.data = ((long)dataInputStream.readInt() & 0xFFFFFFFFL) + ((long)dataInputStream.readInt() << 32);
                break;
            }
            case REAL: {
                this.data = Float.valueOf(dataInputStream.readFloat());
                break;
            }
            case FLOAT: 
            case DOUBLE: {
                this.data = dataInputStream.readDouble();
                break;
            }
            case NUMERIC: 
            case DECIMAL: {
                this.data = new BigDecimal(sQLPacket.unmarshalNum());
                this.hostType = (short)2;
                break;
            }
            case BIT: {
                dataInputStream.readInt();
                this.data = dataInputStream.readBoolean();
                dataInputStream.skipBytes(3);
                break;
            }
            case CHAR: 
            case VARCHAR: 
            case CLOB: 
            case LONGVARCHAR: {
                this.data = sQLPacket.unmarshalString();
                break;
            }
            case BINARY: 
            case VARBINARY: {
                byte[] byArray = sQLPacket.unmarshallBinary();
                this.data = byArray;
                break;
            }
            case BLOB: 
            case LONGVARBINARY: {
                this.data = sQLPacket.unmarshalString();
                break;
            }
            case DATE: {
                if (CtreeValue.isCharType(this.hostType)) {
                    this.data = Date.valueOf(sQLPacket.unmarshalString());
                    break;
                }
                short s2 = dataInputStream.readShort();
                byte by = dataInputStream.readByte();
                byte by2 = dataInputStream.readByte();
                GregorianCalendar gregorianCalendar = new GregorianCalendar(s2, by - 1, by2);
                this.data = new Date(gregorianCalendar.getTime().getTime());
                break;
            }
            case TIME: {
                if (CtreeValue.isCharType(this.hostType)) {
                    this.data = Time.valueOf(sQLPacket.unmarshalString());
                    break;
                }
                int n = dataInputStream.readInt();
                short s3 = dataInputStream.readShort();
                byte by = dataInputStream.readByte();
                byte by3 = dataInputStream.readByte();
                Time time = new Time(by3, by, s3);
                this.data = new Time(time.getTime() + (long)n);
                break;
            }
            case TIMESTAMP: {
                if (CtreeValue.isCharType(this.hostType)) {
                    this.data = Timestamp.valueOf(sQLPacket.unmarshalString());
                    break;
                }
                short s4 = dataInputStream.readShort();
                byte by = dataInputStream.readByte();
                byte by4 = dataInputStream.readByte();
                int n = dataInputStream.readInt();
                n *= 1000000;
                short s5 = dataInputStream.readShort();
                byte by5 = dataInputStream.readByte();
                byte by6 = dataInputStream.readByte();
                Calendar calendar = Calendar.getInstance();
                calendar.set(s4, by - 1, by4, by6, by5, s5);
                this.data = new Timestamp(calendar.getTimeInMillis());
                ((Timestamp)this.data).setNanos(n);
                break;
            }
        }
    }

    public void setSqlType(short s) {
        switch (s) {
            case 4: {
                this.sqlType = JDBCType.INTEGER;
                break;
            }
            case 16: {
                this.sqlType = JDBCType.BIGINT;
                break;
            }
            case 3: {
                this.sqlType = JDBCType.SMALLINT;
                break;
            }
            case 11: {
                this.sqlType = JDBCType.TINYINT;
                break;
            }
            case 13: {
                this.sqlType = JDBCType.BIT;
                break;
            }
            case 2: 
            case 8: {
                this.sqlType = JDBCType.NUMERIC;
                break;
            }
            case 5: {
                this.sqlType = JDBCType.REAL;
                break;
            }
            case 6: {
                this.sqlType = JDBCType.FLOAT;
                break;
            }
            case 7: {
                this.sqlType = JDBCType.DATE;
                break;
            }
            case 9: {
                this.sqlType = JDBCType.TIME;
                break;
            }
            case 10: {
                this.sqlType = JDBCType.TIMESTAMP;
                break;
            }
            case 1: 
            case 17: {
                this.sqlType = JDBCType.CHAR;
                break;
            }
            case 18: 
            case 21: {
                this.sqlType = JDBCType.VARCHAR;
                break;
            }
            case 12: {
                this.sqlType = JDBCType.BINARY;
                break;
            }
            case 26: {
                this.sqlType = JDBCType.VARBINARY;
                break;
            }
            case 15: {
                this.sqlType = JDBCType.LONGVARBINARY;
                break;
            }
            case 22: {
                this.sqlType = JDBCType.BLOB;
                break;
            }
            case 23: {
                this.sqlType = JDBCType.CLOB;
                break;
            }
            case 14: 
            case 24: {
                this.sqlType = JDBCType.LONGVARCHAR;
                break;
            }
        }
    }

    public static boolean isCharType(short s) {
        return s == 1 || s == 17 || s == 21 || s == 18;
    }

    public void makeNotNull() {
        this.data = "";
    }

    private static String getHostTypeName(int n) {
        switch (n) {
            case -1: {
                return "ERROR";
            }
            case 1: {
                return "CHAR";
            }
            case 2: {
                return "NUMERIC";
            }
            case 3: {
                return "SMALLINT";
            }
            case 4: {
                return "INTEGER";
            }
            case 5: {
                return "REAL";
            }
            case 6: {
                return "FLOAT";
            }
            case 7: {
                return "DATE";
            }
            case 8: {
                return "MONEY";
            }
            case 9: {
                return "TIME";
            }
            case 10: {
                return "TIMESTAMP";
            }
            case 11: {
                return "TINYINT";
            }
            case 12: {
                return "BINARY";
            }
            case 13: {
                return "BIT";
            }
            case 14: {
                return "LVARCHAR";
            }
            case 15: {
                return "LVARBINARY";
            }
            case 16: {
                return "BIGINT";
            }
            case 17: {
                return "NCHAR";
            }
            case 18: {
                return "NVARCHAR";
            }
            case 19: {
                return "NCHAR_CS";
            }
            case 20: {
                return "NVARCHAR_CS";
            }
            case 21: {
                return "VARCHAR";
            }
            case 22: {
                return "BLOB";
            }
            case 23: {
                return "CLOB";
            }
            case 24: {
                return "NLVARCHAR";
            }
            case 25: {
                return "NCLOB";
            }
        }
        return "Unknown";
    }

    private static String getSqlTypeName(SQLType sQLType) {
        switch ((JDBCType)sQLType) {
            case ARRAY: {
                return "ARRAY";
            }
            case BIGINT: {
                return "BIGINT";
            }
            case BINARY: {
                return "BINARY";
            }
            case BIT: {
                return "BIT";
            }
            case BLOB: {
                return "BLOB";
            }
            case BOOLEAN: {
                return "BOOLEAN";
            }
            case CHAR: {
                return "CHAR";
            }
            case CLOB: {
                return "CLOB";
            }
            case DATALINK: {
                return "DATALINK";
            }
            case DATE: {
                return "DATE";
            }
            case DECIMAL: {
                return "DECIMAL";
            }
            case DISTINCT: {
                return "DISTINCT";
            }
            case DOUBLE: {
                return "DOUBLE";
            }
            case FLOAT: {
                return "FLOAT";
            }
            case INTEGER: {
                return "INTEGER";
            }
            case JAVA_OBJECT: {
                return "JAVAOBJECT";
            }
            case LONGVARBINARY: {
                return "LVARBINARY";
            }
            case LONGVARCHAR: {
                return "LVARCHAR";
            }
            case NULL: {
                return "NULL";
            }
            case NUMERIC: {
                return "NUMERIC";
            }
            case OTHER: {
                return "OTHER";
            }
            case REAL: {
                return "REAL";
            }
            case REF: {
                return "REF";
            }
            case SMALLINT: {
                return "SMALLINT";
            }
            case STRUCT: {
                return "STRUCT";
            }
            case TIME: {
                return "TIME";
            }
            case TIMESTAMP: {
                return "TIMESTAMP";
            }
            case TINYINT: {
                return "TINYINT";
            }
            case VARBINARY: {
                return "VARBINARY";
            }
            case VARCHAR: {
                return "VARCHAR";
            }
        }
        return "Unknown";
    }
}

