/*
 * Decompiled with CFR 0.152.
 */
package ctree.jdbc;

import ctree.jdbc.CtreeError;
import ctree.jdbc.CtreeSQLException;
import ctree.jdbc.CtreeURL;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import java.math.BigDecimal;
import java.nio.charset.Charset;

public final class SQLPacket
implements CtreeError {
    byte[] buf;
    int length;
    boolean unicode = false;
    int charsize = 1;
    private Charset csm = null;
    ByteArrayOutputStream bout = null;
    DataOutputStream dout = null;
    ByteArrayInputStream bin = null;
    DataInputStream din = null;
    final byte[] paddingBuffer = new byte[]{0, 0, 0, 0};
    InputStream inputStream = null;

    public SQLPacket(int n, boolean bl, Charset charset) throws IOException {
        this.bout = new ByteArrayOutputStream();
        this.dout = new DataOutputStream(this.bout);
        this.unicode = bl;
        this.charsize = n;
        this.csm = charset;
    }

    public int charSize() {
        return this.charsize;
    }

    public boolean unicodeCompatibility() {
        return this.unicode;
    }

    public void reset() {
        this.bout.reset();
    }

    public DataOutputStream getOutputStream() {
        return this.dout;
    }

    public DataInputStream getInputStream() {
        return this.din;
    }

    public void setPacketData(byte[] byArray) throws IOException {
        this.buf = byArray;
        this.bin = new ByteArrayInputStream(this.buf);
        this.din = new DataInputStream(this.bin);
    }

    public void setPacketData(InputStream inputStream) throws IOException {
        this.bin = null;
        this.buf = null;
        this.inputStream = new BufferedInputStream(inputStream, 4096);
        this.din = new DataInputStream(this.inputStream);
    }

    public byte[] getPacketData() {
        return this.bout.toByteArray();
    }

    public void marshalByte(byte by) throws IOException {
        this.dout.writeByte(by);
    }

    public void marshalBoolean(boolean bl) throws IOException {
        this.dout.writeBoolean(bl);
    }

    public boolean unmarshalBoolean() throws IOException {
        return this.din.readBoolean();
    }

    public void marshalInt(int n) throws IOException {
        this.dout.writeInt(n);
    }

    public void marshalLong(long l) throws IOException {
        this.dout.writeLong(l);
    }

    public void marshalFloat(float f) throws IOException {
        this.dout.writeFloat(f);
    }

    public void marshalDouble(double d) throws IOException {
        this.dout.writeDouble(d);
    }

    public void marshalString(String string) throws IOException {
        if (string == null) {
            string = new String();
        }
        int n = 0;
        if (this.unicode) {
            n = string.length() * this.charSize();
            this.dout.writeInt(n);
            this.dout.writeChars(string);
        } else {
            n = this.ctreeWriteCSM(string);
        }
        int n2 = n % 4;
        if (n2 > 0) {
            this.dout.write(this.paddingBuffer, 0, 4 - n2);
        }
    }

    public byte unmarshalByte() throws IOException {
        return (byte)this.din.read();
    }

    public int unmarshalInt() throws IOException {
        return this.din.readInt();
    }

    public char unmarshalChar() throws IOException {
        return this.din.readChar();
    }

    public long unmarshalLong() throws IOException {
        return this.din.readLong();
    }

    public float unmarshalFloat() throws IOException {
        return this.din.readFloat();
    }

    public double unmarshalDouble() throws IOException {
        return this.din.readDouble();
    }

    public int getMessageLength() {
        return this.bout.size();
    }

    public String unmarshalString() throws IOException {
        String string;
        if (this.unicode) {
            char[] cArray = this.unmarshallChars();
            string = new String(cArray);
        } else {
            int n = this.din.readInt();
            string = this.ctreeReadCSM(n);
            int n2 = n % 4;
            if (n2 > 0) {
                this.din.skipBytes(4 - n2);
            }
        }
        return string;
    }

    public byte[] unmarshallBinary() throws IOException {
        int n;
        int n2 = this.din.readInt();
        byte[] byArray = new byte[n2];
        for (int i = 0; i < n2; i += n) {
            n = this.din.read(byArray, i, n2 - i);
            if (n >= 0) continue;
            throw new IOException("EOF while reading bytes");
        }
        n = n2 % 4;
        if (n > 0) {
            this.din.skipBytes(4 - n);
        }
        return byArray;
    }

    public char[] unmarshallChars() throws IOException {
        int n = this.din.readInt();
        int n2 = n / this.charSize();
        char[] cArray = new char[n2];
        int n3 = 0;
        while (n3 < n2) {
            cArray[n3++] = this.din.readChar();
        }
        int n4 = n % 4;
        if (n4 > 0) {
            this.din.skipBytes(4 - n4);
        }
        return cArray;
    }

    private int ctreeWriteCSM(String string) throws IOException {
        byte[] byArray = string.getBytes(this.getCharset().name());
        int n = byArray.length;
        if (n > 0x7FFFFFFB) {
            throw new UTFDataFormatException();
        }
        this.dout.writeInt(n);
        this.dout.write(byArray);
        return n + 4;
    }

    private String ctreeReadCSM(int n) throws IOException {
        byte[] byArray = new byte[n];
        this.din.readFully(byArray, 0, n);
        String string = new String(byArray, this.getCharset().name());
        return string;
    }

    public void marshalNum(BigDecimal bigDecimal) throws IOException, CtreeSQLException {
        int n;
        int n2;
        int n3;
        Object object;
        byte[] byArray = new byte[17];
        boolean bl = false;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 1;
        String string = bigDecimal.toString().trim();
        try {
            object = new BigDecimal(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new CtreeSQLException(26022);
        }
        object = new String(string);
        if (((String)object).charAt(0) == '-') {
            bl = true;
            object = ((String)object).substring(1);
        } else if (string.charAt(0) == '+') {
            bl = false;
            object = ((String)object).substring(1);
        }
        for (n3 = 0; n3 < ((String)object).length() && ((String)object).charAt(n3) != '.'; ++n3) {
            ++n4;
        }
        n5 = n3 < ((String)object).length() ? ((String)object).substring(n3 + 1).length() : 0;
        int n9 = ((String)object).indexOf(101);
        if (n9 != -1 || (n9 = ((String)object).indexOf(69)) != -1) {
            String string2 = ((String)object).substring(n9 + 1);
            n2 = new Integer(string2);
            n3 = string2.length() + 1;
            if (n5 > 0) {
                n5 -= n3;
            }
            if (((String)(object = ((String)object).substring(0, n9))).indexOf(46) == -1) {
                n4 -= n3;
            }
            if ((n6 += n2) % 2 > 0) {
                char[] cArray = ((String)object).toCharArray();
                --n6;
                n3 = ((String)object).length();
                if (n4 == n3) {
                    object = (String)object + '0';
                } else if (n4 == n3 - 1) {
                    cArray[n4] = 48;
                    object = new String(cArray);
                } else {
                    char c = ((String)object).charAt(n4 + 1);
                    cArray[n4 + 1] = 46;
                    cArray[n4] = c;
                    object = new String(cArray);
                    --n5;
                }
                ++n4;
            }
            n6 /= 2;
        }
        if (n4 + n6 * 2 < -128 || n4 + n6 * 2 > 126) {
            throw new CtreeSQLException(26034);
        }
        if (n4 >= 32) {
            if (n4 % 2 > 0) {
                n6 += (n4 + 1 - 32) / 2;
                n4 = 31;
                object = ((String)object).substring(0, n4);
            } else {
                n6 += (n4 - 32) / 2;
                n4 = 32;
                object = ((String)object).substring(0, n4);
            }
            n5 = 0;
        } else if (n4 + n5 > 32) {
            n5 = 32 - n4;
            object = ((String)object).substring(0, n4 + n5 + 1);
        }
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = ((String)object).charAt(n3++) - 48;
            if (n3 == 1 && n4 % 2 > 0) {
                if (bl) {
                    int n10 = n8;
                    n8 = (short)(n8 + 1);
                    byArray[n10] = (byte)(99 - n2);
                } else {
                    int n11 = n8;
                    n8 = (short)(n8 + 1);
                    byArray[n11] = (byte)n2;
                }
                --n3;
                continue;
            }
            if (n3 < n4) {
                n2 = 10 * n2 + (((String)object).charAt(n3) - 48);
            }
            if (bl) {
                int n12 = n8;
                n8 = (short)(n8 + 1);
                byArray[n12] = (byte)(99 - n2);
                continue;
            }
            int n13 = n8;
            n8 = (short)(n8 + 1);
            byArray[n13] = (byte)n2;
        }
        n7 = n8;
        for (n3 = n4 + 1; n3 < n4 + n5 + 1 && n8 < 17 && n3 < ((String)object).length(); ++n3) {
            n2 = ((String)object).charAt(n3++) - 48;
            if (n3 < n4 + n5 + 1 && n3 < ((String)object).length()) {
                n2 = 10 * n2 + (((String)object).charAt(n3) - 48);
            } else if (n5 % 2 > 0) {
                n2 *= 10;
            }
            if (bl) {
                int n14 = n8;
                n8 = (short)(n8 + 1);
                byArray[n14] = (byte)(99 - n2);
                continue;
            }
            int n15 = n8;
            n8 = (short)(n8 + 1);
            byArray[n15] = (byte)n2;
        }
        if (bl) {
            int n16 = n8 - 1;
            byArray[n16] = (byte)(byArray[n16] + 1);
            byArray[0] = (byte)(64 - (n7 + n6));
        } else {
            byArray[0] = (byte)(64 + (n7 + n6) - 1 + 128);
        }
        if (n8 > 17) {
            n8 = 17;
        }
        if ((n = n8) > 17) {
            n = 17;
        }
        for (n3 = n; n3 < 17; ++n3) {
            byArray[n3] = 0;
        }
        if (n > 0) {
            if (byArray[0] == 0) {
                byArray[0] = (byte)(byArray[0] + 128);
            }
            bl = (byArray[0] & 0x80) != 0;
        } else {
            bl = true;
        }
        if (bl) {
            while (byArray[n - 1] == 0 && n > 2) {
                n = (short)(n - 1);
            }
            while (n > 2 && byArray[1] == 0) {
                for (n3 = 1; n3 <= n - 2; ++n3) {
                    byArray[n3] = byArray[n3 + 1];
                }
                n6 = byArray[0] & 0x7F;
                if (--n6 <= 0) {
                    throw new CtreeSQLException(26034);
                }
                byArray[0] = (byte)(n6 | 0x80);
                n = (short)(n - 1);
                byArray[n] = 0;
            }
        } else {
            while (byArray[n - 1] == 100 && byArray[n - 2] == 99 && n > 2) {
                byArray[n - 2] = 100;
                n = (short)(n - 1);
            }
            while (n > 2 && byArray[1] == 99) {
                for (n3 = 1; n3 <= n - 2; ++n3) {
                    byArray[n3] = byArray[n3 + 1];
                }
                n6 = 64 - (byArray[0] & 0x7F) - 1;
                if (--n6 < -64) {
                    throw new CtreeSQLException(26034);
                }
                byArray[0] = (byte)(64 - n6 - 1);
                n = (short)(n - 1);
            }
        }
        n2 = 1;
        for (n3 = 1; n3 < n; ++n3) {
            if (bl && byArray[n3] == 0 || !bl && n3 < n - 1 && byArray[n3] == 99 || !bl && n3 == n - 1 && byArray[n3] == 100) continue;
            n2 = 0;
            break;
        }
        if (n2 == 1) {
            n = 2;
            byArray[0] = -63;
            byArray[1] = 0;
        } else if (!bl) {
            while (byArray[n - 1] == 100 && n > 2) {
                int n17 = n - 2;
                byArray[n17] = (byte)(byArray[n17] + 1);
                n = (short)(n - 1);
            }
        }
        this.dout.writeInt(n);
        this.dout.write(byArray, 0, n);
        byte[] byArray2 = new byte[]{0, 0, 0, 0};
        int n18 = n % 4;
        if (n18 > 0) {
            this.dout.write(byArray2, 0, 4 - n18);
        }
    }

    public String unmarshalNum() throws IOException {
        int n;
        String string = new String();
        byte[] byArray = new byte[17];
        int n2 = this.din.readInt();
        for (n = 0; n < n2; ++n) {
            byArray[n] = this.din.readByte();
        }
        n = n2 % 4;
        if (n > 0) {
            this.din.skipBytes(4 - n);
        }
        try {
            string = this.convNumToString((short)n2, byArray);
        }
        catch (CtreeSQLException ctreeSQLException) {
            ctreeSQLException.printStackTrace();
        }
        return string;
    }

    private String convNumToString(short n, byte[] byArray) throws CtreeSQLException {
        int n2;
        int n3;
        char[] cArray = new char[1024];
        int n4 = 0;
        boolean bl = false;
        if (n <= 0 || n > 17 || byArray[0] > 126 || byArray[0] < -128) {
            throw new CtreeSQLException(26034);
        }
        if ((byArray[0] & 0x80) == 0) {
            n3 = 64 - ((byArray[0] & 0x7F) + 1);
            cArray[n4++] = 45;
            bl = true;
            for (n2 = n; n2 < 17; ++n2) {
                byArray[n2] = 100;
            }
        } else {
            n3 = (byArray[0] & 0x7F) - 64;
            for (n2 = n; n2 < 17; ++n2) {
                byArray[n2] = 0;
            }
        }
        if (n3 <= 0) {
            cArray[n4++] = 48;
            cArray[n4++] = 46;
            while (n3++ < 0) {
                cArray[n4++] = 48;
                cArray[n4++] = 48;
            }
            n3 = 0;
        } else {
            int n5 = 1;
            for (n2 = 1; n2 < n3 + 1; ++n2) {
                if (n2 >= n) {
                    cArray[n4++] = 48;
                    cArray[n4++] = 48;
                } else if (bl) {
                    int n6 = n2 + 1 < n ? 99 : 100;
                    cArray[n4++] = (char)((n6 - byArray[n2]) / 10 + 48);
                    if (n5 > 0) {
                        if (cArray[n4 - 1] == '0') {
                            // empty if block
                        }
                        n5 = 0;
                    }
                    int n7 = --n4;
                    ++n4;
                    cArray[n7] = (char)((n6 - byArray[n2]) % 10 + 48);
                } else {
                    cArray[n4++] = (char)(byArray[n2] / 10 + 48);
                    if (n5 > 0) {
                        if (cArray[n4 - 1] == '0') {
                            // empty if block
                        }
                        n5 = 0;
                    }
                    int n8 = --n4;
                    ++n4;
                    cArray[n8] = (char)(byArray[n2] % 10 + 48);
                }
                if (n2 + 1 != n3 + 1) continue;
                cArray[n4++] = 46;
            }
        }
        if (n3 < n - 1) {
            for (n2 = n3 + 1; n2 < n; ++n2) {
                if (bl) {
                    if (n2 + 1 < n) {
                        cArray[n4++] = (char)((99 - byArray[n2]) / 10 + 48);
                        cArray[n4++] = (char)((99 - byArray[n2]) % 10 + 48);
                        continue;
                    }
                    cArray[n4++] = (char)((100 - byArray[n2]) / 10 + 48);
                    cArray[n4++] = (char)((100 - byArray[n2]) % 10 + 48);
                    continue;
                }
                cArray[n4++] = (char)(byArray[n2] / 10 + 48);
                cArray[n4++] = (char)(byArray[n2] % 10 + 48);
            }
        }
        cArray[n4++] = 48;
        cArray[n4] = '\u0000';
        n2 = n4 - 1;
        while (cArray[n2] == '0') {
            --n2;
        }
        n4 = cArray[n2] == '.' ? n2 : n2 + 1;
        return new String(cArray, 0, n4);
    }

    public Charset getCharset() {
        if (this.csm != null) {
            return this.csm;
        }
        return CtreeURL.defaultCharset;
    }
}

