/*
 * Decompiled with CFR 0.152.
 */
package ctree.jdbc;

import ctree.jdbc.CtreeError;
import ctree.jdbc.ctreeOEM;
import ctree.jdbc.ctreeOEMX;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class SQLPacketHeader
implements CtreeError,
ctreeOEM,
ctreeOEMX {
    byte[] buf;
    private int InterfaceVersion = 10;
    private String InterfaceName = null;
    private int MessageLength = 0;
    private int NetworkVersion = 956302712;
    private int ServerVersion;
    private int RequestIdentifier = 0;
    private int ProcedureNumber = 0;
    private int InterfaceID;
    private int MarshalStatus = 0;

    public byte[] getData() {
        return this.buf;
    }

    public void setData(byte[] byArray) {
        this.buf = byArray;
    }

    public void marshal(OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[]{0, 0, 0, 0};
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        dataOutputStream.writeInt(0);
        dataOutputStream.writeInt(this.MessageLength);
        dataOutputStream.writeInt(this.NetworkVersion);
        dataOutputStream.writeInt(this.RequestIdentifier);
        byte[] byArray2 = new byte[32];
        dataOutputStream.writeInt(byArray2.length);
        System.arraycopy(this.InterfaceName.getBytes(), 0, byArray2, 0, this.InterfaceName.length());
        dataOutputStream.write(byArray2, 0, byArray2.length);
        dataOutputStream.writeInt(10);
        dataOutputStream.writeInt(this.ProcedureNumber);
        dataOutputStream.writeInt(this.MarshalStatus);
    }

    public void unmarshal(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int n = dataInputStream.readInt();
        this.MessageLength = dataInputStream.readInt();
        this.ServerVersion = dataInputStream.readInt();
        this.RequestIdentifier = dataInputStream.readInt();
        int n2 = dataInputStream.readInt();
        byte[] byArray = new byte[32];
        dataInputStream.readFully(byArray, 0, 32);
        this.InterfaceName = new String(byArray, 0, n2);
        this.InterfaceVersion = dataInputStream.readInt();
        this.ProcedureNumber = dataInputStream.readInt();
        this.MarshalStatus = dataInputStream.readInt();
    }

    public void setInterfaceVersion(int n) {
        this.InterfaceVersion = n;
    }

    public void setProcedureNumber(int n) {
        this.ProcedureNumber = n;
    }

    public int getProcedureNumber() {
        return this.ProcedureNumber;
    }

    public int getInterfaceVersion() {
        return this.InterfaceVersion;
    }

    public void setInterfaceName(String string) {
        this.InterfaceName = string;
        this.setInterfaceID(string);
    }

    public void setInterfaceID(int n) {
        this.InterfaceID = n;
    }

    public void setStatus(int n) {
        this.MarshalStatus = n;
    }

    public int getStatus() {
        return this.MarshalStatus;
    }

    public void setRequestIdentifier(int n) {
        this.RequestIdentifier = this.RequestIdentifier;
    }

    public int getRequestIdentifier() {
        return this.RequestIdentifier;
    }

    public int getServerVersion() {
        return this.ServerVersion;
    }

    public void setMessageLength(int n) {
        this.MessageLength = n;
    }

    public int getMessageLength() {
        return this.MessageLength;
    }

    public String getInterfaceName() {
        return this.InterfaceName;
    }

    public int getInterfaceID() {
        return this.InterfaceID;
    }

    public void setInterfaceID(String string) {
        this.InterfaceID = string.equals("netInit") ? 0 : (string.equals("netfns") ? 1 : (string.equals("cntliface") ? 2 : -1));
    }
}

