/*
 * Decompiled with CFR 0.152.
 */
package ctree.jdbcx;

import ctree.jdbcx.CtreeConnectionHandle;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public class CtreePooledConnection
implements PooledConnection {
    private String URL;
    private String user;
    private String password;
    private CtreeConnectionHandle connectionHandle;
    Vector connectionEventListeners;

    public CtreePooledConnection(String string, String string2, String string3) throws SQLException {
        this.URL = string;
        this.user = string2;
        this.password = string3;
        this.connectionEventListeners = new Vector();
    }

    public synchronized Connection getConnection() throws SQLException {
        if (this.connectionHandle == null) {
            this.connectionHandle = new CtreeConnectionHandle(this.URL, this.user, this.password, this);
            return this.connectionHandle;
        }
        if (!this.connectionHandle.isClosed()) {
            this.connectionHandle.closeHandle();
        }
        this.connectionHandle = new CtreeConnectionHandle(this.URL, this.user, this.password, this, this.connectionHandle.connectionID);
        this.connectionHandle.setAutoCommit(true);
        this.connectionHandle.setAutoClose(true);
        this.connectionHandle.setReadOnly(false);
        this.connectionHandle.setTransactionIsolation(8);
        return this.connectionHandle;
    }

    public synchronized void close() throws SQLException {
        if (this.connectionHandle != null) {
            this.connectionHandle.closeBackendConnection();
            this.connectionHandle = null;
        }
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.connectionEventListeners.addElement(connectionEventListener);
    }

    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.connectionEventListeners.removeElement(connectionEventListener);
    }

    void fireConnectionClosed() {
        ConnectionEvent connectionEvent = new ConnectionEvent(this);
        int n = this.connectionEventListeners.size();
        for (int i = 0; i < n; ++i) {
            ConnectionEventListener connectionEventListener = (ConnectionEventListener)this.connectionEventListeners.elementAt(i);
            connectionEventListener.connectionClosed(connectionEvent);
        }
    }

    void fireConnectionErrorOccurred() {
        ConnectionEvent connectionEvent = new ConnectionEvent(this);
        int n = this.connectionEventListeners.size();
        for (int i = 0; i < n; ++i) {
            ConnectionEventListener connectionEventListener = (ConnectionEventListener)this.connectionEventListeners.elementAt(i);
            connectionEventListener.connectionErrorOccurred(connectionEvent);
        }
    }

    public void handleSQLException(SQLException sQLException) throws SQLException {
        int n = sQLException.getErrorCode();
        if (n == -30031 || n == -30032 || n == -30034) {
            this.fireConnectionErrorOccurred();
        }
        throw sQLException;
    }
}

