/*
 * Decompiled with CFR 0.152.
 */
package ctree.jdbcx;

import ctree.jdbc.CtreePreparedStatement;
import ctree.jdbc.CtreeResultSet;
import ctree.jdbcx.CtreeConnectionHandle;
import ctree.jdbcx.CtreePooledConnection;
import ctree.jdbcx.CtreePooledResultSet;
import java.sql.ResultSet;
import java.sql.SQLException;

class CtreePooledPreparedStatement
extends CtreePreparedStatement {
    private CtreePooledConnection pooledConnection;

    public CtreePooledPreparedStatement(CtreePooledConnection ctreePooledConnection, CtreeConnectionHandle ctreeConnectionHandle, String string) throws SQLException {
        super(ctreeConnectionHandle, string, 1003, 1007);
        this.pooledConnection = ctreePooledConnection;
    }

    public ResultSet executeQuery() throws SQLException {
        ResultSet resultSet = null;
        try {
            resultSet = super.executeQuery();
        }
        catch (SQLException sQLException) {
            this.pooledConnection.handleSQLException(sQLException);
        }
        return resultSet;
    }

    public int executeUpdate() throws SQLException {
        int n = 0;
        try {
            n = super.executeUpdate();
        }
        catch (SQLException sQLException) {
            this.pooledConnection.handleSQLException(sQLException);
        }
        return n;
    }

    public boolean execute() throws SQLException {
        boolean bl = false;
        try {
            bl = super.execute();
        }
        catch (SQLException sQLException) {
            this.pooledConnection.handleSQLException(sQLException);
        }
        return bl;
    }

    protected CtreeResultSet createCtreeResultSet() throws SQLException {
        return new CtreePooledResultSet(this.pooledConnection, this);
    }
}

