/*
 * Decompiled with CFR 0.152.
 */
package com.softwarefx.sfxnet.System.Drawing;

import com.softwarefx.sfxnet.System.Drawing.Bitmap;
import com.softwarefx.sfxnet.System.Drawing.Image;
import com.softwarefx.sfxnet.internal.cp;
import com.softwarefx.sfxnet.internal.fi;
import com.softwarefx.sfxnet.internal.km;
import com.softwarefx.sfxnet.internal.lf;
import com.softwarefx.sfxnet.internal.og;
import com.softwarefx.sfxnet.internal.um;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.imageio.ImageIO;

public class ImageLoader {
    private static final Component component = new um();
    private static final MediaTracker tracker = new MediaTracker(component);

    public static Image loadImage(String string) {
        if (string == null) {
            throw new fi("invalid file name for loading image.");
        }
        try {
            BufferedImage bufferedImage = ImageIO.read(new File(string));
            return new Bitmap(bufferedImage, string);
        }
        catch (IOException iOException) {
            throw new km(iOException);
        }
        catch (Exception exception) {
            return ImageLoader.d(string);
        }
    }

    public static Image loadImage(short[] sArray) {
        byte[] byArray = new byte[sArray.length];
        for (int i2 = 0; i2 < sArray.length; ++i2) {
            byArray[i2] = (byte)sArray[i2];
        }
        return ImageLoader.loadImage(byArray);
    }

    public static Image loadImage(byte[] byArray) {
        try {
            BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(byArray));
            return new Bitmap(bufferedImage, null);
        }
        catch (IOException iOException) {
            throw new km(iOException);
        }
        catch (Exception exception) {
            return ImageLoader.d(byArray);
        }
    }

    public static Bitmap loadImage(URL uRL) {
        if (uRL == null) {
            throw new km("invalid image URL");
        }
        try {
            URLConnection uRLConnection = uRL.openConnection();
            BufferedImage bufferedImage = ImageIO.read(uRLConnection.getInputStream());
            return new Bitmap(bufferedImage, uRL.getFile());
        }
        catch (IOException iOException) {
            throw new km(iOException);
        }
        catch (Exception exception) {
            return ImageLoader.d(uRL);
        }
    }

    static Image loadImage(lf lf2) {
        byte[] byArray = null;
        try {
            byArray = lf.h(lf2);
            BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(byArray));
            return new Bitmap(bufferedImage, null);
        }
        catch (IOException iOException) {
            throw new km(iOException);
        }
        catch (Exception exception) {
            return ImageLoader.d(byArray);
        }
    }

    private static Bitmap d(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            java.awt.Image image = null;
            image = Toolkit.getDefaultToolkit().createImage((byte[])object);
            return new Bitmap(ImageLoader.loadImage(image), null);
        }
        if (object instanceof String) {
            java.awt.Image image = null;
            image = Toolkit.getDefaultToolkit().createImage((String)object);
            return new Bitmap(ImageLoader.loadImage(image), (String)object);
        }
        if (object instanceof URL) {
            java.awt.Image image = null;
            image = Toolkit.getDefaultToolkit().createImage((URL)object);
            return new Bitmap(ImageLoader.loadImage(image), ((URL)object).getFile());
        }
        return null;
    }

    public static void a(String string, Image image, String string2) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            ImageLoader.a(fileOutputStream, (BufferedImage)image.rZ, string2);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            throw new km(iOException);
        }
    }

    public static void a(lf lf2, Image image, og og2, cp cp2) {
        ImageLoader.a(lf2, image, og2.getMimeType());
    }

    public static void a(lf lf2, Image image, String string) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ImageLoader.a(byteArrayOutputStream, (BufferedImage)image.rZ, string);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            short[] sArray = new short[byArray.length];
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                sArray[i2] = byArray[i2];
            }
            lf2.c(sArray, 0, sArray.length);
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            throw new km(iOException);
        }
    }

    private static void a(OutputStream outputStream, BufferedImage bufferedImage, String string) throws IOException {
        if (string.toLowerCase().endsWith("png") || string.toLowerCase().equals("memorybmp")) {
            ImageIO.write((RenderedImage)bufferedImage, "png", outputStream);
        } else if (string.toLowerCase().endsWith("bmp")) {
            BufferedImage bufferedImage2 = bufferedImage;
            int n2 = bufferedImage.getSampleModel().getNumBands();
            if (n2 != 1 && n2 != 3) {
                bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 1);
                ColorConvertOp colorConvertOp = new ColorConvertOp(null);
                colorConvertOp.filter(bufferedImage, bufferedImage2);
            }
            ImageIO.write((RenderedImage)bufferedImage2, "bmp", outputStream);
        } else if (string.toLowerCase().endsWith("jpg") || string.toLowerCase().endsWith("jpeg")) {
            BufferedImage bufferedImage3 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 1);
            ColorConvertOp colorConvertOp = new ColorConvertOp(null);
            colorConvertOp.filter(bufferedImage, bufferedImage3);
            ImageIO.write((RenderedImage)bufferedImage3, "jpg", outputStream);
        } else if (string.toLowerCase().endsWith("gif")) {
            ImageIO.write((RenderedImage)bufferedImage, "gif", outputStream);
        } else {
            ImageIO.write((RenderedImage)bufferedImage, "png", outputStream);
        }
    }

    public static synchronized BufferedImage loadImage(java.awt.Image image) {
        BufferedImage bufferedImage = null;
        if (image != null) {
            tracker.addImage(image, 0);
            try {
                tracker.waitForAll();
            }
            catch (InterruptedException interruptedException) {
                tracker.removeImage(image);
                image = null;
                return null;
            }
        }
        if (image != null && (tracker.statusID(0, false) & 8) != 0) {
            bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.drawImage(image, 0, 0, null);
            graphics2D.dispose();
            tracker.removeImage(image);
            return bufferedImage;
        }
        return null;
    }
}

