/*
 * Decompiled with CFR 0.152.
 */
package com.softwarefx.chartfx.desktop;

import java.util.Arrays;
import java.util.EnumSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum HitType {
    NONE(0),
    BACKGROUND(1),
    INSIDE_AREA(2),
    BETWEEN(3),
    POINT(4),
    AXIS(5),
    TITLE(6),
    CUSTOM_GRID_LINE(7),
    DRAG(8),
    CROSSHAIR(9),
    ZOOM(10),
    SCROLL(11),
    LEGEND_BOX(12),
    DATA_GRID(13),
    OTHER(14),
    AXIS_SECTION(15);

    private final int cg;

    private HitType(int n3) {
        this.cg = n3;
    }

    public static int getUnderlyingValue(HitType hitType) {
        return hitType.cg;
    }

    public static HitType getEnumValue(int n2) {
        for (HitType hitType : HitType.values()) {
            if (HitType.getUnderlyingValue(hitType) != n2) continue;
            return hitType;
        }
        throw new IllegalArgumentException();
    }

    public static EnumSet<HitType> getEnumSetValue(int n2) {
        HitType[] hitTypeArray = HitType.values();
        Arrays.sort((Object[])hitTypeArray);
        EnumSet<HitType> enumSet = EnumSet.noneOf(HitType.class);
        for (HitType hitType : hitTypeArray) {
            int n3 = HitType.getUnderlyingValue(hitType);
            if ((n3 & n2) != n3) continue;
            n2 -= n3;
            enumSet.add(hitType);
        }
        return enumSet;
    }

    public static int getUnderlyingValue(EnumSet<HitType> enumSet) {
        int n2 = 0;
        for (HitType hitType : enumSet) {
            n2 |= HitType.getUnderlyingValue(hitType);
        }
        return n2;
    }
}

