/*
 * Decompiled with CFR 0.152.
 */
package com.faircom.persistence.eclipselink;

import FairCom.CtreeDb.CTDatabase;
import FairCom.CtreeDb.CTException;
import FairCom.CtreeDb.CTField;
import FairCom.CtreeDb.CTIndex;
import FairCom.CtreeDb.CTRecord;
import FairCom.CtreeDb.CTSession;
import FairCom.CtreeDb.CTTable;
import com.faircom.persistence.eclipselink.CtreeConnectionMetaData;
import com.faircom.persistence.eclipselink.CtreeInteraction;
import com.faircom.persistence.eclipselink.CtreeInteractionSpec;
import com.faircom.persistence.eclipselink.CtreeJCAConnectionSpec;
import com.faircom.persistence.eclipselink.CtreeListRecord;
import com.faircom.persistence.eclipselink.CtreeMappedRecord;
import com.faircom.persistence.eclipselink.CtreeSequence;
import com.faircom.persistence.eclipselink.CtreeTransaction;
import com.faircom.persistence.eclipselink.ExpressionHelper;
import com.faircom.persistence.eclipselink.Mapper;
import com.faircom.persistence.eclipselink.SmartXML;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.PersistenceException;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionMetaData;
import javax.resource.cci.Interaction;
import javax.resource.cci.LocalTransaction;
import javax.resource.cci.ResultSetInfo;
import org.eclipse.persistence.eis.EISException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.expressions.FunctionExpression;
import org.eclipse.persistence.internal.expressions.RelationExpression;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.queries.ReportItem;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.w3c.dom.Node;

public class CtreeConnection
implements Connection {
    public CTSession ctSession;
    private CTDatabase ctDB;
    protected CtreeJCAConnectionSpec connectionSpec;
    private CtreeTransaction transaction;

    public CtreeConnection(CTSession cTSession, CTDatabase cTDatabase, CtreeJCAConnectionSpec ctreeJCAConnectionSpec) {
        this.ctSession = cTSession;
        this.ctDB = cTDatabase;
        this.connectionSpec = ctreeJCAConnectionSpec;
        this.transaction = new CtreeTransaction(this);
        try {
            this.createTables();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (CTException cTException) {
            cTException.printStackTrace();
        }
    }

    public void createTables() throws CTException, ClassNotFoundException {
        SmartXML smartXML = new SmartXML(this.getClass().getResourceAsStream("/META-INF/persistence.xml"));
        Map<String, String> map = smartXML.getAttributeMap("//persistence-unit/properties/property", "name", "value");
        if (!"create".equals(map.get("ddl-generation"))) {
            return;
        }
        System.out.println("persistence.xml contains ddl-generation=create, tables will be created.");
        for (Node node : smartXML.getNodeListIterable("//persistence-unit/class")) {
            String string = node.getTextContent();
            Class<?> clazz = this.getClass().getClassLoader().loadClass(string);
            if (!clazz.isAnnotationPresent(Entity.class)) {
                System.err.println("persistence.xml entity is not annotated with @Entity: " + string);
                continue;
            }
            String string2 = clazz.getSimpleName();
            Table table = clazz.getAnnotation(Table.class);
            if (table != null) {
                string2 = table.name();
            }
            this.createCTTable(string2, clazz);
        }
    }

    private void createCTTable(String string, Class<?> clazz) throws CTException, SecurityException {
        CTTable cTTable = new CTTable(this.ctDB);
        try {
            cTTable.Open(string, 0);
        }
        catch (CTException cTException) {
            Field[] fieldArray;
            System.out.println("creating table: " + string);
            for (Field field : fieldArray = clazz.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers()) || Modifier.isFinal(field.getModifiers()) || field.getAnnotation(Transient.class) != null || Modifier.isTransient(field.getModifiers())) continue;
                if (Modifier.isPrivate(field.getModifiers())) {
                    // empty if block
                }
                try {
                    CTField cTField;
                    int n;
                    int n2;
                    Class<?> clazz2;
                    Column column = field.getAnnotation(Column.class);
                    String string2 = field.getName();
                    if (column != null) {
                        string2 = column.name();
                    }
                    if ((clazz2 = field.getType()).equals(String.class)) {
                        n2 = 144;
                        n = 255;
                        if (column != null) {
                            n = column.length();
                        }
                    } else if (clazz2.equals(Integer.class) || clazz2.equals(Integer.TYPE)) {
                        n2 = 51;
                        n = 4;
                    } else if (clazz2.equals(Long.class) || clazz2.equals(Long.TYPE)) {
                        n2 = 231;
                        n = 8;
                    } else if (clazz2.equals(Date.class)) {
                        n2 = 75;
                        n = 4;
                    } else {
                        if (clazz2.equals(Set.class)) {
                            cTField = field.getAnnotation(OneToMany.class);
                            if (cTField == null) {
                                System.out.println("WARN: unknown field type: " + clazz2);
                                continue;
                            }
                            System.out.println("ignoring @ManyToOne field: " + field.getName());
                            continue;
                        }
                        cTField = field.getAnnotation(ManyToOne.class);
                        if (cTField == null) {
                            System.out.println("WARN: unknown field type: " + clazz2);
                            continue;
                        }
                        n2 = 231;
                        n = 8;
                        string2 = clazz2.getSimpleName() + "_id";
                    }
                    System.out.println("creating field: " + string2);
                    cTField = cTTable.AddField(string2, n2, n);
                    if (field.getAnnotation(Id.class) == null) continue;
                    cTTable.SetIdentityField(string2, 0L, 1L);
                    CTIndex cTIndex = cTTable.AddIndex(string + "_" + string2 + "_idx", 0, false, false);
                    cTTable.AddSegment(cTIndex, cTField, 12);
                }
                catch (CTException cTException2) {
                    System.out.println(cTException2.GetErrorCode() + " " + cTException2.GetErrorMsg());
                    throw cTException2;
                }
            }
            cTTable.Create(string, 0);
        }
    }

    public long write(String string, CtreeMappedRecord ctreeMappedRecord) throws ResourceException {
        long l;
        CTTable cTTable = null;
        try {
            cTTable = new CTTable(this.ctDB);
            cTTable.Open(string, 0);
            CTRecord cTRecord = null;
            if (cTRecord == null) {
                cTRecord = new CTRecord(cTTable);
                cTRecord.Clear();
            }
            Mapper.fromMappedToCTRecord(ctreeMappedRecord, cTRecord);
            cTRecord.Write();
            Mapper.fromCTRecordToMapped(cTRecord, ctreeMappedRecord);
            long l2 = -1L;
            try {
                CtreeSequence.lastID = l2 = cTTable.GetLastIdentity();
            }
            catch (CTException cTException) {
                // empty catch block
            }
            l = l2;
        }
        catch (CTException cTException) {
            try {
                throw new ResourceException((Throwable)cTException);
            }
            catch (Throwable throwable) {
                Mapper.closeTable(cTTable);
                throw throwable;
            }
        }
        Mapper.closeTable(cTTable);
        return l;
    }

    public void update(String string, CtreeMappedRecord ctreeMappedRecord, CtreeMappedRecord ctreeMappedRecord2) throws ResourceException {
        CTTable cTTable = null;
        try {
            cTTable = new CTTable(this.ctDB);
            cTTable.Open(string, 0);
            CTRecord cTRecord = new CTRecord(cTTable);
            cTRecord.Clear();
            Mapper.fromMappedToCTRecord(ctreeMappedRecord, cTRecord);
            cTRecord.Find(0);
            Mapper.fromMappedToCTRecord(ctreeMappedRecord2, cTRecord);
            cTRecord.Write();
        }
        catch (CTException cTException) {
            try {
                throw new ResourceException((Throwable)cTException);
            }
            catch (Throwable throwable) {
                Mapper.closeTable(cTTable);
                throw throwable;
            }
        }
        Mapper.closeTable(cTTable);
    }

    public void remove(String string, CtreeMappedRecord ctreeMappedRecord) throws ResourceException {
        CTTable cTTable = null;
        try {
            cTTable = new CTTable(this.ctDB);
            cTTable.Open(string, 0);
            CTRecord cTRecord = new CTRecord(cTTable);
            cTRecord.Clear();
            Mapper.fromMappedToCTRecord(ctreeMappedRecord, cTRecord);
            if (!cTRecord.Find(0)) {
                throw new PersistenceException("Object not found.");
            }
            cTRecord.Delete();
            cTTable.Close();
        }
        catch (CTException cTException) {
            try {
                throw new ResourceException((Throwable)cTException);
            }
            catch (Throwable throwable) {
                Mapper.closeTable(cTTable);
                throw throwable;
            }
        }
        Mapper.closeTable(cTTable);
    }

    public void close() throws ResourceException {
        try {
            this.ctDB.CloseAll();
            this.ctDB.Disconnect();
            this.ctSession.Logoff();
        }
        catch (CTException cTException) {
            throw new ResourceException((Throwable)cTException);
        }
    }

    public Interaction createInteraction() throws ResourceException {
        return new CtreeInteraction(this);
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        return this.transaction;
    }

    public ConnectionMetaData getMetaData() throws ResourceException {
        return new CtreeConnectionMetaData(this);
    }

    public ResultSetInfo getResultSetInfo() throws ResourceException {
        throw ValidationException.operationNotSupported((String)"getResultSetInfo");
    }

    public CtreeListRecord find(String string, CtreeMappedRecord ctreeMappedRecord, CtreeInteractionSpec ctreeInteractionSpec) throws ResourceException {
        List list;
        CTTable cTTable = null;
        try {
            List list2;
            Object object;
            cTTable = new CTTable(this.ctDB);
            cTTable.Open(string, 0);
            CTRecord cTRecord = new CTRecord(cTTable);
            cTRecord.Clear();
            DatabaseQuery databaseQuery = ctreeInteractionSpec.getQuery();
            ObjectLevelReadQuery objectLevelReadQuery = (ObjectLevelReadQuery)databaseQuery;
            if (objectLevelReadQuery.hasOrderByExpressions()) {
                // empty if block
            }
            boolean bl = false;
            int n = -1;
            if (ctreeInteractionSpec.statement != null) {
                Expression expression = ctreeInteractionSpec.statement.getWhereClause();
                if (expression != null && expression.isRelationExpression()) {
                    n = this.handleWhere(cTRecord, databaseQuery, n, expression);
                }
                if (ctreeInteractionSpec.statement instanceof SQLSelectStatement) {
                    try {
                        ReportQuery reportQuery;
                        FunctionExpression functionExpression;
                        SQLSelectStatement sQLSelectStatement = (SQLSelectStatement)ctreeInteractionSpec.statement;
                        if (sQLSelectStatement.getQuery() instanceof ReportQuery && (object = (functionExpression = (FunctionExpression)((ReportItem)(list2 = (reportQuery = (ReportQuery)sQLSelectStatement.getQuery()).getItems()).get(0)).getAttributeExpression()).getOperator()).getJavaStrings()[0].equals(".count()")) {
                            bl = true;
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            if (ctreeMappedRecord.size() > 0) {
                Mapper.fromMappedToCTRecord(ctreeMappedRecord, cTRecord);
                n = 0;
            }
            int n2 = objectLevelReadQuery.getFirstResult();
            int n3 = objectLevelReadQuery.getMaxRows() == 0 ? Integer.MAX_VALUE : objectLevelReadQuery.getMaxRows();
            boolean bl2 = n >= 0 ? cTRecord.Find(n) : cTRecord.First();
            list2 = new CtreeListRecord();
            if (bl) {
                long l;
                long l2 = l = bl2 ? 1L : 0L;
                while (cTRecord.Next()) {
                    ++l;
                }
                CtreeMappedRecord ctreeMappedRecord2 = new CtreeMappedRecord();
                ctreeMappedRecord2.put("count", l);
                ((CtreeListRecord)list2).addRecord(ctreeMappedRecord2);
            } else {
                int n4 = 0;
                while (bl2) {
                    if (n4 >= n2 && ((ArrayList)list2).size() < n3) {
                        object = Mapper.fromCTRecordToNewMapped(cTRecord);
                        ((CtreeListRecord)list2).addRecord((CtreeMappedRecord)object);
                    }
                    bl2 = cTRecord.Next();
                    ++n4;
                }
            }
            list = list2;
        }
        catch (CTException cTException) {
            try {
                throw new ResourceException((Throwable)cTException);
            }
            catch (Throwable throwable) {
                Mapper.closeTable(cTTable);
                throw throwable;
            }
        }
        Mapper.closeTable(cTTable);
        return list;
    }

    private int handleWhere(CTRecord cTRecord, DatabaseQuery databaseQuery, int n, Expression expression) throws CTException {
        RelationExpression relationExpression = (RelationExpression)expression;
        Object object = ExpressionHelper.extractValue(relationExpression.getSecondChild(), databaseQuery);
        switch (relationExpression.getOperator().getSelector()) {
            case 4: {
                n = 0;
                Mapper.setCTField(cTRecord, relationExpression.getFirstChild().getName(), object);
                break;
            }
            case 9: {
                n = 3;
                Mapper.setCTField(cTRecord, relationExpression.getFirstChild().getName(), object);
                break;
            }
            case 10: {
                n = 4;
                Mapper.setCTField(cTRecord, relationExpression.getFirstChild().getName(), object);
                break;
            }
            case 7: {
                n = 1;
                Mapper.setCTField(cTRecord, relationExpression.getFirstChild().getName(), object);
                break;
            }
            case 8: {
                n = 2;
                Mapper.setCTField(cTRecord, relationExpression.getFirstChild().getName(), object);
                break;
            }
            default: {
                throw new EISException("Query too complex for Ctree translation, relation [" + expression + "] not supported in query: " + databaseQuery);
            }
        }
        return n;
    }
}

