/*
 * Decompiled with CFR 0.152.
 */
package com.faircom.persistence.eclipselink;

import com.faircom.persistence.eclipselink.CtreeInteractionSpec;
import com.faircom.persistence.eclipselink.CtreeOperation;
import com.faircom.persistence.eclipselink.CtreeSequence;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.Record;
import org.eclipse.persistence.descriptors.DescriptorQueryManager;
import org.eclipse.persistence.eis.EISAccessor;
import org.eclipse.persistence.eis.EISDescriptor;
import org.eclipse.persistence.eis.EISException;
import org.eclipse.persistence.eis.EISPlatform;
import org.eclipse.persistence.eis.interactions.EISInteraction;
import org.eclipse.persistence.eis.interactions.MappedInteraction;
import org.eclipse.persistence.internal.databaseaccess.DatasourceCall;
import org.eclipse.persistence.internal.expressions.SQLStatement;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.sequencing.Sequence;

public class CtreePlatform
extends EISPlatform {
    public static String OPERATION = "ctree.operation";
    public static String TABLE = "ctree.table";
    public static String OPTIONS = "ctree.options";
    public static String SKIP = "ctree.skip";
    public static String LIMIT = "ctree.limit";
    public static String FETCH_SIZE = "ctree.fetch";
    private Sequence s;

    public CtreePlatform() {
        this.setIsMappedRecordSupported(true);
        this.setIsIndexedRecordSupported(false);
        this.setIsDOMRecordSupported(true);
        this.setSupportsLocalTransactions(true);
        this.setDefaultNativeSequenceToTable(false);
    }

    public boolean supportsIdentity() {
        return true;
    }

    private MappedInteraction getCall(DescriptorQueryManager descriptorQueryManager, CtreeOperation ctreeOperation) {
        MappedInteraction mappedInteraction = new MappedInteraction();
        mappedInteraction.setProperty(OPERATION, (Object)ctreeOperation);
        mappedInteraction.setProperty(TABLE, (Object)((EISDescriptor)descriptorQueryManager.getDescriptor()).getDataTypeName());
        if (ctreeOperation == CtreeOperation.FIND || ctreeOperation == CtreeOperation.REMOVE) {
            for (DatabaseField databaseField : descriptorQueryManager.getDescriptor().getPrimaryKeyFields()) {
                mappedInteraction.addArgument(databaseField.getName());
            }
        }
        return mappedInteraction;
    }

    public void initializeDefaultQueries(DescriptorQueryManager descriptorQueryManager, AbstractSession abstractSession) {
        if (!descriptorQueryManager.hasInsertQuery()) {
            descriptorQueryManager.setInsertCall((Call)this.getCall(descriptorQueryManager, CtreeOperation.INSERT));
        }
        if (!descriptorQueryManager.hasUpdateQuery()) {
            descriptorQueryManager.setUpdateCall((Call)this.getCall(descriptorQueryManager, CtreeOperation.UPDATE));
        }
        if (!descriptorQueryManager.hasReadObjectQuery()) {
            descriptorQueryManager.setReadObjectCall((Call)this.getCall(descriptorQueryManager, CtreeOperation.FIND));
        }
        if (!descriptorQueryManager.hasDeleteQuery()) {
            descriptorQueryManager.setDeleteCall((Call)this.getCall(descriptorQueryManager, CtreeOperation.REMOVE));
        }
    }

    public DatasourceCall buildCallFromStatement(SQLStatement sQLStatement, DatabaseQuery databaseQuery, AbstractSession abstractSession) {
        if (!databaseQuery.isObjectLevelReadQuery()) {
            throw new EISException("Query too complex, only select queries are supported: " + databaseQuery);
        }
        MappedInteraction mappedInteraction = new MappedInteraction();
        mappedInteraction.setProperty("SQLStatement", (Object)sQLStatement);
        mappedInteraction.setProperty(OPERATION, (Object)CtreeOperation.FIND);
        mappedInteraction.setProperty(TABLE, (Object)((EISDescriptor)databaseQuery.getDescriptor()).getDataTypeName());
        return mappedInteraction;
    }

    public Record createOutputRecord(EISInteraction eISInteraction, AbstractRecord abstractRecord, EISAccessor eISAccessor) {
        if (eISInteraction.getInteractionSpec() != null) {
            boolean bl;
            boolean bl2 = bl = ((CtreeInteractionSpec)eISInteraction.getInteractionSpec()).getOperation() == CtreeOperation.UPDATE;
            if (bl) {
                return (Record)eISInteraction.createRecordElement(eISInteraction.getInputRecordName(), (Object)abstractRecord, eISAccessor);
            }
        } else if (eISInteraction.getProperty(OPERATION) != null) {
            boolean bl = eISInteraction.getProperty(OPERATION) == CtreeOperation.UPDATE;
            boolean bl3 = eISInteraction.getProperty(OPERATION).equals(CtreeOperation.UPDATE.name());
            if (bl || bl3) {
                return (Record)eISInteraction.createRecordElement(eISInteraction.getInputRecordName(), (Object)abstractRecord, eISAccessor);
            }
        }
        return null;
    }

    public InteractionSpec buildInteractionSpec(EISInteraction eISInteraction) {
        return eISInteraction.getInteractionSpec() == null ? new CtreeInteractionSpec(eISInteraction) : eISInteraction.getInteractionSpec();
    }

    public Sequence getSequence(String string) {
        if ("SEQ_GEN_IDENTITY".equals(string)) {
            if (this.s == null) {
                this.s = this.createPlatformDefaultSequence();
            }
            return this.s;
        }
        if (string == null) {
            return this.getDefaultSequence();
        }
        if (this.sequences != null) {
            return (Sequence)this.sequences.get(string);
        }
        return null;
    }

    protected Sequence createPlatformDefaultSequence() {
        return new CtreeSequence();
    }
}

