/*
 * Decompiled with CFR 0.152.
 */
package com.faircom.persistence.eclipselink;

import FairCom.CtreeDb.CTException;
import FairCom.CtreeDb.CTField;
import FairCom.CtreeDb.CTRecord;
import FairCom.CtreeDb.CTTable;
import com.faircom.persistence.eclipselink.CtreeMappedRecord;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.persistence.PersistenceException;

public class Mapper {
    public static Calendar dateToCalendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    public static Calendar timestampToCalendar(Timestamp timestamp) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timestamp.getTime());
        return calendar;
    }

    public static void setCTField(CTRecord cTRecord, String string, Object object) throws CTException {
        Class<?> clazz = object.getClass();
        if (clazz.equals(String.class)) {
            cTRecord.SetFieldAsString(string, (String)object);
        } else if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
            cTRecord.SetFieldAsInt(string, (Integer)object);
        } else if (clazz.equals(Long.class) || clazz.equals(Long.TYPE)) {
            cTRecord.SetFieldAsLong(string, (Long)object);
        } else if (clazz.equals(Date.class)) {
            cTRecord.SetFieldAsCalendar(string, Mapper.dateToCalendar((Date)object));
        } else if (clazz.equals(Calendar.class)) {
            cTRecord.SetFieldAsCalendar(string, (Calendar)object);
        } else if (clazz.equals(Timestamp.class)) {
            cTRecord.SetFieldAsCalendar(string, Mapper.timestampToCalendar((Timestamp)object));
        } else if (!clazz.equals(Vector.class)) {
            if (clazz.equals(CtreeMappedRecord.class)) {
                throw new PersistenceException("Please use exactly this annotation on your entities: @NoSql(dataFormat=DataFormatType.MAPPED)");
            }
            throw new PersistenceException("unknown field type: " + clazz);
        }
    }

    public static <T> void fromMappedToCTRecord(CtreeMappedRecord ctreeMappedRecord, CTRecord cTRecord) throws CTException {
        Set set = ctreeMappedRecord.entrySet();
        for (Map.Entry entry : set) {
            String string = (String)entry.getKey();
            Object v = entry.getValue();
            if (v == null) continue;
            Mapper.setCTField(cTRecord, string, v);
        }
    }

    public static void fromCTRecordToMapped(CTRecord cTRecord, CtreeMappedRecord ctreeMappedRecord) throws CTException {
        CTTable cTTable = cTRecord.getParent();
        int n = cTTable.GetFieldCount();
        block11: for (int i = 0; i < n; ++i) {
            CTField cTField = cTTable.GetField(i);
            int n2 = cTField.GetType();
            switch (n2) {
                case 105: {
                    ctreeMappedRecord.put(cTField.GetName(), cTRecord.GetFieldAsBigDecimal(i));
                    continue block11;
                }
                case 8: {
                    ctreeMappedRecord.put(cTField.GetName(), cTRecord.GetFieldAsBoolean(i));
                    continue block11;
                }
                case 128: {
                    ctreeMappedRecord.put(cTField.GetName(), cTRecord.GetFieldAsBytes(i));
                    continue block11;
                }
                case 75: {
                    ctreeMappedRecord.put(cTField.GetName(), cTRecord.GetFieldAsCalendar(i));
                    continue block11;
                }
                case 103: {
                    ctreeMappedRecord.put(cTField.GetName(), cTRecord.GetFieldAsDouble(i));
                    continue block11;
                }
                case 91: {
                    ctreeMappedRecord.put(cTField.GetName(), cTRecord.GetFieldAsFloat(i));
                    continue block11;
                }
                case 51: {
                    ctreeMappedRecord.put(cTField.GetName(), cTRecord.GetFieldAsInt(i));
                    continue block11;
                }
                case 231: {
                    ctreeMappedRecord.put(cTField.GetName(), cTRecord.GetFieldAsLong(i));
                    continue block11;
                }
                case 144: 
                case 146: 
                case 152: 
                case 160: 
                case 168: 
                case 177: 
                case 193: {
                    ctreeMappedRecord.put(cTField.GetName(), cTRecord.GetFieldAsString(i));
                    continue block11;
                }
                default: {
                    System.out.println("unknown type");
                }
            }
        }
    }

    public static CtreeMappedRecord fromCTRecordToNewMapped(CTRecord cTRecord) {
        try {
            CtreeMappedRecord ctreeMappedRecord = new CtreeMappedRecord();
            Mapper.fromCTRecordToMapped(cTRecord, ctreeMappedRecord);
            return ctreeMappedRecord;
        }
        catch (CTException cTException) {
            throw new PersistenceException((Throwable)cTException);
        }
    }

    public static void closeTable(CTTable cTTable) {
        if (cTTable != null) {
            try {
                cTTable.Close();
            }
            catch (CTException cTException) {
                throw new RuntimeException(cTException);
            }
        }
    }
}

