/*
 * Decompiled with CFR 0.152.
 */
package com.faircom.persistence.eclipselink;

import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SmartXML {
    private final DocumentBuilder documentBuilder;
    protected XPath xpath;
    protected final Document document;

    public SmartXML(File file) {
        try {
            this.documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException(parserConfigurationException);
        }
        this.xpath = XPathFactory.newInstance().newXPath();
        this.document = this.parse(file);
    }

    public SmartXML(InputStream inputStream) {
        try {
            this.documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException(parserConfigurationException);
        }
        this.xpath = XPathFactory.newInstance().newXPath();
        try {
            this.document = this.documentBuilder.parse(inputStream);
            inputStream.close();
        }
        catch (SAXException sAXException) {
            throw new RuntimeException(sAXException);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public SmartXML(String string) {
        try {
            this.documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException(parserConfigurationException);
        }
        this.xpath = XPathFactory.newInstance().newXPath();
        this.document = this.parse(string);
    }

    public Node getNode(String string) {
        try {
            return (Node)this.xpath.evaluate(string, this.document, XPathConstants.NODE);
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new RuntimeException(xPathExpressionException);
        }
    }

    public String getTextContent(String string) {
        try {
            Node node = (Node)this.xpath.evaluate(string, this.document, XPathConstants.NODE);
            return node == null ? null : node.getTextContent();
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new RuntimeException(xPathExpressionException);
        }
    }

    public String getTextContent(String string, Element element) {
        try {
            Node node = (Node)this.xpath.evaluate(string, element, XPathConstants.NODE);
            return node == null ? null : node.getTextContent();
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new RuntimeException(xPathExpressionException);
        }
    }

    public NodeList getNodeList(String string) {
        try {
            return (NodeList)this.xpath.evaluate(string, this.document, XPathConstants.NODESET);
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new RuntimeException(xPathExpressionException);
        }
    }

    public Iterable<Node> getNodeListIterable(String string) {
        final NodeList nodeList = this.getNodeList(string);
        return new Iterable<Node>(){

            @Override
            public Iterator<Node> iterator() {
                return new Iterator<Node>(){
                    int index = 0;

                    @Override
                    public boolean hasNext() {
                        return this.index < nodeList.getLength();
                    }

                    @Override
                    public Node next() {
                        if (this.hasNext()) {
                            return nodeList.item(this.index++);
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public Document parse(String string) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF-8"));
            return this.documentBuilder.parse(byteArrayInputStream);
        }
        catch (SAXException sAXException) {
            throw new RuntimeException(sAXException);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public Document parse(File file) {
        try {
            return this.documentBuilder.parse(file);
        }
        catch (SAXException sAXException) {
            throw new RuntimeException(sAXException);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static String getXML(Node node) {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            DOMSource dOMSource = new DOMSource(node);
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            StreamResult streamResult = new StreamResult(charArrayWriter);
            transformer.transform(dOMSource, streamResult);
            return charArrayWriter.toString();
        }
        catch (TransformerException transformerException) {
            throw new RuntimeException(transformerException);
        }
    }

    Map<String, String> getAttributeMap(String string, String string2, String string3) {
        NodeList nodeList = this.getNodeList(string);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            hashMap.put(element.getAttribute(string2), element.getAttribute(string3));
        }
        return hashMap;
    }
}

