/*
 * Decompiled with CFR 0.152.
 */
package ctree.jdbc;

import ctree.jdbc.CtreeDA;
import ctree.jdbc.CtreeError;
import ctree.jdbc.CtreeSQLException;
import java.sql.ParameterMetaData;
import java.sql.SQLException;

public class CtreeParameterMetaData
implements ParameterMetaData,
CtreeError {
    CtreeDA paramDA;

    CtreeParameterMetaData(CtreeDA ctreeDA) {
        this.paramDA = ctreeDA;
    }

    @Override
    public int getParameterCount() throws SQLException {
        return this.paramDA.getNColumns();
    }

    @Override
    public int isNullable(int n) throws SQLException {
        switch (this.paramDA.getFlag(n - 1)) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        throw new CtreeSQLException(26026);
    }

    @Override
    public boolean isSigned(int n) throws SQLException {
        return this.paramDA.isSigned(n - 1);
    }

    @Override
    public int getPrecision(int n) throws SQLException {
        return this.paramDA.getPrecision(n - 1);
    }

    @Override
    public int getScale(int n) throws SQLException {
        return this.paramDA.getScale(n - 1);
    }

    @Override
    public int getParameterType(int n) throws SQLException {
        this.paramDA.checkFieldRange(n - 1);
        return CtreeDA.jdbcTypesToTypes(this.paramDA.getSqlType(n - 1));
    }

    @Override
    public String getParameterTypeName(int n) throws SQLException {
        this.paramDA.checkFieldRange(n - 1);
        return this.paramDA.getTypeName(n - 1);
    }

    @Override
    public String getParameterClassName(int n) throws SQLException {
        this.paramDA.checkFieldRange(n - 1);
        return this.paramDA.getColumnClassName(n - 1);
    }

    @Override
    public int getParameterMode(int n) throws SQLException {
        switch (this.paramDA.getParamType(n - 1)) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 4: {
                return 4;
            }
        }
        throw new CtreeSQLException(26026);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) {
        System.out.println("To be implemented ");
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        System.out.println("To be implemented ");
        return null;
    }
}

