/*
 * Decompiled with CFR 0.152.
 */
package ctree.jdbc;

import ctree.jdbc.CtreeCltSvr;
import ctree.jdbc.CtreeData;
import ctree.jdbc.CtreeError;
import ctree.jdbc.SQLPacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public final class CtreeSnGetData
implements CtreeError {
    int status = 0;
    CtreeCltSvr CltSvr;
    CtreeData GetData;

    public CtreeSnGetData() {
        this.CltSvr = new CtreeCltSvr(1);
        this.GetData = new CtreeData();
    }

    public CtreeSnGetData(int n, CtreeData ctreeData) {
        this.CltSvr = new CtreeCltSvr(n);
        this.GetData = ctreeData;
    }

    public void setStatus(int n) {
        this.status = n;
    }

    public void setCltSvr(CtreeCltSvr ctreeCltSvr) {
        this.CltSvr = ctreeCltSvr;
    }

    public void setGetData(CtreeData ctreeData) {
        this.GetData = ctreeData;
    }

    public int getStatus() {
        return this.status;
    }

    public CtreeCltSvr getCltSvr() {
        return this.CltSvr;
    }

    public CtreeData getGetData() {
        return this.GetData;
    }

    public void marshal(SQLPacket sQLPacket) throws IOException, SQLException {
        DataOutputStream dataOutputStream = sQLPacket.getOutputStream();
        dataOutputStream.writeInt(this.status);
        if (this.CltSvr.getType() == 0) {
            this.CltSvr.setType(1);
            this.CltSvr.marshal(sQLPacket);
            dataOutputStream.writeInt(this.GetData.getHostType());
            dataOutputStream.writeInt(this.GetData.getLength());
            dataOutputStream.writeInt(this.GetData.getPosition());
            sQLPacket.marshalString(this.GetData.getHandle());
        } else if (this.CltSvr.getType() == 1) {
            this.CltSvr.setType(0);
            this.CltSvr.marshal(sQLPacket);
            if (this.status != 0) {
                return;
            }
            dataOutputStream.writeShort(this.GetData.getHostType());
            dataOutputStream.writeInt(this.GetData.getPosition());
            dataOutputStream.writeInt(this.GetData.getBuffer().length);
            dataOutputStream.write(this.GetData.getBuffer(), 0, this.GetData.getBuffer().length);
        }
    }

    public void unmarshal(InputStream inputStream) throws IOException, SQLException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        this.status = dataInputStream.readInt();
        this.CltSvr.unmarshal(dataInputStream);
        int n = this.CltSvr.getType();
        if (n == 0) {
            if (this.status != 0) {
                return;
            }
            this.GetData.setHostType((short)dataInputStream.readInt());
            this.GetData.setPosition(dataInputStream.readInt());
            int n2 = dataInputStream.readInt();
            this.GetData.setLength(n2);
            if (n2 > 0) {
                dataInputStream.readFully(this.GetData.getBuffer(), 0, n2);
            }
            if (n2 > 0 && n2 % 4 != 0) {
                byte[] byArray = new byte[4];
                dataInputStream.readFully(byArray, 0, 4 - n2 % 4);
            }
        } else if (this.CltSvr.getType() == 1) {
            this.GetData.setHostType(dataInputStream.readShort());
            this.GetData.setLength(dataInputStream.readInt());
            this.GetData.setPosition(dataInputStream.readInt());
            this.GetData.setHandle(dataInputStream.readUTF());
        }
    }
}

